/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.generator.ClassBuilderInfo;

public class StructTreeBuilder {
    public String buildStructClasses(String _dbusSig, String _structName, ClassBuilderInfo _clzBldr, List<ClassBuilderInfo> _generatedClasses) throws DBusException {
        if (Util.isBlank((String)_dbusSig) || _generatedClasses == null) {
            return null;
        }
        List<StructTree> structTree = this.buildTree(_dbusSig);
        Object parentType = null;
        if (!structTree.isEmpty() && Collection.class.isAssignableFrom(structTree.get(0).getDataType())) {
            parentType = structTree.get(0).getDataType().getName();
            structTree = structTree.get(0).getSubType();
        }
        int cnt = 0;
        for (StructTree treeItem : structTree) {
            ClassBuilderInfo info = new ClassBuilderInfo();
            info.setClassName(Util.upperCaseFirstChar((String)_structName));
            info.setPackageName(_clzBldr.getPackageName());
            info.setExtendClass(Struct.class.getName());
            info.setClassType(ClassBuilderInfo.ClassType.CLASS);
            _clzBldr.getImports().add(info.getFqcn());
            _generatedClasses.add(info);
            if (cnt == 0 && parentType != null) {
                parentType = (String)parentType + "<" + info.getClassName() + ">";
                ++cnt;
            }
            if (treeItem.getSubType().isEmpty()) continue;
            this.createNested(treeItem.getSubType(), info, _generatedClasses);
        }
        return parentType == null ? _clzBldr.getPackageName() + "." + _structName : parentType;
    }

    private void createNested(List<StructTree> _list, ClassBuilderInfo _info, List<ClassBuilderInfo> _classes) {
        int position = 0;
        ClassBuilderInfo info = _info;
        ClassBuilderInfo.ClassConstructor classConstructor = new ClassBuilderInfo.ClassConstructor();
        for (StructTree inTree : _list) {
            ClassBuilderInfo.MemberOrArgument member = new ClassBuilderInfo.MemberOrArgument("member" + position, inTree.getDataType().getName(), true);
            member.getAnnotations().add("@Position(" + position + ")");
            String constructorArg = "member" + position;
            ++position;
            if (Struct.class.isAssignableFrom(inTree.getDataType())) {
                info = new ClassBuilderInfo();
                info.setClassName(Util.upperCaseFirstChar((String)_info.getClassName()) + "Struct");
                info.setPackageName(_info.getClassName());
                info.setExtendClass(Struct.class.getName());
                info.setClassType(ClassBuilderInfo.ClassType.CLASS);
                _classes.add(info);
                classConstructor.getArguments().add(new ClassBuilderInfo.MemberOrArgument(constructorArg, inTree.getDataType().getName()));
            } else if (Collection.class.isAssignableFrom(inTree.getDataType()) || Map.class.isAssignableFrom(inTree.getDataType())) {
                ClassBuilderInfo temp = new ClassBuilderInfo();
                temp.setClassName(info.getClassName());
                temp.setPackageName(info.getPackageName());
                this.createNested(inTree.getSubType(), temp, _classes);
                info.getImports().addAll(temp.getImports());
                member.getGenerics().addAll(temp.getMembers().stream().map(l -> l.getType()).collect(Collectors.toList()));
                ClassBuilderInfo.MemberOrArgument argument = new ClassBuilderInfo.MemberOrArgument(constructorArg, inTree.getDataType().getName());
                argument.getGenerics().addAll(member.getGenerics());
                classConstructor.getArguments().add(argument);
            } else {
                classConstructor.getArguments().add(new ClassBuilderInfo.MemberOrArgument(constructorArg, inTree.getDataType().getName()));
            }
            info.getImports().add(Position.class.getName());
            info.getImports().add(inTree.getDataType().getName());
            info.getMembers().add(member);
        }
        info.getConstructors().add(classConstructor);
    }

    static void printTree(List<StructTree> _buildTree, int _indent) {
        for (StructTree tree : _buildTree) {
            int i;
            for (i = 0; i < _indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("DataType = " + tree.dataType);
            if (tree.subType.isEmpty()) continue;
            for (i = 0; i < _indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("SubElements = " + tree.subType.size());
            StructTreeBuilder.printTree(tree.subType, ++_indent);
        }
    }

    private List<StructTree> buildTree(String _dbusTypeStr) throws DBusException {
        ArrayList<StructTree> root = new ArrayList<StructTree>();
        if (Util.isBlank((String)_dbusTypeStr)) {
            return root;
        }
        ArrayList dataType = new ArrayList();
        Marshalling.getJavaType((String)_dbusTypeStr, dataType, (int)1);
        for (Type type : dataType) {
            StructTree subTree;
            if (type instanceof ParameterizedType) {
                subTree = new StructTree(((ParameterizedType)type).getRawType().getTypeName());
                subTree.subType.addAll(this.buildTree((ParameterizedType)type));
            } else {
                subTree = new StructTree(type.getClass().getName());
            }
            root.add(subTree);
        }
        return root;
    }

    private List<StructTree> buildTree(ParameterizedType _pType) throws DBusException {
        ArrayList<StructTree> trees = new ArrayList<StructTree>();
        if (_pType == null) {
            return trees;
        }
        for (Type type : _pType.getActualTypeArguments()) {
            StructTree tree;
            if (type instanceof ParameterizedType) {
                tree = new StructTree(((ParameterizedType)type).getRawType().getTypeName());
                tree.subType.addAll(this.buildTree((ParameterizedType)type));
                trees.add(tree);
                continue;
            }
            tree = new StructTree(type.getTypeName());
            trees.add(tree);
        }
        return trees;
    }

    static class StructTree {
        private final Class<?> dataType;
        private final List<StructTree> subType = new ArrayList<StructTree>();

        public StructTree(String _dataType) {
            try {
                this.dataType = Class.forName(_dataType);
            }
            catch (ClassNotFoundException _ex) {
                throw new RuntimeException(_ex);
            }
        }

        public Class<?> getDataType() {
            return this.dataType;
        }

        public List<StructTree> getSubType() {
            return this.subType;
        }
    }
}

