/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.generator.ClassBuilderInfo;

public class StructTreeBuilder {
    public String buildStructClasses(String _dbusSig, String _structName, ClassBuilderInfo _clzBldr, List<ClassBuilderInfo> _generatedClasses) throws DBusException {
        if (Util.isBlank((String)_dbusSig) || _generatedClasses == null) {
            return null;
        }
        List<StructTree> structTree = this.buildTree(_dbusSig);
        Object parentType = null;
        if (!structTree.isEmpty() && Collection.class.isAssignableFrom(structTree.get(0).getDataType())) {
            parentType = structTree.get(0).getDataType().getName();
            structTree = structTree.get(0).getSubType();
        }
        int cnt = 0;
        for (StructTree treeItem : structTree) {
            ClassBuilderInfo root = new ClassBuilderInfo();
            root.setClassName(Util.upperCaseFirstChar((String)_structName));
            root.setPackageName(_clzBldr.getPackageName());
            root.setExtendClass(Struct.class.getName());
            root.setClassType(ClassBuilderInfo.ClassType.CLASS);
            _clzBldr.getImports().add(root.getFqcn());
            _generatedClasses.add(root);
            if (cnt == 0 && parentType != null) {
                parentType = (String)parentType + "<" + root.getClassName() + ">";
                ++cnt;
            }
            if (treeItem.getSubType().isEmpty()) continue;
            this.createNested(treeItem.getSubType(), root, _generatedClasses);
        }
        return parentType == null ? _clzBldr.getPackageName() + "." + _structName : parentType;
    }

    private ClassBuilderInfo createNested(List<StructTree> _list, ClassBuilderInfo _root, List<ClassBuilderInfo> _classes) {
        int position = 0;
        ClassBuilderInfo root = _root;
        ClassBuilderInfo retval = null;
        ClassBuilderInfo.ClassConstructor classConstructor = new ClassBuilderInfo.ClassConstructor();
        for (StructTree inTree : _list) {
            ClassBuilderInfo temp;
            ClassBuilderInfo.MemberOrArgument member = new ClassBuilderInfo.MemberOrArgument("member" + position, inTree.getDataType().getName(), true);
            member.getAnnotations().add("@Position(" + position + ")");
            String constructorArg = "member" + position;
            ++position;
            if (Struct.class.isAssignableFrom(inTree.getDataType())) {
                temp = new ClassBuilderInfo();
                temp.setClassName(Util.upperCaseFirstChar((String)_root.getClassName()) + "Struct");
                temp.setPackageName(_root.getPackageName());
                temp.setExtendClass(Struct.class.getName());
                temp.setClassType(ClassBuilderInfo.ClassType.CLASS);
                classConstructor.getArguments().add(new ClassBuilderInfo.MemberOrArgument(constructorArg, inTree.getDataType().getName()));
                this.createNested(inTree.getSubType(), temp, _classes);
                _classes.add(temp);
                retval = temp;
            } else if (Collection.class.isAssignableFrom(inTree.getDataType()) || Map.class.isAssignableFrom(inTree.getDataType())) {
                temp = new ClassBuilderInfo();
                temp.setClassName(root.getClassName());
                temp.setPackageName(root.getPackageName());
                ClassBuilderInfo x = this.createNested(inTree.getSubType(), temp, _classes);
                if (x != null) {
                    member.getGenerics().add(x.getClassName());
                } else {
                    member.getGenerics().addAll(temp.getMembers().stream().map(l -> l.getType()).collect(Collectors.toList()));
                }
                root.getImports().addAll(temp.getImports());
                ClassBuilderInfo.MemberOrArgument argument = new ClassBuilderInfo.MemberOrArgument(constructorArg, inTree.getDataType().getName());
                argument.getGenerics().addAll(member.getGenerics());
                classConstructor.getArguments().add(argument);
                retval = null;
            } else {
                classConstructor.getArguments().add(new ClassBuilderInfo.MemberOrArgument(constructorArg, inTree.getDataType().getName()));
                retval = null;
            }
            root.getImports().add(Position.class.getName());
            root.getImports().add(inTree.getDataType().getName());
            root.getMembers().add(member);
        }
        root.getConstructors().add(classConstructor);
        return retval;
    }

    static void printTree(List<StructTree> _buildTree, int _indent) {
        for (StructTree tree : _buildTree) {
            int i;
            for (i = 0; i < _indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("DataType = " + tree.dataType);
            if (tree.subType.isEmpty()) continue;
            for (i = 0; i < _indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("SubElements = " + tree.subType.size());
            StructTreeBuilder.printTree(tree.subType, _indent + 1);
        }
    }

    private List<StructTree> buildTree(String _dbusTypeStr) throws DBusException {
        ArrayList<StructTree> root = new ArrayList<StructTree>();
        if (Util.isBlank((String)_dbusTypeStr)) {
            return root;
        }
        ArrayList dataType = new ArrayList();
        Marshalling.getJavaType((String)_dbusTypeStr, dataType, (int)1);
        for (Type type : dataType) {
            StructTree subTree;
            if (type instanceof ParameterizedType) {
                subTree = new StructTree(((ParameterizedType)type).getRawType().getTypeName());
                subTree.subType.addAll(this.buildTree((ParameterizedType)type));
            } else {
                subTree = new StructTree(type.getClass().getName());
            }
            root.add(subTree);
        }
        return root;
    }

    private List<StructTree> buildTree(ParameterizedType _pType) throws DBusException {
        ArrayList<StructTree> trees = new ArrayList<StructTree>();
        if (_pType == null) {
            return trees;
        }
        for (Type type : _pType.getActualTypeArguments()) {
            StructTree tree;
            if (type instanceof ParameterizedType) {
                tree = new StructTree(((ParameterizedType)type).getRawType().getTypeName());
                tree.subType.addAll(this.buildTree((ParameterizedType)type));
                trees.add(tree);
                continue;
            }
            tree = new StructTree(type.getTypeName());
            trees.add(tree);
        }
        return trees;
    }

    static class StructTree {
        private final Class<?> dataType;
        private final List<StructTree> subType = new ArrayList<StructTree>();

        StructTree(String _dataType) {
            try {
                this.dataType = Class.forName(_dataType);
            }
            catch (ClassNotFoundException _ex) {
                throw new RuntimeException(_ex);
            }
        }

        public Class<?> getDataType() {
            return this.dataType;
        }

        public List<StructTree> getSubType() {
            return this.subType;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [dataType=" + this.dataType + ", subType=" + this.subType + "]";
        }
    }
}

