/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.viewer.DBusEntry;
import org.freedesktop.dbus.viewer.DBusTableModel;
import org.freedesktop.dbus.viewer.SaveAllAction;
import org.freedesktop.dbus.viewer.SaveFileAction;
import org.freedesktop.dbus.viewer.StringStreamFactory;
import org.slf4j.LoggerFactory;

final class IntrospectAction
extends AbstractAction
implements ListSelectionListener {
    private final JTable table;

    IntrospectAction(JTable _table) {
        super("Introspect");
        this.setEnabled(false);
        this.table = _table;
        ListSelectionModel selectionModel = _table.getSelectionModel();
        selectionModel.addListSelectionListener(this);
        selectionModel.setSelectionMode(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent _event) {
        if (!_event.getValueIsAdjusting()) {
            DBusTableModel model = (DBusTableModel)this.table.getModel();
            int selection = this.table.getSelectedRow();
            if (selection > -1 && selection < model.getRowCount()) {
                DBusEntry entry = model.getEntry(selection);
                Introspectable introspectable = entry.getIntrospectable();
                this.setEnabled(introspectable != null);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent _event) {
        int row = this.table.getSelectedRow();
        DBusTableModel model = (DBusTableModel)this.table.getModel();
        if (row > -1 && row < model.getRowCount()) {
            DBusEntry entry = model.getEntry(row);
            final String xmlFile = entry.getName() + ".xml";
            final Introspectable introspectable = entry.getIntrospectable();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    StringStreamFactory factory = new StringStreamFactory();
                    try {
                        String xml = introspectable.Introspect();
                        JTabbedPane tabbedPane = new JTabbedPane();
                        tabbedPane.addTab(xmlFile, this.createSourceTab(xml));
                        for (String file : factory.streamMap.keySet()) {
                            String source = factory.streamMap.get(file).toString();
                            tabbedPane.addTab(file, this.createSourceTab(source));
                        }
                        tabbedPane.setPreferredSize(new Dimension(600, 400));
                        JPanel introspectionPanel = new JPanel(new BorderLayout());
                        introspectionPanel.add((Component)tabbedPane, "Center");
                        JPanel southPanel = new JPanel();
                        southPanel.add(new JButton(new SaveFileAction(tabbedPane)));
                        southPanel.add(new JButton(new SaveAllAction(tabbedPane)));
                        introspectionPanel.add((Component)southPanel, "South");
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(IntrospectAction.this.table, introspectionPanel, "Introspection", -1));
                    }
                    catch (Exception _ex) {
                        LoggerFactory.getLogger(this.getClass()).error("Error", (Throwable)_ex);
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(IntrospectAction.this.table, _ex.getMessage(), "Introspection Failed", 0));
                    }
                }

                private JScrollPane createSourceTab(String _source) {
                    JTextArea area = new JTextArea(_source);
                    area.setLineWrap(true);
                    area.setWrapStyleWord(true);
                    return new JScrollPane(area, 20, 31);
                }
            }).start();
        }
    }
}

