/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.generator.InterfaceCodeGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class InterfaceCodeGeneratorTest {
    InterfaceCodeGeneratorTest() {
    }

    static InterfaceCodeGenerator loadDBusXmlFile(File _inputFile, String _objectPath, String _busName) {
        if (!Util.isBlank((String)_busName)) {
            String introspectionData = Util.readFileToString((File)_inputFile);
            return new InterfaceCodeGenerator(false, introspectionData, _objectPath, _busName, null, false, null);
        }
        Assertions.fail((String)"No valid busName given");
        Assertions.fail((String)("Unable to load file: " + String.valueOf(_inputFile)));
        return null;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"createTestData"})
    void testExtractData(String _description, File _input, String _dbusPath, String _filter, int _expected) throws Exception {
        InterfaceCodeGenerator ci2 = InterfaceCodeGeneratorTest.loadDBusXmlFile(_input, _dbusPath, _filter);
        Map analyze = ci2.analyze(true);
        Assertions.assertEquals((int)_expected, (int)analyze.size());
    }

    static Stream<Arguments> createTestData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"FirewallD1: Test Extract All", new File("src/test/resources/CreateInterface/firewall/org.fedoraproject.FirewallD1.xml"), "/org/fedoraproject/FirewallD1", "*", 23}), Arguments.of((Object[])new Object[]{"FirewallD1: Test Extract Selected", new File("src/test/resources/CreateInterface/firewall/org.fedoraproject.FirewallD1.xml"), "/org/fedoraproject/FirewallD1", "org.fedoraproject.FirewallD1", 9}), Arguments.of((Object[])new Object[]{"DisplayConfig: Test Extract All", new File("src/test/resources/CreateInterface/mutter/org.gnome.Mutter.DisplayConfig.xml"), "/org/gnome/Mutter", "org.gnome.Mutter.DisplayConfig", 16}));
    }

    @Test
    void testCreateNetworkManagerWirelessInterface() throws Exception {
        InterfaceCodeGenerator ci2 = InterfaceCodeGeneratorTest.loadDBusXmlFile(new File("src/test/resources/CreateInterface/networkmanager/org.freedesktop.NetworkManager.Device.Wireless.xml"), "/", "org.freedesktop.NetworkManager.Device.Wireless");
        Map analyze = ci2.analyze(true);
        Assertions.assertEquals((int)1, (int)analyze.size());
        String clzContent = (String)analyze.get(analyze.keySet().iterator().next());
        Assertions.assertTrue((boolean)clzContent.contains("@" + DBusInterfaceName.class.getSimpleName() + "(\"org.freedesktop.NetworkManager.Device.Wireless\")"));
        Assertions.assertFalse((boolean)clzContent.contains("this._properties"));
        Assertions.assertFalse((boolean)clzContent.contains("this._path"));
        Assertions.assertFalse((boolean)clzContent.contains("this._interfaceName"));
    }

    @Test
    void testCreateSampleStructArgs() throws Exception {
        InterfaceCodeGenerator ci2 = InterfaceCodeGeneratorTest.loadDBusXmlFile(new File("src/test/resources/CreateInterface/sample_struct_args.xml"), "/", "org.example");
        Map analyze = ci2.analyze(true);
        Assertions.assertEquals((int)2, (int)analyze.size());
        String clzContent = (String)analyze.get(new File("org", "ExampleMethodExampleArgStruct.java"));
        Assertions.assertTrue((boolean)clzContent.contains("@Position(0)"), (String)"Position annotation expected");
        Assertions.assertTrue((boolean)clzContent.contains("private final List<Integer> member0;"), (String)"Final List<Integer> member expected");
        Assertions.assertTrue((boolean)clzContent.contains("public ExampleMethodExampleArgStruct(List<Integer> member0)"), (String)"Constructor using List<Integer> expected");
        Assertions.assertTrue((boolean)clzContent.contains("public List<Integer> getMember0()"), (String)"Getter for Member of type List<Integer> expected");
    }

    @Test
    void testCreateStructNames() throws Exception {
        InterfaceCodeGenerator ci2 = InterfaceCodeGeneratorTest.loadDBusXmlFile(new File("src/test/resources/CreateInterface/systemd/org.freedesktop.systemd1.Manager.xml"), "/org/freedesktop/systemd1", "org.freedesktop.systemd1.Manager");
        Map analyze = ci2.analyze(true);
        Assertions.assertEquals((int)6, (int)analyze.size());
        String managerFileContent = (String)analyze.get(new File("org/freedesktop/systemd1/Manager.java"));
        Assertions.assertTrue((boolean)managerFileContent.contains("void StartTransientUnit(List<StartTransientUnitPropertiesStruct> properties, List<StartTransientUnitAuxStruct> aux);"));
        String auxStructFileContent = (String)analyze.get(new File("org/freedesktop/systemd1/StartTransientUnitAuxStruct.java"));
        Assertions.assertTrue((boolean)auxStructFileContent.contains("private final String member0;"));
        Assertions.assertTrue((boolean)auxStructFileContent.contains("private final List<StartTransientUnitAuxStructStruct> member1;"));
        String auxStructStructFileContent = (String)analyze.get(new File("org/freedesktop/systemd1/StartTransientUnitAuxStructStruct.java"));
        Assertions.assertTrue((boolean)auxStructStructFileContent.contains("private final String member0;"));
        Assertions.assertTrue((boolean)auxStructStructFileContent.contains("private final Variant<?> member1;"));
        String propertiesStructFileContent = (String)analyze.get(new File("org/freedesktop/systemd1/StartTransientUnitPropertiesStruct.java"));
        Assertions.assertTrue((boolean)propertiesStructFileContent.contains("private final String member0;"));
        Assertions.assertTrue((boolean)propertiesStructFileContent.contains("private final Variant<?> member1;"));
        String presetUnitFilesTupleContent = (String)analyze.get(new File("org/freedesktop/systemd1/PresetUnitFilesTuple.java"));
        Assertions.assertTrue((boolean)presetUnitFilesTupleContent.lines().noneMatch(s -> s.contains("import PresetUnitFilesChangesStruct")), (String)"Did not expect an import for a class of same package");
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"createFindGenericNameData"})
    void testFindGenericName(String _description, Set<String> _existingNames, String _expectedName) {
        Assertions.assertEquals((Object)_expectedName, (Object)InterfaceCodeGenerator.findNextGenericName(_existingNames));
    }

    static Stream<Arguments> createFindGenericNameData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"ABC -> D", Set.of("A", "B", "C"), "D"}), Arguments.of((Object[])new Object[]{"ABCD -> E", Set.of("A", "B", "C", "D"), "E"}), Arguments.of((Object[])new Object[]{"ABCDE -> F", Set.of("A", "B", "C", "D", "E"), "F"}), Arguments.of((Object[])new Object[]{"ABCDEF -> G", Set.of("A", "B", "C", "D", "E", "F"), "G"}));
    }
}

