/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.TypeRef;
import org.freedesktop.dbus.annotations.DBusBoundProperty;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.Util;
import org.freedesktop.dbus.utils.XmlUtil;
import org.freedesktop.dbus.utils.generator.ClassBuilderInfo;
import org.freedesktop.dbus.utils.generator.StructTreeBuilder;
import org.freedesktop.dbus.utils.generator.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class InterfaceCodeGenerator {
    private final DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String nodeName;
    private final String busName;
    private final String introspectionData;
    private final boolean disableFilter;
    private final String forcePackageName;
    private final boolean propertyMethods;
    private final Set<String> generatedStructClassNames;
    private final String argumentPrefix;

    public InterfaceCodeGenerator(boolean _disableFilter, String _introspectionData, String _objectPath, String _busName, String _packageName, boolean _propertyMethods, String _argumentPrefix) {
        this.disableFilter = _disableFilter;
        this.introspectionData = _introspectionData;
        this.nodeName = _objectPath;
        this.argumentPrefix = _argumentPrefix;
        this.busName = Util.isBlank((String)_busName) ? "*" : _busName;
        this.forcePackageName = _packageName;
        this.propertyMethods = _propertyMethods;
        this.generatedStructClassNames = new LinkedHashSet<String>();
        this.logger.debug("ForcePackageName: {} / PropertyMethods: {}", (Object)this.forcePackageName, (Object)this.propertyMethods);
    }

    public Map<File, String> analyze(boolean _ignoreDtd) throws Exception {
        if (_ignoreDtd) {
            this.docFac.setValidating(false);
            this.docFac.setNamespaceAware(true);
            this.docFac.setFeature("http://xml.org/sax/features/namespaces", false);
            this.docFac.setFeature("http://xml.org/sax/features/validation", false);
            this.docFac.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            this.docFac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        DocumentBuilder builder = this.docFac.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(this.introspectionData)));
        Element root = document.getDocumentElement();
        if (!(Util.isBlank((String)this.nodeName) || Util.isBlank((String)root.getAttribute("name")) || this.nodeName.equals(root.getAttribute("name")))) {
            this.logger.atError().addArgument(() -> root.getAttribute("name")).addArgument((Object)this.nodeName).log("Retrieved node '{}' does not match requested node name '{}'!");
            return null;
        }
        List<Element> interfaceElements = InterfaceCodeGenerator.convertToElementList(root.getChildNodes());
        LinkedHashMap<File, String> filesAndContents = new LinkedHashMap<File, String>();
        boolean noBusnameGiven = "*".equals(this.busName) || this.disableFilter;
        for (Element ife : interfaceElements) {
            String nameAttrib = ife.getAttribute("name");
            if (this.disableFilter && ("org.freedesktop.DBus.Introspectable".equals(nameAttrib) || "org.freedesktop.DBus.Properties".equals(nameAttrib))) continue;
            if (!noBusnameGiven && !nameAttrib.startsWith(this.busName)) {
                this.logger.info("Skipping: {} - does not match given busName: {}", (Object)nameAttrib, (Object)this.busName);
                continue;
            }
            if (noBusnameGiven) {
                filesAndContents.putAll(this.extractAll(ife));
                continue;
            }
            filesAndContents.putAll(this.extractAll(ife));
        }
        return filesAndContents;
    }

    static List<Element> convertToElementList(NodeList _nodeList) {
        ArrayList<Element> elemList = new ArrayList<Element>();
        for (int i = 0; i < _nodeList.getLength(); ++i) {
            Node node = _nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element elm = (Element)node;
            elemList.add(elm);
        }
        return elemList;
    }

    private Map<File, String> extractAll(Element _ife) throws IOException, DBusException {
        String interfaceName = _ife.getAttribute("name");
        Map<DbusInterfaceToFqcn, String> fqcn = DbusInterfaceToFqcn.toFqcn(interfaceName);
        String originalPackageName = fqcn.get((Object)DbusInterfaceToFqcn.PACKAGENAME);
        String packageName = this.forcePackageName == null ? originalPackageName : this.forcePackageName;
        String className = fqcn.get((Object)DbusInterfaceToFqcn.CLASSNAME);
        this.logger.info("Creating interface: {}.{}", (Object)packageName, (Object)className);
        LinkedHashMap<File, String> filesToCreate = new LinkedHashMap<File, String>();
        ClassBuilderInfo interfaceClass = new ClassBuilderInfo(this.argumentPrefix);
        interfaceClass.setClassType(ClassBuilderInfo.ClassType.INTERFACE);
        interfaceClass.setPackageName(packageName);
        interfaceClass.setDbusPackageName(fqcn.get((Object)DbusInterfaceToFqcn.DBUS_INTERFACE_NAME));
        interfaceClass.setClassName(className);
        if (this.forcePackageName != null) {
            interfaceClass.getAnnotations().add(new ClassBuilderInfo.AnnotationInfo(DBusInterfaceName.class, "\"" + originalPackageName + "." + className + "\""));
        }
        interfaceClass.setExtendClass(DBusInterface.class.getName());
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        List<Element> interfaceElements = InterfaceCodeGenerator.convertToElementList(_ife.getChildNodes());
        for (Element element : interfaceElements) {
            switch (element.getTagName().toLowerCase()) {
                case "method": {
                    additionalClasses.addAll(this.extractMethods(element, interfaceClass));
                    break;
                }
                case "property": {
                    additionalClasses.addAll(this.extractProperties(element, interfaceClass));
                    break;
                }
                case "signal": {
                    this.extractSignals(element, interfaceClass);
                }
            }
        }
        filesToCreate.put(new File(interfaceClass.getFileName()), interfaceClass.createClassFileContent());
        for (ClassBuilderInfo cbi : additionalClasses) {
            filesToCreate.put(new File(cbi.getFileName()), cbi.createClassFileContent());
        }
        return filesToCreate;
    }

    private void extractSignals(Element _signalElement, ClassBuilderInfo _clzBldr) throws IOException, DBusException {
        String className = _signalElement.getAttribute("name");
        if (className.contains(".")) {
            className = className.substring(className.lastIndexOf(46));
        }
        ClassBuilderInfo innerClass = new ClassBuilderInfo(this.argumentPrefix);
        innerClass.setClassType(ClassBuilderInfo.ClassType.CLASS);
        innerClass.setExtendClass(DBusSignal.class.getName());
        innerClass.getImports().add(DBusSignal.class.getName());
        innerClass.getImports().add(DBusException.class.getName());
        innerClass.setClassName(className);
        _clzBldr.getInnerClasses().add(innerClass);
        ArrayList<ClassBuilderInfo.MemberOrArgument> argsList = new ArrayList<ClassBuilderInfo.MemberOrArgument>();
        if (!_signalElement.hasChildNodes()) {
            this.logger.info("Signal without any input/output arguments. Creating empty signal class: {}", (Object)innerClass.getFqcn());
        } else {
            List signalArgs = XmlUtil.convertToElementList((NodeList)XmlUtil.applyXpathExpressionToDocument((String)"arg", (Node)_signalElement));
            LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
            int unknownArgCnt = 0;
            for (Element element : signalArgs) {
                String argType = TypeConverter.getJavaTypeFromDBusType(element.getAttribute("type"), _clzBldr.getImports());
                Object argName = Util.snakeToCamelCase((String)element.getAttribute("name"));
                if (Util.isBlank((String)argName)) {
                    argName = "arg" + unknownArgCnt;
                    ++unknownArgCnt;
                }
                args.put((String)argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports()));
            }
            for (Map.Entry entry : args.entrySet()) {
                innerClass.getMembers().add(new ClassBuilderInfo.MemberOrArgument((String)entry.getKey(), (String)entry.getValue(), true));
                argsList.add(new ClassBuilderInfo.MemberOrArgument((String)entry.getKey(), (String)entry.getValue(), false));
            }
        }
        ClassBuilderInfo.ClassConstructor classConstructor = new ClassBuilderInfo.ClassConstructor();
        classConstructor.getArguments().addAll(argsList);
        classConstructor.getThrowArguments().add(DBusException.class.getSimpleName());
        classConstructor.getSuperArguments().add(new ClassBuilderInfo.MemberOrArgument("path", "String", false));
        classConstructor.getSuperArguments().addAll(argsList);
        innerClass.getConstructors().add(classConstructor);
    }

    private List<ClassBuilderInfo> extractMethods(Element _methodElement, ClassBuilderInfo _clzBldr) throws IOException, DBusException {
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        String methodElementName = _methodElement.getAttribute("name");
        if (_methodElement.hasChildNodes()) {
            Object resultType;
            List<Element> methodArgs = InterfaceCodeGenerator.convertToElementList(XmlUtil.applyXpathExpressionToDocument((String)"./arg", (Node)_methodElement));
            ArrayList<ClassBuilderInfo.MemberOrArgument> inputArgs = new ArrayList<ClassBuilderInfo.MemberOrArgument>();
            ArrayList<ClassBuilderInfo.MemberOrArgument> outputArgs = new ArrayList<ClassBuilderInfo.MemberOrArgument>();
            ArrayList<String> dbusOutputArgTypes = new ArrayList<String>();
            int unknownArgNameCnt = 0;
            for (Element argElm : methodArgs) {
                String paramName;
                String structPart;
                String parentType;
                Object argName = argElm.getAttribute("name");
                String argType = argElm.getAttribute("type").contains("(") ? ((parentType = this.buildStructClass(structPart = argElm.getAttribute("type").replaceAll("(\\(.+\\))", "$1"), methodElementName + (paramName = Util.defaultString((String)Util.upperCaseFirstChar((String)Util.snakeToCamelCase((String)argName)), (String)"")) + "Struct", _clzBldr, additionalClasses)) != null ? parentType : null) : TypeConverter.getJavaTypeFromDBusType(argElm.getAttribute("type"), _clzBldr.getImports());
                if (Util.isBlank((String)argName)) {
                    argName = "_arg" + unknownArgNameCnt;
                    ++unknownArgNameCnt;
                } else {
                    argName = Util.snakeToCamelCase((String)argName);
                }
                String dirAttr = argElm.getAttribute("direction");
                if ("in".equals(dirAttr) || "".equals(dirAttr)) {
                    inputArgs.add(new ClassBuilderInfo.MemberOrArgument((String)argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports())));
                    continue;
                }
                if (!"out".equals(dirAttr)) continue;
                outputArgs.add(new ClassBuilderInfo.MemberOrArgument((String)argName, TypeConverter.getProperJavaClass(argType, _clzBldr.getImports()), false));
                dbusOutputArgTypes.add(argType);
            }
            if (outputArgs.size() > 1) {
                this.logger.debug("Found method with multiple return values: {}", (Object)methodElementName);
                ArrayList<String> genericTypes = new ArrayList<String>();
                resultType = this.createTuple(outputArgs, methodElementName + "Tuple", _clzBldr, additionalClasses, genericTypes);
                genericTypes.stream().flatMap(e -> ClassBuilderInfo.getImportsForType(e).stream()).forEach(_clzBldr.getImports()::add);
                _clzBldr.getImports().add((String)resultType);
                resultType = Util.extractClassNameFromFqcn((String)resultType);
                List<String> returnGenerics = genericTypes.stream().map(TypeConverter::convertJavaPrimitiveToBoxed).map(ClassBuilderInfo::getSimpleTypeClasses).toList();
                resultType = (String)resultType + "<" + String.join((CharSequence)", ", returnGenerics) + ">";
            } else {
                this.logger.debug("Found method with arguments: {}({})", (Object)methodElementName, inputArgs);
                resultType = outputArgs.isEmpty() ? "void" : ((ClassBuilderInfo.MemberOrArgument)outputArgs.get(0)).getFullType(new HashSet<String>());
            }
            ClassBuilderInfo.ClassMethod classMethod = new ClassBuilderInfo.ClassMethod(methodElementName, (String)resultType, false);
            classMethod.getArguments().addAll(inputArgs);
            _clzBldr.getMethods().add(classMethod);
        } else {
            ClassBuilderInfo.ClassMethod classMethod = new ClassBuilderInfo.ClassMethod(methodElementName, "void", false);
            _clzBldr.getMethods().add(classMethod);
        }
        return additionalClasses;
    }

    private List<ClassBuilderInfo> extractProperties(Element _propertyElement, ClassBuilderInfo _clzBldr) throws DBusException {
        Object clzzName;
        Object type;
        ArrayList<ClassBuilderInfo> additionalClasses = new ArrayList<ClassBuilderInfo>();
        String attrName = _propertyElement.getAttribute("name");
        String attrAccess = _propertyElement.getAttribute("access");
        String attrType = _propertyElement.getAttribute("type");
        String access = DBusProperty.Access.READ.getAccessName().equals(attrAccess) ? DBusProperty.Access.READ.name() : (DBusProperty.Access.WRITE.getAccessName().equals(attrAccess) ? DBusProperty.Access.WRITE.name() : DBusProperty.Access.READ_WRITE.name());
        _clzBldr.getImports().add(DBusProperty.Access.class.getCanonicalName());
        boolean isStruct = false;
        if ("av".equals(attrType)) {
            type = List.class.getName();
            _clzBldr.getImports().add((String)type);
        } else if ("a{vv}".equals(attrType)) {
            type = Map.class.getName();
            _clzBldr.getImports().add((String)type);
        } else if (attrType.contains("(")) {
            String structPart = attrType.replaceAll("(\\(.+\\))", "$1");
            type = this.buildStructClass(structPart, "Property" + attrName + "Struct", _clzBldr, additionalClasses);
            isStruct = true;
        } else {
            type = TypeConverter.getJavaTypeFromDBusType(attrType, _clzBldr.getImports());
        }
        if (type == null) {
            type = Variant.class.getName();
        }
        type = ((String)type).replaceAll(CharSequence.class.getName(), String.class.getName());
        boolean isComplex = ((String)type).contains("<");
        ClassBuilderInfo propertyTypeRef = null;
        String origType = null;
        if (!isComplex) {
            clzzName = Util.extractClassNameFromFqcn((String)type);
        } else {
            origType = type;
            type = TypeRef.class.getName() + "<" + (String)type + ">";
            String typeRefInterfaceName = "Property" + attrName + "Type";
            propertyTypeRef = new ClassBuilderInfo(this.argumentPrefix);
            propertyTypeRef.setClassType(ClassBuilderInfo.ClassType.INTERFACE);
            propertyTypeRef.setClassName(typeRefInterfaceName);
            propertyTypeRef.setExtendClass((String)type);
            _clzBldr.getInnerClasses().add(propertyTypeRef);
            clzzName = _clzBldr.getClassName() + "." + typeRefInterfaceName;
        }
        if (this.propertyMethods) {
            if (DBusProperty.Access.READ.getAccessName().equals(attrAccess) || DBusProperty.Access.READ_WRITE.getAccessName().equals(attrAccess)) {
                String rtnType = origType != null ? origType : clzzName;
                ClassBuilderInfo.ClassMethod classMethod = new ClassBuilderInfo.ClassMethod(("boolean".equalsIgnoreCase((String)clzzName) ? "is" : "get") + attrName, rtnType, false);
                _clzBldr.getMethods().add(classMethod);
                if (propertyTypeRef != null) {
                    classMethod.getAnnotations().add("@" + DBusBoundProperty.class.getSimpleName() + "(type = " + propertyTypeRef.getClassName() + ".class)");
                } else if (isStruct) {
                    classMethod.getAnnotations().add("@" + DBusBoundProperty.class.getSimpleName() + "(type = " + (String)clzzName + ".class)");
                } else {
                    classMethod.getAnnotations().add("@" + DBusBoundProperty.class.getSimpleName());
                }
                _clzBldr.getImports().add(DBusBoundProperty.class.getName());
            }
            if (DBusProperty.Access.WRITE.getAccessName().equals(attrAccess) || DBusProperty.Access.READ_WRITE.getAccessName().equals(attrAccess)) {
                ClassBuilderInfo.ClassMethod classMethod = new ClassBuilderInfo.ClassMethod("set" + attrName, "void", false);
                classMethod.getArguments().add(new ClassBuilderInfo.MemberOrArgument(attrName.substring(0, 1).toLowerCase() + attrName.substring(1), (String)clzzName));
                _clzBldr.getMethods().add(classMethod);
                classMethod.getAnnotations().add("@" + DBusBoundProperty.class.getSimpleName());
                _clzBldr.getImports().add(DBusBoundProperty.class.getName());
            }
        } else {
            String annotationParams = "name = \"" + attrName + "\", type = " + (String)clzzName + ".class, access = " + DBusProperty.Access.class.getSimpleName() + "." + access;
            ClassBuilderInfo.AnnotationInfo annotationInfo = new ClassBuilderInfo.AnnotationInfo(DBusProperty.class, annotationParams);
            _clzBldr.getAnnotations().add(annotationInfo);
        }
        return additionalClasses;
    }

    private String createTuple(List<ClassBuilderInfo.MemberOrArgument> _outputArgs, String _className, ClassBuilderInfo _parentClzBldr, List<ClassBuilderInfo> _additionalClasses, List<String> _genericTypes) {
        if (_outputArgs == null || _outputArgs.isEmpty() || _additionalClasses == null) {
            return null;
        }
        ClassBuilderInfo info = new ClassBuilderInfo(this.argumentPrefix);
        info.setClassName(_className);
        info.setPackageName(_parentClzBldr.getPackageName());
        info.setExtendClass(Tuple.class.getName());
        if (!_outputArgs.isEmpty()) {
            info.getImports().add(Position.class.getName());
        }
        ArrayList<ClassBuilderInfo.MemberOrArgument> cnstrctArgs = new ArrayList<ClassBuilderInfo.MemberOrArgument>();
        LinkedHashMap<String, String> genericTypes = new LinkedHashMap<String, String>();
        int position = 0;
        for (ClassBuilderInfo.MemberOrArgument entry : _outputArgs) {
            String genericName = InterfaceCodeGenerator.findNextGenericName(genericTypes.keySet());
            genericTypes.put(genericName, entry.getType());
            entry.getAnnotations().add("@Position(" + position++ + ")");
            entry.setType(genericName);
            cnstrctArgs.add(new ClassBuilderInfo.MemberOrArgument(entry.getName(), genericName));
        }
        ClassBuilderInfo.ClassConstructor cnstrct = new ClassBuilderInfo.ClassConstructor();
        cnstrct.getArguments().addAll(cnstrctArgs);
        info.getConstructors().add(cnstrct);
        info.getMembers().addAll(_outputArgs);
        info.getGenerics().addAll(genericTypes.keySet());
        _additionalClasses.add(info);
        _genericTypes.addAll(genericTypes.values());
        return info.getFqcn();
    }

    static String findNextGenericName(Set<String> _used) {
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            String name = String.valueOf(c);
            if (_used.contains(name)) continue;
            return name;
        }
        throw new IllegalStateException("Unable to find a generic name for Tuple class");
    }

    private String buildStructClass(String _dbusTypeStr, String _structName, ClassBuilderInfo _packageName, List<ClassBuilderInfo> _structClasses) throws DBusException {
        String structFqcn = _packageName.getPackageName() + "." + Util.upperCaseFirstChar((String)_structName);
        String structClassName = new StructTreeBuilder(this.argumentPrefix, this.generatedStructClassNames).buildStructClasses(_dbusTypeStr, structFqcn, _packageName, _structClasses);
        this.generatedStructClassNames.add(structFqcn);
        return structClassName;
    }

    static void writeToFile(String _outputDir, Map<File, String> _filesToGenerate) {
        for (Map.Entry<File, String> entry : _filesToGenerate.entrySet()) {
            File outputFile = new File(_outputDir, entry.getKey().getPath());
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            if (Util.writeTextFile((String)outputFile.getAbsolutePath(), (String)entry.getValue(), (Charset)Charset.defaultCharset(), (boolean)false)) {
                LoggerFactory.getLogger(InterfaceCodeGenerator.class).info("Created class file {}", (Object)outputFile.getAbsolutePath());
                continue;
            }
            LoggerFactory.getLogger(InterfaceCodeGenerator.class).error("Could not write content to class file {}", (Object)outputFile.getName());
        }
    }

    public static void main(String[] _args) {
        String busName = null;
        String outputDir = null;
        DBusConnection.DBusBusType busType = null;
        boolean ignoreDtd = true;
        String objectPath = null;
        String inputFile = null;
        boolean noFilter = false;
        boolean propertyMethods = false;
        String forcePackageName = null;
        String argumentPrefix = null;
        for (int i = 0; i < _args.length; ++i) {
            String p = _args[i];
            if ("--system".equals(p) || "-y".equals(p)) {
                busType = DBusConnection.DBusBusType.SYSTEM;
                continue;
            }
            if ("--session".equals(p) || "-s".equals(p)) {
                busType = DBusConnection.DBusBusType.SESSION;
                continue;
            }
            if ("--enable-dtd-validation".equals(p)) {
                ignoreDtd = false;
                continue;
            }
            if ("--help".equals(p) || "-h".equals(p)) {
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if ("--all".equals(p) || "-a".equals(p)) {
                noFilter = true;
                continue;
            }
            if ("--argumentPrefix".equals(p)) {
                if (_args.length > i) {
                    argumentPrefix = _args[++i];
                    continue;
                }
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if ("--propertyMethods".equals(p) || "-m".equals(p)) {
                propertyMethods = true;
                continue;
            }
            if ("--package".equals(p) || "-p".equals(p)) {
                if (_args.length > i) {
                    forcePackageName = _args[++i];
                    continue;
                }
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if ("--version".equals(p) || "-v".equals(p)) {
                InterfaceCodeGenerator.version();
                System.exit(0);
                continue;
            }
            if ("--outputDir".equals(p) || "-o".equals(p)) {
                if (_args.length > i) {
                    outputDir = _args[++i];
                    continue;
                }
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if ("--inputFile".equals(p) || "-i".equals(p)) {
                if (_args.length > i) {
                    inputFile = _args[++i];
                    continue;
                }
                InterfaceCodeGenerator.printHelp();
                System.exit(0);
                continue;
            }
            if (null == busName) {
                busName = p;
                continue;
            }
            if (null == objectPath) {
                objectPath = p;
                continue;
            }
            InterfaceCodeGenerator.printHelp();
            System.exit(1);
        }
        if (objectPath == null) {
            objectPath = "/";
        }
        if (outputDir == null) {
            throw new RuntimeException("No output directory (--outputDir) given!");
        }
        Logger logger = LoggerFactory.getLogger(InterfaceCodeGenerator.class);
        String introspectionData = null;
        if (!Util.isBlank(inputFile)) {
            File file = new File(inputFile);
            if (!file.exists()) {
                logger.error("Given input file {} does not exist", (Object)file);
                System.exit(1);
            }
            introspectionData = Util.readFileToString((File)file);
        } else if (!Util.isBlank(busName)) {
            logger.info("Introspecting: { Interface: {}, Busname: {} }", (Object)objectPath, busName);
            try (DBusConnection conn = DBusConnectionBuilder.forType((DBusConnection.DBusBusType)busType).build();){
                Introspectable in = (Introspectable)conn.getRemoteObject(busName, objectPath, Introspectable.class);
                introspectionData = in.Introspect();
                if (Util.isBlank((String)introspectionData)) {
                    logger.error("Failed to get introspection data");
                    System.exit(1);
                }
            }
            catch (IOException | DBusException | DBusExecutionException _ex) {
                logger.error("Failure in DBus Communications. ", _ex);
                System.exit(1);
            }
        } else {
            logger.error("Busname missing!");
            System.exit(1);
        }
        InterfaceCodeGenerator ci2 = new InterfaceCodeGenerator(noFilter, introspectionData, objectPath, busName, forcePackageName, propertyMethods, argumentPrefix);
        try {
            Map<File, String> analyze = ci2.analyze(ignoreDtd);
            if (analyze == null) {
                logger.error("Unable to create interface files");
                return;
            }
            if (analyze.isEmpty()) {
                logger.warn("No files to create!");
            }
            InterfaceCodeGenerator.writeToFile(outputDir, analyze);
            logger.info("Interface creation finished");
        }
        catch (Exception _ex) {
            logger.error("Error while analyzing introspection data", (Throwable)_ex);
        }
    }

    private static void version() {
        String version = "unknown";
        String rev = "?";
        try (InputStream resourceAsStream = InterfaceCodeGenerator.class.getResourceAsStream("/dbus-java.version");){
            if (resourceAsStream != null) {
                Properties properties = new Properties();
                properties.load(resourceAsStream);
                version = properties.getProperty("version");
                rev = properties.getProperty("revision");
            }
        }
        catch (IOException _ex) {
            LoggerFactory.getLogger(InterfaceCodeGenerator.class).debug("Unable to load version information", (Throwable)_ex);
        }
        System.out.println("DBus-Java Utils Version: " + version + ", revision: " + rev);
        System.exit(1);
    }

    private static void printHelp() {
        System.out.println("Syntax: <options> [busname object] [object path]");
        System.out.println("        Options: ");
        System.out.println("        --system           | -y           Use SYSTEM DBus");
        System.out.println("        --session          | -s           Use SESSION DBus");
        System.out.println("        --outputDir <Dir>  | -o <Dir>     Use <Dir> as output directory for all generated files");
        System.out.println("        --packageName <Pkg>| -p <Pkg>     Use <Pkg> as the Java package instead of using the DBus namespace.");
        System.out.println("        --inputFile <File> | -i <File>    Use <File> as XML introspection input file instead of querying DBus");
        System.out.println("        --all              | -a           Create all classes for given bus name (do not filter)");
        System.out.println("        --boundProperties  | -b           Generate setter/getter methods for properties");
        System.out.println("");
        System.out.println("        --argumentPrefix                  Prepend the given prefix to generated method arguments/parameters");
        System.out.println("");
        System.out.println("        --enable-dtd-validation           Enable DTD validation of introspection XML");
        System.out.println("        --version                         Show version information");
        System.out.println("        --help                            Show this help");
        System.out.println("");
        System.out.println("If --inputFile is given busname object argument can be skipped (or * can be used), that will force the util to extract all interfaces found in the given file.");
        System.out.println("If busname (not empty, blank and not '*') is given, then only interfaces starting with the given busname will be extracted.");
    }

    static enum DbusInterfaceToFqcn {
        PACKAGENAME,
        ORIG_PKGNAME,
        CLASSNAME,
        DBUS_INTERFACE_NAME;


        public static Map<DbusInterfaceToFqcn, String> toFqcn(String _interfaceName) {
            String packageName = _interfaceName.contains(".") ? _interfaceName.substring(0, _interfaceName.lastIndexOf(46)) : _interfaceName;
            String className = _interfaceName.substring(_interfaceName.lastIndexOf(46) + 1);
            LinkedHashMap<DbusInterfaceToFqcn, String> map = new LinkedHashMap<DbusInterfaceToFqcn, String>();
            map.put(CLASSNAME, Util.upperCaseFirstChar((String)className));
            map.put(PACKAGENAME, packageName.toLowerCase());
            if (!packageName.equals(packageName.toLowerCase())) {
                map.put(ORIG_PKGNAME, packageName);
                map.put(DBUS_INTERFACE_NAME, packageName + "." + className);
            }
            return map;
        }
    }
}

