/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBusAsyncReply<ReturnType> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ReturnType rval = null;
    private DBusExecutionException error = null;
    private MethodCall mc;
    private Method me;
    private AbstractConnection conn;

    public static Collection<DBusAsyncReply<? extends Object>> hasReply(Collection<DBusAsyncReply<? extends Object>> replies) {
        ArrayList<DBusAsyncReply<? extends Object>> c = new ArrayList<DBusAsyncReply<? extends Object>>(replies);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (((DBusAsyncReply)i.next()).hasReply()) continue;
            i.remove();
        }
        return c;
    }

    DBusAsyncReply(MethodCall _mc, Method _me, AbstractConnection _conn) {
        this.mc = _mc;
        this.me = _me;
        this.conn = _conn;
    }

    private synchronized void checkReply() {
        if (this.mc.hasReply()) {
            Message m = this.mc.getReply();
            if (m instanceof Error) {
                this.error = ((Error)m).getException();
            } else if (m instanceof MethodReturn) {
                try {
                    this.rval = RemoteInvocationHandler.convertRV(m.getSig(), m.getParameters(), this.me, this.conn);
                }
                catch (DBusExecutionException exDee) {
                    this.error = exDee;
                }
                catch (DBusException dbe) {
                    if (AbstractConnection.EXCEPTION_DEBUG) {
                        this.logger.error("", (Throwable)dbe);
                    }
                    this.error = new DBusExecutionException(dbe.getMessage());
                }
            }
        }
    }

    public boolean hasReply() {
        if (null != this.rval || null != this.error) {
            return true;
        }
        this.checkReply();
        return null != this.rval || null != this.error;
    }

    public ReturnType getReply() throws DBusExecutionException {
        if (null != this.rval) {
            return this.rval;
        }
        if (null != this.error) {
            throw this.error;
        }
        this.checkReply();
        if (null != this.rval) {
            return this.rval;
        }
        if (null != this.error) {
            throw this.error;
        }
        throw new DBus.Error.NoReply(Gettext.t("Async call has not had a reply"));
    }

    public String toString() {
        return Gettext.t("Waiting for: ") + this.mc;
    }

    Method getMethod() {
        return this.me;
    }

    AbstractConnection getConnection() {
        return this.conn;
    }

    MethodCall getCall() {
        return this.mc;
    }
}

