/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import org.freedesktop.dbus.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EfficientQueue {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Message[] mv;
    private int start;
    private int end;
    private int initSize;

    EfficientQueue(int _initialSize) {
        this.initSize = _initialSize;
        this.shrink();
    }

    private void grow() {
        this.logger.debug("Growing");
        Message[] oldmv = this.mv;
        this.mv = new Message[oldmv.length * 2];
        System.arraycopy(oldmv, this.start, this.mv, 0, oldmv.length - this.start);
        if (this.end != oldmv.length - 1) {
            System.arraycopy(oldmv, 0, this.mv, oldmv.length - this.start, this.end + 1);
        }
        this.start = 0;
        this.end = oldmv.length;
    }

    public Message[] getKeys() {
        Message[] lv;
        if (this.start == this.end) {
            return new Message[0];
        }
        if (this.start < this.end) {
            int size = this.end - this.start;
            lv = new Message[size];
            System.arraycopy(this.mv, this.start, lv, 0, size);
        } else {
            int size = this.mv.length - this.start + this.end;
            lv = new Message[size];
            System.arraycopy(this.mv, this.start, lv, 0, this.mv.length - this.start);
            System.arraycopy(this.mv, 0, lv, this.mv.length - this.start, this.end);
        }
        return lv;
    }

    private void shrink() {
        this.logger.debug("Shrinking");
        if (null != this.mv && this.mv.length == this.initSize) {
            return;
        }
        this.mv = new Message[this.initSize];
        this.start = 0;
        this.end = 0;
    }

    public void add(Message m) {
        this.logger.debug("Enqueueing Message " + m);
        this.mv[this.end] = m;
        this.end = this.end == this.mv.length - 1 ? 0 : ++this.end;
        if (this.end == this.start) {
            this.grow();
        }
    }

    public Message remove() {
        if (this.start == this.end) {
            return null;
        }
        int pos = this.start;
        Message m = this.mv[pos];
        this.mv[pos] = null;
        this.start = this.start == this.mv.length - 1 ? 0 : ++this.start;
        this.logger.debug("Dequeueing " + m);
        return m;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public int size() {
        if (this.end >= this.start) {
            return this.end - this.start;
        }
        return this.mv.length - this.start + this.end;
    }
}

