/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.unix.USOutputStream;
import cx.ath.matthew.utils.Hexdump;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freedesktop.dbus.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OutputStream out;
    private boolean isunix;

    public MessageWriter(OutputStream _out) {
        this.out = _out;
        this.isunix = false;
        try {
            if (_out instanceof USOutputStream) {
                this.isunix = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.isunix) {
            this.out = new BufferedOutputStream(this.out);
        }
    }

    public void writeMessage(Message m) throws IOException {
        this.logger.info("<= " + m);
        if (null == m) {
            return;
        }
        if (null == m.getWireData()) {
            this.logger.warn("Message " + m + " wire-data was null!");
            return;
        }
        if (this.isunix) {
            if (this.logger.isTraceEnabled()) {
                this.logger.debug("Writing all " + m.getWireData().length + " buffers simultaneously to Unix Socket");
                for (byte[] buf : m.getWireData()) {
                    this.logger.trace("(" + buf + "):" + (null == buf ? "" : Hexdump.format((byte[])buf)));
                }
            }
            ((USOutputStream)this.out).write(m.getWireData());
        } else {
            for (byte[] buf : m.getWireData()) {
                this.logger.trace("(" + buf + "):" + (null == buf ? "" : Hexdump.format((byte[])buf)));
                if (null == buf) break;
                this.out.write(buf);
            }
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.logger.info("Closing Message Writer");
        this.out.close();
    }
}

