/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import cx.ath.matthew.unix.UnixServerSocket;
import cx.ath.matthew.unix.UnixSocket;
import cx.ath.matthew.unix.UnixSocketAddress;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.DirectConnection;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MessageReader;
import org.freedesktop.dbus.MessageWriter;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBusDaemon
extends Thread {
    public static final int QUEUE_POLL_WAIT = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBusDaemon.class);
    private Map<Connstruct, Reader> conns = new HashMap<Connstruct, Reader>();
    private HashMap<String, Connstruct> names = new HashMap();
    private MagicMap<Message, WeakReference<Connstruct>> outqueue = new MagicMap("out");
    private MagicMap<Message, WeakReference<Connstruct>> inqueue = new MagicMap("in");
    private MagicMap<Message, WeakReference<Connstruct>> localqueue = new MagicMap("local");
    private List<Connstruct> sigrecips = new Vector<Connstruct>();
    private boolean run = true;
    private int nextUnique = 0;
    private Object uniqueLock = new Object();
    DBusServer dbusServer = new DBusServer();
    Sender sender = new Sender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusDaemon() {
        this.setName("Daemon");
        HashMap<String, Connstruct> hashMap = this.names;
        synchronized (hashMap) {
            this.names.put("org.freedesktop.DBus", null);
        }
    }

    private void send(Connstruct c, Message m) {
        this.send(c, m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Connstruct c, Message m, boolean head) {
        LOGGER.debug("enter");
        if (null == c) {
            LOGGER.trace("Queing message " + m + " for all connections");
        } else {
            LOGGER.trace("Queing message " + m + " for " + c.unique);
        }
        if (null == c) {
            Map<Connstruct, Reader> map = this.conns;
            synchronized (map) {
                MagicMap<Message, WeakReference<Connstruct>> magicMap = this.outqueue;
                synchronized (magicMap) {
                    for (Connstruct d : this.conns.keySet()) {
                        if (head) {
                            this.outqueue.putFirst(m, new WeakReference<Connstruct>(d));
                            continue;
                        }
                        this.outqueue.putLast(m, new WeakReference<Connstruct>(d));
                    }
                    this.outqueue.notifyAll();
                }
            }
        }
        MagicMap<Message, WeakReference<Connstruct>> magicMap = this.outqueue;
        synchronized (magicMap) {
            if (head) {
                this.outqueue.putFirst(m, new WeakReference<Connstruct>(c));
            } else {
                this.outqueue.putLast(m, new WeakReference<Connstruct>(c));
            }
            this.outqueue.notifyAll();
        }
        LOGGER.debug("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connstruct> findSignalMatches(DBusSignal sig) {
        Vector<Connstruct> l;
        LOGGER.debug("enter");
        List<Connstruct> list = this.sigrecips;
        synchronized (list) {
            l = new Vector<Connstruct>(this.sigrecips);
        }
        LOGGER.debug("exit");
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.debug("enter");
        while (this.run) {
            try {
                List<WeakReference<Connstruct>> wcs;
                Message m;
                MagicMap<Message, WeakReference<Connstruct>> magicMap = this.inqueue;
                synchronized (magicMap) {
                    while (0 == this.inqueue.size()) {
                        try {
                            this.inqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    m = this.inqueue.head();
                    wcs = this.inqueue.remove(m);
                }
                if (null == wcs) continue;
                for (WeakReference weakReference : wcs) {
                    Connstruct c = (Connstruct)weakReference.get();
                    if (null == c) continue;
                    LOGGER.info("<inqueue> Got message " + m + " from " + c.unique);
                    if (!(null != c.unique || m instanceof MethodCall && "org.freedesktop.DBus".equals(m.getDestination()) && "Hello".equals(m.getName()))) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.AccessDenied", m.getSerial(), "s", Gettext.t("You must send a Hello message")));
                        continue;
                    }
                    try {
                        if (null != c.unique) {
                            m.setSource(c.unique);
                        }
                    }
                    catch (DBusException dbe) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            LOGGER.error("", (Throwable)dbe);
                        }
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.GeneralError", m.getSerial(), "s", Gettext.t("Sending message failed")));
                    }
                    if ("org.freedesktop.DBus".equals(m.getDestination())) {
                        MagicMap<Message, WeakReference<Connstruct>> dbe = this.localqueue;
                        synchronized (dbe) {
                            this.localqueue.putLast(m, weakReference);
                            this.localqueue.notifyAll();
                            continue;
                        }
                    }
                    if (m instanceof DBusSignal) {
                        List<Connstruct> list = this.findSignalMatches((DBusSignal)m);
                        for (Connstruct d : list) {
                            this.send(d, m);
                        }
                        continue;
                    }
                    Connstruct dest = this.names.get(m.getDestination());
                    if (null == dest) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.ServiceUnknown", m.getSerial(), "s", MessageFormat.format(Gettext.t("The name `{0}' does not exist"), m.getDestination())));
                        continue;
                    }
                    this.send(dest, m);
                }
            }
            catch (DBusException dbe) {
                if (!AbstractConnection.EXCEPTION_DEBUG) continue;
                LOGGER.error("", (Throwable)dbe);
            }
        }
        LOGGER.debug("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(Connstruct c) {
        boolean exists;
        LOGGER.debug("enter");
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            exists = this.conns.containsKey(c);
            if (exists) {
                Reader r = this.conns.get(c);
                r.stopRunning();
                this.conns.remove(c);
            }
        }
        if (exists) {
            try {
                if (null != c.usock) {
                    c.usock.close();
                }
                if (null != c.tsock) {
                    c.tsock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            map = this.names;
            synchronized (map) {
                Vector<String> toRemove = new Vector<String>();
                for (String name : this.names.keySet()) {
                    if (this.names.get(name) != c) continue;
                    toRemove.add(name);
                    try {
                        this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, c.unique, ""));
                    }
                    catch (DBusException dbe) {
                        if (!AbstractConnection.EXCEPTION_DEBUG) continue;
                        LOGGER.error("", (Throwable)dbe);
                    }
                }
                for (String name : toRemove) {
                    this.names.remove(name);
                }
            }
        }
        LOGGER.debug("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSock(UnixSocket us) {
        LOGGER.debug("enter");
        LOGGER.warn("New Client");
        Connstruct c = new Connstruct(us);
        Reader r = new Reader(c);
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            this.conns.put(c, r);
        }
        r.start();
        LOGGER.debug("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSock(Socket s) throws IOException {
        LOGGER.debug("enter");
        LOGGER.debug("New Client");
        Connstruct c = new Connstruct(s);
        Reader r = new Reader(c);
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            this.conns.put(c, r);
        }
        r.start();
        LOGGER.debug("exit");
    }

    public static void syntax() {
        System.out.println("Syntax: DBusDaemon [--version] [-v] [--help] [-h] [--listen address] [-l address] [--print-address] [-r] [--pidfile file] [-p file] [--addressfile file] [-a file] [--unix] [-u] [--tcp] [-t] ");
        System.exit(1);
    }

    public static void version() {
        System.out.println("D-Bus Java Version: " + System.getProperty("Version"));
        System.exit(1);
    }

    public static void saveFile(String data, String file) throws IOException {
        PrintWriter w = new PrintWriter(new FileOutputStream(file));
        w.println(data);
        w.close();
    }

    public static void main(String[] args) throws Exception {
        if (AbstractConnection.EXCEPTION_DEBUG) {
            LOGGER.debug("enter");
        }
        String addr = null;
        String pidfile = null;
        String addrfile = null;
        boolean printaddress = false;
        boolean unix = true;
        boolean tcp = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                    DBusDaemon.syntax();
                    continue;
                }
                if ("--version".equals(args[i]) || "-v".equals(args[i])) {
                    DBusDaemon.version();
                    continue;
                }
                if ("--listen".equals(args[i]) || "-l".equals(args[i])) {
                    addr = args[++i];
                    continue;
                }
                if ("--pidfile".equals(args[i]) || "-p".equals(args[i])) {
                    pidfile = args[++i];
                    continue;
                }
                if ("--addressfile".equals(args[i]) || "-a".equals(args[i])) {
                    addrfile = args[++i];
                    continue;
                }
                if ("--print-address".equals(args[i]) || "-r".equals(args[i])) {
                    printaddress = true;
                    continue;
                }
                if ("--unix".equals(args[i]) || "-u".equals(args[i])) {
                    unix = true;
                    tcp = false;
                    continue;
                }
                if ("--tcp".equals(args[i]) || "-t".equals(args[i])) {
                    tcp = true;
                    unix = false;
                    continue;
                }
                DBusDaemon.syntax();
            }
        }
        catch (ArrayIndexOutOfBoundsException exAioob) {
            DBusDaemon.syntax();
        }
        if (null == addr && unix) {
            addr = DirectConnection.createDynamicSession();
        } else if (null == addr && tcp) {
            addr = DirectConnection.createDynamicTCPSession();
        }
        BusAddress address = new BusAddress(addr);
        if (null == address.getParameter("guid")) {
            addr = addr + ",guid=" + Transport.genGUID();
            address = new BusAddress(addr);
        }
        if (printaddress) {
            System.out.println(addr);
        }
        if (null != addrfile) {
            DBusDaemon.saveFile(addr, addrfile);
        }
        if (null != pidfile) {
            DBusDaemon.saveFile(System.getProperty("Pid"), pidfile);
        }
        LOGGER.warn("Binding to " + addr);
        if ("unix".equals(address.getType())) {
            DBusDaemon.doUnix(address);
        } else if ("tcp".equals(address.getType())) {
            DBusDaemon.doTCP(address);
        } else {
            throw new Exception("Unknown address type: " + address.getType());
        }
        LOGGER.debug("exit");
    }

    private static void doUnix(BusAddress address) throws IOException {
        LOGGER.debug("enter");
        UnixServerSocket uss = null != address.getParameter("abstract") ? new UnixServerSocket(new UnixSocketAddress(address.getParameter("abstract"), true)) : new UnixServerSocket(new UnixSocketAddress(address.getParameter("path"), false));
        DBusDaemon d = new DBusDaemon();
        d.start();
        d.sender.start();
        d.dbusServer.start();
        while (d.run) {
            UnixSocket s = uss.accept();
            if (new Transport.SASL().auth(1, 1, address.getParameter("guid"), s.getOutputStream(), s.getInputStream(), s)) {
                d.addSock(s);
                continue;
            }
            s.close();
        }
        uss.close();
        LOGGER.debug("exit");
    }

    private static void doTCP(BusAddress address) throws IOException {
        LOGGER.debug("enter");
        try (ServerSocket ss = new ServerSocket(Integer.parseInt(address.getParameter("port")), 10, InetAddress.getByName(address.getParameter("host")));){
            DBusDaemon d = new DBusDaemon();
            d.start();
            d.sender.start();
            d.dbusServer.start();
            while (d.run) {
                Socket s = ss.accept();
                boolean authOK = false;
                try {
                    authOK = new Transport.SASL().auth(1, 1, address.getParameter("guid"), s.getOutputStream(), s.getInputStream(), null);
                }
                catch (Exception e) {
                    LOGGER.debug("", (Throwable)e);
                }
                if (authOK) {
                    d.addSock(s);
                    continue;
                }
                s.close();
            }
            LOGGER.debug("exit");
        }
    }

    public class Reader
    extends Thread {
        private Connstruct conn;
        private WeakReference<Connstruct> weakconn;
        private boolean lrun = true;

        public Reader(Connstruct _conn) {
            this.conn = _conn;
            this.weakconn = new WeakReference<Connstruct>(_conn);
            this.setName("Reader");
        }

        public void stopRunning() {
            this.lrun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.debug("enter");
            while (DBusDaemon.this.run && this.lrun) {
                Message m;
                block9: {
                    m = null;
                    try {
                        m = this.conn.min.readMessage();
                    }
                    catch (IOException ioe) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            LOGGER.error("", (Throwable)ioe);
                        }
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                    catch (DBusException dbe) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            LOGGER.error("", (Throwable)dbe);
                        }
                        if (!(dbe instanceof FatalException)) break block9;
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                }
                if (null == m) continue;
                LOGGER.info("Read " + m + " from " + this.conn.unique);
                MagicMap magicMap = DBusDaemon.this.inqueue;
                synchronized (magicMap) {
                    DBusDaemon.this.inqueue.putLast(m, this.weakconn);
                    DBusDaemon.this.inqueue.notifyAll();
                }
            }
            this.conn = null;
            LOGGER.debug("exit");
        }
    }

    public class Sender
    extends Thread {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        public Sender() {
            this.setName("Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.logger.debug("enter");
            while (DBusDaemon.this.run) {
                this.logger.trace("Acquiring lock on outqueue and blocking for data");
                Message m = null;
                List wcs = null;
                MagicMap magicMap = DBusDaemon.this.outqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.outqueue.size() == 0) {
                        try {
                            DBusDaemon.this.outqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    m = (Message)DBusDaemon.this.outqueue.head();
                    wcs = DBusDaemon.this.outqueue.remove(m);
                }
                if (null != wcs) {
                    for (WeakReference wc : wcs) {
                        Connstruct c = (Connstruct)wc.get();
                        if (null == c) continue;
                        this.logger.trace("<outqueue> Got message " + m + " for " + c.unique);
                        this.logger.info("Sending message " + m + " to " + c.unique);
                        try {
                            c.mout.writeMessage(m);
                        }
                        catch (IOException ioe) {
                            if (AbstractConnection.EXCEPTION_DEBUG) {
                                this.logger.error("", (Throwable)ioe);
                            }
                            DBusDaemon.this.removeConnection(c);
                        }
                    }
                    continue;
                }
                this.logger.info("Discarding " + m + " connection reaped");
            }
            this.logger.debug("exit");
        }
    }

    public class DBusServer
    extends Thread
    implements DBus,
    DBus.Introspectable,
    DBus.Peer {
        public Connstruct c;
        public Message m;

        public DBusServer() {
            this.setName("Server");
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String Hello() {
            block12: {
                LOGGER.debug("enter");
                Object object = this.c;
                synchronized (object) {
                    if (null != this.c.unique) {
                        throw new DBus.Error.AccessDenied(Gettext.t("Connection has already sent a Hello message"));
                    }
                    Object object2 = DBusDaemon.this.uniqueLock;
                    synchronized (object2) {
                        this.c.unique = ":1." + ++DBusDaemon.this.nextUnique;
                    }
                }
                object = DBusDaemon.this.names;
                synchronized (object) {
                    DBusDaemon.this.names.put(this.c.unique, this.c);
                }
                LOGGER.warn("Client " + this.c.unique + " registered");
                try {
                    DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", this.c.unique));
                    DBusSignal s = new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", this.c.unique, "", this.c.unique);
                    DBusDaemon.this.send(null, s);
                }
                catch (DBusException dbe) {
                    if (!AbstractConnection.EXCEPTION_DEBUG) break block12;
                    LOGGER.error("", (Throwable)dbe);
                }
            }
            LOGGER.debug("exit");
            return this.c.unique;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] ListNames() {
            String[] ns;
            LOGGER.debug("enter");
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                Set nss = DBusDaemon.this.names.keySet();
                ns = nss.toArray(new String[0]);
            }
            LOGGER.debug("exit");
            return ns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean NameHasOwner(String name) {
            boolean rv;
            LOGGER.debug("enter");
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                rv = DBusDaemon.this.names.containsKey(name);
            }
            LOGGER.debug("exit");
            return rv;
        }

        @Override
        public String GetNameOwner(String name) {
            LOGGER.debug("enter");
            Connstruct owner = (Connstruct)DBusDaemon.this.names.get(name);
            String o = null == owner ? "" : owner.unique;
            LOGGER.debug("exit");
            return o;
        }

        @Override
        public UInt32 GetConnectionUnixUser(String connection_name) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new UInt32(0L);
        }

        @Override
        public UInt32 StartServiceByName(String name, UInt32 flags) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new UInt32(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UInt32 RequestName(String name, UInt32 flags) {
            int rv;
            block8: {
                LOGGER.debug("enter");
                boolean exists = false;
                HashMap hashMap = DBusDaemon.this.names;
                synchronized (hashMap) {
                    exists = DBusDaemon.this.names.containsKey(name);
                    if (!exists) {
                        DBusDaemon.this.names.put(name, this.c);
                    }
                }
                if (exists) {
                    rv = 3;
                } else {
                    LOGGER.warn("Client " + this.c.unique + " acquired name " + name);
                    rv = 1;
                    try {
                        DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", name));
                        DBusDaemon.this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, "", this.c.unique));
                    }
                    catch (DBusException dbe) {
                        if (!AbstractConnection.EXCEPTION_DEBUG) break block8;
                        LOGGER.error("", (Throwable)dbe);
                    }
                }
            }
            LOGGER.debug("exit");
            return new UInt32(rv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UInt32 ReleaseName(String name) {
            int rv;
            block8: {
                LOGGER.debug("enter");
                boolean exists = false;
                HashMap hashMap = DBusDaemon.this.names;
                synchronized (hashMap) {
                    exists = DBusDaemon.this.names.containsKey(name) && ((Connstruct)DBusDaemon.this.names.get(name)).equals(this.c);
                    if (exists) {
                        DBusDaemon.this.names.remove(name);
                    }
                }
                if (!exists) {
                    rv = 2;
                } else {
                    LOGGER.warn("Client " + this.c.unique + " acquired name " + name);
                    rv = 1;
                    try {
                        DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameLost", "s", name));
                        DBusDaemon.this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, this.c.unique, ""));
                    }
                    catch (DBusException dbe) {
                        if (!AbstractConnection.EXCEPTION_DEBUG) break block8;
                        LOGGER.error("", (Throwable)dbe);
                    }
                }
            }
            LOGGER.debug("exit");
            return new UInt32(rv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddMatch(String matchrule) throws DBus.Error.MatchRuleInvalid {
            LOGGER.debug("enter");
            LOGGER.trace("Adding match rule: " + matchrule);
            List list = DBusDaemon.this.sigrecips;
            synchronized (list) {
                if (!DBusDaemon.this.sigrecips.contains(this.c)) {
                    DBusDaemon.this.sigrecips.add(this.c);
                }
            }
            LOGGER.debug("exit");
        }

        @Override
        public void RemoveMatch(String matchrule) throws DBus.Error.MatchRuleInvalid {
            LOGGER.debug("enter");
            LOGGER.trace("Removing match rule: " + matchrule);
            LOGGER.debug("exit");
        }

        @Override
        public String[] ListQueuedOwners(String name) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new String[0];
        }

        @Override
        public UInt32 GetConnectionUnixProcessID(String connection_name) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new UInt32(0L);
        }

        @Override
        public Byte[] GetConnectionSELinuxSecurityContext(String a) {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
            return new Byte[0];
        }

        @Override
        public void ReloadConfig() {
            LOGGER.debug("enter");
            LOGGER.debug("exit");
        }

        private void handleMessage(Connstruct _c, Message _m) throws DBusException {
            block12: {
                LOGGER.debug("enter");
                LOGGER.trace("Handling message " + _m + " from " + _c.unique);
                if (!(_m instanceof MethodCall)) {
                    return;
                }
                Object[] args = _m.getParameters();
                Class[] cs = new Class[args.length];
                for (int i = 0; i < cs.length; ++i) {
                    cs[i] = args[i].getClass();
                }
                Method meth = null;
                Object rv = null;
                try {
                    meth = DBusServer.class.getMethod(_m.getName(), cs);
                    try {
                        this.c = _c;
                        this.m = _m;
                        rv = meth.invoke((Object)DBusDaemon.this.dbusServer, args);
                        if (null == rv) {
                            DBusDaemon.this.send(_c, new MethodReturn("org.freedesktop.DBus", (MethodCall)_m, null, new Object[0]), true);
                            break block12;
                        }
                        String sig = Marshalling.getDBusType(meth.getGenericReturnType())[0];
                        DBusDaemon.this.send(_c, new MethodReturn("org.freedesktop.DBus", (MethodCall)_m, sig, rv), true);
                    }
                    catch (InvocationTargetException ite) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            LOGGER.error("", (Throwable)ite);
                        }
                        DBusDaemon.this.send(_c, new Error("org.freedesktop.DBus", _m, ite.getCause()));
                    }
                    catch (DBusExecutionException dbee) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            LOGGER.error("", (Throwable)dbee);
                        }
                        DBusDaemon.this.send(_c, new Error("org.freedesktop.DBus", _m, dbee));
                    }
                    catch (Exception e) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            LOGGER.error("", (Throwable)e);
                        }
                        DBusDaemon.this.send(_c, new Error("org.freedesktop.DBus", _c.unique, "org.freedesktop.DBus.Error.GeneralError", _m.getSerial(), "s", Gettext.t("An error occurred while calling ") + _m.getName()));
                    }
                }
                catch (NoSuchMethodException exNsm) {
                    DBusDaemon.this.send(_c, new Error("org.freedesktop.DBus", _c.unique, "org.freedesktop.DBus.Error.UnknownMethod", _m.getSerial(), "s", Gettext.t("This service does not support ") + _m.getName()));
                }
            }
            LOGGER.debug("exit");
        }

        @Override
        public String Introspect() {
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n<node>\n  <interface name=\"org.freedesktop.DBus.Introspectable\">\n    <method name=\"Introspect\">\n      <arg name=\"data\" direction=\"out\" type=\"s\"/>\n    </method>\n  </interface>\n  <interface name=\"org.freedesktop.DBus\">\n    <method name=\"RequestName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"ReleaseName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"StartServiceByName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"Hello\">\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"NameHasOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"b\"/>\n    </method>\n    <method name=\"ListNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"ListActivatableNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"AddMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"RemoveMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"GetNameOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"ListQueuedOwners\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"GetConnectionUnixUser\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionUnixProcessID\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionSELinuxSecurityContext\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"ay\"/>\n    </method>\n    <method name=\"ReloadConfig\">\n    </method>\n    <signal name=\"NameOwnerChanged\">\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameLost\">\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameAcquired\">\n      <arg type=\"s\"/>\n    </signal>\n  </interface>\n</node>";
        }

        @Override
        public void Ping() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.debug("enter");
            while (DBusDaemon.this.run) {
                List wcs;
                Message msg;
                MagicMap magicMap = DBusDaemon.this.localqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.localqueue.size() == 0) {
                        try {
                            DBusDaemon.this.localqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    msg = (Message)DBusDaemon.this.localqueue.head();
                    wcs = DBusDaemon.this.localqueue.remove(msg);
                }
                if (null != wcs) {
                    try {
                        for (WeakReference wc : wcs) {
                            Connstruct constructor = (Connstruct)wc.get();
                            if (null == constructor) continue;
                            LOGGER.trace("<localqueue> Got message " + msg + " from " + constructor);
                            this.handleMessage(constructor, msg);
                        }
                        continue;
                    }
                    catch (DBusException dbe) {
                        if (!AbstractConnection.EXCEPTION_DEBUG) continue;
                        LOGGER.debug("", (Throwable)dbe);
                        continue;
                    }
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.info("Discarding " + msg + " connection reaped");
            }
            LOGGER.debug("exit");
        }
    }

    static class MagicMap<A, B> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private Map<A, LinkedList<B>> m = new HashMap<A, LinkedList<B>>();
        private LinkedList<A> q = new LinkedList();
        private String name;

        MagicMap(String _name) {
            this.name = _name;
        }

        public A head() {
            return this.q.getFirst();
        }

        public void putFirst(A a, B b) {
            this.logger.debug("<" + this.name + "> Queueing {" + a + " => " + b + "}");
            if (this.m.containsKey(a)) {
                this.m.get(a).add(b);
            } else {
                LinkedList<B> l = new LinkedList<B>();
                l.add(b);
                this.m.put(a, l);
            }
            this.q.addFirst(a);
        }

        public void putLast(A a, B b) {
            this.logger.debug("<" + this.name + "> Queueing {" + a + " => " + b + "}");
            if (this.m.containsKey(a)) {
                this.m.get(a).add(b);
            } else {
                LinkedList<B> l = new LinkedList<B>();
                l.add(b);
                this.m.put(a, l);
            }
            this.q.addLast(a);
        }

        public List<B> remove(A a) {
            this.logger.debug("<" + this.name + "> Removing {" + a + "}");
            this.q.remove(a);
            return this.m.remove(a);
        }

        public int size() {
            return this.q.size();
        }
    }

    static class Connstruct {
        public UnixSocket usock;
        public Socket tsock;
        public MessageReader min;
        public MessageWriter mout;
        public String unique;

        Connstruct(UnixSocket sock) {
            this.usock = sock;
            this.min = new MessageReader(sock.getInputStream());
            this.mout = new MessageWriter(sock.getOutputStream());
        }

        Connstruct(Socket sock) throws IOException {
            this.tsock = sock;
            this.min = new MessageReader(sock.getInputStream());
            this.mout = new MessageWriter(sock.getOutputStream());
        }

        public String toString() {
            return null == this.unique ? ":?-?" : this.unique;
        }
    }
}

