/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.viewer.TextFile;

final class FileSaver
implements Runnable {
    private static final String CANCEL = "Cancel";
    private static final String SKIP_ALL = "Skip All";
    private static final String SKIP = "Skip";
    private static final String OVERWRITE = "Overwrite";
    private static final String OVERWRITE_ALL = "Overwrite All";
    private final File parentDirectory;
    private final Component parentComponent;
    private final Iterable<TextFile> textFiles;

    FileSaver(Component _parentComponent, File _parentDirectory, Iterable<TextFile> _files) {
        this.parentComponent = _parentComponent;
        this.parentDirectory = _parentDirectory;
        this.textFiles = _files;
    }

    @Override
    public void run() {
        this.saveFiles();
    }

    private void saveFiles() {
        Object overwritePolicy = null;
        Iterator<TextFile> iterator = this.textFiles.iterator();
        while (iterator.hasNext()) {
            TextFile textFile = iterator.next();
            String fileName = textFile.getFileName();
            File fileToSave = new File(this.parentDirectory, fileName);
            File parentFile = fileToSave.getParentFile();
            if (parentFile.exists() || parentFile.mkdirs()) {
                boolean doSave;
                boolean bl = doSave = !fileToSave.exists() || OVERWRITE_ALL.equals(overwritePolicy);
                if (!doSave && !SKIP_ALL.equals(overwritePolicy)) {
                    Object[] selectionValues = iterator.hasNext() ? new String[]{OVERWRITE, OVERWRITE_ALL, SKIP, SKIP_ALL, CANCEL} : new String[]{OVERWRITE, CANCEL};
                    int option = JOptionPane.showOptionDialog(this.parentComponent, "File exists: " + fileName, "Save", 1, 3, null, selectionValues, null);
                    if (option == -1 || CANCEL.equals(overwritePolicy = selectionValues[option])) break;
                    boolean bl2 = doSave = OVERWRITE.equals(overwritePolicy) || OVERWRITE_ALL.equals(overwritePolicy);
                }
                if (!doSave) continue;
                try {
                    String contents = textFile.getContents();
                    this.writeFile(fileToSave, contents);
                }
                catch (IOException ex) {
                    String errorMessage = "Could not save " + fileName + ": " + ex.getLocalizedMessage();
                    if (iterator.hasNext()) {
                        int confirm = JOptionPane.showConfirmDialog(this.parentComponent, errorMessage + ".\n" + Gettext.t("Try saving other files?"), Gettext.t("Save Failed"), 2, 0);
                        if (confirm == 0) continue;
                        break;
                    }
                    JOptionPane.showMessageDialog(this.parentComponent, errorMessage + ".", Gettext.t("Save Failed"), 0);
                }
                continue;
            }
            String errorMessage = Gettext.t("Could not access parent directory for ") + fileName;
            if (iterator.hasNext()) {
                int confirm = JOptionPane.showConfirmDialog(this.parentComponent, errorMessage + ".\n" + Gettext.t("Try saving other files?"), Gettext.t("Save Failed"), 2, 0);
                if (confirm == 0) continue;
                break;
            }
            JOptionPane.showMessageDialog(this.parentComponent, errorMessage + ".", Gettext.t("Save Failed"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File fileToSave, String contents) throws IOException {
        OutputStreamWriter fileWriter = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileToSave));){
            writer.append(contents);
            writer.flush();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

