/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.exceptions.DBusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectConnection
extends AbstractConnection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DirectConnection(String address) throws DBusException {
        super(address);
        try {
            this.transport = new Transport(this.addr, 100000);
            this.connected = true;
        }
        catch (IOException exIo) {
            if (EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)exIo);
            }
            throw new DBusException(Gettext.t("Failed to connect to bus ") + exIo.getMessage());
        }
        catch (ParseException exP) {
            if (EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)exP);
            }
            throw new DBusException(Gettext.t("Failed to connect to bus ") + exP.getMessage());
        }
        this.listen();
    }

    public static String createDynamicTCPSession() {
        int port;
        String address = "tcp:host=localhost";
        try {
            ServerSocket s = new ServerSocket();
            s.bind(null);
            port = s.getLocalPort();
            s.close();
        }
        catch (Exception e) {
            Random r = new Random();
            port = 32768 + Math.abs(r.nextInt()) % 28232;
        }
        address = address + ",port=" + port;
        address = address + ",guid=" + Transport.genGUID();
        LoggerFactory.getLogger(DirectConnection.class).debug("Created Session address: " + address);
        return address;
    }

    public static String createDynamicSession() {
        String address = "unix:";
        String path = "/tmp/dbus-XXXXXXXXXX";
        Random r = new Random();
        do {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                sb.append((char)(Math.abs(r.nextInt()) % 26 + 65));
            }
            path = path.replaceAll("..........$", sb.toString());
            LoggerFactory.getLogger(DirectConnection.class).trace("Trying path " + path);
        } while (new File(path).exists());
        address = address + "abstract=" + path;
        address = address + ",guid=" + Transport.genGUID();
        LoggerFactory.getLogger(DirectConnection.class).debug("Created Session address: " + address);
        return address;
    }

    DBusInterface dynamicProxy(String path) throws DBusException {
        try {
            DBus.Introspectable intro = (DBus.Introspectable)this.getRemoteObject(path, DBus.Introspectable.class);
            String data = intro.Introspect();
            String[] tags = data.split("[<>]");
            Vector<String> ifaces = new Vector<String>();
            for (String tag : tags) {
                if (!tag.startsWith("interface")) continue;
                ifaces.add(tag.replaceAll("^interface *name *= *['\"]([^'\"]*)['\"].*$", "$1"));
            }
            Vector ifcs = new Vector();
            block5: for (String iface : ifaces) {
                int j = 0;
                while (j >= 0) {
                    try {
                        ifcs.add(Class.forName(iface));
                        continue block5;
                    }
                    catch (Exception exception) {
                        j = iface.lastIndexOf(".");
                        char[] cs = iface.toCharArray();
                        if (j < 0) continue;
                        cs[j] = 36;
                        iface = String.valueOf(cs);
                    }
                }
            }
            if (ifcs.size() == 0) {
                throw new DBusException(Gettext.t("Could not find an interface to cast to"));
            }
            RemoteObject ro = new RemoteObject(null, path, null, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(((Class)ifcs.get(0)).getClassLoader(), ifcs.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.importedObjects.put(newi, ro);
            return newi;
        }
        catch (Exception e) {
            if (EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)e);
            }
            throw new DBusException(MessageFormat.format(Gettext.t("Failed to create proxy object for {0}; reason: {1}."), path, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBusInterface getExportedObject(String path) throws DBusException {
        ExportedObject o = null;
        Map map = this.exportedObjects;
        synchronized (map) {
            o = (ExportedObject)this.exportedObjects.get(path);
        }
        if (null != o && null == o.object.get()) {
            this.unExportObject(path);
            o = null;
        }
        if (null != o) {
            return o.object.get();
        }
        return this.dynamicProxy(path);
    }

    public DBusInterface getRemoteObject(String objectpath) throws DBusException {
        if (null == objectpath) {
            throw new DBusException(Gettext.t("Invalid object path: null"));
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.t("Invalid object path: ") + objectpath);
        }
        return this.dynamicProxy(objectpath);
    }

    public DBusInterface getRemoteObject(String objectpath, Class<? extends DBusInterface> type) throws DBusException {
        if (null == objectpath) {
            throw new DBusException(Gettext.t("Invalid object path: null"));
        }
        if (null == type) {
            throw new ClassCastException(Gettext.t("Not A DBus Interface"));
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.t("Invalid object path: ") + objectpath);
        }
        if (!DBusInterface.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.t("Not A DBus Interface"));
        }
        if (type.getName().equals(type.getSimpleName())) {
            throw new DBusException(Gettext.t("DBusInterfaces cannot be declared outside a package"));
        }
        RemoteObject ro = new RemoteObject(null, objectpath, type, false);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.importedObjects.put(i, ro);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector v = (Vector)this.handledSignals.get(key);
            if (null != v) {
                v.remove(handler);
                if (0 == v.size()) {
                    this.handledSignals.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void addSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<T>> v = (Vector<DBusSigHandler<T>>)this.handledSignals.get(key);
            if (null == v) {
                v = new Vector<DBusSigHandler<T>>();
                v.add(handler);
                this.handledSignals.put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    @Override
    DBusInterface getExportedObject(String source, String path) throws DBusException {
        return this.getExportedObject(path);
    }
}

