/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.DBusSerializable;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.Position;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.DBusStructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Marshalling {
    private static final Logger LOGGER = LoggerFactory.getLogger(Marshalling.class);
    private static Map<Type, String[]> typeCache = new HashMap<Type, String[]>();
    private static StringBuffer[] out = new StringBuffer[10];

    private Marshalling() {
    }

    public static String getDBusType(Type[] c) throws DBusException {
        StringBuffer sb = new StringBuffer();
        for (Type t : c) {
            for (String s : Marshalling.getDBusType(t)) {
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static String[] getDBusType(Type c) throws DBusException {
        String[] cached = typeCache.get(c);
        if (null != cached) {
            return cached;
        }
        cached = Marshalling.getDBusType(c, false);
        typeCache.put(c, cached);
        return cached;
    }

    public static String[] getDBusType(Type c, boolean basic) throws DBusException {
        return Marshalling.recursiveGetDBusType(c, basic, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] recursiveGetDBusType(Type c, boolean basic, int level) throws DBusException {
        block31: {
            Type[] ts;
            block69: {
                int n;
                Field[] fieldArray;
                block70: {
                    int s4;
                    int t3;
                    Type[] typeArray;
                    Vector<String> vs;
                    block42: {
                        int aioobe2;
                        Type[] t22;
                        block39: {
                            Type[] newtypes;
                            block35: {
                                block68: {
                                    block67: {
                                        String[] s2;
                                        block66: {
                                            block65: {
                                                block64: {
                                                    block63: {
                                                        block62: {
                                                            block61: {
                                                                block60: {
                                                                    block59: {
                                                                        block58: {
                                                                            block57: {
                                                                                block56: {
                                                                                    block55: {
                                                                                        block54: {
                                                                                            block53: {
                                                                                                block52: {
                                                                                                    block51: {
                                                                                                        block50: {
                                                                                                            block49: {
                                                                                                                block48: {
                                                                                                                    block47: {
                                                                                                                        block46: {
                                                                                                                            block45: {
                                                                                                                                block44: {
                                                                                                                                    block43: {
                                                                                                                                        block36: {
                                                                                                                                            ParameterizedType p;
                                                                                                                                            block41: {
                                                                                                                                                block40: {
                                                                                                                                                    block38: {
                                                                                                                                                        block37: {
                                                                                                                                                            block34: {
                                                                                                                                                                block33: {
                                                                                                                                                                    block32: {
                                                                                                                                                                        if (out.length <= level) {
                                                                                                                                                                            StringBuffer[] newout = new StringBuffer[out.length];
                                                                                                                                                                            System.arraycopy(out, 0, newout, 0, out.length);
                                                                                                                                                                            out = newout;
                                                                                                                                                                        }
                                                                                                                                                                        if (null == out[level]) {
                                                                                                                                                                            Marshalling.out[level] = new StringBuffer();
                                                                                                                                                                        } else {
                                                                                                                                                                            out[level].delete(0, out[level].length());
                                                                                                                                                                        }
                                                                                                                                                                        if (basic && !(c instanceof Class)) {
                                                                                                                                                                            throw new DBusException(c + Gettext.t(" is not a basic type"));
                                                                                                                                                                        }
                                                                                                                                                                        if (!(c instanceof TypeVariable)) break block32;
                                                                                                                                                                        out[level].append('v');
                                                                                                                                                                        break block31;
                                                                                                                                                                    }
                                                                                                                                                                    if (!(c instanceof GenericArrayType)) break block33;
                                                                                                                                                                    out[level].append('a');
                                                                                                                                                                    s2 = Marshalling.recursiveGetDBusType(((GenericArrayType)c).getGenericComponentType(), false, level + 1);
                                                                                                                                                                    if (s2.length != 1) {
                                                                                                                                                                        throw new DBusException(Gettext.t("Multi-valued array types not permitted"));
                                                                                                                                                                    }
                                                                                                                                                                    out[level].append(s2[0]);
                                                                                                                                                                    break block31;
                                                                                                                                                                }
                                                                                                                                                                if ((!(c instanceof Class) || !DBusSerializable.class.isAssignableFrom((Class)c)) && (!(c instanceof ParameterizedType) || !DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)c).getRawType()))) break block34;
                                                                                                                                                                newtypes = null;
                                                                                                                                                                if (c instanceof Class) {
                                                                                                                                                                    for (Method m : ((Class)c).getDeclaredMethods()) {
                                                                                                                                                                        if (!m.getName().equals("deserialize")) continue;
                                                                                                                                                                        newtypes = m.getGenericParameterTypes();
                                                                                                                                                                    }
                                                                                                                                                                } else {
                                                                                                                                                                    for (Method m : ((Class)((ParameterizedType)c).getRawType()).getDeclaredMethods()) {
                                                                                                                                                                        if (!m.getName().equals("deserialize")) continue;
                                                                                                                                                                        newtypes = m.getGenericParameterTypes();
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                                if (null == newtypes) {
                                                                                                                                                                    throw new DBusException(Gettext.t("Serializable classes must implement a deserialize method"));
                                                                                                                                                                }
                                                                                                                                                                break block35;
                                                                                                                                                            }
                                                                                                                                                            if (!(c instanceof ParameterizedType)) break block36;
                                                                                                                                                            p = (ParameterizedType)c;
                                                                                                                                                            if (!p.getRawType().equals(Map.class)) break block37;
                                                                                                                                                            out[level].append("a{");
                                                                                                                                                            Type[] t22 = p.getActualTypeArguments();
                                                                                                                                                            try {
                                                                                                                                                                String[] s3 = Marshalling.recursiveGetDBusType(t22[0], true, level + 1);
                                                                                                                                                                if (s3.length != 1) {
                                                                                                                                                                    throw new DBusException(Gettext.t("Multi-valued array types not permitted"));
                                                                                                                                                                }
                                                                                                                                                                out[level].append(s3[0]);
                                                                                                                                                                s3 = Marshalling.recursiveGetDBusType(t22[1], false, level + 1);
                                                                                                                                                                if (s3.length != 1) {
                                                                                                                                                                    throw new DBusException(Gettext.t("Multi-valued array types not permitted"));
                                                                                                                                                                }
                                                                                                                                                                out[level].append(s3[0]);
                                                                                                                                                            }
                                                                                                                                                            catch (ArrayIndexOutOfBoundsException aioobe2) {
                                                                                                                                                                if (AbstractConnection.EXCEPTION_DEBUG) {
                                                                                                                                                                    LOGGER.error("", (Throwable)aioobe2);
                                                                                                                                                                }
                                                                                                                                                                throw new DBusException(Gettext.t("Map must have 2 parameters"));
                                                                                                                                                            }
                                                                                                                                                            out[level].append('}');
                                                                                                                                                            break block31;
                                                                                                                                                        }
                                                                                                                                                        if (!List.class.isAssignableFrom((Class)p.getRawType())) break block38;
                                                                                                                                                        t22 = p.getActualTypeArguments();
                                                                                                                                                        aioobe2 = t22.length;
                                                                                                                                                        break block39;
                                                                                                                                                    }
                                                                                                                                                    if (!p.getRawType().equals(Variant.class)) break block40;
                                                                                                                                                    out[level].append('v');
                                                                                                                                                    break block31;
                                                                                                                                                }
                                                                                                                                                if (!DBusInterface.class.isAssignableFrom((Class)p.getRawType())) break block41;
                                                                                                                                                out[level].append('o');
                                                                                                                                                break block31;
                                                                                                                                            }
                                                                                                                                            if (!Tuple.class.isAssignableFrom((Class)p.getRawType())) {
                                                                                                                                                throw new DBusException(Gettext.t("Exporting non-exportable parameterized type ") + c);
                                                                                                                                            }
                                                                                                                                            Type[] ts2 = p.getActualTypeArguments();
                                                                                                                                            vs = new Vector<String>();
                                                                                                                                            typeArray = ts2;
                                                                                                                                            t3 = typeArray.length;
                                                                                                                                            s4 = 0;
                                                                                                                                            break block42;
                                                                                                                                        }
                                                                                                                                        if (!c.equals(Byte.class)) break block43;
                                                                                                                                        out[level].append('y');
                                                                                                                                        break block31;
                                                                                                                                    }
                                                                                                                                    if (!c.equals(Byte.TYPE)) break block44;
                                                                                                                                    out[level].append('y');
                                                                                                                                    break block31;
                                                                                                                                }
                                                                                                                                if (!c.equals(Boolean.class)) break block45;
                                                                                                                                out[level].append('b');
                                                                                                                                break block31;
                                                                                                                            }
                                                                                                                            if (!c.equals(Boolean.TYPE)) break block46;
                                                                                                                            out[level].append('b');
                                                                                                                            break block31;
                                                                                                                        }
                                                                                                                        if (!c.equals(Short.class)) break block47;
                                                                                                                        out[level].append('n');
                                                                                                                        break block31;
                                                                                                                    }
                                                                                                                    if (!c.equals(Short.TYPE)) break block48;
                                                                                                                    out[level].append('n');
                                                                                                                    break block31;
                                                                                                                }
                                                                                                                if (!c.equals(UInt16.class)) break block49;
                                                                                                                out[level].append('q');
                                                                                                                break block31;
                                                                                                            }
                                                                                                            if (!c.equals(Integer.class)) break block50;
                                                                                                            out[level].append('i');
                                                                                                            break block31;
                                                                                                        }
                                                                                                        if (!c.equals(Integer.TYPE)) break block51;
                                                                                                        out[level].append('i');
                                                                                                        break block31;
                                                                                                    }
                                                                                                    if (!c.equals(UInt32.class)) break block52;
                                                                                                    out[level].append('u');
                                                                                                    break block31;
                                                                                                }
                                                                                                if (!c.equals(Long.class)) break block53;
                                                                                                out[level].append('x');
                                                                                                break block31;
                                                                                            }
                                                                                            if (!c.equals(Long.TYPE)) break block54;
                                                                                            out[level].append('x');
                                                                                            break block31;
                                                                                        }
                                                                                        if (!c.equals(UInt64.class)) break block55;
                                                                                        out[level].append('t');
                                                                                        break block31;
                                                                                    }
                                                                                    if (!c.equals(Double.class)) break block56;
                                                                                    out[level].append('d');
                                                                                    break block31;
                                                                                }
                                                                                if (!c.equals(Double.TYPE)) break block57;
                                                                                out[level].append('d');
                                                                                break block31;
                                                                            }
                                                                            if (!c.equals(Float.class) || !AbstractConnection.FLOAT_SUPPORT) break block58;
                                                                            out[level].append('f');
                                                                            break block31;
                                                                        }
                                                                        if (!c.equals(Float.class)) break block59;
                                                                        out[level].append('d');
                                                                        break block31;
                                                                    }
                                                                    if (!c.equals(Float.TYPE) || !AbstractConnection.FLOAT_SUPPORT) break block60;
                                                                    out[level].append('f');
                                                                    break block31;
                                                                }
                                                                if (!c.equals(Float.TYPE)) break block61;
                                                                out[level].append('d');
                                                                break block31;
                                                            }
                                                            if (!c.equals(String.class)) break block62;
                                                            out[level].append('s');
                                                            break block31;
                                                        }
                                                        if (!c.equals(Variant.class)) break block63;
                                                        out[level].append('v');
                                                        break block31;
                                                    }
                                                    if (!(c instanceof Class) || !DBusInterface.class.isAssignableFrom((Class)c)) break block64;
                                                    out[level].append('o');
                                                    break block31;
                                                }
                                                if (!(c instanceof Class) || !Path.class.equals((Object)c)) break block65;
                                                out[level].append('o');
                                                break block31;
                                            }
                                            if (!(c instanceof Class) || !ObjectPath.class.equals((Object)c)) break block66;
                                            out[level].append('o');
                                            break block31;
                                        }
                                        if (!(c instanceof Class) || !((Class)c).isArray()) break block67;
                                        if (Type.class.equals(((Class)c).getComponentType())) {
                                            out[level].append('g');
                                            break block31;
                                        } else {
                                            out[level].append('a');
                                            s2 = Marshalling.recursiveGetDBusType(((Class)c).getComponentType(), false, level + 1);
                                            if (s2.length != 1) {
                                                throw new DBusException(Gettext.t("Multi-valued array types not permitted"));
                                            }
                                            out[level].append(s2[0]);
                                        }
                                        break block31;
                                    }
                                    if (!(c instanceof Class) || !Struct.class.isAssignableFrom((Class)c)) break block68;
                                    out[level].append('(');
                                    ts = Container.getTypeCache(c);
                                    if (null != ts) break block69;
                                    Field[] fs = ((Class)c).getDeclaredFields();
                                    ts = new Type[fs.length];
                                    fieldArray = fs;
                                    n = fieldArray.length;
                                    break block70;
                                }
                                throw new DBusException(Gettext.t("Exporting non-exportable type ") + c);
                            }
                            String[] sigs = new String[newtypes.length];
                            int j = 0;
                            while (true) {
                                if (j >= sigs.length) {
                                    return sigs;
                                }
                                String[] ss = Marshalling.recursiveGetDBusType(newtypes[j], false, level + 1);
                                if (1 != ss.length) {
                                    throw new DBusException(Gettext.t("Serializable classes must serialize to native DBus types"));
                                }
                                sigs[j] = ss[0];
                                ++j;
                            }
                        }
                        for (int i = 0; i < aioobe2; ++i) {
                            Type t3 = t22[i];
                            if (Type.class.equals((Object)t3)) {
                                out[level].append('g');
                                continue;
                            }
                            String[] s4 = Marshalling.recursiveGetDBusType(t3, false, level + 1);
                            if (s4.length != 1) {
                                throw new DBusException(Gettext.t("Multi-valued array types not permitted"));
                            }
                            out[level].append('a');
                            out[level].append(s4[0]);
                        }
                        break block31;
                    }
                    while (true) {
                        if (s4 >= t3) {
                            return vs.toArray(new String[0]);
                        }
                        Type t4 = typeArray[s4];
                        for (String s5 : Marshalling.recursiveGetDBusType(t4, false, level + 1)) {
                            vs.add(s5);
                        }
                        ++s4;
                    }
                }
                for (int t3 = 0; t3 < n; ++t3) {
                    Field f = fieldArray[t3];
                    Position p = f.getAnnotation(Position.class);
                    if (null == p) continue;
                    ts[p.value()] = f.getGenericType();
                }
                Container.putTypeCache(c, ts);
            }
            for (Type t : ts) {
                if (t == null) continue;
                for (String s : Marshalling.recursiveGetDBusType(t, false, level + 1)) {
                    out[level].append(s);
                }
            }
            out[level].append(')');
        }
        LOGGER.trace("Converted Java type: " + c + " to D-Bus Type: " + out[level]);
        return new String[]{out[level].toString()};
    }

    public static int getJavaType(String dbus, List<Type> rv, int limit) throws DBusException {
        if (null == dbus || "".equals(dbus) || 0 == limit) {
            return 0;
        }
        try {
            int i;
            block21: for (i = 0; i < dbus.length() && (-1 == limit || limit > rv.size()); ++i) {
                switch (dbus.charAt(i)) {
                    case '(': {
                        int j = i + 1;
                        int c = 1;
                        while (c > 0) {
                            if (')' == dbus.charAt(j)) {
                                --c;
                            } else if ('(' == dbus.charAt(j)) {
                                ++c;
                            }
                            ++j;
                        }
                        Vector<Type> contained = new Vector();
                        int c2 = Marshalling.getJavaType(dbus.substring(i + 1, j - 1), contained, -1);
                        rv.add(new DBusStructType(contained.toArray(new Type[0])));
                        i = j;
                        continue block21;
                    }
                    case 'a': {
                        int c2;
                        Vector<Type> contained;
                        if ('{' == dbus.charAt(i + 1)) {
                            contained = new Vector();
                            c2 = Marshalling.getJavaType(dbus.substring(i + 2), contained, 2);
                            rv.add(new DBusMapType(contained.get(0), contained.get(1)));
                            i += c2 + 2;
                            continue block21;
                        }
                        contained = new Vector();
                        c2 = Marshalling.getJavaType(dbus.substring(i + 1), contained, 1);
                        rv.add(new DBusListType(contained.get(0)));
                        i += c2;
                        continue block21;
                    }
                    case 'v': {
                        rv.add((Type)((Object)Variant.class));
                        continue block21;
                    }
                    case 'b': {
                        rv.add((Type)((Object)Boolean.class));
                        continue block21;
                    }
                    case 'n': {
                        rv.add((Type)((Object)Short.class));
                        continue block21;
                    }
                    case 'y': {
                        rv.add((Type)((Object)Byte.class));
                        continue block21;
                    }
                    case 'o': {
                        rv.add((Type)((Object)DBusInterface.class));
                        continue block21;
                    }
                    case 'q': {
                        rv.add((Type)((Object)UInt16.class));
                        continue block21;
                    }
                    case 'i': {
                        rv.add((Type)((Object)Integer.class));
                        continue block21;
                    }
                    case 'u': {
                        rv.add((Type)((Object)UInt32.class));
                        continue block21;
                    }
                    case 'x': {
                        rv.add((Type)((Object)Long.class));
                        continue block21;
                    }
                    case 't': {
                        rv.add((Type)((Object)UInt64.class));
                        continue block21;
                    }
                    case 'd': {
                        rv.add((Type)((Object)Double.class));
                        continue block21;
                    }
                    case 'f': {
                        rv.add((Type)((Object)Float.class));
                        continue block21;
                    }
                    case 's': {
                        rv.add((Type)((Object)String.class));
                        continue block21;
                    }
                    case 'g': {
                        rv.add((Type)((Object)Type[].class));
                        continue block21;
                    }
                    case '{': {
                        rv.add((Type)((Object)Map.Entry.class));
                        Vector<Type> contained = new Vector<Type>();
                        int c2 = Marshalling.getJavaType(dbus.substring(i + 1), contained, 2);
                        i += c2 + 1;
                        continue block21;
                    }
                    default: {
                        throw new DBusException(MessageFormat.format(Gettext.t("Failed to parse DBus type signature: {0} ({1})."), dbus, Character.valueOf(dbus.charAt(i))));
                    }
                }
            }
            return i;
        }
        catch (IndexOutOfBoundsException ioobe) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                LOGGER.error("", (Throwable)ioobe);
            }
            throw new DBusException(Gettext.t("Failed to parse DBus type signature: ") + dbus);
        }
    }

    public static Object[] convertParameters(Object[] parameters, Type[] types, AbstractConnection conn) throws DBusException {
        if (null == parameters) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            LOGGER.trace("Converting " + i + " from " + parameters[i] + " to " + types[i]);
            if (null == parameters[i]) continue;
            if (parameters[i] instanceof DBusSerializable) {
                for (Method m : parameters[i].getClass().getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Class<?>[] newtypes = m.getParameterTypes();
                    Type[] expand = new Type[types.length + newtypes.length - 1];
                    System.arraycopy(types, 0, expand, 0, i);
                    System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                    System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                    types = expand;
                    Object[] newparams = ((DBusSerializable)parameters[i]).serialize();
                    Object[] exparams = new Object[parameters.length + newparams.length - 1];
                    System.arraycopy(parameters, 0, exparams, 0, i);
                    System.arraycopy(newparams, 0, exparams, i, newparams.length);
                    System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                    parameters = exparams;
                }
                --i;
                continue;
            }
            if (parameters[i] instanceof Tuple) {
                Type[] newtypes = ((ParameterizedType)types[i]).getActualTypeArguments();
                Type[] expand = new Type[types.length + newtypes.length - 1];
                System.arraycopy(types, 0, expand, 0, i);
                System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                types = expand;
                Object[] newparams = ((Tuple)parameters[i]).getParameters();
                Object[] exparams = new Object[parameters.length + newparams.length - 1];
                System.arraycopy(parameters, 0, exparams, 0, i);
                System.arraycopy(newparams, 0, exparams, i, newparams.length);
                System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                parameters = exparams;
                LOGGER.trace("New params: " + Arrays.deepToString(parameters) + " new types: " + Arrays.deepToString(types));
                --i;
                continue;
            }
            if (types[i] instanceof TypeVariable && !(parameters[i] instanceof Variant)) {
                parameters[i] = new Variant<Object>(parameters[i]);
                continue;
            }
            if (!(parameters[i] instanceof DBusInterface)) continue;
            parameters[i] = conn.getExportedObject((DBusInterface)parameters[i]);
        }
        return parameters;
    }

    /*
     * WARNING - void declaration
     */
    static Object deSerializeParameter(Object parameter, Type type, AbstractConnection conn) throws Exception {
        Type type2;
        Object[] ts;
        LOGGER.trace("Deserializing from " + parameter.getClass() + " to " + type.getClass());
        if (type instanceof TypeVariable && parameter instanceof Variant) {
            parameter = ((Variant)parameter).getValue();
        }
        if (type instanceof Class && ((Class)type).isArray() && ((Class)type).getComponentType().equals(Type.class) && parameter instanceof String) {
            Vector<Type> rv = new Vector<Type>();
            Marshalling.getJavaType((String)parameter, rv, -1);
            parameter = rv.toArray(new Type[0]);
        }
        if (parameter instanceof ObjectPath) {
            parameter = type instanceof Class && DBusInterface.class.isAssignableFrom((Class)type) ? conn.getExportedObject(((ObjectPath)parameter).source, ((ObjectPath)parameter).path) : new Path(((ObjectPath)parameter).path);
        }
        if (parameter instanceof Object[] && type instanceof Class && Struct.class.isAssignableFrom((Class)type)) {
            LOGGER.trace("Creating Struct " + type + " from " + parameter);
            ts = Container.getTypeCache(type);
            if (null == ts) {
                void var7_12;
                AccessibleObject[] fs = ((Class)type).getDeclaredFields();
                ts = new Type[fs.length];
                Field[] fieldArray = fs;
                int n = fieldArray.length;
                boolean i = false;
                while (var7_12 < n) {
                    Field f = fieldArray[var7_12];
                    Position p = f.getAnnotation(Position.class);
                    if (null != p) {
                        ts[p.value()] = f.getGenericType();
                    }
                    ++var7_12;
                }
                Container.putTypeCache(type, (Type[])ts);
            }
            parameter = Marshalling.deSerializeParameters(parameter, (Type[])ts, conn);
            for (AccessibleObject accessibleObject : ((Class)type).getDeclaredConstructors()) {
                try {
                    parameter = ((Constructor)accessibleObject).newInstance(parameter);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        if (parameter instanceof Object[]) {
            ts = new Type[((Object[])parameter).length];
            Arrays.fill(ts, parameter.getClass().getComponentType());
            parameter = Marshalling.deSerializeParameters(parameter, (Type[])ts, conn);
        }
        if (parameter instanceof List && null != (type2 = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : (type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : (type instanceof Class && ((Class)type).isArray() ? ((Class)type).getComponentType() : null)))) {
            parameter = Marshalling.deSerializeParameters((List)parameter, type2, conn);
        }
        if ((type.equals(Float.class) || type.equals(Float.TYPE)) && !(parameter instanceof Float)) {
            parameter = Float.valueOf(((Number)parameter).floatValue());
        }
        if (parameter instanceof Object[] || parameter instanceof List || parameter.getClass().isArray()) {
            if (type instanceof ParameterizedType) {
                parameter = ArrayFrob.convert(parameter, (Class)((ParameterizedType)type).getRawType());
            } else if (type instanceof GenericArrayType) {
                Type ct = ((GenericArrayType)type).getGenericComponentType();
                Class cc = null;
                if (ct instanceof Class) {
                    cc = (Class)ct;
                }
                if (ct instanceof ParameterizedType) {
                    cc = (Class)((ParameterizedType)ct).getRawType();
                }
                Object o = Array.newInstance(cc, 0);
                parameter = ArrayFrob.convert(parameter, o.getClass());
            } else if (type instanceof Class && ((Class)type).isArray()) {
                Class<?> cc = ((Class)type).getComponentType();
                if ((cc.equals(Float.class) || cc.equals(Float.TYPE)) && parameter instanceof double[]) {
                    double[] tmp1 = (double[])parameter;
                    float[] tmp2 = new float[tmp1.length];
                    for (int i = 0; i < tmp1.length; ++i) {
                        tmp2[i] = (float)tmp1[i];
                    }
                    parameter = tmp2;
                }
                Object o = Array.newInstance(cc, 0);
                parameter = ArrayFrob.convert(parameter, o.getClass());
            }
        }
        if (parameter instanceof DBusMap) {
            LOGGER.trace("Deserializing a Map");
            DBusMap dmap = (DBusMap)parameter;
            Type[] maptypes = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < dmap.entries.length; ++i) {
                dmap.entries[i][0] = Marshalling.deSerializeParameter(dmap.entries[i][0], maptypes[0], conn);
                dmap.entries[i][1] = Marshalling.deSerializeParameter(dmap.entries[i][1], maptypes[1], conn);
            }
        }
        return parameter;
    }

    static List<Object> deSerializeParameters(List<Object> parameters, Type type, AbstractConnection conn) throws Exception {
        LOGGER.trace("Deserializing from " + parameters + " to " + type);
        if (null == parameters) {
            return null;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (null == parameters.get(i)) continue;
            parameters.set(i, Marshalling.deSerializeParameter(parameters.get(i), type, conn));
        }
        return parameters;
    }

    static Object[] deSerializeParameters(Object[] parameters, Type[] types, AbstractConnection conn) throws Exception {
        LOGGER.trace("Deserializing from " + Arrays.deepToString(parameters) + " to " + Arrays.deepToString(types));
        if (null == parameters) {
            return null;
        }
        if (types.length == 1 && types[0] instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)types[0]).getRawType())) {
            types = ((ParameterizedType)types[0]).getActualTypeArguments();
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (i >= types.length) {
                if (LOGGER.isDebugEnabled()) {
                    for (int j = 0; j < parameters.length; ++j) {
                        LOGGER.error(String.format("Error, Parameters difference (%1d, '%2s')", j, parameters[j].toString()));
                    }
                }
                throw new DBusException(Gettext.t("Error deserializing message: number of parameters didn't match receiving signature"));
            }
            if (null == parameters[i]) continue;
            if (types[i] instanceof Class && DBusSerializable.class.isAssignableFrom((Class)types[i]) || types[i] instanceof ParameterizedType && DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)types[i]).getRawType())) {
                Class dsc = types[i] instanceof Class ? (Class)types[i] : (Class)((ParameterizedType)types[i]).getRawType();
                for (Method m : dsc.getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Type[] newtypes = m.getGenericParameterTypes();
                    try {
                        Object[] sub = new Object[newtypes.length];
                        System.arraycopy(parameters, i, sub, 0, newtypes.length);
                        sub = Marshalling.deSerializeParameters(sub, newtypes, conn);
                        DBusSerializable sz = (DBusSerializable)dsc.newInstance();
                        m.invoke((Object)sz, sub);
                        Object[] compress = new Object[parameters.length - newtypes.length + 1];
                        System.arraycopy(parameters, 0, compress, 0, i);
                        compress[i] = sz;
                        System.arraycopy(parameters, i + newtypes.length, compress, i + 1, parameters.length - i - newtypes.length);
                        parameters = compress;
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            LOGGER.error("", (Throwable)aioobe);
                        }
                        throw new DBusException(MessageFormat.format(Gettext.t("Not enough elements to create custom object from serialized data ({0} < {1})."), parameters.length - i, newtypes.length));
                    }
                }
                continue;
            }
            parameters[i] = Marshalling.deSerializeParameter(parameters[i], types[i], conn);
        }
        return parameters;
    }
}

