/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.unix.UnixServerSocket;
import cx.ath.matthew.unix.UnixSocket;
import cx.ath.matthew.unix.UnixSocketAddress;
import cx.ath.matthew.utils.Hexdump;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MessageReader;
import org.freedesktop.dbus.MessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public MessageReader min;
    public MessageWriter mout;

    public Transport() {
    }

    public static String genGUID() {
        Random r = new Random();
        byte[] buf = new byte[16];
        r.nextBytes(buf);
        String guid = Hexdump.toHex((byte[])buf);
        return guid.replaceAll(" ", "");
    }

    public Transport(BusAddress address) throws IOException {
        this.connect(address);
    }

    public Transport(String address) throws IOException, ParseException {
        this.connect(new BusAddress(address));
    }

    public Transport(String address, int timeout) throws IOException, ParseException {
        this.connect(new BusAddress(address), timeout);
    }

    public void connect(String address) throws IOException, ParseException {
        this.connect(new BusAddress(address), 0);
    }

    public void connect(String address, int timeout) throws IOException, ParseException {
        this.connect(new BusAddress(address), timeout);
    }

    public void connect(BusAddress address) throws IOException {
        this.connect(address, 0);
    }

    public void connect(BusAddress address, int timeout) throws IOException {
        this.logger.info("Connecting to " + address);
        OutputStream out = null;
        InputStream in = null;
        UnixSocket us = null;
        Socket s = null;
        int mode = 0;
        int types = 0;
        if ("unix".equals(address.getType())) {
            types = 1;
            if (null != address.getParameter("listen")) {
                mode = 1;
                UnixServerSocket uss = new UnixServerSocket();
                if (null != address.getParameter("abstract")) {
                    uss.bind(new UnixSocketAddress(address.getParameter("abstract"), true));
                } else if (null != address.getParameter("path")) {
                    uss.bind(new UnixSocketAddress(address.getParameter("path"), false));
                }
                us = uss.accept();
            } else {
                mode = 2;
                us = new UnixSocket();
                if (null != address.getParameter("abstract")) {
                    us.connect(new UnixSocketAddress(address.getParameter("abstract"), true));
                } else if (null != address.getParameter("path")) {
                    us.connect(new UnixSocketAddress(address.getParameter("path"), false));
                }
            }
            us.setPassCred(true);
            in = us.getInputStream();
            out = us.getOutputStream();
        } else if ("tcp".equals(address.getType())) {
            types = 2;
            if (null != address.getParameter("listen")) {
                mode = 1;
                try (ServerSocket ss = new ServerSocket();){
                    ss.bind(new InetSocketAddress(address.getParameter("host"), Integer.parseInt(address.getParameter("port"))));
                    s = ss.accept();
                }
            } else {
                mode = 2;
                s = new Socket();
                s.connect(new InetSocketAddress(address.getParameter("host"), Integer.parseInt(address.getParameter("port"))));
            }
            in = s.getInputStream();
            out = s.getOutputStream();
        } else {
            throw new IOException(Gettext.t("unknown address type ") + address.getType());
        }
        if (!new SASL().auth(mode, types, address.getParameter("guid"), out, in, us)) {
            out.close();
            throw new IOException(Gettext.t("Failed to auth"));
        }
        if (null != us) {
            this.logger.trace("Setting timeout to " + timeout + " on Socket");
            if (timeout == 1) {
                us.setBlocking(false);
            } else {
                us.setSoTimeout(timeout);
            }
        }
        if (null != s) {
            this.logger.trace("Setting timeout to " + timeout + " on Socket");
            s.setSoTimeout(timeout);
        }
        this.mout = new MessageWriter(out);
        this.min = new MessageReader(in);
    }

    public void disconnect() throws IOException {
        this.logger.info("Disconnecting Transport");
        this.min.close();
        this.mout.close();
    }

    public static class SASL {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private static Collator col = Collator.getInstance();
        public static final int LOCK_TIMEOUT = 1000;
        public static final int NEW_KEY_TIMEOUT_SECONDS = 300;
        public static final int EXPIRE_KEYS_TIMEOUT_SECONDS = 420;
        public static final int MAX_TIME_TRAVEL_SECONDS = 300;
        public static final int COOKIE_TIMEOUT = 240;
        public static final String COOKIE_CONTEXT = "org_freedesktop_java";
        public static final int MODE_SERVER = 1;
        public static final int MODE_CLIENT = 2;
        public static final int AUTH_NONE = 0;
        public static final int AUTH_EXTERNAL = 1;
        public static final int AUTH_SHA = 2;
        public static final int AUTH_ANON = 4;
        public static final int COMMAND_AUTH = 1;
        public static final int COMMAND_DATA = 2;
        public static final int COMMAND_REJECTED = 3;
        public static final int COMMAND_OK = 4;
        public static final int COMMAND_BEGIN = 5;
        public static final int COMMAND_CANCEL = 6;
        public static final int COMMAND_ERROR = 7;
        public static final int INITIAL_STATE = 0;
        public static final int WAIT_DATA = 1;
        public static final int WAIT_OK = 2;
        public static final int WAIT_REJECT = 3;
        public static final int WAIT_AUTH = 4;
        public static final int WAIT_BEGIN = 5;
        public static final int AUTHENTICATED = 6;
        public static final int FAILED = 7;
        public static final int OK = 1;
        public static final int CONTINUE = 2;
        public static final int ERROR = 3;
        public static final int REJECT = 4;
        public String challenge = "";
        public String cookie = "";

        private String findCookie(String context, String ID) throws IOException {
            String homedir = System.getProperty("user.home");
            File f = new File(homedir + "/.dbus-keyrings/" + context);
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String s = null;
            String lCookie = null;
            long now = System.currentTimeMillis() / 1000L;
            while (null != (s = r.readLine())) {
                String[] line = s.split(" ");
                long timestamp = Long.parseLong(line[1]);
                if (!line[0].equals(ID) || timestamp < 0L || now + 300L < timestamp || now - 420L > timestamp) continue;
                lCookie = line[2];
                break;
            }
            r.close();
            return lCookie;
        }

        private void addCookie(String _context, String _id, long _timestamp, String _cookie) throws IOException {
            String homedir = System.getProperty("user.home");
            File keydir = new File(homedir + "/.dbus-keyrings/");
            File cookiefile = new File(homedir + "/.dbus-keyrings/" + _context);
            File lock = new File(homedir + "/.dbus-keyrings/" + _context + ".lock");
            File temp = new File(homedir + "/.dbus-keyrings/" + _context + ".temp");
            if (!keydir.exists()) {
                keydir.mkdirs();
            }
            long start = System.currentTimeMillis();
            while (!lock.createNewFile() && 1000L > System.currentTimeMillis() - start) {
            }
            Vector<String> lines = new Vector<String>();
            if (cookiefile.exists()) {
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(cookiefile)));
                String s = null;
                while (null != (s = r.readLine())) {
                    String[] line = s.split(" ");
                    long time = Long.parseLong(line[1]);
                    if (_timestamp - time >= 240L) continue;
                    lines.add(s);
                }
                r.close();
            }
            lines.add(_id + " " + _timestamp + " " + _cookie);
            PrintWriter w = new PrintWriter(new FileOutputStream(temp));
            for (String l : lines) {
                w.println(l);
            }
            w.close();
            if (!temp.renameTo(cookiefile)) {
                cookiefile.delete();
                temp.renameTo(cookiefile);
            }
            lock.delete();
        }

        private String stupidlyEncode(String data) {
            return Hexdump.toHex((byte[])data.getBytes()).replaceAll(" ", "");
        }

        private String stupidlyEncode(byte[] data) {
            return Hexdump.toHex((byte[])data).replaceAll(" ", "");
        }

        private byte getNibble(char c) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return (byte)(c - 48);
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    return (byte)(c - 65 + 10);
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return (byte)(c - 97 + 10);
                }
            }
            return 0;
        }

        private String stupidlyDecode(String data) {
            char[] cs = new char[data.length()];
            char[] res = new char[cs.length / 2];
            data.getChars(0, data.length(), cs, 0);
            int i = 0;
            for (int j = 0; j < res.length; ++j) {
                int b = 0;
                b |= this.getNibble(cs[i]) << 4;
                res[j] = (char)(b |= this.getNibble(cs[i + 1]));
                i += 2;
            }
            return new String(res);
        }

        public Command receive(InputStream s) throws IOException {
            StringBuffer sb = new StringBuffer();
            block7: while (true) {
                int c = s.read();
                switch (c) {
                    case -1: {
                        throw new IOException("Stream unexpectedly short (broken pipe)");
                    }
                    case 0: 
                    case 13: {
                        continue block7;
                    }
                    case 10: {
                        break block7;
                    }
                    default: {
                        sb.append((char)c);
                        continue block7;
                    }
                }
                break;
            }
            this.logger.trace("received: " + sb);
            try {
                return new Command(sb.toString());
            }
            catch (Exception e) {
                if (AbstractConnection.EXCEPTION_DEBUG) {
                    this.logger.error("", (Throwable)e);
                }
                return new Command();
            }
        }

        public void send(OutputStream out, int command, String ... data) throws IOException {
            StringBuffer sb = new StringBuffer();
            switch (command) {
                case 1: {
                    sb.append("AUTH");
                    break;
                }
                case 2: {
                    sb.append("DATA");
                    break;
                }
                case 3: {
                    sb.append("REJECTED");
                    break;
                }
                case 4: {
                    sb.append("OK");
                    break;
                }
                case 5: {
                    sb.append("BEGIN");
                    break;
                }
                case 6: {
                    sb.append("CANCEL");
                    break;
                }
                case 7: {
                    sb.append("ERROR");
                    break;
                }
                default: {
                    return;
                }
            }
            for (String s : data) {
                sb.append(' ');
                sb.append(s);
            }
            sb.append('\r');
            sb.append('\n');
            this.logger.trace("sending: " + sb);
            out.write(sb.toString().getBytes());
        }

        public int do_challenge(int _auth, Command c) throws IOException {
            switch (_auth) {
                case 2: {
                    Object[] reply = this.stupidlyDecode(c.getData()).split(" ");
                    this.logger.trace(Arrays.toString(reply));
                    if (3 != reply.length) {
                        this.logger.debug("Reply is not length 3");
                        return 3;
                    }
                    Object context = reply[0];
                    Object id = reply[1];
                    Object serverchallenge = reply[2];
                    MessageDigest md = null;
                    try {
                        md = MessageDigest.getInstance("SHA");
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            this.logger.error("", (Throwable)nsae);
                        }
                        return 3;
                    }
                    byte[] buf = new byte[8];
                    Message.marshallintBig(System.currentTimeMillis(), buf, 0, 8);
                    String clientchallenge = this.stupidlyEncode(md.digest(buf));
                    md.reset();
                    long start = System.currentTimeMillis();
                    String lCookie = null;
                    while (null == lCookie && System.currentTimeMillis() - start < 1000L) {
                        lCookie = this.findCookie((String)context, (String)id);
                    }
                    if (null == lCookie) {
                        this.logger.debug("Did not find a cookie in context " + (String)context + " with ID " + (String)id);
                        return 3;
                    }
                    String response = (String)serverchallenge + ":" + clientchallenge + ":" + lCookie;
                    buf = md.digest(response.getBytes());
                    this.logger.trace("Response: " + response + " hash: " + Hexdump.format((byte[])buf));
                    response = this.stupidlyEncode(buf);
                    c.setResponse(this.stupidlyEncode(clientchallenge + " " + response));
                    return 1;
                }
            }
            this.logger.debug("Not DBUS_COOKIE_SHA1 authtype.");
            return 3;
        }

        /*
         * Unable to fully structure code
         */
        public int do_response(int _auth, String _uid, String _kernelUid, Command _c) {
            md = null;
            try {
                md = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException nsae) {
                if (AbstractConnection.EXCEPTION_DEBUG) {
                    this.logger.error("", (Throwable)nsae);
                }
                return 3;
            }
            switch (_auth) {
                case 0: {
                    switch (_c.getMechs()) {
                        case 4: {
                            return 1;
                        }
                        case 1: {
                            if (0 == SASL.col.compare(_uid, _c.getData()) && (null == _kernelUid || 0 == SASL.col.compare(_uid, _kernelUid))) {
                                return 1;
                            }
                            return 3;
                        }
                        case 2: {
                            context = "org_freedesktop_java";
                            id = System.currentTimeMillis();
                            buf = new byte[8];
                            Message.marshallintBig(id, buf, 0, 8);
                            this.challenge = this.stupidlyEncode(md.digest(buf));
                            r = new Random();
                            r.nextBytes(buf);
                            this.cookie = this.stupidlyEncode(md.digest(buf));
                            try {
                                this.addCookie(context, "" + id, id / 1000L, this.cookie);
                            }
                            catch (IOException ioe) {
                                if (!AbstractConnection.EXCEPTION_DEBUG) ** GOTO lbl33
                                this.logger.error("", (Throwable)ioe);
                            }
lbl33:
                            // 3 sources

                            this.logger.debug("Sending challenge: " + context + ' ' + id + ' ' + this.challenge);
                            _c.setResponse(this.stupidlyEncode(context + ' ' + id + ' ' + this.challenge));
                            return 2;
                        }
                    }
                    return 3;
                }
                case 2: {
                    response = this.stupidlyDecode(_c.getData()).split(" ");
                    if (response.length < 2) {
                        return 3;
                    }
                    cchal = response[0];
                    hash = response[1];
                    prehash = this.challenge + ":" + cchal + ":" + this.cookie;
                    buf = md.digest(prehash.getBytes());
                    posthash = this.stupidlyEncode(buf);
                    this.logger.debug("Authenticating Hash; data=" + prehash + " remote hash=" + hash + " local hash=" + posthash);
                    if (0 == SASL.col.compare(posthash, hash)) {
                        return 1;
                    }
                    return 3;
                }
            }
            return 3;
        }

        public String[] getTypes(int types) {
            switch (types) {
                case 1: {
                    return new String[]{"EXTERNAL"};
                }
                case 2: {
                    return new String[]{"DBUS_COOKIE_SHA1"};
                }
                case 4: {
                    return new String[]{"ANONYMOUS"};
                }
                case 3: {
                    return new String[]{"EXTERNAL", "DBUS_COOKIE_SHA1"};
                }
                case 6: {
                    return new String[]{"ANONYMOUS", "DBUS_COOKIE_SHA1"};
                }
                case 5: {
                    return new String[]{"ANONYMOUS", "EXTERNAL"};
                }
                case 7: {
                    return new String[]{"ANONYMOUS", "EXTERNAL", "DBUS_COOKIE_SHA1"};
                }
            }
            return new String[0];
        }

        public boolean auth(int mode, int types, String guid, OutputStream out, InputStream in, UnixSocket us) throws IOException {
            Object c;
            String username = System.getProperty("user.name");
            String luid = null;
            String kernelUid = null;
            try {
                c = Class.forName("com.sun.security.auth.module.UnixSystem");
                Method m = ((Class)c).getMethod("getUid", new Class[0]);
                Object o = ((Class)c).newInstance();
                long uid = (Long)m.invoke(o, new Object[0]);
                luid = this.stupidlyEncode("" + uid);
            }
            catch (Exception e) {
                luid = this.stupidlyEncode(username);
            }
            int failed = 0;
            int current = 0;
            int state = 0;
            block61: while (state != 6 && state != 7) {
                this.logger.trace("AUTH state: " + state);
                switch (mode) {
                    case 2: {
                        switch (state) {
                            case 0: {
                                if (null == us) {
                                    out.write(new byte[]{0});
                                } else {
                                    us.sendCredentialByte((byte)0);
                                }
                                this.send(out, 1, new String[0]);
                                state = 1;
                                continue block61;
                            }
                            case 1: {
                                c = this.receive(in);
                                switch (((Command)c).getCommand()) {
                                    case 2: {
                                        switch (this.do_challenge(current, (Command)c)) {
                                            case 2: {
                                                this.send(out, 2, ((Command)c).getResponse());
                                                break;
                                            }
                                            case 1: {
                                                this.send(out, 2, ((Command)c).getResponse());
                                                state = 2;
                                                break;
                                            }
                                            case 3: {
                                                this.send(out, 7, ((Command)c).getResponse());
                                            }
                                        }
                                        continue block61;
                                    }
                                    case 3: {
                                        int available = ((Command)c).getMechs() & ~(failed |= current);
                                        if (0 != (available & 1)) {
                                            this.send(out, 1, "EXTERNAL", luid);
                                            current = 1;
                                            continue block61;
                                        }
                                        if (0 != (available & 2)) {
                                            this.send(out, 1, "DBUS_COOKIE_SHA1", luid);
                                            current = 2;
                                            continue block61;
                                        }
                                        if (0 != (available & 4)) {
                                            this.send(out, 1, "ANONYMOUS");
                                            current = 4;
                                            continue block61;
                                        }
                                        state = 7;
                                        continue block61;
                                    }
                                    case 7: {
                                        this.send(out, 6, new String[0]);
                                        state = 3;
                                        continue block61;
                                    }
                                    case 4: {
                                        this.send(out, 5, new String[0]);
                                        state = 6;
                                        continue block61;
                                    }
                                }
                                this.send(out, 7, "Got invalid command");
                                continue block61;
                            }
                            case 2: {
                                c = this.receive(in);
                                switch (((Command)c).getCommand()) {
                                    case 4: {
                                        this.send(out, 5, new String[0]);
                                        state = 6;
                                        continue block61;
                                    }
                                    case 2: 
                                    case 7: {
                                        this.send(out, 6, new String[0]);
                                        state = 3;
                                        continue block61;
                                    }
                                    case 3: {
                                        int available = ((Command)c).getMechs() & ~(failed |= current);
                                        state = 1;
                                        if (0 != (available & 1)) {
                                            this.send(out, 1, "EXTERNAL", luid);
                                            current = 1;
                                            continue block61;
                                        }
                                        if (0 != (available & 2)) {
                                            this.send(out, 1, "DBUS_COOKIE_SHA1", luid);
                                            current = 2;
                                            continue block61;
                                        }
                                        if (0 != (available & 4)) {
                                            this.send(out, 1, "ANONYMOUS");
                                            current = 4;
                                            continue block61;
                                        }
                                        state = 7;
                                        continue block61;
                                    }
                                }
                                this.send(out, 7, "Got invalid command");
                                continue block61;
                            }
                            case 3: {
                                c = this.receive(in);
                                switch (((Command)c).getCommand()) {
                                    case 3: {
                                        int available = ((Command)c).getMechs() & ~(failed |= current);
                                        if (0 != (available & 1)) {
                                            this.send(out, 1, "EXTERNAL", luid);
                                            current = 1;
                                            continue block61;
                                        }
                                        if (0 != (available & 2)) {
                                            this.send(out, 1, "DBUS_COOKIE_SHA1", luid);
                                            current = 2;
                                            continue block61;
                                        }
                                        if (0 != (available & 4)) {
                                            this.send(out, 1, "ANONYMOUS");
                                            current = 4;
                                            continue block61;
                                        }
                                        state = 7;
                                        continue block61;
                                    }
                                }
                                state = 7;
                                continue block61;
                            }
                        }
                        state = 7;
                        continue block61;
                    }
                    case 1: {
                        switch (state) {
                            case 0: {
                                byte[] buf = new byte[1];
                                if (null == us) {
                                    in.read(buf);
                                } else {
                                    buf[0] = us.recvCredentialByte();
                                    int kuid = us.getPeerUID();
                                    if (kuid >= 0) {
                                        kernelUid = this.stupidlyEncode("" + kuid);
                                    }
                                }
                                if (0 != buf[0]) {
                                    state = 7;
                                    continue block61;
                                }
                                state = 4;
                                continue block61;
                            }
                            case 4: {
                                c = this.receive(in);
                                switch (((Command)c).getCommand()) {
                                    case 1: {
                                        if (null == ((Command)c).getData()) {
                                            this.send(out, 3, this.getTypes(types));
                                            continue block61;
                                        }
                                        switch (this.do_response(current, luid, kernelUid, (Command)c)) {
                                            case 2: {
                                                this.send(out, 2, ((Command)c).getResponse());
                                                current = ((Command)c).getMechs();
                                                state = 1;
                                                break;
                                            }
                                            case 1: {
                                                this.send(out, 4, guid);
                                                state = 5;
                                                current = 0;
                                                break;
                                            }
                                            case 4: {
                                                this.send(out, 3, this.getTypes(types));
                                                current = 0;
                                            }
                                        }
                                        continue block61;
                                    }
                                    case 7: {
                                        this.send(out, 3, this.getTypes(types));
                                        continue block61;
                                    }
                                    case 5: {
                                        state = 7;
                                        continue block61;
                                    }
                                }
                                this.send(out, 7, "Got invalid command");
                                continue block61;
                            }
                            case 1: {
                                c = this.receive(in);
                                switch (((Command)c).getCommand()) {
                                    case 2: {
                                        switch (this.do_response(current, luid, kernelUid, (Command)c)) {
                                            case 2: {
                                                this.send(out, 2, ((Command)c).getResponse());
                                                state = 1;
                                                break;
                                            }
                                            case 1: {
                                                this.send(out, 4, guid);
                                                state = 5;
                                                current = 0;
                                                break;
                                            }
                                            case 4: {
                                                this.send(out, 3, this.getTypes(types));
                                                current = 0;
                                            }
                                        }
                                        continue block61;
                                    }
                                    case 6: 
                                    case 7: {
                                        this.send(out, 3, this.getTypes(types));
                                        state = 4;
                                        continue block61;
                                    }
                                    case 5: {
                                        state = 7;
                                        continue block61;
                                    }
                                }
                                this.send(out, 7, "Got invalid command");
                                continue block61;
                            }
                            case 5: {
                                c = this.receive(in);
                                switch (((Command)c).getCommand()) {
                                    case 6: 
                                    case 7: {
                                        this.send(out, 3, this.getTypes(types));
                                        state = 4;
                                        continue block61;
                                    }
                                    case 5: {
                                        state = 6;
                                        continue block61;
                                    }
                                }
                                this.send(out, 7, "Got invalid command");
                                continue block61;
                            }
                        }
                        state = 7;
                        continue block61;
                    }
                }
                return false;
            }
            return state == 6;
        }

        static {
            col.setDecomposition(2);
            col.setStrength(0);
        }

        public static class Command {
            private final Logger logger = LoggerFactory.getLogger(this.getClass());
            private int command;
            private int mechs;
            private String data;
            private String response;

            public Command() {
            }

            public Command(String s) throws IOException {
                Object[] ss = s.split(" ");
                this.logger.trace("Creating command from: " + Arrays.toString(ss));
                if (0 == col.compare((String)ss[0], "OK")) {
                    this.command = 4;
                    this.data = ss[1];
                } else if (0 == col.compare((String)ss[0], "AUTH")) {
                    this.command = 1;
                    if (ss.length > 1) {
                        if (0 == col.compare((String)ss[1], "EXTERNAL")) {
                            this.mechs = 1;
                        } else if (0 == col.compare((String)ss[1], "DBUS_COOKIE_SHA1")) {
                            this.mechs = 2;
                        } else if (0 == col.compare((String)ss[1], "ANONYMOUS")) {
                            this.mechs = 4;
                        }
                    }
                    if (ss.length > 2) {
                        this.data = ss[2];
                    }
                } else if (0 == col.compare((String)ss[0], "DATA")) {
                    this.command = 2;
                    this.data = ss[1];
                } else if (0 == col.compare((String)ss[0], "REJECTED")) {
                    this.command = 3;
                    for (int i = 1; i < ss.length; ++i) {
                        if (0 == col.compare((String)ss[i], "EXTERNAL")) {
                            this.mechs |= 1;
                            continue;
                        }
                        if (0 == col.compare((String)ss[i], "DBUS_COOKIE_SHA1")) {
                            this.mechs |= 2;
                            continue;
                        }
                        if (0 != col.compare((String)ss[i], "ANONYMOUS")) continue;
                        this.mechs |= 4;
                    }
                } else if (0 == col.compare((String)ss[0], "BEGIN")) {
                    this.command = 5;
                } else if (0 == col.compare((String)ss[0], "CANCEL")) {
                    this.command = 6;
                } else if (0 == col.compare((String)ss[0], "ERROR")) {
                    this.command = 7;
                    this.data = ss[1];
                } else {
                    throw new IOException(Gettext.t("Invalid Command ") + (String)ss[0]);
                }
                this.logger.trace("Created command: " + this);
            }

            public int getCommand() {
                return this.command;
            }

            public int getMechs() {
                return this.mechs;
            }

            public String getData() {
                return this.data;
            }

            public String getResponse() {
                return this.response;
            }

            public void setResponse(String s) {
                this.response = s;
            }

            public String toString() {
                return "Command(" + this.command + ", " + this.mechs + ", " + this.data + ", " + null + ")";
            }
        }
    }
}

