/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.text.Collator;
import org.freedesktop.dbus.CallbackHandler;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.test.TestAll;
import org.freedesktop.dbus.test.TestException;

class CallbackHandlerImpl
implements CallbackHandler<String> {
    CallbackHandlerImpl() {
    }

    public void handle(String r) {
        System.out.println("Handling callback: " + r);
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", r)) {
            TestAll.fail("call with callback, wrong return value");
        }
        if (TestAll.done4) {
            TestAll.fail("Already ran callback handler");
        }
        TestAll.done4 = true;
    }

    public void handleError(DBusExecutionException e) {
        System.out.println("Handling error callback: " + e + " message = '" + e.getMessage() + "'");
        if (!(e instanceof TestException)) {
            TestAll.fail("Exception is of the wrong sort");
        }
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("test", e.getMessage())) {
            TestAll.fail("Exception has the wrong message");
        }
        if (TestAll.done8) {
            TestAll.fail("Already ran callback error handler");
        }
        TestAll.done8 = true;
    }
}

