/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.types.DBusMapType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossTestClient
implements DBus.Binding.TestClient,
DBusSigHandler<DBus.Binding.TestSignals.Triggered> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrossTestClient.class);
    private DBusConnection conn;
    public static final Set<String> PASSED = new TreeSet<String>();
    public static final Map<String, List<String>> FAILED = new HashMap<String, List<String>>();
    private static CrossTestClient CROSS_TEST_CLIENT_INSTANCE;

    public CrossTestClient(DBusConnection _conn) {
        this.conn = _conn;
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return null;
    }

    public void handle(DBus.Binding.TestSignals.Triggered t) {
        FAILED.remove("org.freedesktop.DBus.Binding.TestSignals.Triggered");
        if (new UInt64(21389479283L).equals((Object)t.a) && "/Test".equals(t.getPath())) {
            CrossTestClient.pass("org.freedesktop.DBus.Binding.TestSignals.Triggered");
        } else if (!new UInt64(21389479283L).equals((Object)t.a)) {
            CrossTestClient.fail("org.freedesktop.DBus.Binding.TestSignals.Triggered", "Incorrect signal content; expected 21389479283 got " + t.a);
        } else if (!"/Test".equals(t.getPath())) {
            CrossTestClient.fail("org.freedesktop.DBus.Binding.TestSignals.Triggered", "Incorrect signal source object; expected /Test got " + t.getPath());
        }
    }

    public void Response(UInt16 a, double b) {
        FAILED.remove("org.freedesktop.DBus.Binding.TestClient.Response");
        if (a.equals((Object)new UInt16(15)) && b == 12.5) {
            CrossTestClient.pass("org.freedesktop.DBus.Binding.TestClient.Response");
        } else {
            CrossTestClient.fail("org.freedesktop.DBus.Binding.TestClient.Response", "Incorrect parameters; expected 15, 12.5 got " + a + ", " + b);
        }
    }

    public static void pass(String test) {
        PASSED.add(test.replaceAll("[$]", "."));
    }

    public static void fail(String test, String reason) {
        List<String> reasons = FAILED.get(test = test.replaceAll("[$]", "."));
        if (null == reasons) {
            reasons = new Vector<String>();
            FAILED.put(test, reasons);
        }
        reasons.add(reason);
    }

    public static void test(Class<? extends DBusInterface> iface, Object proxy, String method, Object rv, Object ... parameters) {
        try {
            Method[] ms = iface.getMethods();
            Method m = null;
            for (Method t : ms) {
                if (!t.getName().equals(method)) continue;
                m = t;
            }
            Object o = m.invoke(proxy, parameters);
            String msg = "Incorrect return value; sent ( ";
            if (null != parameters) {
                for (Object po : parameters) {
                    if (null == po) continue;
                    msg = msg + CrossTestClient.collapseArray(po) + ",";
                }
            }
            msg = msg.replaceAll(".$", ");");
            msg = msg + " expected " + CrossTestClient.collapseArray(rv) + " got " + CrossTestClient.collapseArray(o);
            if (null != rv && rv.getClass().isArray()) {
                CrossTestClient.compareArray(iface.getName() + "." + method, rv, o);
            } else if (rv instanceof Map) {
                if (o instanceof Map) {
                    Map a = (Map)o;
                    Map b = (Map)rv;
                    if (a.keySet().size() != b.keySet().size()) {
                        CrossTestClient.fail(iface.getName() + "." + method, msg);
                    } else {
                        for (Object k : a.keySet()) {
                            if (a.get(k) instanceof List) {
                                if (b.get(k) instanceof List) {
                                    if (CrossTestClient.setCompareLists((List)a.get(k), (List)b.get(k))) continue;
                                    CrossTestClient.fail(iface.getName() + "." + method, msg);
                                    continue;
                                }
                                CrossTestClient.fail(iface.getName() + "." + method, msg);
                                continue;
                            }
                            if (a.get(k).equals(b.get(k))) continue;
                            CrossTestClient.fail(iface.getName() + "." + method, msg);
                            return;
                        }
                    }
                    CrossTestClient.pass(iface.getName() + "." + method);
                } else {
                    CrossTestClient.fail(iface.getName() + "." + method, msg);
                }
            } else if (o == rv || o != null && o.equals(rv)) {
                CrossTestClient.pass(iface.getName() + "." + method);
            } else {
                CrossTestClient.fail(iface.getName() + "." + method, msg);
            }
        }
        catch (DBusExecutionException exDbe) {
            exDbe.printStackTrace();
            CrossTestClient.fail(iface.getName() + "." + method, "Error occurred during execution: " + ((Object)((Object)exDbe)).getClass().getName() + " " + exDbe.getMessage());
        }
        catch (InvocationTargetException exIt) {
            exIt.printStackTrace();
            CrossTestClient.fail(iface.getName() + "." + method, "Error occurred during execution: " + exIt.getCause().getClass().getName() + " " + exIt.getCause().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            CrossTestClient.fail(iface.getName() + "." + method, "Error occurred during execution: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static String collapseArray(Object array) {
        if (null == array) {
            return "null";
        }
        if (array.getClass().isArray()) {
            String s = "{ ";
            for (int i = 0; i < Array.getLength(array); ++i) {
                s = s + CrossTestClient.collapseArray(Array.get(array, i)) + ",";
            }
            s = s.replaceAll(".$", " }");
            return s;
        }
        if (array instanceof List) {
            String s = "{ ";
            for (Object o : (List)array) {
                s = s + CrossTestClient.collapseArray(o) + ",";
            }
            s = s.replaceAll(".$", " }");
            return s;
        }
        if (array instanceof Map) {
            String s = "{ ";
            for (Object o : ((Map)array).keySet()) {
                s = s + CrossTestClient.collapseArray(o) + " => " + CrossTestClient.collapseArray(((Map)array).get(o)) + ",";
            }
            s = s.replaceAll(".$", " }");
            return s;
        }
        return array.toString();
    }

    public static <T> boolean setCompareLists(List<T> a, List<T> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (T v : a) {
            if (b.contains(v)) continue;
            return false;
        }
        return true;
    }

    public static List<Variant<Object>> primitizeRecurse(Object a, Type t) {
        Vector<Variant<Object>> vs = new Vector<Variant<Object>>();
        if (t instanceof ParameterizedType) {
            Class c = (Class)((ParameterizedType)t).getRawType();
            if (List.class.isAssignableFrom(c)) {
                Object[] os = a instanceof List ? ((List)a).toArray() : a;
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                for (int i = 0; i < Array.getLength(os); ++i) {
                    vs.addAll(CrossTestClient.primitizeRecurse(Array.get(os, i), ts[0]));
                }
            } else if (Map.class.isAssignableFrom(c)) {
                Object[] os = ((Map)a).keySet().toArray();
                Object[] ks = ((Map)a).values().toArray();
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                for (Object element : ks) {
                    vs.addAll(CrossTestClient.primitizeRecurse(element, ts[0]));
                }
                for (Object element : os) {
                    vs.addAll(CrossTestClient.primitizeRecurse(element, ts[1]));
                }
            } else if (Struct.class.isAssignableFrom(c)) {
                Object[] os = ((Struct)a).getParameters();
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                for (int i = 0; i < os.length; ++i) {
                    vs.addAll(CrossTestClient.primitizeRecurse(os[i], ts[i]));
                }
            } else if (Variant.class.isAssignableFrom(c)) {
                vs.addAll(CrossTestClient.primitizeRecurse(((Variant)a).getValue(), ((Variant)a).getType()));
            }
        } else if (Variant.class.isAssignableFrom((Class)t)) {
            vs.addAll(CrossTestClient.primitizeRecurse(((Variant)a).getValue(), ((Variant)a).getType()));
        } else if (t instanceof Class && ((Class)t).isArray()) {
            Class<?> t2 = ((Class)t).getComponentType();
            for (int i = 0; i < Array.getLength(a); ++i) {
                vs.addAll(CrossTestClient.primitizeRecurse(Array.get(a, i), t2));
            }
        } else {
            vs.add(new Variant((Object)a));
        }
        return vs;
    }

    public static List<Variant<Object>> primitize(Variant<Object> a) {
        return CrossTestClient.primitizeRecurse(a.getValue(), a.getType());
    }

    public static void primitizeTest(DBus.Binding.Tests tests, Object input) {
        Variant in = new Variant(input);
        List<Variant<Object>> vs = CrossTestClient.primitize((Variant<Object>)in);
        try {
            List res = tests.Primitize(in);
            if (CrossTestClient.setCompareLists(res, vs)) {
                CrossTestClient.pass("org.freedesktop.DBus.Binding.Tests.Primitize");
            } else {
                CrossTestClient.fail("org.freedesktop.DBus.Binding.Tests.Primitize", "Wrong Return Value; expected " + CrossTestClient.collapseArray(vs) + " got " + CrossTestClient.collapseArray(res));
            }
        }
        catch (Exception e) {
            LOGGER.debug("", (Throwable)e);
            CrossTestClient.fail("org.freedesktop.DBus.Binding.Tests.Primitize", "Exception occurred during test: (" + e.getClass().getName() + ") " + e.getMessage());
        }
    }

    public static void doTests(DBus.Peer peer, DBus.Introspectable intro, DBus.Introspectable rootintro, DBus.Binding.Tests tests, DBus.Binding.SingleTests singletests) {
        Random r = new Random();
        CrossTestClient.test(DBus.Peer.class, peer, "Ping", null, new Object[0]);
        try {
            if (intro.Introspect().startsWith("<!DOCTYPE")) {
                CrossTestClient.pass("org.freedesktop.DBus.Introspectable.Introspect");
            } else {
                CrossTestClient.fail("org.freedesktop.DBus.Introspectable.Introspect", "Didn't get valid xml data back when introspecting /Test");
            }
        }
        catch (DBusExecutionException dbee) {
            LOGGER.debug("", (Throwable)dbee);
            CrossTestClient.fail("org.freedesktop.DBus.Introspectable.Introspect", "Got exception during introspection on /Test (" + ((Object)((Object)dbee)).getClass().getName() + "): " + dbee.getMessage());
        }
        try {
            if (rootintro.Introspect().startsWith("<!DOCTYPE")) {
                CrossTestClient.pass("org.freedesktop.DBus.Introspectable.Introspect");
            } else {
                CrossTestClient.fail("org.freedesktop.DBus.Introspectable.Introspect", "Didn't get valid xml data back when introspecting /");
            }
        }
        catch (DBusExecutionException dbee) {
            LOGGER.debug("", (Throwable)dbee);
            CrossTestClient.fail("org.freedesktop.DBus.Introspectable.Introspect", "Got exception during introspection on / (" + ((Object)((Object)dbee)).getClass().getName() + "): " + dbee.getMessage());
        }
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "Identity", new Variant((Object)new Integer(1)), new Variant((Object)new Integer(1)));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "Identity", new Variant((Object)"Hello"), new Variant((Object)"Hello"));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityBool", false, false);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityBool", true, true);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "Invert", false, true);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "Invert", true, false);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)0, (byte)0);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)1, (byte)1);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)-1, (byte)-1);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)127, (byte)127);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)-128, (byte)-128);
        int i = r.nextInt();
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)i, (byte)i);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)0, (short)0);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)1, (short)1);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)-1, (short)-1);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)Short.MAX_VALUE, (short)Short.MAX_VALUE);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)Short.MIN_VALUE, (short)Short.MIN_VALUE);
        i = r.nextInt();
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)i, (short)i);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt32", 0, 0);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt32", 1, 1);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt32", -1, -1);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt32", Integer.MAX_VALUE, Integer.MAX_VALUE);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt32", Integer.MIN_VALUE, Integer.MIN_VALUE);
        i = r.nextInt();
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt32", i, i);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt64", 0L, 0L);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt64", 1L, 1L);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt64", -1L, -1L);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt64", Long.MAX_VALUE, Long.MAX_VALUE);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt64", Long.MIN_VALUE, Long.MIN_VALUE);
        i = r.nextInt();
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityInt64", i, i);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(0), new UInt16(0));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(1), new UInt16(1));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(65535), new UInt16(65535));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(0), new UInt16(0));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(i % 65535), new UInt16(i % 65535));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32(0L), new UInt32(0L));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32(1L), new UInt32(1L));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32(0xFFFFFFFFL), new UInt32(0xFFFFFFFFL));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32(0L), new UInt32(0L));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32((long)i % 0xFFFFFFFFL), new UInt32((long)i % 0xFFFFFFFFL));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(0L), new UInt64(0L));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(1L), new UInt64(1L));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(Long.MAX_VALUE), new UInt64(Long.MAX_VALUE));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(UInt64.MAX_BIG_VALUE), new UInt64(UInt64.MAX_BIG_VALUE));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(0L), new UInt64(0L));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64((long)i % Long.MAX_VALUE), new UInt64((long)i % Long.MAX_VALUE));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityDouble", 0.0, 0.0);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityDouble", 1.0, 1.0);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityDouble", -1.0, -1.0);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityDouble", Double.MAX_VALUE, Double.MAX_VALUE);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityDouble", Double.MIN_VALUE, Double.MIN_VALUE);
        i = r.nextInt();
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityDouble", i, i);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityString", "", "");
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityString", "The Quick Brown Fox Jumped Over The Lazy Dog", "The Quick Brown Fox Jumped Over The Lazy Dog");
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "IdentityString", "\u3072\u3089\u304c\u306a\u30b2\u30fc\u30e0 - \u304b\u306a\u3076\u3093", "\u3072\u3089\u304c\u306a\u30b2\u30fc\u30e0 - \u304b\u306a\u3076\u3093");
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityBoolArray", Boolean.TYPE, null);
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityByteArray", Byte.TYPE, null);
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityInt16Array", Short.TYPE, null);
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityInt32Array", Integer.TYPE, null);
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityInt64Array", Long.TYPE, null);
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityDoubleArray", Double.TYPE, null);
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityArray", Variant.class, new Variant((Object)"aoeu"));
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityUInt16Array", UInt16.class, new UInt16(12));
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityUInt32Array", UInt32.class, new UInt32(190L));
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityUInt64Array", UInt64.class, new UInt64(103948L));
        CrossTestClient.testArray(DBus.Binding.Tests.class, tests, "IdentityStringArray", String.class, "asdf");
        int[] is = new int[]{};
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "Sum", 0L, new Object[]{is});
        r = new Random();
        int len = r.nextInt() % 100 + 15;
        len = (len < 0 ? -len : len) + 15;
        is = new int[len];
        long result = 0L;
        for (i = 0; i < len; ++i) {
            is[i] = r.nextInt();
            result += (long)is[i];
        }
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "Sum", result, new Object[]{is});
        byte[] bs = new byte[]{};
        CrossTestClient.test(DBus.Binding.SingleTests.class, singletests, "Sum", new UInt32(0L), new Object[]{bs});
        len = r.nextInt() % 100;
        len = (len < 0 ? -len : len) + 15;
        bs = new byte[len];
        int res = 0;
        for (i = 0; i < len; ++i) {
            bs[i] = (byte)r.nextInt();
            res += bs[i] < 0 ? bs[i] + 256 : bs[i];
        }
        CrossTestClient.test(DBus.Binding.SingleTests.class, singletests, "Sum", new UInt32((long)res % 0x100000000L), new Object[]{bs});
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "DeStruct", new DBus.Binding.Triplet((Object)"hi", (Object)new UInt32(12L), (Object)new Short(99)), new DBus.Binding.TestStruct("hi", new UInt32(12L), new Short(99)));
        HashMap<String, String> in = new HashMap<String, String>();
        HashMap out = new HashMap();
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "InvertMapping", out, in);
        in.put("hi", "there");
        in.put("to", "there");
        in.put("from", "here");
        in.put("in", "out");
        Vector<String> l = new Vector<String>();
        l.add("hi");
        l.add("to");
        out.put("there", l);
        l = new Vector();
        l.add("from");
        out.put("here", l);
        l = new Vector();
        l.add("in");
        out.put("out", l);
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "InvertMapping", out, in);
        CrossTestClient.primitizeTest(tests, new Integer(1));
        CrossTestClient.primitizeTest(tests, new Variant((Object)new Variant((Object)new Variant((Object)new Variant((Object)"Hi")))));
        CrossTestClient.primitizeTest(tests, new Variant(in, (Type)new DBusMapType(String.class, String.class)));
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "Trigger", null, "/Test", new UInt64(21389479283L));
        try {
            CrossTestClient.CROSS_TEST_CLIENT_INSTANCE.conn.sendSignal((DBusSignal)new DBus.Binding.TestClient.Trigger("/Test", new UInt16(15), 12.5));
        }
        catch (DBusException dbe) {
            LOGGER.debug("", (Throwable)dbe);
            throw new DBusExecutionException(dbe.getMessage());
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        CrossTestClient.test(DBus.Binding.Tests.class, tests, "Exit", null, new Object[0]);
    }

    public static void testArray(Class<? extends DBusInterface> iface, Object proxy, String method, Class<? extends Object> arrayType, Object content) {
        Object array = Array.newInstance(arrayType, 0);
        CrossTestClient.test(iface, proxy, method, array, array);
        Random r = new Random();
        int l = r.nextInt() % 100;
        array = Array.newInstance(arrayType, (l < 0 ? -l : l) + 15);
        if (null != content) {
            Arrays.fill((Object[])array, content);
        }
        CrossTestClient.test(iface, proxy, method, array, array);
    }

    public static void compareArray(String test, Object a, Object b) {
        if (!a.getClass().equals(b.getClass())) {
            CrossTestClient.fail(test, "Incorrect return type; expected " + a.getClass() + " got " + b.getClass());
            return;
        }
        boolean pass = false;
        if (a instanceof Object[]) {
            pass = Arrays.equals((Object[])a, (Object[])b);
        } else if (a instanceof byte[]) {
            pass = Arrays.equals((byte[])a, (byte[])b);
        } else if (a instanceof boolean[]) {
            pass = Arrays.equals((boolean[])a, (boolean[])b);
        } else if (a instanceof int[]) {
            pass = Arrays.equals((int[])a, (int[])b);
        } else if (a instanceof short[]) {
            pass = Arrays.equals((short[])a, (short[])b);
        } else if (a instanceof long[]) {
            pass = Arrays.equals((long[])a, (long[])b);
        } else if (a instanceof double[]) {
            pass = Arrays.equals((double[])a, (double[])b);
        }
        if (pass) {
            CrossTestClient.pass(test);
        } else {
            String s = "Incorrect return value; expected ";
            s = s + CrossTestClient.collapseArray(a);
            s = s + " got ";
            s = s + CrossTestClient.collapseArray(b);
            CrossTestClient.fail(test, s);
        }
    }

    public static void main(String[] args) {
        try {
            DBusConnection conn = DBusConnection.getConnection((int)1);
            CROSS_TEST_CLIENT_INSTANCE = new CrossTestClient(conn);
            conn.exportObject("/Test", (DBusInterface)CROSS_TEST_CLIENT_INSTANCE);
            conn.addSigHandler(DBus.Binding.TestSignals.Triggered.class, (DBusSigHandler)CROSS_TEST_CLIENT_INSTANCE);
            DBus.Binding.Tests tests = (DBus.Binding.Tests)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", DBus.Binding.Tests.class);
            DBus.Binding.SingleTests singletests = (DBus.Binding.SingleTests)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", DBus.Binding.SingleTests.class);
            DBus.Peer peer = (DBus.Peer)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", DBus.Peer.class);
            DBus.Introspectable intro = (DBus.Introspectable)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", DBus.Introspectable.class);
            DBus.Introspectable rootintro = (DBus.Introspectable)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/", DBus.Introspectable.class);
            CrossTestClient.doTests(peer, intro, rootintro, tests, singletests);
            for (String s : PASSED) {
                System.out.println(s + " pass");
            }
            int i = 1;
            for (String s : FAILED.keySet()) {
                for (String r : FAILED.get(s)) {
                    System.out.println(s + " fail " + i);
                    System.out.println("report " + i + ": " + r);
                    ++i;
                }
            }
            conn.disconnect();
        }
        catch (DBusException exDbe) {
            exDbe.printStackTrace();
            System.exit(1);
        }
    }

    static {
        Vector<String> l = new Vector<String>();
        l.add("Signal never arrived");
        FAILED.put("org.freedesktop.DBus.Binding.TestSignals.Triggered", l);
        l = new Vector();
        l.add("Method never called");
        FAILED.put("org.freedesktop.DBus.Binding.TestClient.Response", l);
    }
}

