/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.test.ProfileHandler;
import org.freedesktop.dbus.test.ProfileStruct;
import org.freedesktop.dbus.test.Profiler;
import org.freedesktop.dbus.test.ProfilerInstance;

public final class Profile {
    public static final int SIGNAL_INNER = 100;
    public static final int SIGNAL_OUTER = 100;
    public static final int PING_INNER = 100;
    public static final int PING_OUTER = 100;
    public static final int BYTES = 2000000;
    public static final int INTROSPECTION_OUTER = 100;
    public static final int INTROSPECTION_INNER = 10;
    public static final int STRUCT_OUTER = 100;
    public static final int STRUCT_INNER = 10;
    public static final int LIST_OUTER = 100;
    public static final int LIST_INNER = 10;
    public static final int LIST_LENGTH = 100;
    public static final int MAP_OUTER = 100;
    public static final int MAP_INNER = 10;
    public static final int MAP_LENGTH = 100;
    public static final int ARRAY_OUTER = 100;
    public static final int ARRAY_INNER = 10;
    public static final int ARRAY_LENGTH = 1000;
    public static final int STRING_ARRAY_OUTER = 10;
    public static final int STRING_ARRAY_INNER = 1;
    public static final int STRING_ARRAY_LENGTH = 20000;

    private Profile() {
    }

    public static void main(String[] args) {
        try {
            if (0 == args.length) {
                System.out.println("You must specify a profile type.");
                System.out.println("Syntax: profile <pings|arrays|introspect|maps|bytes|lists|structs|signals|rate|strings>");
                System.exit(1);
            }
            DBusConnection conn = DBusConnection.getConnection((int)1);
            conn.requestBusName("org.freedesktop.DBus.java.profiler");
            if ("pings".equals(args[0])) {
                int count = 10000;
                System.out.print("Sending " + count + " pings...");
                DBus.Peer p = (DBus.Peer)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", DBus.Peer.class);
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    for (int j = 0; j < 100; ++j) {
                        l.start();
                        p.Ping();
                        l.stop();
                    }
                    System.out.print(".");
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("strings".equals(args[0])) {
                int count = 10;
                System.out.print("Sending array of 20000 strings " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", (DBusInterface)pi);
                Profiler p = (Profiler)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                String[] v = new String[20000];
                Random r = new Random();
                for (int i = 0; i < 20000; ++i) {
                    v[i] = "" + r.nextInt();
                }
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < 1; ++j) {
                        l.start();
                        p.stringarray(v);
                        l.stop();
                    }
                    System.out.print(".");
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("arrays".equals(args[0])) {
                int count = 1000;
                System.out.print("Sending array of 1000 ints " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", (DBusInterface)pi);
                Profiler p = (Profiler)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                int[] v = new int[1000];
                Random r = new Random();
                for (int i = 0; i < 1000; ++i) {
                    v[i] = r.nextInt();
                }
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        l.start();
                        p.array(v);
                        l.stop();
                    }
                    System.out.print(".");
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("maps".equals(args[0])) {
                int count = 1000;
                System.out.print("Sending map of 100 string=>strings " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", (DBusInterface)pi);
                Profiler p = (Profiler)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                HashMap<String, String> m = new HashMap<String, String>();
                for (int i = 0; i < 100; ++i) {
                    m.put("" + i, "hello");
                }
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        l.start();
                        p.map(m);
                        l.stop();
                    }
                    System.out.print(".");
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("lists".equals(args[0])) {
                int count = 1000;
                System.out.print("Sending list of 100 strings " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", (DBusInterface)pi);
                Profiler p = (Profiler)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                Vector<String> v = new Vector<String>();
                for (int i = 0; i < 100; ++i) {
                    v.add("hello " + i);
                }
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        l.start();
                        p.list(v);
                        l.stop();
                    }
                    System.out.print(".");
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("structs".equals(args[0])) {
                int count = 1000;
                System.out.print("Sending a struct " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", (DBusInterface)pi);
                Profiler p = (Profiler)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                ProfileStruct ps = new ProfileStruct("hello", new UInt32(18L), 500L);
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        l.start();
                        p.struct(ps);
                        l.stop();
                    }
                    System.out.print(".");
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("introspect".equals(args[0])) {
                int count = 1000;
                System.out.print("Recieving introspection data " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", (DBusInterface)pi);
                DBus.Introspectable is = (DBus.Introspectable)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", DBus.Introspectable.class);
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                String s = null;
                for (int i = 0; i < 100; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        l.start();
                        s = is.Introspect();
                        l.stop();
                    }
                    System.out.print(".");
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
                System.out.println("Introspect data: " + s);
            } else if ("bytes".equals(args[0])) {
                System.out.print("Sending 2000000 bytes");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", (DBusInterface)pi);
                Profiler p = (Profiler)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                byte[] bs = new byte[2000000];
                for (int i = 0; i < 2000000; ++i) {
                    bs[i] = (byte)i;
                }
                long t = System.currentTimeMillis();
                p.bytes(bs);
                System.out.println(" done in " + (System.currentTimeMillis() - t) + "ms.");
            } else if ("rate".equals(args[0])) {
                int len;
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", (DBusInterface)pi);
                Profiler p = (Profiler)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                DBus.Peer peer = (DBus.Peer)conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", DBus.Peer.class);
                conn.changeThreadCount((byte)1);
                long start = System.currentTimeMillis();
                int count = 0;
                do {
                    p.Pong();
                } while (++count < 10000);
                long end = System.currentTimeMillis();
                System.out.println("No payload: " + (long)(count * 1000) / (end - start) + " RT/second");
                start = System.currentTimeMillis();
                count = 0;
                do {
                    p.Pong();
                } while (++count < 10000);
                peer.Ping();
                end = System.currentTimeMillis();
                System.out.println("No payload, One way: " + (long)(count * 1000) / (end - start) + " /second");
                for (len = 256; len <= 32768; len <<= 1) {
                    byte[] bs = new byte[len];
                    count = 0;
                    start = System.currentTimeMillis();
                    do {
                        p.bytes(bs);
                    } while (++count < 1000);
                    end = System.currentTimeMillis();
                    long ms = end - start;
                    double cps = (long)(count * 1000) / ms;
                    double rate = (double)len * cps / 1048576.0;
                    System.out.println(len + " byte array) " + count * len + " bytes in " + ms + "ms (in " + count + " calls / " + (int)cps + " CPS): " + rate + "MB/s");
                }
                for (len = 256; len <= 32768; len <<= 1) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < len; ++i) {
                        sb.append('a');
                    }
                    String s = sb.toString();
                    end = System.currentTimeMillis() + 500L;
                    count = 0;
                    do {
                        p.string(s);
                    } while (++count < 1000);
                    long ms = end - start;
                    double cps = (long)(count * 1000) / ms;
                    double rate = (double)len * cps / 1048576.0;
                    System.out.println(len + " string) " + count * len + " bytes in " + ms + "ms (in " + count + " calls / " + (int)cps + " CPS): " + rate + "MB/s");
                }
            } else if ("signals".equals(args[0])) {
                int count = 10000;
                System.out.print("Sending " + count + " signals");
                ProfileHandler ph = new ProfileHandler();
                conn.addSigHandler(Profiler.ProfileSignal.class, (DBusSigHandler)ph);
                Log l = new Log(count);
                Profiler.ProfileSignal ps = new Profiler.ProfileSignal("/");
                long t = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    for (int j = 0; j < 100; ++j) {
                        l.start();
                        conn.sendSignal((DBusSignal)ps);
                        l.stop();
                    }
                    System.out.print(".");
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
                while (ph.getCount() < count) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                conn.disconnect();
                System.out.println("Invalid profile ``" + args[0] + "''.");
                System.out.println("Syntax: profile <pings|arrays|introspect|maps|bytes|lists|structs|signals>");
                System.exit(1);
            }
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static class Log {
        private long last;
        private int[] deltas;
        private int current = 0;

        public Log(int size) {
            this.deltas = new int[size];
        }

        public void start() {
            this.last = System.currentTimeMillis();
        }

        public void stop() {
            this.deltas[this.current] = (int)(System.currentTimeMillis() - this.last);
            ++this.current;
        }

        public double mean() {
            if (0 == this.current) {
                return 0.0;
            }
            long sum = 0L;
            for (int i = 0; i < this.current; ++i) {
                sum += (long)this.deltas[i];
            }
            return sum /= (long)this.current;
        }

        public long min() {
            int m = Integer.MAX_VALUE;
            for (int i = 0; i < this.current; ++i) {
                if (this.deltas[i] >= m) continue;
                m = this.deltas[i];
            }
            return m;
        }

        public long max() {
            int m = 0;
            for (int i = 0; i < this.current; ++i) {
                if (this.deltas[i] <= m) continue;
                m = this.deltas[i];
            }
            return m;
        }

        public double stddev() {
            double mean = this.mean();
            double sum = 0.0;
            for (int i = 0; i < this.current; ++i) {
                sum += ((double)this.deltas[i] - mean) * ((double)this.deltas[i] - mean);
            }
            return Math.sqrt(sum / (double)(this.current - 1));
        }
    }
}

