/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import org.freedesktop.dbus.MethodCall;

class EfficientMap {
    private long[] kv;
    private MethodCall[] vv;
    private int start;
    private int end;
    private int initSize;

    EfficientMap(int initialSize) {
        this.initSize = initialSize;
        this.shrink();
    }

    private void grow() {
        long[] oldkv = this.kv;
        this.kv = new long[oldkv.length * 2];
        MethodCall[] oldvv = this.vv;
        this.vv = new MethodCall[oldvv.length * 2];
        System.arraycopy(oldkv, this.start, this.kv, 0, oldkv.length - this.start);
        System.arraycopy(oldvv, this.start, this.vv, 0, oldvv.length - this.start);
        if (this.end != oldkv.length - 1) {
            System.arraycopy(oldkv, 0, this.kv, oldkv.length - this.start, this.end + 1);
            System.arraycopy(oldvv, 0, this.vv, oldvv.length - this.start, this.end + 1);
        }
        this.start = 0;
        this.end = oldkv.length;
    }

    public long[] getKeys() {
        int size = this.start < this.end ? this.end - this.start : this.kv.length - (this.start - this.end);
        long[] lv = new long[size];
        int copya = size > this.kv.length - this.start ? this.kv.length - this.start : size;
        System.arraycopy(this.kv, this.start, lv, 0, copya);
        if (copya < size) {
            System.arraycopy(this.kv, 0, lv, copya, size - copya);
        }
        return lv;
    }

    private void shrink() {
        if (null != this.kv && this.kv.length == this.initSize) {
            return;
        }
        this.kv = new long[this.initSize];
        this.vv = new MethodCall[this.initSize];
        this.start = 0;
        this.end = 0;
    }

    public void put(long l, MethodCall m) {
        this.kv[this.end] = l;
        this.vv[this.end] = m;
        this.end = this.end == this.kv.length - 1 ? 0 : ++this.end;
        if (this.end == this.start) {
            this.grow();
        }
    }

    public MethodCall remove(long l) {
        int pos = this.find(l);
        if (-1 == pos) {
            return null;
        }
        MethodCall m = this.vv[pos];
        this.vv[pos] = null;
        this.kv[pos] = -1L;
        while (-1L == this.kv[this.start]) {
            this.start = this.start == this.kv.length - 1 ? 0 : ++this.start;
            if (this.start != this.end) continue;
            this.shrink();
            break;
        }
        return m;
    }

    public boolean contains(long l) {
        return -1 != this.find(l);
    }

    private int find(long l) {
        int i = this.start;
        while (i != this.end && this.kv[i] != l) {
            if (i == this.kv.length - 1) {
                i = 0;
                continue;
            }
            ++i;
        }
        if (i == this.end) {
            return -1;
        }
        return i;
    }
}

