/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.utils.Hexdump;
import java.util.Vector;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCall
extends Message {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static long REPLY_WAIT_TIMEOUT = 20000L;
    Message reply = null;

    MethodCall() {
    }

    public MethodCall(String dest, String path, String iface, String member, byte flags, String sig, Object ... args) throws DBusException {
        this(null, dest, path, iface, member, flags, sig, args);
    }

    public MethodCall(String source, String dest, String path, String iface, String member, byte flags, String sig, Object ... args) throws DBusException {
        super((byte)66, (byte)1, flags);
        if (null == member || null == path) {
            throw new MessageFormatException(Gettext.t("Must specify destination, path and function name to MethodCalls."));
        }
        this.headers.put((byte)1, path);
        this.headers.put((byte)3, member);
        Vector<Object[]> hargs = new Vector<Object[]>();
        hargs.add(new Object[]{(byte)1, new Object[]{"o", path}});
        if (null != source) {
            this.headers.put((byte)7, source);
            hargs.add(new Object[]{(byte)7, new Object[]{"s", source}});
        }
        if (null != dest) {
            this.headers.put((byte)6, dest);
            hargs.add(new Object[]{(byte)6, new Object[]{"s", dest}});
        }
        if (null != iface) {
            hargs.add(new Object[]{(byte)2, new Object[]{"s", iface}});
            this.headers.put((byte)2, iface);
        }
        hargs.add(new Object[]{(byte)3, new Object[]{"s", member}});
        if (null != sig) {
            this.logger.debug("Appending arguments with signature: " + sig);
            hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
            this.headers.put((byte)8, sig);
            this.setArgs(args);
        }
        byte[] blen = new byte[4];
        this.appendBytes(blen);
        this.append("ua(yv)", this.serial, hargs.toArray());
        this.pad((byte)8);
        long c = this.bytecounter;
        if (null != sig) {
            this.append(sig, args);
        }
        this.logger.debug("Appended body, type: " + sig + " start: " + c + " end: " + this.bytecounter + " size: " + (this.bytecounter - c));
        this.marshallint(this.bytecounter - c, blen, 0, 4);
        this.logger.debug("marshalled size (" + blen + "): " + Hexdump.format((byte[])blen));
    }

    public static void setDefaultTimeout(long timeout) {
        REPLY_WAIT_TIMEOUT = timeout;
    }

    public synchronized boolean hasReply() {
        return null != this.reply;
    }

    public synchronized Message getReply(long timeout) {
        this.logger.trace("Blocking on " + this);
        if (null != this.reply) {
            return this.reply;
        }
        try {
            this.wait(timeout);
            return this.reply;
        }
        catch (InterruptedException exI) {
            return this.reply;
        }
    }

    public synchronized Message getReply() {
        this.logger.trace("Blocking on " + this);
        if (null != this.reply) {
            return this.reply;
        }
        try {
            this.wait(REPLY_WAIT_TIMEOUT);
            return this.reply;
        }
        catch (InterruptedException exI) {
            return this.reply;
        }
    }

    protected synchronized void setReply(Message _reply) {
        this.logger.trace("Setting reply to " + this + " to " + _reply);
        this.reply = _reply;
        this.notifyAll();
    }
}

