/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.math.BigInteger;
import java.text.MessageFormat;
import org.freedesktop.dbus.Gettext;

public class UInt64
extends Number
implements Comparable<UInt64> {
    public static final long MAX_LONG_VALUE = Long.MAX_VALUE;
    public static final BigInteger MAX_BIG_VALUE = new BigInteger("18446744073709551615");
    public static final long MIN_VALUE = 0L;
    private BigInteger value;
    private long top;
    private long bottom;

    public UInt64(long _value) {
        if (_value < 0L || _value > Long.MAX_VALUE) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), _value, 0L, Long.MAX_VALUE));
        }
        this.value = new BigInteger("" + _value);
        this.top = this.value.shiftRight(32).and(new BigInteger("4294967295")).longValue();
        this.bottom = this.value.and(new BigInteger("4294967295")).longValue();
    }

    public UInt64(long _top, long _bottom) {
        BigInteger a = new BigInteger("" + _top);
        a = a.shiftLeft(32);
        a = a.add(new BigInteger("" + _bottom));
        if (0 > a.compareTo(BigInteger.ZERO)) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), a, 0L, MAX_BIG_VALUE));
        }
        if (0 < a.compareTo(MAX_BIG_VALUE)) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), a, 0L, MAX_BIG_VALUE));
        }
        this.value = a;
        this.top = _top;
        this.bottom = _bottom;
    }

    public UInt64(BigInteger _value) {
        if (null == _value) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), _value, 0L, MAX_BIG_VALUE));
        }
        if (0 > _value.compareTo(BigInteger.ZERO)) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), _value, 0L, MAX_BIG_VALUE));
        }
        if (0 < _value.compareTo(MAX_BIG_VALUE)) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), _value, 0L, MAX_BIG_VALUE));
        }
        this.value = _value;
        this.top = this.value.shiftRight(32).and(new BigInteger("4294967295")).longValue();
        this.bottom = this.value.and(new BigInteger("4294967295")).longValue();
    }

    public UInt64(String _value) {
        if (null == _value) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), _value, 0L, MAX_BIG_VALUE));
        }
        BigInteger a = new BigInteger(_value);
        if (0 > a.compareTo(BigInteger.ZERO)) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), _value, 0L, MAX_BIG_VALUE));
        }
        if (0 < a.compareTo(MAX_BIG_VALUE)) {
            throw new NumberFormatException(MessageFormat.format(Gettext.t("{0} is not between {1} and {2}."), _value, 0L, MAX_BIG_VALUE));
        }
        this.value = a;
        this.top = this.value.shiftRight(32).and(new BigInteger("4294967295")).longValue();
        this.bottom = this.value.and(new BigInteger("4294967295")).longValue();
    }

    public BigInteger value() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    public boolean equals(Object o) {
        return o instanceof UInt64 && this.value.equals(((UInt64)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(UInt64 other) {
        return this.value.compareTo(other.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public long top() {
        return this.top;
    }

    public long bottom() {
        return this.bottom;
    }
}

