/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.test.CrossTestClient;

public class CrossTestServer
implements DBus.Binding.Tests,
DBus.Binding.SingleTests,
DBusSigHandler<DBus.Binding.TestClient.Trigger> {
    private DBusConnection conn;
    private boolean run = true;
    private Set<String> done = new TreeSet<String>();
    private Set<String> notdone = new TreeSet<String>();

    public CrossTestServer(DBusConnection _conn) {
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Identity");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityString");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Sum");
        this.notdone.add("org.freedesktop.DBus.Binding.SingleTests.Sum");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.DeStruct");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Primitize");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Invert");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Trigger");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Exit");
        this.notdone.add("org.freedesktop.DBus.Binding.TestClient.Trigger");
        this.conn = _conn;
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return null;
    }

    public boolean isRun() {
        return this.run;
    }

    public void setRun(boolean _run) {
        this.run = _run;
    }

    public Set<String> getDone() {
        return this.done;
    }

    public void setDone(Set<String> _done) {
        this.done = _done;
    }

    public Set<String> getNotdone() {
        return this.notdone;
    }

    public void setNotdone(Set<String> _notdone) {
        this.notdone = _notdone;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public <T> Variant<T> Identity(Variant<T> input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Identity");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Identity");
        return new Variant(input.getValue());
    }

    @DBus.Description(value="Returns whatever it is passed")
    public byte IdentityByte(byte input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public boolean IdentityBool(boolean input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public short IdentityInt16(short input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public UInt16 IdentityUInt16(UInt16 input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public int IdentityInt32(int input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public UInt32 IdentityUInt32(UInt32 input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public long IdentityInt64(long input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public UInt64 IdentityUInt64(UInt64 input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public double IdentityDouble(double input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public String IdentityString(String input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityString");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityString");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public <T> Variant<T>[] IdentityArray(Variant<T>[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public byte[] IdentityByteArray(byte[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public boolean[] IdentityBoolArray(boolean[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public short[] IdentityInt16Array(short[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public UInt16[] IdentityUInt16Array(UInt16[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public int[] IdentityInt32Array(int[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public UInt32[] IdentityUInt32Array(UInt32[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public long[] IdentityInt64Array(long[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public UInt64[] IdentityUInt64Array(UInt64[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public double[] IdentityDoubleArray(double[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        return input;
    }

    @DBus.Description(value="Returns whatever it is passed")
    public String[] IdentityStringArray(String[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        return input;
    }

    @DBus.Description(value="Returns the sum of the values in the input list")
    public long Sum(int[] a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Sum");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Sum");
        long sum = 0L;
        for (int b : a) {
            sum += (long)b;
        }
        return sum;
    }

    @DBus.Description(value="Returns the sum of the values in the input list")
    public UInt32 Sum(byte[] a) {
        this.done.add("org.freedesktop.DBus.Binding.SingleTests.Sum");
        this.notdone.remove("org.freedesktop.DBus.Binding.SingleTests.Sum");
        int sum = 0;
        for (int n : a) {
            sum += n < 0 ? n + 256 : n;
        }
        return new UInt32((long)sum % 0x100000000L);
    }

    @DBus.Description(value="Given a map of A => B, should return a map of B => a list of all the As which mapped to B")
    public Map<String, List<String>> InvertMapping(Map<String, String> a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        for (String s : a.keySet()) {
            String b = a.get(s);
            List<String> l = m.get(b);
            if (null == l) {
                l = new Vector<String>();
                m.put(b, l);
            }
            l.add(s);
        }
        return m;
    }

    @DBus.Description(value="This method returns the contents of a struct as separate values")
    public DBus.Binding.Triplet<String, UInt32, Short> DeStruct(DBus.Binding.TestStruct a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.DeStruct");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.DeStruct");
        return new DBus.Binding.Triplet((Object)a.a, (Object)a.b, (Object)a.c);
    }

    @DBus.Description(value="Given any compound type as a variant, return all the primitive types recursively contained within as an array of variants")
    public List<Variant<Object>> Primitize(Variant<Object> a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Primitize");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Primitize");
        return CrossTestClient.primitizeRecurse(a.getValue(), a.getType());
    }

    @DBus.Description(value="inverts it's input")
    public boolean Invert(boolean a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Invert");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Invert");
        return !a;
    }

    @DBus.Description(value="triggers sending of a signal from the supplied object with the given parameter")
    public void Trigger(String a, UInt64 b) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Trigger");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Trigger");
        try {
            this.conn.sendSignal((DBusSignal)new DBus.Binding.TestSignals.Triggered(a, b));
        }
        catch (DBusException exD) {
            throw new DBusExecutionException(exD.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Exit() {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Exit");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Exit");
        this.run = false;
        CrossTestServer crossTestServer = this;
        synchronized (crossTestServer) {
            this.notifyAll();
        }
    }

    public void handle(DBus.Binding.TestClient.Trigger t) {
        this.done.add("org.freedesktop.DBus.Binding.TestClient.Trigger");
        this.notdone.remove("org.freedesktop.DBus.Binding.TestClient.Trigger");
        try {
            DBus.Binding.TestClient cb = (DBus.Binding.TestClient)this.conn.getRemoteObject(t.getSource(), "/Test", DBus.Binding.TestClient.class);
            cb.Response(t.a, t.b);
        }
        catch (DBusException exD) {
            throw new DBusExecutionException(exD.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            DBusConnection conn = DBusConnection.getConnection((int)1);
            conn.requestBusName("org.freedesktop.DBus.Binding.TestServer");
            CrossTestServer cts = new CrossTestServer(conn);
            conn.addSigHandler(DBus.Binding.TestClient.Trigger.class, (DBusSigHandler)cts);
            conn.exportObject("/Test", (DBusInterface)cts);
            Iterator<String> iterator = cts;
            synchronized (iterator) {
                while (cts.run) {
                    try {
                        cts.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            for (String s : cts.done) {
                System.out.println(s + " ok");
            }
            for (String s : cts.notdone) {
                System.out.println(s + " untested");
            }
            conn.disconnect();
            System.exit(0);
        }
        catch (DBusException exDe) {
            exDe.printStackTrace();
            System.exit(1);
        }
    }
}

