/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.List;
import java.util.Map;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.test.TestStruct2;

@DBus.Description(value="Test interface containing signals")
public interface TestSignalInterface
extends DBusInterface {

    public static class TestPathSignal
    extends DBusSignal {
        public final Path otherpath;
        public final List<Path> pathlist;
        public final Map<Path, Path> pathmap;

        public TestPathSignal(String _path, Path _otherpath, List<Path> _pathlist, Map<Path, Path> _pathmap) throws DBusException {
            super(_path, new Object[]{_otherpath, _pathlist, _pathmap});
            this.otherpath = _otherpath;
            this.pathlist = _pathlist;
            this.pathmap = _pathmap;
        }
    }

    @DBus.Description(value="Test signal sending an object path")
    @DBusMemberName(value="TestSignalObject")
    public static class TestObjectSignal
    extends DBusSignal {
        public final DBusInterface otherpath;

        public TestObjectSignal(String _path, DBusInterface _otherpath) throws DBusException {
            super(_path, new Object[]{_otherpath});
            this.otherpath = _otherpath;
        }
    }

    @DBus.Description(value="Test signal with arrays")
    public static class TestArraySignal
    extends DBusSignal {
        public final List<TestStruct2> v;
        public final Map<UInt32, TestStruct2> m;

        public TestArraySignal(String _path, List<TestStruct2> _v, Map<UInt32, TestStruct2> _m) throws DBusException {
            super(_path, new Object[]{_v, _m});
            this.v = _v;
            this.m = _m;
        }
    }

    public static class EmptySignal
    extends DBusSignal {
        public EmptySignal(String path) throws DBusException {
            super(path, new Object[0]);
        }
    }

    public static class StringSignal
    extends DBusSignal {
        public final String aoeu;

        public StringSignal(String _path, String _aoeu) throws DBusException {
            super(_path, new Object[]{_aoeu});
            this.aoeu = _aoeu;
        }
    }

    @DBus.Description(value="Test basic signal")
    public static class TestSignal
    extends DBusSignal {
        public final String value;
        public final UInt32 number;

        public TestSignal(String _path, String _value, UInt32 _number) throws DBusException {
            super(_path, new Object[]{_value, _number});
            this.value = _value;
            this.number = _number;
        }
    }
}

