/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.Gettext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusAddress {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String type;
    private Map<String, String> parameters;

    public BusAddress(String address) throws ParseException {
        if (null == address || "".equals(address)) {
            throw new ParseException(Gettext.t("Bus address is blank"), 0);
        }
        this.logger.trace("Parsing bus address: " + address);
        String[] ss = address.split(":", 2);
        if (ss.length < 2) {
            throw new ParseException(Gettext.t("Bus address is invalid: ") + address, 0);
        }
        this.type = ss[0];
        this.logger.trace("Transport type: " + this.type);
        String[] ps = ss[1].split(",");
        this.parameters = new HashMap<String, String>();
        for (String p : ps) {
            String[] kv = p.split("=", 2);
            this.parameters.put(kv[0], kv[1]);
        }
        this.logger.trace("Transport options: " + this.parameters);
    }

    public String getType() {
        return this.type;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String toString() {
        return this.type + ": " + this.parameters;
    }
}

