/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBusConnection
extends AbstractConnection
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int SYSTEM = 0;
    public static final int SESSION = 1;
    public static final String DEFAULT_SYSTEM_BUS_ADDRESS = "unix:path=/var/run/dbus/system_bus_socket";
    private List<String> busnames;
    private static final Map<Object, DBusConnection> CONN = new HashMap<Object, DBusConnection>();
    private int refcount = 0;
    private Object reflock = new Object();
    private DBus dbus;

    public static DBusConnection getConnection(String address) throws DBusException {
        return DBusConnection.getConnection(address, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusConnection getConnection(String address, boolean registerSelf) throws DBusException {
        Map<Object, DBusConnection> map = CONN;
        synchronized (map) {
            DBusConnection c = CONN.get(address);
            if (null != c) {
                Object object = c.reflock;
                synchronized (object) {
                    ++c.refcount;
                }
                return c;
            }
            c = new DBusConnection(address, registerSelf);
            CONN.put(address, c);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static DBusConnection getConnection(int bustype) throws DBusException {
        var1_1 = DBusConnection.CONN;
        synchronized (var1_1) {
            logger = LoggerFactory.getLogger(DBusConnection.class);
            s = null;
            switch (bustype) {
                case 0: {
                    s = System.getenv("DBUS_SYSTEM_BUS_ADDRESS");
                    if (null != s) break;
                    s = "unix:path=/var/run/dbus/system_bus_socket";
                    break;
                }
                case 1: {
                    s = System.getenv("DBUS_SESSION_BUS_ADDRESS");
                    if (null != s) break;
                    display = System.getenv("DISPLAY");
                    if (null == display) {
                        throw new DBusException(Gettext.t("Cannot Resolve Session Bus Address"));
                    }
                    if (!display.startsWith(":") && display.contains(":")) {
                        display = display.substring(display.indexOf(58));
                    }
                    if (!(uuidfile = new File("/var/lib/dbus/machine-id")).exists()) {
                        throw new DBusException(Gettext.t("Cannot Resolve Session Bus Address"));
                    }
                    try {
                        r = new BufferedReader(new FileReader(uuidfile));
                        var7_8 = null;
                        uuid = r.readLine();
                        homedir = System.getProperty("user.home");
                        addressfile = new File(homedir + "/.dbus/session-bus", uuid + "-" + display.replaceAll(":([0-9]*)\\..*", "$1"));
                        if (!addressfile.exists()) {
                            throw new DBusException(Gettext.t("Cannot Resolve Session Bus Address"));
                        }
                        rf = new BufferedReader(new FileReader(addressfile));
                        var12_15 = null;
                        try {
                            while (null != (l = rf.readLine())) {
                                logger.trace("Reading D-Bus session data: " + l);
                                if (!l.matches("DBUS_SESSION_BUS_ADDRESS.*")) continue;
                                s = l.replaceAll("^[^=]*=", "");
                                logger.trace("Parsing " + l + " to " + s);
                            }
                        }
                        catch (Throwable var13_18) {
                            var12_15 = var13_18;
                            throw var13_18;
                        }
                        finally {
                            if (rf != null) {
                                if (var12_15 != null) {
                                    try {
                                        rf.close();
                                    }
                                    catch (Throwable var13_17) {
                                        var12_15.addSuppressed(var13_17);
                                    }
                                } else {
                                    rf.close();
                                }
                            }
                        }
                        if (null == s || "".equals(s)) {
                            throw new DBusException(Gettext.t("Cannot Resolve Session Bus Address"));
                        }
                        logger.debug("Read bus address " + s + " from file " + addressfile.toString());
                        if (r == null) break;
                        if (var7_8 == null) ** GOTO lbl66
                        try {
                            r.close();
                        }
                        catch (Throwable var8_10) {
                            var7_8.addSuppressed(var8_10);
                        }
                        break;
lbl66:
                        // 1 sources

                        r.close();
                        ** break;
                        catch (Throwable var8_11) {
                            try {
                                var7_8 = var8_11;
                                throw var8_11;
                            }
                            catch (Throwable var16_21) {
                                if (r != null) {
                                    if (var7_8 != null) {
                                        try {
                                            r.close();
                                        }
                                        catch (Throwable var17_22) {
                                            var7_8.addSuppressed(var17_22);
                                        }
                                    } else {
                                        r.close();
                                    }
                                }
                                throw var16_21;
lbl83:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (DBusConnection.EXCEPTION_DEBUG) {
                            logger.error("", (Throwable)e);
                        }
                        throw new DBusException(Gettext.t("Cannot Resolve Session Bus Address"));
                    }
                }
                default: {
                    throw new DBusException(Gettext.t("Invalid Bus Type: ") + bustype);
                }
            }
            c = DBusConnection.CONN.get(s);
            logger.trace("Getting bus connection for " + s + ": " + c);
            if (null != c) {
                var5_5 = c.reflock;
                synchronized (var5_5) {
                    ++c.refcount;
                }
                return c;
            }
            logger.debug("Creating new bus connection to: " + s);
            c = new DBusConnection(s);
            DBusConnection.CONN.put(s, c);
            return c;
        }
    }

    private DBusConnection(String address) throws DBusException {
        this(address, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBusConnection(String address, boolean registerSelf) throws DBusException {
        super(address);
        this.busnames = new Vector<String>();
        Object object = this.reflock;
        synchronized (object) {
            this.refcount = 1;
        }
        try {
            this.transport = new Transport(this.addr, 100000);
            this.connected = true;
        }
        catch (IOException ioe) {
            if (EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)ioe);
            }
            this.disconnect();
            throw new DBusException(Gettext.t("Failed to connect to bus ") + ioe.getMessage());
        }
        catch (ParseException exP) {
            if (EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)exP);
            }
            this.disconnect();
            throw new DBusException(Gettext.t("Failed to connect to bus ") + exP.getMessage());
        }
        this.listen();
        SigHandler h = new SigHandler();
        this.addSigHandlerWithoutMatch(DBus.Local.Disconnected.class, h);
        this.addSigHandlerWithoutMatch(DBus.NameAcquired.class, h);
        if (registerSelf) {
            this.dbus = this.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
            try {
                this.busnames.add(this.dbus.Hello());
            }
            catch (DBusExecutionException dbee) {
                if (EXCEPTION_DEBUG) {
                    this.logger.error("", (Throwable)dbee);
                }
                throw new DBusException(dbee.getMessage());
            }
        }
    }

    DBusInterface dynamicProxy(String source, String path) throws DBusException {
        this.logger.debug("Introspecting " + path + " on " + source + " for dynamic proxy creation");
        try {
            DBus.Introspectable intro = this.getRemoteObject(source, path, DBus.Introspectable.class);
            String data = intro.Introspect();
            this.logger.trace("Got introspection data: " + data);
            String[] tags = data.split("[<>]");
            Vector<String> ifaces = new Vector<String>();
            for (String tag : tags) {
                if (!tag.startsWith("interface")) continue;
                ifaces.add(tag.replaceAll("^interface *name *= *['\"]([^'\"]*)['\"].*$", "$1"));
            }
            Vector ifcs = new Vector();
            block5: for (String iface : ifaces) {
                this.logger.debug("Trying interface " + iface);
                int j = 0;
                while (j >= 0) {
                    try {
                        Class<?> ifclass = Class.forName(iface);
                        if (ifcs.contains(ifclass)) continue block5;
                        ifcs.add(ifclass);
                        continue block5;
                    }
                    catch (Exception ifclass) {
                        j = iface.lastIndexOf(".");
                        char[] cs = iface.toCharArray();
                        if (j < 0) continue;
                        cs[j] = 36;
                        iface = String.valueOf(cs);
                    }
                }
            }
            if (ifcs.size() == 0) {
                throw new DBusException(Gettext.t("Could not find an interface to cast to"));
            }
            RemoteObject ro = new RemoteObject(source, path, null, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(((Class)ifcs.get(0)).getClassLoader(), ifcs.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.importedObjects.put(newi, ro);
            return newi;
        }
        catch (Exception e) {
            if (EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)e);
            }
            throw new DBusException(MessageFormat.format(Gettext.t("Failed to create proxy object for {0} exported by {1}. Reason: {2}"), path, source, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DBusInterface getExportedObject(String source, String path) throws DBusException {
        ExportedObject o = null;
        Map map = this.exportedObjects;
        synchronized (map) {
            o = (ExportedObject)this.exportedObjects.get(path);
        }
        if (null != o && null == o.object.get()) {
            this.unExportObject(path);
            o = null;
        }
        if (null != o) {
            return o.object.get();
        }
        if (null == source) {
            throw new DBusException(Gettext.t("Not an object exported by this connection and no remote specified"));
        }
        return this.dynamicProxy(source, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBusName(String busname) throws DBusException {
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || busname.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name"));
        }
        List<String> list = this.busnames;
        synchronized (list) {
            try {
                this.dbus.ReleaseName(busname);
            }
            catch (DBusExecutionException dbee) {
                if (EXCEPTION_DEBUG) {
                    this.logger.error("", (Throwable)dbee);
                }
                throw new DBusException(dbee.getMessage());
            }
            this.busnames.remove(busname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBusName(String busname) throws DBusException {
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || busname.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name"));
        }
        List<String> list = this.busnames;
        synchronized (list) {
            UInt32 rv;
            try {
                rv = this.dbus.RequestName(busname, new UInt32(6L));
            }
            catch (DBusExecutionException dbee) {
                if (EXCEPTION_DEBUG) {
                    this.logger.error("", (Throwable)dbee);
                }
                throw new DBusException(dbee.getMessage());
            }
            switch (rv.intValue()) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new DBusException(Gettext.t("Failed to register bus name"));
                }
                case 3: {
                    throw new DBusException(Gettext.t("Failed to register bus name"));
                }
                case 4: {
                    break;
                }
            }
            this.busnames.add(busname);
        }
    }

    public String getUniqueName() {
        return this.busnames.get(0);
    }

    public String[] getNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(this.busnames);
        return names.toArray(new String[0]);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String busname, String objectpath, Class<I> type) throws DBusException {
        return this.getPeerRemoteObject(busname, objectpath, type, true);
    }

    public DBusInterface getPeerRemoteObject(String busname, String objectpath) throws DBusException {
        if (null == busname) {
            throw new DBusException(Gettext.t("Invalid bus name: null"));
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name: ") + busname);
        }
        String unique = this.dbus.GetNameOwner(busname);
        return this.dynamicProxy(unique, objectpath);
    }

    public DBusInterface getRemoteObject(String busname, String objectpath) throws DBusException {
        if (null == busname) {
            throw new DBusException(Gettext.t("Invalid bus name: null"));
        }
        if (null == objectpath) {
            throw new DBusException(Gettext.t("Invalid object path: null"));
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name: ") + busname);
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.t("Invalid object path: ") + objectpath);
        }
        return this.dynamicProxy(busname, objectpath);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String busname, String objectpath, Class<I> type, boolean autostart) throws DBusException {
        if (null == busname) {
            throw new DBusException(Gettext.t("Invalid bus name: null"));
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name: ") + busname);
        }
        String unique = this.dbus.GetNameOwner(busname);
        return this.getRemoteObject(unique, objectpath, type, autostart);
    }

    public <I extends DBusInterface> I getRemoteObject(String busname, String objectpath, Class<I> type) throws DBusException {
        return this.getRemoteObject(busname, objectpath, type, true);
    }

    public <I extends DBusInterface> I getRemoteObject(String busname, String objectpath, Class<I> type, boolean autostart) throws DBusException {
        if (null == busname) {
            throw new DBusException(Gettext.t("Invalid bus name: null"));
        }
        if (null == objectpath) {
            throw new DBusException(Gettext.t("Invalid object path: null"));
        }
        if (null == type) {
            throw new ClassCastException(Gettext.t("Not A DBus Interface"));
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name: ") + busname);
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.t("Invalid object path: ") + objectpath);
        }
        if (!DBusInterface.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.t("Not A DBus Interface"));
        }
        if (type.getName().equals(type.getSimpleName())) {
            throw new DBusException(Gettext.t("DBusInterfaces cannot be declared outside a package"));
        }
        RemoteObject ro = new RemoteObject(busname, objectpath, type, autostart);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.importedObjects.put(i, ro);
        return (I)i;
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, String source, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.t("Not A DBus Signal"));
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext.t("Cannot watch for signals based on well known bus name as source, only unique names."));
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name: ") + source);
        }
        this.removeSigHandler(new DBusMatchRule(type, source, null), handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, String source, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.t("Not A DBus Signal"));
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext.t("Cannot watch for signals based on well known bus name as source, only unique names."));
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name: ") + source);
        }
        String objectpath = ((RemoteObject)this.importedObjects.get((Object)object)).objectpath;
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.t("Invalid object path: ") + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(type, source, objectpath), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector v = (Vector)this.handledSignals.get(key);
            if (null != v) {
                v.remove(handler);
                if (0 == v.size()) {
                    this.handledSignals.remove(key);
                    try {
                        this.dbus.RemoveMatch(rule.toString());
                    }
                    catch (NotConnected exNc) {
                        if (EXCEPTION_DEBUG) {
                            this.logger.error("", (Throwable)exNc);
                        }
                    }
                    catch (DBusExecutionException dbee) {
                        if (EXCEPTION_DEBUG) {
                            this.logger.error("", (Throwable)dbee);
                        }
                        throw new DBusException(dbee);
                    }
                }
            }
        }
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, String source, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.t("Not A DBus Signal"));
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext.t("Cannot watch for signals based on well known bus name as source, only unique names."));
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name: ") + source);
        }
        this.addSigHandler(new DBusMatchRule(type, source, null), handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, String source, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.t("Not A DBus Signal"));
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext.t("Cannot watch for signals based on well known bus name as source, only unique names."));
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException(Gettext.t("Invalid bus name: ") + source);
        }
        String objectpath = ((RemoteObject)this.importedObjects.get((Object)object)).objectpath;
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.t("Invalid object path: ") + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(type, source, objectpath), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void addSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        try {
            this.dbus.AddMatch(rule.toString());
        }
        catch (DBusExecutionException dbee) {
            if (EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)dbee);
            }
            throw new DBusException(dbee.getMessage());
        }
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<T>> v = (Vector<DBusSigHandler<T>>)this.handledSignals.get(key);
            if (null == v) {
                v = new Vector<DBusSigHandler<T>>();
                v.add(handler);
                this.handledSignals.put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Map<Object, DBusConnection> map = CONN;
        synchronized (map) {
            Object object = this.reflock;
            synchronized (object) {
                if (0 == --this.refcount) {
                    this.logger.debug("Disconnecting DBusConnection");
                    try {
                        Error err = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", Gettext.t("Disconnected"));
                        Object object2 = this.pendingCalls;
                        synchronized (object2) {
                            long[] set;
                            for (long l : set = this.pendingCalls.getKeys()) {
                                MethodCall m;
                                if (-1L == l || null == (m = this.pendingCalls.remove(l))) continue;
                                m.setReply(err);
                            }
                            this.pendingCalls = null;
                        }
                        object2 = this.pendingErrors;
                        synchronized (object2) {
                            this.pendingErrors.add(err);
                        }
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                    CONN.remove(this.addr);
                    super.disconnect();
                }
            }
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    private class SigHandler
    implements DBusSigHandler<DBusSignal> {
        private SigHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(DBusSignal s) {
            if (s instanceof DBus.Local.Disconnected) {
                DBusConnection.this.logger.debug("Handling Disconnected signal from bus");
                try {
                    Object object;
                    Error err = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", Gettext.t("Disconnected"));
                    if (null != DBusConnection.this.pendingCalls) {
                        object = DBusConnection.this.pendingCalls;
                        synchronized (object) {
                            long[] set;
                            for (long l : set = DBusConnection.this.pendingCalls.getKeys()) {
                                MethodCall m;
                                if (-1L == l || null == (m = DBusConnection.this.pendingCalls.remove(l))) continue;
                                m.setReply(err);
                            }
                        }
                    }
                    object = DBusConnection.this.pendingErrors;
                    synchronized (object) {
                        DBusConnection.this.pendingErrors.add(err);
                    }
                }
                catch (DBusException dBusException) {}
            } else if (s instanceof DBus.NameAcquired) {
                DBusConnection.this.busnames.add(((DBus.NameAcquired)s).name);
            }
        }
    }

    public class PeerSet
    implements Set<String>,
    DBusSigHandler<DBus.NameOwnerChanged> {
        private Set<String> addresses;

        public PeerSet() {
            block2: {
                this.addresses = new TreeSet<String>();
                try {
                    DBusConnection.this.addSigHandler(new DBusMatchRule(DBus.NameOwnerChanged.class, null, null), this);
                }
                catch (DBusException dbe) {
                    if (!AbstractConnection.EXCEPTION_DEBUG) break block2;
                    DBusConnection.this.logger.error("", (Throwable)dbe);
                }
            }
        }

        @Override
        public void handle(DBus.NameOwnerChanged noc) {
            DBusConnection.this.logger.debug("Received NameOwnerChanged(" + noc.name + "," + noc.oldOwner + "," + noc.newOwner + ")");
            if ("".equals(noc.newOwner) && this.addresses.contains(noc.name)) {
                this.remove(noc.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(String address) {
            DBusConnection.this.logger.debug("Adding " + address);
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.add(address);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends String> _addresses) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.addAll(_addresses);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Set<String> set = this.addresses;
            synchronized (set) {
                this.addresses.clear();
            }
        }

        @Override
        public boolean contains(Object o) {
            return this.addresses.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> os) {
            return this.addresses.containsAll(os);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof PeerSet) {
                return ((PeerSet)o).addresses.equals(this.addresses);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.addresses.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.addresses.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return this.addresses.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            DBusConnection.this.logger.debug("Removing " + o);
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> os) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.removeAll(os);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> os) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.retainAll(os);
            }
        }

        @Override
        public int size() {
            return this.addresses.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.toArray(a);
            }
        }
    }
}

