/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variant<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T o;
    private final Type type;
    private final String sig;

    public Variant(T _o) throws IllegalArgumentException {
        if (null == _o) {
            throw new IllegalArgumentException(Gettext.t("Can't wrap Null in a Variant"));
        }
        this.type = _o.getClass();
        try {
            String[] ss = Marshalling.getDBusType(_o.getClass(), true);
            if (ss.length != 1) {
                throw new IllegalArgumentException(Gettext.t("Can't wrap a multi-valued type in a Variant: ") + this.type);
            }
            this.sig = ss[0];
        }
        catch (DBusException dbe) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)dbe);
            }
            throw new IllegalArgumentException(MessageFormat.format(Gettext.t("Can't wrap {0} in an unqualified Variant ({1})."), _o.getClass(), dbe.getMessage()));
        }
        this.o = _o;
    }

    public Variant(T _o, Type _type) throws IllegalArgumentException {
        if (null == _o) {
            throw new IllegalArgumentException(Gettext.t("Can't wrap Null in a Variant"));
        }
        this.type = _type;
        try {
            String[] ss = Marshalling.getDBusType(_type);
            if (ss.length != 1) {
                throw new IllegalArgumentException(Gettext.t("Can't wrap a multi-valued type in a Variant: ") + _type);
            }
            this.sig = ss[0];
        }
        catch (DBusException dbe) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)dbe);
            }
            throw new IllegalArgumentException(MessageFormat.format(Gettext.t("Can't wrap {0} in an unqualified Variant ({1})."), _type, dbe.getMessage()));
        }
        this.o = _o;
    }

    public Variant(T _o, String _sig) throws IllegalArgumentException {
        if (null == _o) {
            throw new IllegalArgumentException(Gettext.t("Can't wrap Null in a Variant"));
        }
        this.sig = _sig;
        try {
            Vector<Type> ts = new Vector<Type>();
            Marshalling.getJavaType(_sig, ts, 1);
            if (ts.size() != 1) {
                throw new IllegalArgumentException(Gettext.t("Can't wrap multiple or no types in a Variant: ") + _sig);
            }
            this.type = ts.get(0);
        }
        catch (DBusException dbe) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                this.logger.error("", (Throwable)dbe);
            }
            throw new IllegalArgumentException(MessageFormat.format(Gettext.t("Can't wrap {0} in an unqualified Variant ({1})."), _sig, dbe.getMessage()));
        }
        this.o = _o;
    }

    public T getValue() {
        return this.o;
    }

    public Type getType() {
        return this.type;
    }

    public String getSig() {
        return this.sig;
    }

    public String toString() {
        return "[" + this.o + "]";
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof Variant)) {
            return false;
        }
        return this.o.equals(((Variant)other).o);
    }
}

