/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

public final class ListDBus {
    public static void syntax() {
        System.out.println("Syntax: ListDBus [--version] [-v] [--help] [-h] [--owners] [-o] [--uids] [-u] [--session] [-s] [--system] [-y]");
        System.exit(1);
    }

    private ListDBus() {
    }

    public static void version() {
        System.out.println("Java D-Bus Version " + System.getProperty("Version"));
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        String[] names;
        boolean owners = false;
        boolean users = false;
        int connection = 1;
        for (String a : args) {
            if ("--help".equals(a)) {
                ListDBus.syntax();
                continue;
            }
            if ("-h".equals(a)) {
                ListDBus.syntax();
                continue;
            }
            if ("--version".equals(a)) {
                ListDBus.version();
                continue;
            }
            if ("-v".equals(a)) {
                ListDBus.version();
                continue;
            }
            if ("-u".equals(a)) {
                users = true;
                continue;
            }
            if ("--uids".equals(a)) {
                users = true;
                continue;
            }
            if ("-o".equals(a)) {
                owners = true;
                continue;
            }
            if ("--owners".equals(a)) {
                owners = true;
                continue;
            }
            if ("--session".equals(a)) {
                connection = 1;
                continue;
            }
            if ("-s".equals(a)) {
                connection = 1;
                continue;
            }
            if ("--system".equals(a)) {
                connection = 0;
                continue;
            }
            if ("-y".equals(a)) {
                connection = 0;
                continue;
            }
            ListDBus.syntax();
        }
        DBusConnection conn = DBusConnection.getConnection(connection);
        DBus dbus = conn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        for (String s : names = dbus.ListNames()) {
            if (users) {
                try {
                    System.out.print(dbus.GetConnectionUnixUser(s) + "\t");
                }
                catch (DBusExecutionException exDe) {
                    System.out.print("\t");
                }
            }
            System.out.print(s);
            if (!s.startsWith(":") && owners) {
                try {
                    System.out.print("\t" + dbus.GetNameOwner(s));
                }
                catch (DBusExecutionException dBusExecutionException) {
                    // empty catch block
                }
            }
            System.out.println();
        }
        conn.disconnect();
    }
}

