/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.lang.reflect.Type;
import java.text.Collator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.CallbackHandler;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.test.ArraySignalHandler;
import org.freedesktop.dbus.test.BadArraySignalHandler;
import org.freedesktop.dbus.test.CallbackHandlerImpl;
import org.freedesktop.dbus.test.DisconnectHandler;
import org.freedesktop.dbus.test.EmptySignalHandler;
import org.freedesktop.dbus.test.ObjectSignalHandler;
import org.freedesktop.dbus.test.PathSignalHandler;
import org.freedesktop.dbus.test.RenamedSignalHandler;
import org.freedesktop.dbus.test.SignalHandler;
import org.freedesktop.dbus.test.TestClass;
import org.freedesktop.dbus.test.TestException;
import org.freedesktop.dbus.test.TestNewInterface;
import org.freedesktop.dbus.test.TestRemoteInterface;
import org.freedesktop.dbus.test.TestRemoteInterface2;
import org.freedesktop.dbus.test.TestSerializable;
import org.freedesktop.dbus.test.TestSignalInterface;
import org.freedesktop.dbus.test.TestSignalInterface2;
import org.freedesktop.dbus.test.TestStruct;
import org.freedesktop.dbus.test.TestStruct2;
import org.freedesktop.dbus.test.TestStruct3;
import org.freedesktop.dbus.test.TestTuple;
import org.junit.Assert;
import org.junit.Test;

public class TestAll {
    public static boolean done1 = false;
    public static boolean done2 = false;
    public static boolean done3 = false;
    public static boolean done4 = false;
    public static boolean done5 = false;
    public static boolean done6 = false;
    public static boolean done7 = false;
    public static boolean done8 = false;
    static DBusConnection serverconn = null;
    static DBusConnection clientconn = null;

    @Test
    public void testAllMethods() {
        TestAll.main(null);
    }

    public static void fail(String message) {
        System.out.println("Test Failed: " + message);
        System.err.println("Test Failed: " + message);
        if (null != serverconn) {
            serverconn.disconnect();
        }
        if (null != clientconn) {
            clientconn.disconnect();
        }
        Assert.fail((String)("Test Failed: " + message));
    }

    public static void main(String[] args) {
        try {
            Vector<Integer> li;
            Vector<List<Integer>> lli;
            Collator col;
            TestRemoteInterface tri;
            DBusConnection.PeerSet peers;
            DBus.Introspectable intro;
            TestClass tclass;
            SignalHandler sigh;
            block56: {
                String[] names;
                System.out.println("Creating Connection");
                serverconn = DBusConnection.getConnection((int)1);
                clientconn = DBusConnection.getConnection((int)1);
                serverconn.setWeakReferences(true);
                clientconn.setWeakReferences(true);
                System.out.println("Registering Name");
                serverconn.requestBusName("foo.bar.Test");
                DBus.Peer peer = (DBus.Peer)clientconn.getRemoteObject("foo.bar.Test", "/Test", DBus.Peer.class);
                DBus dbus = (DBus)clientconn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
                System.out.print("Listening for signals...");
                sigh = new SignalHandler();
                RenamedSignalHandler rsh = new RenamedSignalHandler();
                try {
                    clientconn.addSigHandler(TestSignalInterface.EmptySignal.class, (DBusSigHandler)new EmptySignalHandler());
                    clientconn.addSigHandler(TestSignalInterface.TestSignal.class, (DBusSigHandler)sigh);
                    clientconn.addSigHandler(TestSignalInterface2.TestRenamedSignal.class, (DBusSigHandler)rsh);
                    clientconn.addSigHandler(DBus.Local.Disconnected.class, (DBusSigHandler)new DisconnectHandler(clientconn, rsh));
                    String source = dbus.GetNameOwner("foo.bar.Test");
                    clientconn.addSigHandler(TestSignalInterface.TestArraySignal.class, source, (DBusInterface)peer, (DBusSigHandler)new ArraySignalHandler());
                    clientconn.addSigHandler(TestSignalInterface.TestObjectSignal.class, (DBusSigHandler)new ObjectSignalHandler());
                    clientconn.addSigHandler(TestSignalInterface.TestPathSignal.class, (DBusSigHandler)new PathSignalHandler());
                    BadArraySignalHandler bash = new BadArraySignalHandler();
                    clientconn.addSigHandler(TestSignalInterface.TestSignal.class, bash);
                    clientconn.removeSigHandler(TestSignalInterface.TestSignal.class, bash);
                    System.out.println("done");
                }
                catch (DBus.Error.MatchRuleInvalid exMri) {
                    TestAll.fail("Failed to add handlers: " + exMri.getMessage());
                }
                catch (DBusException exDb) {
                    TestAll.fail("Failed to add handlers: " + exDb.getMessage());
                }
                System.out.println("Listening for Method Calls");
                tclass = new TestClass(serverconn);
                TestClass tclass2 = new TestClass(serverconn);
                serverconn.exportObject("/Test", (DBusInterface)tclass);
                serverconn.exportObject("/BadTest", (DBusInterface)tclass);
                serverconn.exportObject("/BadTest2", (DBusInterface)tclass2);
                serverconn.addFallback("/FallbackTest", (DBusInterface)tclass);
                serverconn.unExportObject("/BadTest");
                tclass2 = null;
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.out.println("Sending Signal");
                serverconn.sendSignal((DBusSignal)new TestSignalInterface.TestSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
                serverconn.sendSignal((DBusSignal)new TestSignalInterface.EmptySignal("/foo/bar/Wibble"));
                serverconn.sendSignal((DBusSignal)new TestSignalInterface2.TestRenamedSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
                System.out.println("These things are on the bus:");
                for (String name : names = dbus.ListNames()) {
                    System.out.println("\t" + name);
                }
                System.out.println("Getting our introspection data");
                intro = (DBus.Introspectable)clientconn.getRemoteObject("foo.bar.Test", "/", DBus.Introspectable.class);
                intro = (DBus.Introspectable)clientconn.getRemoteObject("foo.bar.Test", "/Test", DBus.Introspectable.class);
                String data = intro.Introspect();
                if (null == data || !data.startsWith("<!DOCTYPE")) {
                    TestAll.fail("Introspection data invalid");
                }
                System.out.println("Got Introspection Data: \n" + data);
                peers = new DBusConnection.PeerSet(serverconn);
                peers.add("org.freedesktop.DBus");
                clientconn.requestBusName("test.testclient");
                peers.add("test.testclient");
                clientconn.releaseBusName("test.testclient");
                System.out.println("Pinging ourselves");
                for (int i = 0; i < 10; ++i) {
                    long then = System.currentTimeMillis();
                    peer.Ping();
                    long now = System.currentTimeMillis();
                    System.out.println("Ping returned in " + (now - then) + "ms.");
                }
                System.out.println("Calling Method0/1");
                tri = (TestRemoteInterface)clientconn.getPeerRemoteObject("foo.bar.Test", "/Test");
                System.out.println("Got Remote Object: " + tri);
                String rname = tri.getName();
                System.out.println("Got Remote Name: " + rname);
                Path path = new Path("/nonexistantwooooooo");
                Path p = tri.pathrv(path);
                System.out.println(path.toString() + " => " + p.toString());
                if (!path.equals((Object)p)) {
                    TestAll.fail("pathrv incorrect");
                }
                Vector<Path> paths = new Vector<Path>();
                paths.add(path);
                List<Path> ps = tri.pathlistrv(paths);
                System.out.println(((Object)paths).toString() + " => " + ps.toString());
                if (!paths.equals(ps)) {
                    TestAll.fail("pathlistrv incorrect");
                }
                HashMap<Path, Path> pathm = new HashMap<Path, Path>();
                pathm.put(path, path);
                Map<Path, Path> pm = tri.pathmaprv(pathm);
                System.out.println(((Object)pathm).toString() + " => " + pm.toString());
                System.out.println(pm.containsKey(path) + " " + pm.get(path) + " " + path.equals((Object)pm.get(path)));
                System.out.println(pm.containsKey(p) + " " + pm.get(p) + " " + p.equals((Object)pm.get(p)));
                for (Path q : pm.keySet()) {
                    System.out.println(q);
                    System.out.println(pm.get(q));
                }
                if (!pm.containsKey(path) || !path.equals((Object)pm.get(path))) {
                    TestAll.fail("pathmaprv incorrect");
                }
                serverconn.sendSignal((DBusSignal)new TestSignalInterface.TestPathSignal("/Test", path, paths, pathm));
                col = Collator.getInstance();
                col.setDecomposition(2);
                col.setStrength(0);
                if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", rname)) {
                    TestAll.fail("getName return value incorrect");
                }
                System.out.println("sending it to sleep");
                tri.waitawhile();
                System.out.println("testing floats");
                if (17.093f != tri.testfloat(new float[]{17.093f, -23.0f, 0.0f, 31.42f})) {
                    TestAll.fail("testfloat returned the wrong thing");
                }
                System.out.println("Structs of Structs");
                lli = new Vector<List<Integer>>();
                li = new Vector<Integer>();
                li.add(1);
                li.add(2);
                li.add(3);
                lli.add(li);
                lli.add(li);
                lli.add(li);
                TestStruct3 ts3 = new TestStruct3(new TestStruct2(new Vector<String>(), (Variant<? extends Object>)new Variant((Object)0)), lli);
                int[][] out = tri.teststructstruct(ts3);
                if (out.length != 3) {
                    TestAll.fail("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out));
                }
                for (int[] o : out) {
                    if (o.length == 3 && o[0] == 1 && o[1] == 2 && o[2] == 3) continue;
                    TestAll.fail("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out));
                }
                System.out.println("frobnicating");
                Vector<Long> ls = new Vector<Long>();
                ls.add(2L);
                ls.add(5L);
                ls.add(71L);
                HashMap<UInt16, Short> mus = new HashMap<UInt16, Short>();
                mus.put(new UInt16(4), (short)5);
                mus.put(new UInt16(5), (short)6);
                mus.put(new UInt16(6), (short)7);
                HashMap<String, Map<UInt16, Short>> msmus = new HashMap<String, Map<UInt16, Short>>();
                msmus.put("stuff", mus);
                int rint = tri.frobnicate(ls, msmus, 13);
                if (-5 != rint) {
                    TestAll.fail("frobnicate return value incorrect");
                }
                System.out.println("Doing stuff asynchronously with callback");
                clientconn.callWithCallback((DBusInterface)tri, "getName", (CallbackHandler)new CallbackHandlerImpl(), new Object[0]);
                System.out.println("Doing stuff asynchronously with callback, which throws an error");
                clientconn.callWithCallback((DBusInterface)tri, "getNameAndThrow", (CallbackHandler)new CallbackHandlerImpl(), new Object[0]);
                try {
                    System.out.println("Throwing stuff");
                    tri.throwme();
                    TestAll.fail("Method Execution should have failed");
                }
                catch (TestException ex) {
                    System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
                    if (ex.getMessage().equals("test")) break block56;
                    TestAll.fail("Error message was not correct");
                }
            }
            Vector ts = new Vector();
            Marshalling.getJavaType((String)"ya{si}", ts, (int)-1);
            tri.sig(ts.toArray(new Type[0]));
            tri.newpathtest(new Path("/new/path/test"));
            try {
                System.out.println("Calling Method2");
                tri = (TestRemoteInterface)clientconn.getRemoteObject("foo.bar.NotATest", "/Moofle", TestRemoteInterface.class);
                System.out.println("Got Remote Name: " + tri.getName());
                TestAll.fail("Method Execution should have failed");
            }
            catch (DBus.Error.ServiceUnknown ex) {
                System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
            }
            try {
                System.out.println("Calling Method3");
                tri = (TestRemoteInterface)clientconn.getRemoteObject("foo.bar.Test", "/Moofle", TestRemoteInterface.class);
                System.out.println("Got Remote Name: " + tri.getName());
                TestAll.fail("Method Execution should have failed");
            }
            catch (DBus.Error.UnknownObject ex) {
                System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
            }
            try {
                System.out.println("Calling Method4");
                tri = (TestRemoteInterface)clientconn.getRemoteObject("foo.bar.Test", "/BadTest", TestRemoteInterface.class);
                System.out.println("Got Remote Name: " + tri.getName());
                TestAll.fail("Method Execution should have failed");
            }
            catch (DBus.Error.UnknownObject ex) {
                System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
            }
            try {
                System.out.println("Calling Method5");
                tri = (TestRemoteInterface)clientconn.getRemoteObject("foo.bar.Test", "/BadTest2", TestRemoteInterface.class);
                System.out.println("Got Remote Name: " + tri.getName());
                TestAll.fail("Method Execution should have failed");
            }
            catch (DBus.Error.UnknownObject ex) {
                System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
            }
            System.out.println("Calling Method6");
            tri = (TestRemoteInterface)clientconn.getRemoteObject("foo.bar.Test", "/FallbackTest/0/1", TestRemoteInterface.class);
            intro = (DBus.Introspectable)clientconn.getRemoteObject("foo.bar.Test", "/FallbackTest/0/4", DBus.Introspectable.class);
            System.out.println("Got Fallback Name: " + tri.getName());
            System.out.println("Fallback Introspection Data: \n" + intro.Introspect());
            System.out.println("Testing Properties returning Paths");
            DBus.Properties prop = (DBus.Properties)clientconn.getRemoteObject("foo.bar.Test", "/Test", DBus.Properties.class);
            Path prv = (Path)prop.Get("foo.bar", "foo");
            System.out.println("Got path " + prv);
            System.out.println("Calling Method7--9");
            TestRemoteInterface2 tri2 = (TestRemoteInterface2)clientconn.getRemoteObject("foo.bar.Test", "/Test", TestRemoteInterface2.class);
            System.out.print("Calling the other introspect method: ");
            String intro2 = tri2.Introspect();
            System.out.println(intro2);
            if (0 != col.compare("Not XML", intro2)) {
                TestAll.fail("Introspect return value incorrect");
            }
            TestTuple<String, List<Integer>, Boolean> rv = tri2.show(234);
            System.out.println("Show returned: " + rv);
            if (!serverconn.getUniqueName().equals(rv.a) || 1 != ((List)rv.b).size() || 1953 != (Integer)((List)rv.b).get(0) || !((Boolean)rv.c).booleanValue()) {
                TestAll.fail("show return value incorrect (" + (String)rv.a + "," + rv.b + "," + rv.c + ")");
            }
            System.out.println("Doing stuff asynchronously");
            DBusAsyncReply stuffreply = clientconn.callMethodAsync((DBusInterface)tri2, "dostuff", new Object[]{new TestStruct("bar", new UInt32(52L), (Variant<? extends Object>)new Variant((Object)new Boolean(true)))});
            System.out.println("Checking bools");
            if (tri2.check()) {
                TestAll.fail("bools are broken");
            }
            Vector<String> l = new Vector<String>();
            l.add("hi");
            l.add("hello");
            l.add("hej");
            l.add("hey");
            l.add("aloha");
            System.out.println("Sampling Arrays:");
            List<Integer> is = tri2.sampleArray(l, new Integer[]{1, 5, 7, 9}, new long[]{2L, 6L, 8L, 12L});
            System.out.println("sampleArray returned an array:");
            for (Integer i : is) {
                System.out.println("--" + i);
            }
            if (is.size() != 5 || is.get(0) != -1 || is.get(1) != -5 || is.get(2) != -7 || is.get(3) != -12 || is.get(4) != -18) {
                TestAll.fail("sampleArray return value incorrect");
            }
            System.out.println("Get This");
            if (!tclass.equals(tri2.getThis(tri2))) {
                TestAll.fail("Didn't get the correct this");
            }
            Boolean b = (Boolean)stuffreply.getReply();
            System.out.println("Do stuff replied " + b);
            if (!b.booleanValue()) {
                TestAll.fail("dostuff return value incorrect");
            }
            System.out.print("Sending Array Signal...");
            Vector<TestStruct2> tsl = new Vector<TestStruct2>();
            tsl.add(new TestStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(567L))));
            HashMap<UInt32, TestStruct2> tsm = new HashMap<UInt32, TestStruct2>();
            tsm.put(new UInt32(1L), new TestStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(678L))));
            tsm.put(new UInt32(42L), new TestStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(789L))));
            serverconn.sendSignal((DBusSignal)new TestSignalInterface.TestArraySignal("/Test", tsl, tsm));
            System.out.println("done");
            System.out.print("testing custom serialization...");
            Vector<Integer> v = new Vector<Integer>();
            v.add(1);
            v.add(2);
            v.add(3);
            TestSerializable<String> s = new TestSerializable<String>(1, "woo", v);
            s = tri2.testSerializable((byte)12, s, 13);
            System.out.print("returned: " + s);
            if (s.getInt() != 1 || !s.getString().equals("woo") || s.getVector().size() != 3 || s.getVector().get(0) != 1 || s.getVector().get(1) != 2 || s.getVector().get(2) != 3) {
                TestAll.fail("Didn't get back the same TestSerializable");
            }
            System.out.println("done");
            System.out.print("testing complex variants...");
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("cow", "moo");
            tri2.complexv((Variant<? extends Object>)new Variant(m, "a{ss}"));
            System.out.println("done");
            System.out.print("testing recursion...");
            if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", tri2.recursionTest())) {
                TestAll.fail("recursion test failed");
            }
            System.out.println("done");
            System.out.print("testing method overloading...");
            tri = (TestRemoteInterface)clientconn.getRemoteObject("foo.bar.Test", "/Test", TestRemoteInterface.class);
            if (1 != tri2.overload("foo")) {
                TestAll.fail("wrong overloaded method called");
            }
            if (2 != tri2.overload((byte)0)) {
                TestAll.fail("wrong overloaded method called");
            }
            if (3 != tri2.overload()) {
                TestAll.fail("wrong overloaded method called");
            }
            if (4 != tri.overload()) {
                TestAll.fail("wrong overloaded method called");
            }
            System.out.println("done");
            System.out.print("reg13291...");
            byte[] as = new byte[10];
            for (int i = 0; i < 10; ++i) {
                as[i] = (byte)(100 - i);
            }
            tri.reg13291(as, as);
            System.out.println("done");
            System.out.print("Testing nested lists...");
            lli = new Vector();
            li = new Vector();
            li.add(1);
            lli.add(li);
            List<List<Integer>> reti = tri2.checklist(lli);
            if (reti.size() != 1 || reti.get(0).size() != 1 || reti.get(0).get(0) != 1) {
                TestAll.fail("Failed to check nested lists");
            }
            System.out.println("done");
            System.out.print("Testing dynamic object creation...");
            TestNewInterface tni = tri2.getNew();
            System.out.print(tni.getName() + " ");
            System.out.println("done");
            serverconn.sendSignal((DBusSignal)new TestSignalInterface.TestObjectSignal("/foo/bar/Wibble", tclass));
            Thread.sleep(1000L);
            if (peers.size() != 1) {
                TestAll.fail("peers hasn't been trimmed");
            }
            if (!peers.contains("org.freedesktop.DBus")) {
                TestAll.fail("peers contains the wrong name");
            }
            System.out.println("Checking for outstanding errors");
            DBusExecutionException dbee = serverconn.getError();
            if (null != dbee) {
                throw dbee;
            }
            dbee = clientconn.getError();
            if (null != dbee) {
                throw dbee;
            }
            System.out.println("Disconnecting");
            clientconn.disconnect();
            serverconn.disconnect();
            System.out.println("Trying to do things after disconnection");
            clientconn.removeSigHandler(TestSignalInterface.TestSignal.class, (DBusSigHandler)sigh);
            try {
                System.out.println("getName() suceeded and returned: " + tri.getName());
                TestAll.fail("Should not succeed when disconnected");
            }
            catch (NotConnected exnc) {
                System.out.println("getName() failed with exception " + (Object)((Object)exnc));
            }
            clientconn = null;
            serverconn = null;
            if (!done1) {
                TestAll.fail("Signal handler 1 failed to be run");
            }
            if (!done2) {
                TestAll.fail("Signal handler 2 failed to be run");
            }
            if (!done3) {
                TestAll.fail("Signal handler 3 failed to be run");
            }
            if (!done4) {
                TestAll.fail("Callback handler failed to be run");
            }
            if (!done5) {
                TestAll.fail("Signal handler R failed to be run");
            }
            if (!done6) {
                TestAll.fail("Disconnect handler failed to be run");
            }
            if (!done7) {
                TestAll.fail("Signal handler E failed to be run");
            }
            if (!done8) {
                TestAll.fail("Error callback handler failed to be run");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestAll.fail("Unexpected Exception Occurred: " + e);
        }
    }
}

