/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.freedesktop.DBus;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.CallbackHandler;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.EfficientMap;
import org.freedesktop.dbus.EfficientQueue;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.ObjectTree;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalDBusException;
import org.freedesktop.dbus.exceptions.FatalException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final int TIMEOUT = 100000;
    private static final int PENDING_MAP_INITIAL_SIZE = 10;
    static final String BUSNAME_REGEX = "^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$";
    static final String CONNID_REGEX = "^:[0-9]*\\.[0-9]*$";
    static final String OBJECT_REGEX = "^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$";
    static final byte THREADCOUNT = 4;
    static final int MAX_ARRAY_LENGTH = 0x4000000;
    static final int MAX_NAME_LENGTH = 255;
    private ObjectTree objectTree;
    private GlobalHandler globalHandlerReference;
    protected Map<String, ExportedObject> exportedObjects = new HashMap<String, ExportedObject>();
    protected Map<DBusInterface, RemoteObject> importedObjects = new HashMap<DBusInterface, RemoteObject>();
    protected Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> handledSignals;
    protected EfficientMap pendingCalls;
    protected Map<MethodCall, CallbackHandler<? extends Object>> pendingCallbacks;
    protected Map<MethodCall, DBusAsyncReply<? extends Object>> pendingCallbackReplys;
    protected LinkedList<Runnable> runnables;
    protected LinkedList<WorkerThread> workers;
    protected FallbackContainer fallbackcontainer;
    protected volatile boolean run;
    EfficientQueue outgoing;
    LinkedList<Error> pendingErrors;
    protected ConnThread thread;
    protected SenderThread sender;
    protected Transport transport;
    protected String addr;
    protected boolean weakreferences = false;
    protected boolean connected = false;
    static final Pattern DOLLAR_PATTERN = Pattern.compile("[$]");
    private static final Map<Thread, DBusCallInfo> INFOMAP = new HashMap<Thread, DBusCallInfo>();
    static final boolean FLOAT_SUPPORT = null != System.getenv("DBUS_JAVA_FLOATS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractConnection(String address) throws DBusException {
        this.globalHandlerReference = new GlobalHandler();
        Object object = this.exportedObjects;
        synchronized (object) {
            this.exportedObjects.put(null, new ExportedObject(this.globalHandlerReference, this.weakreferences));
        }
        this.handledSignals = new HashMap<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>>();
        this.pendingCalls = new EfficientMap(10);
        this.outgoing = new EfficientQueue(10);
        this.pendingCallbacks = new HashMap<MethodCall, CallbackHandler<? extends Object>>();
        this.pendingCallbackReplys = new HashMap<MethodCall, DBusAsyncReply<? extends Object>>();
        this.pendingErrors = new LinkedList();
        this.runnables = new LinkedList();
        this.workers = new LinkedList();
        this.objectTree = new ObjectTree();
        this.fallbackcontainer = new FallbackContainer();
        object = this.workers;
        synchronized (object) {
            for (int i = 0; i < 4; ++i) {
                WorkerThread t = new WorkerThread();
                t.start();
                this.workers.add(t);
            }
        }
        this.run = true;
        this.addr = address;
    }

    protected void listen() {
        this.thread = new ConnThread();
        this.thread.start();
        this.sender = new SenderThread();
        this.sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeThreadCount(byte newcount) {
        LinkedList<WorkerThread> linkedList = this.workers;
        synchronized (linkedList) {
            if (this.workers.size() > newcount) {
                int n = this.workers.size() - newcount;
                for (int i = 0; i < n; ++i) {
                    WorkerThread t = this.workers.removeFirst();
                    t.halt();
                }
            } else if (this.workers.size() < newcount) {
                int n = newcount - this.workers.size();
                for (int i = 0; i < n; ++i) {
                    WorkerThread t = new WorkerThread();
                    t.start();
                    this.workers.add(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunnable(Runnable r) {
        LinkedList<Runnable> linkedList = this.runnables;
        synchronized (linkedList) {
            this.runnables.add(r);
            this.runnables.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getExportedObject(DBusInterface i) throws DBusException {
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            for (String s : this.exportedObjects.keySet()) {
                if (!i.equals(this.exportedObjects.get((Object)s).object.get())) continue;
                return s;
            }
        }
        String s = this.importedObjects.get((Object)i).objectpath;
        if (null != s) {
            return s;
        }
        throw new DBusException("Not an object exported or imported by this connection");
    }

    abstract DBusInterface getExportedObject(String var1, String var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusCallInfo getCallInfo() {
        DBusCallInfo info;
        Map<Thread, DBusCallInfo> map = INFOMAP;
        synchronized (map) {
            info = INFOMAP.get(Thread.currentThread());
        }
        return info;
    }

    public void setWeakReferences(boolean _weakreferences) {
        this.weakreferences = _weakreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(String objectpath, DBusInterface object) throws DBusException {
        if (null == objectpath || "".equals(objectpath)) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            if (null != this.exportedObjects.get(objectpath)) {
                throw new DBusException("Object already exported");
            }
            ExportedObject eo = new ExportedObject(object, this.weakreferences);
            this.exportedObjects.put(objectpath, eo);
            this.objectTree.add(objectpath, eo, eo.introspectiondata);
        }
    }

    public void addFallback(String objectprefix, DBusInterface object) throws DBusException {
        if (null == objectprefix || "".equals(objectprefix)) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (!objectprefix.matches(OBJECT_REGEX) || objectprefix.length() > 255) {
            throw new DBusException("Invalid object path: " + objectprefix);
        }
        ExportedObject eo = new ExportedObject(object, this.weakreferences);
        this.fallbackcontainer.add(objectprefix, eo);
    }

    public void removeFallback(String objectprefix) {
        this.fallbackcontainer.remove(objectprefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unExportObject(String objectpath) {
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            this.exportedObjects.remove(objectpath);
            this.objectTree.remove(objectpath);
        }
    }

    public void sendSignal(DBusSignal signal) {
        this.queueOutgoing(signal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueOutgoing(Message m) {
        EfficientQueue efficientQueue = this.outgoing;
        synchronized (efficientQueue) {
            if (null == this.outgoing) {
                return;
            }
            this.outgoing.add(m);
            this.logger.debug("Notifying outgoing thread");
            this.outgoing.notifyAll();
        }
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.removeSigHandler(new DBusMatchRule(type), handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        String objectpath = this.importedObjects.get((Object)object).objectpath;
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(type, null, objectpath), handler);
    }

    protected abstract <T extends DBusSignal> void removeSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    public <T extends DBusSignal> void addSigHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.addSigHandler(new DBusMatchRule(type), handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        String objectpath = this.importedObjects.get((Object)object).objectpath;
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(type, null, objectpath), handler);
    }

    protected abstract <T extends DBusSignal> void addSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DBusSignal> void addSigHandlerWithoutMatch(Class<? extends DBusSignal> signal, DBusSigHandler<T> handler) throws DBusException {
        DBusMatchRule rule = new DBusMatchRule(signal);
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<DBusSignal>> v = this.handledSignals.get(key);
            if (null == v) {
                v = new Vector();
                v.add(handler);
                this.handledSignals.put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object ex2;
        this.connected = false;
        this.logger.debug("Sending disconnected signal");
        try {
            this.handleMessage(new DBus.Local.Disconnected("/"));
        }
        catch (Exception ex2) {
            this.logger.debug("Exception while disconnecting", (Throwable)ex2);
        }
        this.logger.debug("Disconnecting Abstract Connection");
        while (this.runnables.size() > 0) {
            ex2 = this.runnables;
            synchronized (ex2) {
                this.runnables.notifyAll();
            }
        }
        this.run = false;
        ex2 = this.outgoing;
        synchronized (ex2) {
            this.outgoing.notifyAll();
        }
        try {
            if (null != this.transport) {
                this.transport.disconnect();
                this.transport = null;
            }
        }
        catch (IOException exIo) {
            this.logger.debug("Exception while disconnecting transport.", (Throwable)exIo);
        }
        LinkedList<Runnable> linkedList = this.workers;
        synchronized (linkedList) {
            for (WorkerThread t : this.workers) {
                t.halt();
            }
        }
        linkedList = this.runnables;
        synchronized (linkedList) {
            this.runnables.notifyAll();
        }
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusExecutionException getError() {
        LinkedList<Error> linkedList = this.pendingErrors;
        synchronized (linkedList) {
            if (this.pendingErrors.size() == 0) {
                return null;
            }
            return this.pendingErrors.removeFirst().getException();
        }
    }

    public <A> void callWithCallback(DBusInterface object, String m, CallbackHandler<A> callback, Object ... parameters) {
        this.logger.trace("callWithCallback(" + object + "," + m + ", " + callback);
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        RemoteObject ro = this.importedObjects.get(object);
        try {
            Method me = null == ro.iface ? object.getClass().getMethod(m, types) : ro.iface.getMethod(m, types);
            RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 2, callback, parameters);
        }
        catch (DBusExecutionException exEe) {
            this.logger.debug("", (Throwable)exEe);
            throw exEe;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusExecutionException(e.getMessage());
        }
    }

    public DBusAsyncReply<?> callMethodAsync(DBusInterface object, String m, Object ... parameters) {
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        RemoteObject ro = this.importedObjects.get(object);
        try {
            Method me = null == ro.iface ? object.getClass().getMethod(m, types) : ro.iface.getMethod(m, types);
            return (DBusAsyncReply)RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 1, null, parameters);
        }
        catch (DBusExecutionException exDee) {
            this.logger.debug("", (Throwable)exDee);
            throw exDee;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusExecutionException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodCall m) throws DBusException {
        Object object;
        this.logger.debug("Handling incoming method call: " + m);
        ExportedObject eo = null;
        Method meth = null;
        DBusInterface o = null;
        if (null == m.getInterface() || m.getInterface().equals("org.freedesktop.DBus.Peer") || m.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            object = this.exportedObjects;
            synchronized (object) {
                eo = this.exportedObjects.get(null);
            }
            if (null != eo && null == eo.object.get()) {
                this.unExportObject(null);
                eo = null;
            }
            if (null != eo) {
                meth = eo.methods.get(new MethodTuple(m.getName(), m.getSig()));
            }
            if (null != meth) {
                o = new GlobalHandler(m.getPath());
            } else {
                eo = null;
            }
        }
        if (null == o) {
            object = this.exportedObjects;
            synchronized (object) {
                eo = this.exportedObjects.get(m.getPath());
            }
            if (null != eo && null == eo.object.get()) {
                this.logger.info("Unexporting " + m.getPath() + " implicitly");
                this.unExportObject(m.getPath());
                eo = null;
            }
            if (null == eo) {
                eo = this.fallbackcontainer.get(m.getPath());
            }
            if (null == eo) {
                this.queueOutgoing(new Error(m, new DBus.Error.UnknownObject(m.getPath() + " is not an object provided by this process.")));
                return;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Searching for method " + m.getName() + " with signature " + m.getSig());
                this.logger.trace("List of methods on " + eo + ":");
                for (MethodTuple mt : eo.methods.keySet()) {
                    this.logger.trace("   " + mt + " => " + eo.methods.get(mt));
                }
            }
            if (null == (meth = eo.methods.get(new MethodTuple(m.getName(), m.getSig())))) {
                this.queueOutgoing(new Error(m, new DBus.Error.UnknownMethod(MessageFormat.format("The method `{0}.{1}' does not exist on this object.", m.getInterface(), m.getName()))));
                return;
            }
            o = eo.object.get();
        }
        final Method me = meth;
        final GlobalHandler ob = o;
        final boolean noreply = 1 == (m.getFlags() & 1);
        final DBusCallInfo info = new DBusCallInfo(m);
        final AbstractConnection conn = this;
        this.logger.trace("Adding Runnable for method " + meth);
        this.addRunnable(new Runnable(){
            private boolean run = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                if (this.run) {
                    return;
                }
                this.run = true;
                AbstractConnection.this.logger.debug("Running method " + me + " for remote call");
                try {
                    Object[] ts = me.getGenericParameterTypes();
                    m.setArgs(Marshalling.deSerializeParameters(m.getParameters(), (Type[])ts, conn));
                    AbstractConnection.this.logger.trace("Deserialised " + Arrays.deepToString(m.getParameters()) + " to types " + Arrays.deepToString(ts));
                }
                catch (Exception e) {
                    AbstractConnection.this.logger.debug("", (Throwable)e);
                    AbstractConnection.this.handleException(conn, m, new DBus.Error.UnknownMethod("Failure in de-serializing message: " + e));
                    return;
                }
                try {
                    Object result;
                    Map e = INFOMAP;
                    synchronized (e) {
                        INFOMAP.put(Thread.currentThread(), info);
                    }
                    try {
                        AbstractConnection.this.logger.trace("Invoking Method: " + me + " on " + ob + " with parameters " + Arrays.deepToString(m.getParameters()));
                        result = me.invoke(ob, m.getParameters());
                    }
                    catch (InvocationTargetException ite) {
                        AbstractConnection.this.logger.debug(ite.getMessage(), (Throwable)ite);
                        throw ite.getCause();
                    }
                    Map ite = INFOMAP;
                    synchronized (ite) {
                        INFOMAP.remove(Thread.currentThread());
                    }
                    if (!noreply) {
                        MethodReturn reply;
                        if (Void.TYPE.equals(me.getReturnType())) {
                            reply = new MethodReturn(m, null, new Object[0]);
                        } else {
                            StringBuffer sb = new StringBuffer();
                            for (String s : Marshalling.getDBusType(me.getGenericReturnType())) {
                                sb.append(s);
                            }
                            Object[] nr = Marshalling.convertParameters(new Object[]{result}, new Type[]{me.getGenericReturnType()}, conn);
                            reply = new MethodReturn(m, sb.toString(), nr);
                        }
                        conn.queueOutgoing(reply);
                    }
                }
                catch (DBusExecutionException exDee) {
                    AbstractConnection.this.logger.debug("", (Throwable)exDee);
                    AbstractConnection.this.handleException(conn, m, exDee);
                }
                catch (Throwable e) {
                    AbstractConnection.this.logger.debug("", e);
                    AbstractConnection.this.handleException(conn, m, new DBusExecutionException(MessageFormat.format("Error Executing Method {0}.{1}: {2}", m.getInterface(), m.getName(), e.getMessage())));
                }
            }
        });
    }

    protected void handleException(AbstractConnection dbusConnection, Message methodOrSignal, DBusExecutionException exception) {
        if (dbusConnection == null) {
            throw new NullPointerException("DBusConnection cannot be null");
        }
        try {
            dbusConnection.queueOutgoing(new Error(methodOrSignal, exception));
        }
        catch (DBusException ex) {
            this.logger.warn("Exception caught while processing previous error.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final DBusSignal s) {
        this.logger.debug("Handling incoming signal: " + s);
        Vector<DBusSigHandler<? extends DBusSignal>> v = new Vector<DBusSigHandler<? extends DBusSignal>>();
        Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<? extends DBusSignal>> t = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), null, null));
            if (null != t) {
                v.addAll(t);
            }
            if (null != (t = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), s.getPath(), null)))) {
                v.addAll(t);
            }
            if (null != (t = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), null, s.getSource())))) {
                v.addAll(t);
            }
            if (null != (t = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), s.getPath(), s.getSource())))) {
                v.addAll(t);
            }
        }
        if (0 == v.size()) {
            return;
        }
        final AbstractConnection conn = this;
        for (final DBusSigHandler dBusSigHandler : v) {
            this.logger.trace("Adding Runnable for signal " + s + " with handler " + dBusSigHandler);
            this.addRunnable(new Runnable(){
                private boolean run = false;

                @Override
                public synchronized void run() {
                    if (this.run) {
                        return;
                    }
                    this.run = true;
                    try {
                        DBusSignal rs = s instanceof DBusSignal.internalsig || s.getClass().equals(DBusSignal.class) ? s.createReal(conn) : s;
                        dBusSigHandler.handle(rs);
                    }
                    catch (DBusException exDe) {
                        AbstractConnection.this.logger.debug("", (Throwable)exDe);
                        AbstractConnection.this.handleException(conn, s, new DBusExecutionException("Error handling signal " + s.getInterface() + "." + s.getName() + ": " + exDe.getMessage()));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final Error err) {
        this.logger.debug("Handling incoming error: " + err);
        MethodCall m = null;
        if (null == this.pendingCalls) {
            return;
        }
        Object object = this.pendingCalls;
        synchronized (object) {
            if (this.pendingCalls.contains(err.getReplySerial())) {
                m = this.pendingCalls.remove(err.getReplySerial());
            }
        }
        if (null != m) {
            m.setReply(err);
            CallbackHandler<? extends Object> cbh = null;
            Map<MethodCall, CallbackHandler<? extends Object>> map = this.pendingCallbacks;
            synchronized (map) {
                cbh = this.pendingCallbacks.remove(m);
                this.logger.trace(cbh + " = pendingCallbacks.remove(" + m + ")");
                this.pendingCallbackReplys.remove(m);
            }
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                this.logger.trace("Adding Error Runnable with callback handler " + fcbh);
                this.addRunnable(new Runnable(){
                    private boolean run = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        if (this.run) {
                            return;
                        }
                        this.run = true;
                        try {
                            AbstractConnection.this.logger.trace("Running Error Callback for " + err);
                            DBusCallInfo info = new DBusCallInfo(err);
                            Map map = INFOMAP;
                            synchronized (map) {
                                INFOMAP.put(Thread.currentThread(), info);
                            }
                            fcbh.handleError(err.getException());
                            map = INFOMAP;
                            synchronized (map) {
                                INFOMAP.remove(Thread.currentThread());
                            }
                        }
                        catch (Exception e) {
                            AbstractConnection.this.logger.debug("Exception while running error callback.", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            object = this.pendingErrors;
            synchronized (object) {
                this.pendingErrors.addLast(err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodReturn mr) {
        this.logger.debug("Handling incoming method return: " + mr);
        MethodCall m = null;
        if (null == this.pendingCalls) {
            return;
        }
        EfficientMap efficientMap = this.pendingCalls;
        synchronized (efficientMap) {
            if (this.pendingCalls.contains(mr.getReplySerial())) {
                m = this.pendingCalls.remove(mr.getReplySerial());
            }
        }
        if (null != m) {
            m.setReply(mr);
            mr.setCall(m);
            CallbackHandler<? extends Object> cbh = null;
            DBusAsyncReply<? extends Object> asr = null;
            Map<MethodCall, CallbackHandler<? extends Object>> map = this.pendingCallbacks;
            synchronized (map) {
                cbh = this.pendingCallbacks.remove(m);
                this.logger.trace(cbh + " = pendingCallbacks.remove(" + m + ")");
                asr = this.pendingCallbackReplys.remove(m);
            }
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                final DBusAsyncReply<? extends Object> fasr = asr;
                this.logger.trace("Adding Runnable for method " + fasr.getMethod() + " with callback handler " + fcbh);
                this.addRunnable(new Runnable(){
                    private boolean run = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        if (this.run) {
                            return;
                        }
                        this.run = true;
                        try {
                            AbstractConnection.this.logger.trace("Running Callback for " + mr);
                            DBusCallInfo info = new DBusCallInfo(mr);
                            Map map = INFOMAP;
                            synchronized (map) {
                                INFOMAP.put(Thread.currentThread(), info);
                            }
                            Object convertRV = RemoteInvocationHandler.convertRV(mr.getSig(), mr.getParameters(), fasr.getMethod(), fasr.getConnection());
                            fcbh.handle(convertRV);
                            Map map2 = INFOMAP;
                            synchronized (map2) {
                                INFOMAP.remove(Thread.currentThread());
                            }
                        }
                        catch (Exception e) {
                            AbstractConnection.this.logger.debug("Exception while running callback.", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            try {
                this.queueOutgoing(new Error(mr, new DBusExecutionException("Spurious reply. No message with the given serial id was awaiting a reply.")));
            }
            catch (DBusException dBusException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(Message m) {
        block26: {
            try {
                if (!this.connected) {
                    throw new NotConnected("Disconnected");
                }
                if (m instanceof DBusSignal) {
                    ((DBusSignal)m).appendbody(this);
                }
                if (m instanceof MethodCall && 0 == (m.getFlags() & 1)) {
                    if (null == this.pendingCalls) {
                        ((MethodCall)m).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected"));
                    } else {
                        EfficientMap efficientMap = this.pendingCalls;
                        synchronized (efficientMap) {
                            this.pendingCalls.put(m.getSerial(), (MethodCall)m);
                        }
                    }
                }
                this.transport.mout.writeMessage(m);
            }
            catch (Exception e) {
                this.logger.debug("Exception while sending message.", (Throwable)e);
                if (m instanceof MethodCall && e instanceof NotConnected) {
                    try {
                        ((MethodCall)m).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected"));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                }
                if (m instanceof MethodCall && e instanceof DBusExecutionException) {
                    try {
                        ((MethodCall)m).setReply(new Error(m, e));
                    }
                    catch (DBusException dBusException) {}
                } else if (m instanceof MethodCall) {
                    try {
                        this.logger.info("Setting reply to " + m + " as an error");
                        ((MethodCall)m).setReply(new Error(m, new DBusExecutionException("Message Failed to Send: " + e.getMessage())));
                    }
                    catch (DBusException dBusException) {}
                } else if (m instanceof MethodReturn) {
                    try {
                        this.transport.mout.writeMessage(new Error(m, e));
                    }
                    catch (IOException exIo) {
                        this.logger.debug("", (Throwable)exIo);
                    }
                    catch (DBusException exDe) {
                        this.logger.debug("", (Throwable)exDe);
                    }
                }
                if (!(e instanceof IOException)) break block26;
                this.disconnect();
            }
        }
    }

    private Message readIncoming() throws DBusException {
        if (!this.connected) {
            throw new NotConnected("No transport present");
        }
        Message m = null;
        try {
            m = this.transport.min.readMessage();
        }
        catch (IOException exIo) {
            if (!this.run && exIo instanceof EOFException) {
                return null;
            }
            throw new FatalDBusException(exIo.getMessage());
        }
        return m;
    }

    public BusAddress getAddress() throws ParseException {
        return new BusAddress(this.addr);
    }

    private class SenderThread
    extends Thread {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        SenderThread() {
            this.setName("Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Message m = null;
            this.logger.trace("Monitoring outbound queue");
            while (AbstractConnection.this.run) {
                if (null != AbstractConnection.this.outgoing) {
                    EfficientQueue efficientQueue = AbstractConnection.this.outgoing;
                    synchronized (efficientQueue) {
                        this.logger.trace("Blocking");
                        while (AbstractConnection.this.outgoing.size() == 0 && AbstractConnection.this.run) {
                            try {
                                AbstractConnection.this.outgoing.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.logger.trace("Notified");
                        if (AbstractConnection.this.outgoing.size() > 0) {
                            m = AbstractConnection.this.outgoing.remove();
                        }
                        this.logger.debug("Got message: " + m);
                    }
                }
                if (null != m) {
                    AbstractConnection.this.sendMessage(m);
                }
                m = null;
            }
            this.logger.debug("Flushing outbound queue and quitting");
            if (null != AbstractConnection.this.outgoing) {
                do {
                    EfficientQueue ogq;
                    EfficientQueue efficientQueue = ogq = AbstractConnection.this.outgoing;
                    synchronized (efficientQueue) {
                        AbstractConnection.this.outgoing = null;
                    }
                    m = !ogq.isEmpty() ? ogq.remove() : null;
                    AbstractConnection.this.sendMessage(m);
                } while (null != m);
            }
        }
    }

    protected class WorkerThread
    extends Thread {
        private boolean running = true;

        protected WorkerThread() {
        }

        public void halt() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                Runnable r = null;
                LinkedList<Runnable> linkedList = AbstractConnection.this.runnables;
                synchronized (linkedList) {
                    while (AbstractConnection.this.runnables.size() == 0 && this.running) {
                        try {
                            AbstractConnection.this.runnables.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (AbstractConnection.this.runnables.size() > 0) {
                        r = AbstractConnection.this.runnables.removeFirst();
                    }
                }
                if (null == r) continue;
                r.run();
            }
        }
    }

    private class GlobalHandler
    implements DBus.Peer,
    DBus.Introspectable {
        private String objectpath;

        GlobalHandler() {
            this.objectpath = null;
        }

        GlobalHandler(String _objectpath) {
            this.objectpath = _objectpath;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public void Ping() {
        }

        @Override
        public String Introspect() {
            ExportedObject eo;
            String intro = AbstractConnection.this.objectTree.Introspect(this.objectpath);
            if (null == intro && null != (eo = AbstractConnection.this.fallbackcontainer.get(this.objectpath))) {
                intro = eo.introspectiondata;
            }
            if (null == intro) {
                throw new DBus.Error.UnknownObject("Introspecting on non-existant object");
            }
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n" + intro;
        }

        @Override
        public String getObjectPath() {
            return this.objectpath;
        }
    }

    protected class ConnThread
    extends Thread {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        public ConnThread() {
            this.setName("DBusConnection");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ConnThread connThread;
                Message m = null;
                while (AbstractConnection.this.run) {
                    m = null;
                    try {
                        m = AbstractConnection.this.readIncoming();
                        if (m == null) continue;
                        this.logger.trace("Got Incoming Message: " + m);
                        connThread = this;
                        synchronized (connThread) {
                            this.notifyAll();
                        }
                        if (m instanceof DBusSignal) {
                            AbstractConnection.this.handleMessage((DBusSignal)m);
                        } else if (m instanceof MethodCall) {
                            AbstractConnection.this.handleMessage((MethodCall)m);
                        } else if (m instanceof MethodReturn) {
                            AbstractConnection.this.handleMessage((MethodReturn)m);
                        } else if (m instanceof Error) {
                            AbstractConnection.this.handleMessage((Error)m);
                        }
                        m = null;
                    }
                    catch (Exception e) {
                        this.logger.error("Exception in connection thread.", (Throwable)e);
                        if (!(e instanceof FatalException)) continue;
                        AbstractConnection.this.disconnect();
                    }
                }
                connThread = this;
                synchronized (connThread) {
                    this.notifyAll();
                }
            }
            catch (Exception e) {
                this.logger.debug("", (Throwable)e);
            }
        }
    }

    protected class FallbackContainer {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private Map<String[], ExportedObject> fallbacks = new HashMap<String[], ExportedObject>();

        protected FallbackContainer() {
        }

        public synchronized void add(String path, ExportedObject eo) {
            this.logger.debug("Adding fallback on " + path + " of " + eo);
            this.fallbacks.put(path.split("/"), eo);
        }

        public synchronized void remove(String path) {
            this.logger.debug("Removing fallback on " + path);
            this.fallbacks.remove(path.split("/"));
        }

        public synchronized ExportedObject get(String path) {
            int best = 0;
            int i = 0;
            ExportedObject bestobject = null;
            Object[] pathel = path.split("/");
            for (Object[] objectArray : this.fallbacks.keySet()) {
                this.logger.trace("Trying fallback path " + Arrays.deepToString(objectArray) + " to match " + Arrays.deepToString(pathel));
                for (i = 0; i < pathel.length && i < objectArray.length && ((String)pathel[i]).equals(objectArray[i]); ++i) {
                }
                if (i > 0 && i == objectArray.length && i > best) {
                    bestobject = this.fallbacks.get(objectArray);
                }
                this.logger.trace("Matches " + i + " bestobject now " + bestobject);
            }
            this.logger.debug("Found fallback for " + path + " of " + bestobject);
            return bestobject;
        }
    }
}

