/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.HashMap;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

public class DBusMatchRule {
    private String type;
    private String iface;
    private String member;
    private String object;
    private String source;
    private static HashMap<String, Class<? extends DBusSignal>> signalTypeMap = new HashMap();

    static Class<? extends DBusSignal> getCachedSignalType(String type) {
        return signalTypeMap.get(type);
    }

    public DBusMatchRule(String _type, String _iface, String _member) {
        this.type = _type;
        this.iface = _iface;
        this.member = _member;
    }

    public DBusMatchRule(DBusExecutionException e) throws DBusException {
        this(e.getClass());
        this.member = null;
        this.type = "error";
    }

    public DBusMatchRule(Message m) {
        this.iface = m.getInterface();
        this.member = m.getName();
        if (m instanceof DBusSignal) {
            this.type = "signal";
        } else if (m instanceof Error) {
            this.type = "error";
            this.member = null;
        } else if (m instanceof MethodCall) {
            this.type = "method_call";
        } else if (m instanceof MethodReturn) {
            this.type = "method_reply";
        }
    }

    public DBusMatchRule(Class<? extends DBusInterface> c, String method) throws DBusException {
        this(c);
        this.member = method;
        this.type = "method_call";
    }

    public DBusMatchRule(Class<? extends Object> _c, String _source, String _object) throws DBusException {
        this(_c);
        this.source = _source;
        this.object = _object;
    }

    public DBusMatchRule(Class<? extends Object> c) throws DBusException {
        if (DBusInterface.class.isAssignableFrom(c)) {
            this.iface = null != c.getAnnotation(DBusInterfaceName.class) ? c.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException("DBusInterfaces must be defined in a package.");
            }
            this.member = null;
            this.type = null;
        } else if (DBusSignal.class.isAssignableFrom(c)) {
            if (null == c.getEnclosingClass()) {
                throw new DBusException("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package.");
            }
            this.iface = null != c.getEnclosingClass().getAnnotation(DBusInterfaceName.class) ? c.getEnclosingClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getEnclosingClass().getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException("DBusInterfaces must be defined in a package.");
            }
            this.member = c.isAnnotationPresent(DBusMemberName.class) ? c.getAnnotation(DBusMemberName.class).value() : c.getSimpleName();
            signalTypeMap.put(this.iface + '$' + this.member, c);
            this.type = "signal";
        } else if (Error.class.isAssignableFrom(c)) {
            this.iface = null != c.getAnnotation(DBusInterfaceName.class) ? c.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException("DBusInterfaces must be defined in a package.");
            }
            this.member = null;
            this.type = "error";
        } else if (DBusExecutionException.class.isAssignableFrom(c)) {
            this.iface = null != c.getClass().getAnnotation(DBusInterfaceName.class) ? c.getClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getClass().getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException("DBusInterfaces must be defined in a package.");
            }
            this.member = null;
            this.type = "error";
        } else {
            throw new DBusException("Invalid type for match rule: " + c);
        }
    }

    public String toString() {
        String s = null;
        if (null != this.type) {
            String string = s = null == s ? "type='" + this.type + "'" : s + ",type='" + this.type + "'";
        }
        if (null != this.member) {
            String string = s = null == s ? "member='" + this.member + "'" : s + ",member='" + this.member + "'";
        }
        if (null != this.iface) {
            String string = s = null == s ? "interface='" + this.iface + "'" : s + ",interface='" + this.iface + "'";
        }
        if (null != this.source) {
            String string = s = null == s ? "sender='" + this.source + "'" : s + ",sender='" + this.source + "'";
        }
        if (null != this.object) {
            s = null == s ? "path='" + this.object + "'" : s + ",path='" + this.object + "'";
        }
        return s;
    }

    public String getType() {
        return this.type;
    }

    public String getInterface() {
        return this.iface;
    }

    public String getMember() {
        return this.member;
    }

    public String getSource() {
        return this.source;
    }

    public String getObject() {
        return this.object;
    }
}

