/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Error
extends Message {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    Error() {
    }

    public Error(String dest, String errorName, long replyserial, String sig, Object ... args) throws DBusException {
        this(null, dest, errorName, replyserial, sig, args);
    }

    public Error(String source, String dest, String errorName, long replyserial, String sig, Object ... args) throws DBusException {
        super((byte)66, (byte)3, (byte)0);
        if (null == errorName) {
            throw new MessageFormatException("Must specify error name to Errors.");
        }
        this.headers.put((byte)5, replyserial);
        this.headers.put((byte)4, errorName);
        Vector<Object[]> hargs = new Vector<Object[]>();
        hargs.add(new Object[]{(byte)4, new Object[]{"s", errorName}});
        hargs.add(new Object[]{(byte)5, new Object[]{"u", replyserial}});
        if (null != source) {
            this.headers.put((byte)7, source);
            hargs.add(new Object[]{(byte)7, new Object[]{"s", source}});
        }
        if (null != dest) {
            this.headers.put((byte)6, dest);
            hargs.add(new Object[]{(byte)6, new Object[]{"s", dest}});
        }
        if (null != sig) {
            hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
            this.headers.put((byte)8, sig);
            this.setArgs(args);
        }
        byte[] blen = new byte[4];
        this.appendBytes(blen);
        this.append("ua(yv)", this.serial, hargs.toArray());
        this.pad((byte)8);
        long c = this.bytecounter;
        if (null != sig) {
            this.append(sig, args);
        }
        this.marshallint(this.bytecounter - c, blen, 0, 4);
    }

    public Error(String source, Message m, Throwable e) throws DBusException {
        this(source, m.getSource(), AbstractConnection.DOLLAR_PATTERN.matcher(e.getClass().getName()).replaceAll("."), m.getSerial(), "s", e.getMessage());
    }

    public Error(Message m, Throwable e) throws DBusException {
        this(m.getSource(), AbstractConnection.DOLLAR_PATTERN.matcher(e.getClass().getName()).replaceAll("."), m.getSerial(), "s", e.getMessage());
    }

    private static Class<? extends DBusExecutionException> createExceptionClass(String name) {
        if (name == "org.freedesktop.DBus.Local.Disconnected") {
            return NotConnected.class;
        }
        Class<?> c = null;
        do {
            try {
                c = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            name = name.replaceAll("\\.([^\\.]*)$", "\\$$1");
        } while (null == c && name.matches(".*\\..*"));
        return c;
    }

    public DBusExecutionException getException() {
        try {
            DBusExecutionException ex;
            Class<? extends DBusExecutionException> c = Error.createExceptionClass(this.getName());
            if (null == c || !DBusExecutionException.class.isAssignableFrom(c)) {
                c = DBusExecutionException.class;
            }
            Constructor<? extends DBusExecutionException> con = c.getConstructor(String.class);
            Object[] args2 = this.getParameters();
            if (null == args2 || 0 == args2.length) {
                ex = con.newInstance("");
            } else {
                String s = "";
                for (Object o : args2) {
                    s = s + o + " ";
                }
                ex = con.newInstance(s.trim());
            }
            ex.setType(this.getName());
            return ex;
        }
        catch (Exception ex1) {
            DBusExecutionException ex;
            this.logger.debug("", (Throwable)ex1);
            Object[] args = null;
            try {
                args = this.getParameters();
            }
            catch (Exception args2) {
                // empty catch block
            }
            if (null == args || 0 == args.length) {
                ex = new DBusExecutionException("");
            } else {
                String s = "";
                for (Object o : args) {
                    s = s + o + " ";
                }
                ex = new DBusExecutionException(s.trim());
            }
            ex.setType(this.getName());
            return ex;
        }
    }

    public void throwException() throws DBusExecutionException {
        throw this.getException();
    }
}

