/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.DBusSerializable;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.Position;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.DBusStructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Marshalling {
    private static final Logger LOGGER = LoggerFactory.getLogger(Marshalling.class);
    private static final Map<Type, String[]> TYPE_CACHE = new HashMap<Type, String[]>();
    private static final Map<Class<?>, Byte> CLASS_TO_ARGUMENTTYPE = new LinkedHashMap();

    private Marshalling() {
    }

    public static String getDBusType(Type[] c) throws DBusException {
        StringBuffer sb = new StringBuffer();
        for (Type t : c) {
            for (String s : Marshalling.getDBusType(t)) {
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static String[] getDBusType(Type _dataType) throws DBusException {
        String[] cached = TYPE_CACHE.get(_dataType);
        if (null != cached) {
            return cached;
        }
        cached = Marshalling.getDBusType(_dataType, false);
        TYPE_CACHE.put(_dataType, cached);
        return cached;
    }

    public static String[] getDBusType(Type _dataType, boolean _basic) throws DBusException {
        return Marshalling.recursiveGetDBusType(new StringBuffer[10], _dataType, _basic, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] recursiveGetDBusType(StringBuffer[] _out, Type _dataType, boolean _basic, int _level) throws DBusException {
        block33: {
            Type[] ts;
            block47: {
                int n;
                Field[] ss22;
                block48: {
                    int s5;
                    int n2;
                    Type[] ss22;
                    Vector<String> vs;
                    block44: {
                        int aioobe2;
                        Type[] t2;
                        block41: {
                            Type[] newtypes;
                            block37: {
                                Class dataTypeClazz;
                                block46: {
                                    block45: {
                                        block38: {
                                            ParameterizedType p;
                                            block43: {
                                                block42: {
                                                    block40: {
                                                        block39: {
                                                            block36: {
                                                                block35: {
                                                                    block34: {
                                                                        if (_out.length <= _level) {
                                                                            StringBuffer[] newout = new StringBuffer[_out.length];
                                                                            System.arraycopy(_out, 0, newout, 0, _out.length);
                                                                            _out = newout;
                                                                        }
                                                                        if (null == _out[_level]) {
                                                                            _out[_level] = new StringBuffer();
                                                                        } else {
                                                                            _out[_level].delete(0, _out[_level].length());
                                                                        }
                                                                        if (_basic && !(_dataType instanceof Class)) {
                                                                            throw new DBusException(_dataType + " is not a basic type");
                                                                        }
                                                                        if (!(_dataType instanceof TypeVariable)) break block34;
                                                                        _out[_level].append('v');
                                                                        break block33;
                                                                    }
                                                                    if (!(_dataType instanceof GenericArrayType)) break block35;
                                                                    _out[_level].append('a');
                                                                    String[] s2 = Marshalling.recursiveGetDBusType(_out, ((GenericArrayType)_dataType).getGenericComponentType(), false, _level + 1);
                                                                    if (s2.length != 1) {
                                                                        throw new DBusException("Multi-valued array types not permitted");
                                                                    }
                                                                    _out[_level].append(s2[0]);
                                                                    break block33;
                                                                }
                                                                if ((!(_dataType instanceof Class) || !DBusSerializable.class.isAssignableFrom((Class)_dataType)) && (!(_dataType instanceof ParameterizedType) || !DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)_dataType).getRawType()))) break block36;
                                                                newtypes = null;
                                                                if (_dataType instanceof Class) {
                                                                    for (Method m : ((Class)_dataType).getDeclaredMethods()) {
                                                                        if (!m.getName().equals("deserialize")) continue;
                                                                        newtypes = m.getGenericParameterTypes();
                                                                    }
                                                                } else {
                                                                    for (Method m : ((Class)((ParameterizedType)_dataType).getRawType()).getDeclaredMethods()) {
                                                                        if (!m.getName().equals("deserialize")) continue;
                                                                        newtypes = m.getGenericParameterTypes();
                                                                    }
                                                                }
                                                                if (null == newtypes) {
                                                                    throw new DBusException("Serializable classes must implement a deserialize method");
                                                                }
                                                                break block37;
                                                            }
                                                            if (!(_dataType instanceof ParameterizedType)) break block38;
                                                            p = (ParameterizedType)_dataType;
                                                            if (!p.getRawType().equals(Map.class)) break block39;
                                                            _out[_level].append("a{");
                                                            Type[] t2 = p.getActualTypeArguments();
                                                            try {
                                                                String[] s3 = Marshalling.recursiveGetDBusType(_out, t2[0], true, _level + 1);
                                                                if (s3.length != 1) {
                                                                    throw new DBusException("Multi-valued array types not permitted");
                                                                }
                                                                _out[_level].append(s3[0]);
                                                                s3 = Marshalling.recursiveGetDBusType(_out, t2[1], false, _level + 1);
                                                                if (s3.length != 1) {
                                                                    throw new DBusException("Multi-valued array types not permitted");
                                                                }
                                                                _out[_level].append(s3[0]);
                                                            }
                                                            catch (ArrayIndexOutOfBoundsException aioobe2) {
                                                                LOGGER.debug("", (Throwable)aioobe2);
                                                                throw new DBusException("Map must have 2 parameters");
                                                            }
                                                            _out[_level].append('}');
                                                            break block33;
                                                        }
                                                        if (!List.class.isAssignableFrom((Class)p.getRawType())) break block40;
                                                        t2 = p.getActualTypeArguments();
                                                        aioobe2 = t2.length;
                                                        break block41;
                                                    }
                                                    if (!p.getRawType().equals(Variant.class)) break block42;
                                                    _out[_level].append('v');
                                                    break block33;
                                                }
                                                if (!DBusInterface.class.isAssignableFrom((Class)p.getRawType())) break block43;
                                                _out[_level].append('o');
                                                break block33;
                                            }
                                            if (!Tuple.class.isAssignableFrom((Class)p.getRawType())) {
                                                throw new DBusException("Exporting non-exportable parameterized type " + _dataType);
                                            }
                                            Type[] ts2 = p.getActualTypeArguments();
                                            vs = new Vector<String>();
                                            ss22 = ts2;
                                            n2 = ss22.length;
                                            s5 = 0;
                                            break block44;
                                        }
                                        if (!(_dataType instanceof Class)) break block33;
                                        dataTypeClazz = (Class)_dataType;
                                        if (!dataTypeClazz.isArray()) break block45;
                                        if (Type.class.equals(((Class)_dataType).getComponentType())) {
                                            _out[_level].append('g');
                                            break block33;
                                        } else {
                                            _out[_level].append('a');
                                            String[] s4 = Marshalling.recursiveGetDBusType(_out, ((Class)_dataType).getComponentType(), false, _level + 1);
                                            if (s4.length != 1) {
                                                throw new DBusException("Multi-valued array types not permitted");
                                            }
                                            _out[_level].append(s4[0]);
                                        }
                                        break block33;
                                    }
                                    if (!Struct.class.isAssignableFrom((Class)_dataType)) break block46;
                                    _out[_level].append('(');
                                    ts = Container.getTypeCache(_dataType);
                                    if (null != ts) break block47;
                                    Field[] fs = ((Class)_dataType).getDeclaredFields();
                                    ts = new Type[fs.length];
                                    ss22 = fs;
                                    n = ss22.length;
                                    break block48;
                                }
                                if (dataTypeClazz.isPrimitive()) {
                                    // empty if block
                                }
                                boolean found = false;
                                for (Map.Entry<Class<?>, Byte> entry : CLASS_TO_ARGUMENTTYPE.entrySet()) {
                                    if (!entry.getKey().isAssignableFrom(dataTypeClazz)) continue;
                                    _out[_level].append((char)entry.getValue().byteValue());
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    throw new DBusException("Exporting non-exportable type: " + _dataType);
                                }
                                break block33;
                            }
                            String[] sigs = new String[newtypes.length];
                            int j = 0;
                            while (true) {
                                if (j >= sigs.length) {
                                    return sigs;
                                }
                                String[] ss22 = Marshalling.recursiveGetDBusType(_out, newtypes[j], false, _level + 1);
                                if (1 != ss22.length) {
                                    throw new DBusException("Serializable classes must serialize to native DBus types");
                                }
                                sigs[j] = ss22[0];
                                ++j;
                            }
                        }
                        for (int ss22 = 0; ss22 < aioobe2; ++ss22) {
                            Type t3 = t2[ss22];
                            if (Type.class.equals((Object)t3)) {
                                _out[_level].append('g');
                                continue;
                            }
                            String[] s5 = Marshalling.recursiveGetDBusType(_out, t3, false, _level + 1);
                            if (s5.length != 1) {
                                throw new DBusException("Multi-valued array types not permitted");
                            }
                            _out[_level].append('a');
                            _out[_level].append(s5[0]);
                        }
                        break block33;
                    }
                    while (true) {
                        if (s5 >= n2) {
                            return vs.toArray(new String[0]);
                        }
                        Type t = ss22[s5];
                        for (String s6 : Marshalling.recursiveGetDBusType(_out, t, false, _level + 1)) {
                            vs.add(s6);
                        }
                        ++s5;
                    }
                }
                for (int s5 = 0; s5 < n; ++s5) {
                    Field f = ss22[s5];
                    Position p = f.getAnnotation(Position.class);
                    if (null == p) continue;
                    ts[p.value()] = f.getGenericType();
                }
                Container.putTypeCache(_dataType, ts);
            }
            for (Type t : ts) {
                if (t == null) continue;
                for (String s : Marshalling.recursiveGetDBusType(_out, t, false, _level + 1)) {
                    _out[_level].append(s);
                }
            }
            _out[_level].append(')');
        }
        LOGGER.trace("Converted Java type: {} to D-Bus Type: {}", (Object)_dataType, (Object)_out[_level]);
        return new String[]{_out[_level].toString()};
    }

    public static int getJavaType(String dbus, List<Type> rv, int limit) throws DBusException {
        if (null == dbus || "".equals(dbus) || 0 == limit) {
            return 0;
        }
        try {
            int i;
            block21: for (i = 0; i < dbus.length() && (-1 == limit || limit > rv.size()); ++i) {
                switch (dbus.charAt(i)) {
                    case '(': {
                        int j = i + 1;
                        int c = 1;
                        while (c > 0) {
                            if (')' == dbus.charAt(j)) {
                                --c;
                            } else if ('(' == dbus.charAt(j)) {
                                ++c;
                            }
                            ++j;
                        }
                        Vector<Type> contained = new Vector();
                        int c2 = Marshalling.getJavaType(dbus.substring(i + 1, j - 1), contained, -1);
                        rv.add(new DBusStructType(contained.toArray(new Type[0])));
                        i = j;
                        continue block21;
                    }
                    case 'a': {
                        int c2;
                        Vector<Type> contained;
                        if ('{' == dbus.charAt(i + 1)) {
                            contained = new Vector();
                            c2 = Marshalling.getJavaType(dbus.substring(i + 2), contained, 2);
                            rv.add(new DBusMapType(contained.get(0), contained.get(1)));
                            i += c2 + 2;
                            continue block21;
                        }
                        contained = new Vector();
                        c2 = Marshalling.getJavaType(dbus.substring(i + 1), contained, 1);
                        rv.add(new DBusListType(contained.get(0)));
                        i += c2;
                        continue block21;
                    }
                    case 'v': {
                        rv.add((Type)((Object)Variant.class));
                        continue block21;
                    }
                    case 'b': {
                        rv.add((Type)((Object)Boolean.class));
                        continue block21;
                    }
                    case 'n': {
                        rv.add((Type)((Object)Short.class));
                        continue block21;
                    }
                    case 'y': {
                        rv.add((Type)((Object)Byte.class));
                        continue block21;
                    }
                    case 'o': {
                        rv.add((Type)((Object)DBusInterface.class));
                        continue block21;
                    }
                    case 'q': {
                        rv.add((Type)((Object)UInt16.class));
                        continue block21;
                    }
                    case 'i': {
                        rv.add((Type)((Object)Integer.class));
                        continue block21;
                    }
                    case 'u': {
                        rv.add((Type)((Object)UInt32.class));
                        continue block21;
                    }
                    case 'x': {
                        rv.add((Type)((Object)Long.class));
                        continue block21;
                    }
                    case 't': {
                        rv.add((Type)((Object)UInt64.class));
                        continue block21;
                    }
                    case 'd': {
                        rv.add((Type)((Object)Double.class));
                        continue block21;
                    }
                    case 'f': {
                        rv.add((Type)((Object)Float.class));
                        continue block21;
                    }
                    case 's': {
                        rv.add((Type)((Object)CharSequence.class));
                        continue block21;
                    }
                    case 'g': {
                        rv.add((Type)((Object)Type[].class));
                        continue block21;
                    }
                    case '{': {
                        rv.add((Type)((Object)Map.Entry.class));
                        Vector<Type> contained = new Vector<Type>();
                        int c2 = Marshalling.getJavaType(dbus.substring(i + 1), contained, 2);
                        i += c2 + 1;
                        continue block21;
                    }
                    default: {
                        throw new DBusException(MessageFormat.format("Failed to parse DBus type signature: {0} ({1}).", dbus, Character.valueOf(dbus.charAt(i))));
                    }
                }
            }
            return i;
        }
        catch (IndexOutOfBoundsException ioobe) {
            LOGGER.debug("Failed to parse DBus type signature.", (Throwable)ioobe);
            throw new DBusException("Failed to parse DBus type signature: " + dbus);
        }
    }

    public static Object[] convertParameters(Object[] parameters, Type[] types, AbstractConnection conn) throws DBusException {
        if (null == parameters) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (null == parameters[i]) continue;
            LOGGER.trace("Converting {} from {} to {}", new Object[]{i, parameters[i], types[i]});
            if (parameters[i] instanceof DBusSerializable) {
                for (Method m : parameters[i].getClass().getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Class<?>[] newtypes = m.getParameterTypes();
                    Type[] expand = new Type[types.length + newtypes.length - 1];
                    System.arraycopy(types, 0, expand, 0, i);
                    System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                    System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                    types = expand;
                    Object[] newparams = ((DBusSerializable)parameters[i]).serialize();
                    Object[] exparams = new Object[parameters.length + newparams.length - 1];
                    System.arraycopy(parameters, 0, exparams, 0, i);
                    System.arraycopy(newparams, 0, exparams, i, newparams.length);
                    System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                    parameters = exparams;
                }
                --i;
                continue;
            }
            if (parameters[i] instanceof Tuple) {
                Type[] newtypes = ((ParameterizedType)types[i]).getActualTypeArguments();
                Type[] expand = new Type[types.length + newtypes.length - 1];
                System.arraycopy(types, 0, expand, 0, i);
                System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                types = expand;
                Object[] newparams = ((Tuple)parameters[i]).getParameters();
                Object[] exparams = new Object[parameters.length + newparams.length - 1];
                System.arraycopy(parameters, 0, exparams, 0, i);
                System.arraycopy(newparams, 0, exparams, i, newparams.length);
                System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                parameters = exparams;
                LOGGER.trace("New params: {}, new types: {}", (Object)Arrays.deepToString(parameters), (Object)Arrays.deepToString(types));
                --i;
                continue;
            }
            if (types[i] instanceof TypeVariable && !(parameters[i] instanceof Variant)) {
                parameters[i] = new Variant<Object>(parameters[i]);
                continue;
            }
            if (!(parameters[i] instanceof DBusInterface)) continue;
            parameters[i] = conn.getExportedObject((DBusInterface)parameters[i]);
        }
        return parameters;
    }

    /*
     * WARNING - void declaration
     */
    static Object deSerializeParameter(Object parameter, Type type, AbstractConnection conn) throws Exception {
        Type type2;
        Object[] ts;
        LOGGER.trace("Deserializing from {} to {}", parameter.getClass(), type.getClass());
        if (type instanceof TypeVariable && parameter instanceof Variant) {
            parameter = ((Variant)parameter).getValue();
        }
        if (type instanceof Class && ((Class)type).isArray() && ((Class)type).getComponentType().equals(Type.class) && parameter instanceof String) {
            Vector<Type> rv = new Vector<Type>();
            Marshalling.getJavaType((String)parameter, rv, -1);
            parameter = rv.toArray(new Type[0]);
        }
        if (parameter instanceof ObjectPath) {
            parameter = type instanceof Class && DBusInterface.class.isAssignableFrom((Class)type) ? conn.getExportedObject(((ObjectPath)parameter).source, ((ObjectPath)parameter).path) : new Path(((ObjectPath)parameter).path);
        }
        if (parameter instanceof Object[] && type instanceof Class && Struct.class.isAssignableFrom((Class)type)) {
            LOGGER.trace("Creating Struct {} from {}", (Object)type, parameter);
            ts = Container.getTypeCache(type);
            if (null == ts) {
                void var7_12;
                AccessibleObject[] fs = ((Class)type).getDeclaredFields();
                ts = new Type[fs.length];
                Field[] fieldArray = fs;
                int n = fieldArray.length;
                boolean i = false;
                while (var7_12 < n) {
                    Field f = fieldArray[var7_12];
                    Position p = f.getAnnotation(Position.class);
                    if (null != p) {
                        ts[p.value()] = f.getGenericType();
                    }
                    ++var7_12;
                }
                Container.putTypeCache(type, (Type[])ts);
            }
            parameter = Marshalling.deSerializeParameters(parameter, (Type[])ts, conn);
            for (AccessibleObject accessibleObject : ((Class)type).getDeclaredConstructors()) {
                try {
                    parameter = ((Constructor)accessibleObject).newInstance(parameter);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        if (parameter instanceof Object[]) {
            ts = new Type[((Object[])parameter).length];
            Arrays.fill(ts, parameter.getClass().getComponentType());
            parameter = Marshalling.deSerializeParameters(parameter, (Type[])ts, conn);
        }
        if (parameter instanceof List && null != (type2 = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : (type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : (type instanceof Class && ((Class)type).isArray() ? ((Class)type).getComponentType() : null)))) {
            parameter = Marshalling.deSerializeParameters((List)parameter, type2, conn);
        }
        if ((type.equals(Float.class) || type.equals(Float.TYPE)) && !(parameter instanceof Float)) {
            parameter = Float.valueOf(((Number)parameter).floatValue());
        }
        if (parameter instanceof Object[] || parameter instanceof List || parameter.getClass().isArray()) {
            if (type instanceof ParameterizedType) {
                parameter = ArrayFrob.convert(parameter, (Class)((ParameterizedType)type).getRawType());
            } else if (type instanceof GenericArrayType) {
                Type ct = ((GenericArrayType)type).getGenericComponentType();
                Class cc = null;
                if (ct instanceof Class) {
                    cc = (Class)ct;
                }
                if (ct instanceof ParameterizedType) {
                    cc = (Class)((ParameterizedType)ct).getRawType();
                }
                Object o = Array.newInstance(cc, 0);
                parameter = ArrayFrob.convert(parameter, o.getClass());
            } else if (type instanceof Class && ((Class)type).isArray()) {
                Class<?> cc = ((Class)type).getComponentType();
                if ((cc.equals(Float.class) || cc.equals(Float.TYPE)) && parameter instanceof double[]) {
                    double[] tmp1 = (double[])parameter;
                    float[] tmp2 = new float[tmp1.length];
                    for (int i = 0; i < tmp1.length; ++i) {
                        tmp2[i] = (float)tmp1[i];
                    }
                    parameter = tmp2;
                }
                Object o = Array.newInstance(cc, 0);
                parameter = ArrayFrob.convert(parameter, o.getClass());
            }
        }
        if (parameter instanceof DBusMap) {
            LOGGER.trace("Deserializing a Map");
            DBusMap dmap = (DBusMap)parameter;
            Type[] maptypes = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < dmap.entries.length; ++i) {
                dmap.entries[i][0] = Marshalling.deSerializeParameter(dmap.entries[i][0], maptypes[0], conn);
                dmap.entries[i][1] = Marshalling.deSerializeParameter(dmap.entries[i][1], maptypes[1], conn);
            }
        }
        return parameter;
    }

    static List<Object> deSerializeParameters(List<Object> parameters, Type type, AbstractConnection conn) throws Exception {
        LOGGER.trace("Deserializing from {} to {}", parameters, (Object)type);
        if (null == parameters) {
            return null;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (null == parameters.get(i)) continue;
            parameters.set(i, Marshalling.deSerializeParameter(parameters.get(i), type, conn));
        }
        return parameters;
    }

    static Object[] deSerializeParameters(Object[] parameters, Type[] types, AbstractConnection conn) throws Exception {
        LOGGER.trace("Deserializing from {} to {} ", (Object)Arrays.deepToString(parameters), (Object)Arrays.deepToString(types));
        if (null == parameters) {
            return null;
        }
        if (types.length == 1 && types[0] instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)types[0]).getRawType())) {
            types = ((ParameterizedType)types[0]).getActualTypeArguments();
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (i >= types.length) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error("Parameter length differs, expected {} but got {}", (Object)parameters.length, (Object)types.length);
                    for (int j = 0; j < parameters.length; ++j) {
                        LOGGER.error("Error, Parameters differ: {}, '{}'", (Object)j, (Object)parameters[j].toString());
                    }
                }
                throw new DBusException("Error deserializing message: number of parameters didn't match receiving signature");
            }
            if (null == parameters[i]) continue;
            if (types[i] instanceof Class && DBusSerializable.class.isAssignableFrom((Class)types[i]) || types[i] instanceof ParameterizedType && DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)types[i]).getRawType())) {
                Class dsc = types[i] instanceof Class ? (Class)types[i] : (Class)((ParameterizedType)types[i]).getRawType();
                for (Method m : dsc.getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Type[] newtypes = m.getGenericParameterTypes();
                    try {
                        Object[] sub = new Object[newtypes.length];
                        System.arraycopy(parameters, i, sub, 0, newtypes.length);
                        sub = Marshalling.deSerializeParameters(sub, newtypes, conn);
                        DBusSerializable sz = (DBusSerializable)dsc.newInstance();
                        m.invoke((Object)sz, sub);
                        Object[] compress = new Object[parameters.length - newtypes.length + 1];
                        System.arraycopy(parameters, 0, compress, 0, i);
                        compress[i] = sz;
                        System.arraycopy(parameters, i + newtypes.length, compress, i + 1, parameters.length - i - newtypes.length);
                        parameters = compress;
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        LOGGER.debug("", (Throwable)aioobe);
                        throw new DBusException(MessageFormat.format("Not enough elements to create custom object from serialized data ({0} < {1}).", parameters.length - i, newtypes.length));
                    }
                }
                continue;
            }
            parameters[i] = Marshalling.deSerializeParameter(parameters[i], types[i], conn);
        }
        return parameters;
    }

    static {
        CLASS_TO_ARGUMENTTYPE.put(Boolean.class, (byte)98);
        CLASS_TO_ARGUMENTTYPE.put(Boolean.TYPE, (byte)98);
        CLASS_TO_ARGUMENTTYPE.put(Byte.class, (byte)121);
        CLASS_TO_ARGUMENTTYPE.put(Byte.TYPE, (byte)121);
        CLASS_TO_ARGUMENTTYPE.put(Short.class, (byte)110);
        CLASS_TO_ARGUMENTTYPE.put(Short.TYPE, (byte)110);
        CLASS_TO_ARGUMENTTYPE.put(Integer.class, (byte)105);
        CLASS_TO_ARGUMENTTYPE.put(Integer.TYPE, (byte)105);
        CLASS_TO_ARGUMENTTYPE.put(Long.class, (byte)120);
        CLASS_TO_ARGUMENTTYPE.put(Long.TYPE, (byte)120);
        CLASS_TO_ARGUMENTTYPE.put(Double.class, (byte)100);
        CLASS_TO_ARGUMENTTYPE.put(Double.TYPE, (byte)100);
        if (AbstractConnection.FLOAT_SUPPORT) {
            CLASS_TO_ARGUMENTTYPE.put(Float.class, (byte)102);
            CLASS_TO_ARGUMENTTYPE.put(Float.TYPE, (byte)102);
        } else {
            CLASS_TO_ARGUMENTTYPE.put(Float.class, (byte)100);
            CLASS_TO_ARGUMENTTYPE.put(Float.TYPE, (byte)100);
        }
        CLASS_TO_ARGUMENTTYPE.put(UInt16.class, (byte)113);
        CLASS_TO_ARGUMENTTYPE.put(UInt32.class, (byte)117);
        CLASS_TO_ARGUMENTTYPE.put(UInt64.class, (byte)116);
        CLASS_TO_ARGUMENTTYPE.put(CharSequence.class, (byte)115);
        CLASS_TO_ARGUMENTTYPE.put(Variant.class, (byte)118);
        CLASS_TO_ARGUMENTTYPE.put(DBusInterface.class, (byte)111);
        CLASS_TO_ARGUMENTTYPE.put(Path.class, (byte)111);
        CLASS_TO_ARGUMENTTYPE.put(ObjectPath.class, (byte)111);
    }
}

