/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Vector;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variant<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T value;
    private final Type type;
    private final String sig;

    public Variant(T value) throws IllegalArgumentException {
        if (null == value) {
            throw new IllegalArgumentException("Can't wrap Null in a Variant");
        }
        this.type = value.getClass();
        try {
            String[] ss = Marshalling.getDBusType(value.getClass(), true);
            if (ss.length != 1) {
                throw new IllegalArgumentException("Can't wrap a multi-valued type in a Variant: " + this.type);
            }
            this.sig = ss[0];
        }
        catch (DBusException dbe) {
            this.logger.debug("", (Throwable)dbe);
            throw new IllegalArgumentException(MessageFormat.format("Can't wrap {0} in an unqualified Variant ({1}).", value.getClass(), dbe.getMessage()));
        }
        this.value = value;
    }

    public Variant(T value, Type type) throws IllegalArgumentException {
        if (null == value) {
            throw new IllegalArgumentException("Can't wrap Null in a Variant");
        }
        this.type = type;
        try {
            String[] ss = Marshalling.getDBusType(type);
            if (ss.length != 1) {
                throw new IllegalArgumentException("Can't wrap a multi-valued type in a Variant: " + type);
            }
            this.sig = ss[0];
        }
        catch (DBusException dbe) {
            this.logger.debug("", (Throwable)dbe);
            throw new IllegalArgumentException(MessageFormat.format("Can't wrap {0} in an unqualified Variant ({1}).", type, dbe.getMessage()));
        }
        this.value = value;
    }

    public Variant(T value, String type) throws IllegalArgumentException {
        if (null == value) {
            throw new IllegalArgumentException("Can't wrap Null in a Variant");
        }
        this.sig = type;
        try {
            Vector<Type> ts = new Vector<Type>();
            Marshalling.getJavaType(type, ts, 1);
            if (ts.size() != 1) {
                throw new IllegalArgumentException("Can't wrap multiple or no types in a Variant: " + type);
            }
            this.type = ts.get(0);
        }
        catch (DBusException dbe) {
            this.logger.debug("", (Throwable)dbe);
            throw new IllegalArgumentException(MessageFormat.format("Can''t wrap {0} in an unqualified Variant ({1}).", type, dbe.getMessage()));
        }
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public String getSig() {
        return this.sig;
    }

    public String toString() {
        return "[" + this.value + "]";
    }

    public boolean equals(Object other) {
        return null != other && other instanceof Variant && this.value.equals(((Variant)other).value);
    }
}

