/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.unix;

import com.github.hypfvieh.common.SearchOrder;
import com.github.hypfvieh.system.NativeLibraryLoader;
import com.github.hypfvieh.util.SystemUtil;
import com.github.hypfvieh.util.TypeUtil;
import cx.ath.matthew.unix.UnixSocket;
import cx.ath.matthew.unix.UnixSocketAddress;
import java.io.Closeable;
import java.io.IOException;

public class UnixServerSocket
implements Closeable {
    private UnixSocketAddress address = null;
    private boolean bound = false;
    private boolean closed = false;
    private int sock;

    public UnixServerSocket() {
    }

    public UnixServerSocket(UnixSocketAddress _address) throws IOException {
        this.bind(_address);
    }

    public UnixServerSocket(String _address) throws IOException {
        this(new UnixSocketAddress(_address));
    }

    public UnixSocket accept() throws IOException {
        int clientSock = this.native_accept(this.sock);
        return new UnixSocket(clientSock, this.address);
    }

    @Override
    public synchronized void close() throws IOException {
        this.native_close(this.sock);
        this.sock = 0;
        this.closed = true;
        this.bound = false;
    }

    public void bind(UnixSocketAddress _address) throws IOException {
        if (this.bound) {
            this.close();
        }
        this.sock = this.native_bind(_address.getPath(), _address.isAbs());
        this.bound = true;
        this.closed = false;
        this.address = _address;
    }

    public void bind(String _address) throws IOException {
        this.bind(new UnixSocketAddress(_address));
    }

    public UnixSocketAddress getAddress() {
        return this.address;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isBound() {
        return this.bound;
    }

    private native int native_bind(String var1, boolean var2) throws IOException;

    private native void native_close(int var1) throws IOException;

    private native int native_accept(int var1) throws IOException;

    static {
        if (SystemUtil.isMacOs()) {
            String macOsMajorVersion = SystemUtil.getMacOsMajorVersion();
            String[] split = macOsMajorVersion.split("\\.");
            if (split.length == 2 && TypeUtil.isInteger((String)split[1])) {
                if (Integer.parseInt(split[1]) >= 6) {
                    NativeLibraryLoader.loadLibrary((boolean)true, (String)"libunix-java.so", (String[])new String[]{"macos/" + macOsMajorVersion + "/"});
                }
            } else {
                NativeLibraryLoader.loadLibrary((String)"libunix-java.so", (SearchOrder[])new SearchOrder[]{SearchOrder.SYSTEM_PATH}, (String[])new String[0]);
            }
        } else {
            NativeLibraryLoader.loadLibrary((boolean)true, (String)"libunix-java.so", (String[])new String[]{"lib/"});
        }
    }
}

