/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSerializable;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.DBusStructType;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Marshalling {
    private static final Logger LOGGER = LoggerFactory.getLogger(Marshalling.class);
    private static final Map<Type, String[]> TYPE_CACHE = new HashMap<Type, String[]>();
    private static final Map<Class<?>, Byte> CLASS_TO_ARGUMENTTYPE = new LinkedHashMap();

    private Marshalling() {
    }

    public static String getDBusType(Type[] _javaType) throws DBusException {
        StringBuffer sb = new StringBuffer();
        for (Type t : _javaType) {
            for (String s : Marshalling.getDBusType(t)) {
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public static String[] getDBusType(Type _javaType) throws DBusException {
        String[] cached = TYPE_CACHE.get(_javaType);
        if (null != cached) {
            return cached;
        }
        cached = Marshalling.getDBusType(_javaType, false);
        TYPE_CACHE.put(_javaType, cached);
        return cached;
    }

    public static String[] getDBusType(Type _dataType, boolean _basic) throws DBusException {
        return Marshalling.recursiveGetDBusType(new StringBuffer[10], _dataType, _basic, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] recursiveGetDBusType(StringBuffer[] _out, Type _dataType, boolean _basic, int _level) throws DBusException {
        block33: {
            Type[] ts;
            block47: {
                int n;
                Field[] ss22;
                block48: {
                    int s5;
                    int n2;
                    Type[] ss22;
                    ArrayList<String> vs;
                    block44: {
                        int aioobe2;
                        Type[] t2;
                        block41: {
                            Type[] newtypes;
                            block37: {
                                Class dataTypeClazz;
                                block46: {
                                    block45: {
                                        block38: {
                                            ParameterizedType p;
                                            block43: {
                                                block42: {
                                                    block40: {
                                                        block39: {
                                                            block36: {
                                                                block35: {
                                                                    block34: {
                                                                        if (_out.length <= _level) {
                                                                            StringBuffer[] newout = new StringBuffer[_out.length];
                                                                            System.arraycopy(_out, 0, newout, 0, _out.length);
                                                                            _out = newout;
                                                                        }
                                                                        if (null == _out[_level]) {
                                                                            _out[_level] = new StringBuffer();
                                                                        } else {
                                                                            _out[_level].delete(0, _out[_level].length());
                                                                        }
                                                                        if (_basic && !(_dataType instanceof Class)) {
                                                                            throw new DBusException(_dataType + " is not a basic type");
                                                                        }
                                                                        if (!(_dataType instanceof TypeVariable)) break block34;
                                                                        _out[_level].append('v');
                                                                        break block33;
                                                                    }
                                                                    if (!(_dataType instanceof GenericArrayType)) break block35;
                                                                    _out[_level].append('a');
                                                                    String[] s2 = Marshalling.recursiveGetDBusType(_out, ((GenericArrayType)_dataType).getGenericComponentType(), false, _level + 1);
                                                                    if (s2.length != 1) {
                                                                        throw new DBusException("Multi-valued array types not permitted");
                                                                    }
                                                                    _out[_level].append(s2[0]);
                                                                    break block33;
                                                                }
                                                                if ((!(_dataType instanceof Class) || !DBusSerializable.class.isAssignableFrom((Class)_dataType)) && (!(_dataType instanceof ParameterizedType) || !DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)_dataType).getRawType()))) break block36;
                                                                newtypes = null;
                                                                if (_dataType instanceof Class) {
                                                                    for (Method m : ((Class)_dataType).getDeclaredMethods()) {
                                                                        if (!m.getName().equals("deserialize")) continue;
                                                                        newtypes = m.getGenericParameterTypes();
                                                                    }
                                                                } else {
                                                                    for (Method m : ((Class)((ParameterizedType)_dataType).getRawType()).getDeclaredMethods()) {
                                                                        if (!m.getName().equals("deserialize")) continue;
                                                                        newtypes = m.getGenericParameterTypes();
                                                                    }
                                                                }
                                                                if (null == newtypes) {
                                                                    throw new DBusException("Serializable classes must implement a deserialize method");
                                                                }
                                                                break block37;
                                                            }
                                                            if (!(_dataType instanceof ParameterizedType)) break block38;
                                                            p = (ParameterizedType)_dataType;
                                                            if (!p.getRawType().equals(Map.class)) break block39;
                                                            _out[_level].append("a{");
                                                            Type[] t2 = p.getActualTypeArguments();
                                                            try {
                                                                String[] s3 = Marshalling.recursiveGetDBusType(_out, t2[0], true, _level + 1);
                                                                if (s3.length != 1) {
                                                                    throw new DBusException("Multi-valued array types not permitted");
                                                                }
                                                                _out[_level].append(s3[0]);
                                                                s3 = Marshalling.recursiveGetDBusType(_out, t2[1], false, _level + 1);
                                                                if (s3.length != 1) {
                                                                    throw new DBusException("Multi-valued array types not permitted");
                                                                }
                                                                _out[_level].append(s3[0]);
                                                            }
                                                            catch (ArrayIndexOutOfBoundsException aioobe2) {
                                                                LOGGER.debug("", (Throwable)aioobe2);
                                                                throw new DBusException("Map must have 2 parameters");
                                                            }
                                                            _out[_level].append('}');
                                                            break block33;
                                                        }
                                                        if (!List.class.isAssignableFrom((Class)p.getRawType())) break block40;
                                                        t2 = p.getActualTypeArguments();
                                                        aioobe2 = t2.length;
                                                        break block41;
                                                    }
                                                    if (!p.getRawType().equals(Variant.class)) break block42;
                                                    _out[_level].append('v');
                                                    break block33;
                                                }
                                                if (!DBusInterface.class.isAssignableFrom((Class)p.getRawType())) break block43;
                                                _out[_level].append('o');
                                                break block33;
                                            }
                                            if (!Tuple.class.isAssignableFrom((Class)p.getRawType())) {
                                                throw new DBusException("Exporting non-exportable parameterized type " + _dataType);
                                            }
                                            Type[] ts2 = p.getActualTypeArguments();
                                            vs = new ArrayList<String>();
                                            ss22 = ts2;
                                            n2 = ss22.length;
                                            s5 = 0;
                                            break block44;
                                        }
                                        if (!(_dataType instanceof Class)) break block33;
                                        dataTypeClazz = (Class)_dataType;
                                        if (!dataTypeClazz.isArray()) break block45;
                                        if (Type.class.equals(((Class)_dataType).getComponentType())) {
                                            _out[_level].append('g');
                                            break block33;
                                        } else {
                                            _out[_level].append('a');
                                            String[] s4 = Marshalling.recursiveGetDBusType(_out, ((Class)_dataType).getComponentType(), false, _level + 1);
                                            if (s4.length != 1) {
                                                throw new DBusException("Multi-valued array types not permitted");
                                            }
                                            _out[_level].append(s4[0]);
                                        }
                                        break block33;
                                    }
                                    if (!Struct.class.isAssignableFrom((Class)_dataType)) break block46;
                                    _out[_level].append('(');
                                    ts = Container.getTypeCache(_dataType);
                                    if (null != ts) break block47;
                                    Field[] fs = ((Class)_dataType).getDeclaredFields();
                                    ts = new Type[fs.length];
                                    ss22 = fs;
                                    n = ss22.length;
                                    break block48;
                                }
                                if (dataTypeClazz.isPrimitive()) {
                                    // empty if block
                                }
                                boolean found = false;
                                for (Map.Entry<Class<?>, Byte> entry : CLASS_TO_ARGUMENTTYPE.entrySet()) {
                                    if (!entry.getKey().isAssignableFrom(dataTypeClazz)) continue;
                                    _out[_level].append((char)entry.getValue().byteValue());
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    throw new DBusException("Exporting non-exportable type: " + _dataType);
                                }
                                break block33;
                            }
                            String[] sigs = new String[newtypes.length];
                            int j = 0;
                            while (true) {
                                if (j >= sigs.length) {
                                    return sigs;
                                }
                                String[] ss22 = Marshalling.recursiveGetDBusType(_out, newtypes[j], false, _level + 1);
                                if (1 != ss22.length) {
                                    throw new DBusException("Serializable classes must serialize to native DBus types");
                                }
                                sigs[j] = ss22[0];
                                ++j;
                            }
                        }
                        for (int ss22 = 0; ss22 < aioobe2; ++ss22) {
                            Type t3 = t2[ss22];
                            if (Type.class.equals((Object)t3)) {
                                _out[_level].append('g');
                                continue;
                            }
                            String[] s5 = Marshalling.recursiveGetDBusType(_out, t3, false, _level + 1);
                            if (s5.length != 1) {
                                throw new DBusException("Multi-valued array types not permitted");
                            }
                            _out[_level].append('a');
                            _out[_level].append(s5[0]);
                        }
                        break block33;
                    }
                    while (true) {
                        if (s5 >= n2) {
                            return vs.toArray(new String[0]);
                        }
                        Type t = ss22[s5];
                        for (String s6 : Marshalling.recursiveGetDBusType(_out, t, false, _level + 1)) {
                            vs.add(s6);
                        }
                        ++s5;
                    }
                }
                for (int s5 = 0; s5 < n; ++s5) {
                    Field f = ss22[s5];
                    Position p = f.getAnnotation(Position.class);
                    if (null == p) continue;
                    ts[p.value()] = f.getGenericType();
                }
                Container.putTypeCache(_dataType, ts);
            }
            for (Type t : ts) {
                if (t == null) continue;
                for (String s : Marshalling.recursiveGetDBusType(_out, t, false, _level + 1)) {
                    _out[_level].append(s);
                }
            }
            _out[_level].append(')');
        }
        LOGGER.trace("Converted Java type: {} to D-Bus Type: {}", (Object)_dataType, (Object)_out[_level]);
        return new String[]{_out[_level].toString()};
    }

    public static int getJavaType(String _dbusType, List<Type> _resultValue, int _limit) throws DBusException {
        if (null == _dbusType || "".equals(_dbusType) || 0 == _limit) {
            return 0;
        }
        try {
            int idx;
            block21: for (idx = 0; idx < _dbusType.length() && (-1 == _limit || _limit > _resultValue.size()); ++idx) {
                switch (_dbusType.charAt(idx)) {
                    case '(': {
                        int structIdx = idx + 1;
                        int structLen = 1;
                        while (structLen > 0) {
                            if (')' == _dbusType.charAt(structIdx)) {
                                --structLen;
                            } else if ('(' == _dbusType.charAt(structIdx)) {
                                ++structLen;
                            }
                            ++structIdx;
                        }
                        ArrayList<Type> contained = new ArrayList();
                        int javaType = Marshalling.getJavaType(_dbusType.substring(idx + 1, structIdx - 1), contained, -1);
                        _resultValue.add(new DBusStructType(contained.toArray(new Type[0])));
                        idx = structIdx - 1;
                        continue block21;
                    }
                    case 'a': {
                        int javaType;
                        ArrayList<Type> contained;
                        if ('{' == _dbusType.charAt(idx + 1)) {
                            contained = new ArrayList();
                            javaType = Marshalling.getJavaType(_dbusType.substring(idx + 2), contained, 2);
                            _resultValue.add(new DBusMapType((Type)contained.get(0), (Type)contained.get(1)));
                            idx += javaType + 2;
                            continue block21;
                        }
                        contained = new ArrayList();
                        javaType = Marshalling.getJavaType(_dbusType.substring(idx + 1), contained, 1);
                        _resultValue.add(new DBusListType((Type)contained.get(0)));
                        idx += javaType;
                        continue block21;
                    }
                    case 'v': {
                        _resultValue.add((Type)((Object)Variant.class));
                        continue block21;
                    }
                    case 'b': {
                        _resultValue.add((Type)((Object)Boolean.class));
                        continue block21;
                    }
                    case 'n': {
                        _resultValue.add((Type)((Object)Short.class));
                        continue block21;
                    }
                    case 'y': {
                        _resultValue.add((Type)((Object)Byte.class));
                        continue block21;
                    }
                    case 'o': {
                        _resultValue.add((Type)((Object)DBusInterface.class));
                        continue block21;
                    }
                    case 'q': {
                        _resultValue.add((Type)((Object)UInt16.class));
                        continue block21;
                    }
                    case 'i': {
                        _resultValue.add((Type)((Object)Integer.class));
                        continue block21;
                    }
                    case 'u': {
                        _resultValue.add((Type)((Object)UInt32.class));
                        continue block21;
                    }
                    case 'x': {
                        _resultValue.add((Type)((Object)Long.class));
                        continue block21;
                    }
                    case 't': {
                        _resultValue.add((Type)((Object)UInt64.class));
                        continue block21;
                    }
                    case 'd': {
                        _resultValue.add((Type)((Object)Double.class));
                        continue block21;
                    }
                    case 'f': {
                        _resultValue.add((Type)((Object)Float.class));
                        continue block21;
                    }
                    case 's': {
                        _resultValue.add((Type)((Object)CharSequence.class));
                        continue block21;
                    }
                    case 'g': {
                        _resultValue.add((Type)((Object)Type[].class));
                        continue block21;
                    }
                    case '{': {
                        _resultValue.add((Type)((Object)Map.Entry.class));
                        ArrayList<Type> contained = new ArrayList<Type>();
                        int javaType = Marshalling.getJavaType(_dbusType.substring(idx + 1), contained, 2);
                        idx += javaType + 1;
                        continue block21;
                    }
                    default: {
                        throw new DBusException(String.format("Failed to parse DBus type signature: %s (%s).", _dbusType, Character.valueOf(_dbusType.charAt(idx))));
                    }
                }
            }
            return idx;
        }
        catch (IndexOutOfBoundsException _ex) {
            LOGGER.debug("Failed to parse DBus type signature.", (Throwable)_ex);
            throw new DBusException("Failed to parse DBus type signature: " + _dbusType);
        }
    }

    public static Object[] convertParameters(Object[] _parameters, Type[] _types, AbstractConnection _conn) throws DBusException {
        if (null == _parameters) {
            return null;
        }
        for (int i = 0; i < _parameters.length; ++i) {
            if (null == _parameters[i]) continue;
            LOGGER.trace("Converting {} from {} to {}", new Object[]{i, _parameters[i], _types[i]});
            if (_parameters[i] instanceof DBusSerializable) {
                for (Method m : _parameters[i].getClass().getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Class<?>[] newtypes = m.getParameterTypes();
                    Type[] expand = new Type[_types.length + newtypes.length - 1];
                    System.arraycopy(_types, 0, expand, 0, i);
                    System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                    System.arraycopy(_types, i + 1, expand, i + newtypes.length, _types.length - i - 1);
                    _types = expand;
                    Object[] newparams = ((DBusSerializable)_parameters[i]).serialize();
                    Object[] exparams = new Object[_parameters.length + newparams.length - 1];
                    System.arraycopy(_parameters, 0, exparams, 0, i);
                    System.arraycopy(newparams, 0, exparams, i, newparams.length);
                    System.arraycopy(_parameters, i + 1, exparams, i + newparams.length, _parameters.length - i - 1);
                    _parameters = exparams;
                }
                --i;
                continue;
            }
            if (_parameters[i] instanceof Tuple) {
                Type[] newtypes = ((ParameterizedType)_types[i]).getActualTypeArguments();
                Type[] expand = new Type[_types.length + newtypes.length - 1];
                System.arraycopy(_types, 0, expand, 0, i);
                System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                System.arraycopy(_types, i + 1, expand, i + newtypes.length, _types.length - i - 1);
                _types = expand;
                Object[] newparams = ((Tuple)_parameters[i]).getParameters();
                Object[] exparams = new Object[_parameters.length + newparams.length - 1];
                System.arraycopy(_parameters, 0, exparams, 0, i);
                System.arraycopy(newparams, 0, exparams, i, newparams.length);
                System.arraycopy(_parameters, i + 1, exparams, i + newparams.length, _parameters.length - i - 1);
                _parameters = exparams;
                LOGGER.trace("New params: {}, new types: {}", (Object)Arrays.deepToString(_parameters), (Object)Arrays.deepToString(_types));
                --i;
                continue;
            }
            if (_types[i] instanceof TypeVariable && !(_parameters[i] instanceof Variant)) {
                _parameters[i] = new Variant<Object>(_parameters[i]);
                continue;
            }
            if (!(_parameters[i] instanceof DBusInterface)) continue;
            _parameters[i] = _conn.getExportedObject((DBusInterface)_parameters[i]);
        }
        return _parameters;
    }

    /*
     * WARNING - void declaration
     */
    static Object deSerializeParameter(Object _parameter, Type _type, AbstractConnection _conn) throws Exception {
        Type type2;
        Object[] ts;
        LOGGER.trace("Deserializing from {} to {}", _parameter.getClass(), _type.getClass());
        if (_type instanceof TypeVariable && _parameter instanceof Variant) {
            _parameter = ((Variant)_parameter).getValue();
        }
        if (_type instanceof Class && ((Class)_type).isArray() && ((Class)_type).getComponentType().equals(Type.class) && _parameter instanceof String) {
            ArrayList<Type> rv = new ArrayList<Type>();
            Marshalling.getJavaType((String)_parameter, rv, -1);
            _parameter = rv.toArray(new Type[0]);
        }
        if (_parameter instanceof ObjectPath) {
            _parameter = _type instanceof Class && DBusInterface.class.isAssignableFrom((Class)_type) ? _conn.getExportedObject(((ObjectPath)_parameter).getSource(), ((ObjectPath)_parameter).getPath()) : new DBusPath(((ObjectPath)_parameter).getPath());
        }
        if (_parameter instanceof Object[] && _type instanceof Class && Struct.class.isAssignableFrom((Class)_type)) {
            LOGGER.trace("Creating Struct {} from {}", (Object)_type, _parameter);
            ts = Container.getTypeCache(_type);
            if (null == ts) {
                void var7_12;
                AccessibleObject[] fs = ((Class)_type).getDeclaredFields();
                ts = new Type[fs.length];
                Field[] fieldArray = fs;
                int n = fieldArray.length;
                boolean i = false;
                while (var7_12 < n) {
                    Field f = fieldArray[var7_12];
                    Position p = f.getAnnotation(Position.class);
                    if (null != p) {
                        ts[p.value()] = f.getGenericType();
                    }
                    ++var7_12;
                }
                Container.putTypeCache(_type, (Type[])ts);
            }
            _parameter = Marshalling.deSerializeParameters(_parameter, (Type[])ts, _conn);
            for (AccessibleObject accessibleObject : ((Class)_type).getDeclaredConstructors()) {
                try {
                    _parameter = ((Constructor)accessibleObject).newInstance(_parameter);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        if (_parameter instanceof Object[]) {
            ts = new Type[((Object[])_parameter).length];
            Arrays.fill(ts, _parameter.getClass().getComponentType());
            _parameter = Marshalling.deSerializeParameters(_parameter, (Type[])ts, _conn);
        }
        if (_parameter instanceof List && null != (type2 = _type instanceof ParameterizedType ? ((ParameterizedType)_type).getActualTypeArguments()[0] : (_type instanceof GenericArrayType ? ((GenericArrayType)_type).getGenericComponentType() : (_type instanceof Class && ((Class)_type).isArray() ? ((Class)_type).getComponentType() : null)))) {
            _parameter = Marshalling.deSerializeParameters((List)_parameter, type2, _conn);
        }
        if ((_type.equals(Float.class) || _type.equals(Float.TYPE)) && !(_parameter instanceof Float)) {
            _parameter = Float.valueOf(((Number)_parameter).floatValue());
        }
        if (_parameter instanceof Object[] || _parameter instanceof List || _parameter.getClass().isArray()) {
            if (_type instanceof ParameterizedType) {
                _parameter = ArrayFrob.convert(_parameter, (Class)((ParameterizedType)_type).getRawType());
            } else if (_type instanceof GenericArrayType) {
                Type ct = ((GenericArrayType)_type).getGenericComponentType();
                Class cc = null;
                if (ct instanceof Class) {
                    cc = (Class)ct;
                }
                if (ct instanceof ParameterizedType) {
                    cc = (Class)((ParameterizedType)ct).getRawType();
                }
                Object o = Array.newInstance(cc, 0);
                _parameter = ArrayFrob.convert(_parameter, o.getClass());
            } else if (_type instanceof Class && ((Class)_type).isArray()) {
                Class<?> cc = ((Class)_type).getComponentType();
                if ((cc.equals(Float.class) || cc.equals(Float.TYPE)) && _parameter instanceof double[]) {
                    double[] tmp1 = (double[])_parameter;
                    float[] tmp2 = new float[tmp1.length];
                    for (int i = 0; i < tmp1.length; ++i) {
                        tmp2[i] = (float)tmp1[i];
                    }
                    _parameter = tmp2;
                }
                Object o = Array.newInstance(cc, 0);
                _parameter = ArrayFrob.convert(_parameter, o.getClass());
            }
        }
        if (_parameter instanceof DBusMap) {
            LOGGER.trace("Deserializing a Map");
            DBusMap dmap = (DBusMap)_parameter;
            Type[] maptypes = ((ParameterizedType)_type).getActualTypeArguments();
            for (int i = 0; i < dmap.entries.length; ++i) {
                dmap.entries[i][0] = Marshalling.deSerializeParameter(dmap.entries[i][0], maptypes[0], _conn);
                dmap.entries[i][1] = Marshalling.deSerializeParameter(dmap.entries[i][1], maptypes[1], _conn);
            }
        }
        return _parameter;
    }

    static List<Object> deSerializeParameters(List<Object> _parameters, Type _type, AbstractConnection _conn) throws Exception {
        LOGGER.trace("Deserializing from {} to {}", _parameters, (Object)_type);
        if (null == _parameters) {
            return null;
        }
        for (int i = 0; i < _parameters.size(); ++i) {
            if (null == _parameters.get(i)) continue;
            _parameters.set(i, Marshalling.deSerializeParameter(_parameters.get(i), _type, _conn));
        }
        return _parameters;
    }

    public static Object[] deSerializeParameters(Object[] _parameters, Type[] _types, AbstractConnection _conn) throws Exception {
        LOGGER.trace("Deserializing from {} to {} ", (Object)Arrays.deepToString(_parameters), (Object)Arrays.deepToString(_types));
        if (null == _parameters) {
            return null;
        }
        if (_types.length == 1 && _types[0] instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)_types[0]).getRawType())) {
            _types = ((ParameterizedType)_types[0]).getActualTypeArguments();
        }
        for (int i = 0; i < _parameters.length; ++i) {
            if (i >= _types.length) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error("Parameter length differs, expected {} but got {}", (Object)_parameters.length, (Object)_types.length);
                    for (int j = 0; j < _parameters.length; ++j) {
                        LOGGER.error("Error, Parameters differ: {}, '{}'", (Object)j, (Object)_parameters[j].toString());
                    }
                }
                throw new DBusException("Error deserializing message: number of parameters didn't match receiving signature");
            }
            if (null == _parameters[i]) continue;
            if (_types[i] instanceof Class && DBusSerializable.class.isAssignableFrom((Class)_types[i]) || _types[i] instanceof ParameterizedType && DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)_types[i]).getRawType())) {
                Class dsc = _types[i] instanceof Class ? (Class)_types[i] : (Class)((ParameterizedType)_types[i]).getRawType();
                for (Method m : dsc.getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Type[] newtypes = m.getGenericParameterTypes();
                    try {
                        Object[] sub = new Object[newtypes.length];
                        System.arraycopy(_parameters, i, sub, 0, newtypes.length);
                        sub = Marshalling.deSerializeParameters(sub, newtypes, _conn);
                        DBusSerializable sz = (DBusSerializable)dsc.newInstance();
                        m.invoke((Object)sz, sub);
                        Object[] compress = new Object[_parameters.length - newtypes.length + 1];
                        System.arraycopy(_parameters, 0, compress, 0, i);
                        compress[i] = sz;
                        System.arraycopy(_parameters, i + newtypes.length, compress, i + 1, _parameters.length - i - newtypes.length);
                        _parameters = compress;
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        LOGGER.debug("", (Throwable)aioobe);
                        throw new DBusException(String.format("Not enough elements to create custom object from serialized data (%s < %s).", _parameters.length - i, newtypes.length));
                    }
                }
                continue;
            }
            _parameters[i] = Marshalling.deSerializeParameter(_parameters[i], _types[i], _conn);
        }
        return _parameters;
    }

    static {
        CLASS_TO_ARGUMENTTYPE.put(Boolean.class, (byte)98);
        CLASS_TO_ARGUMENTTYPE.put(Boolean.TYPE, (byte)98);
        CLASS_TO_ARGUMENTTYPE.put(Byte.class, (byte)121);
        CLASS_TO_ARGUMENTTYPE.put(Byte.TYPE, (byte)121);
        CLASS_TO_ARGUMENTTYPE.put(Short.class, (byte)110);
        CLASS_TO_ARGUMENTTYPE.put(Short.TYPE, (byte)110);
        CLASS_TO_ARGUMENTTYPE.put(Integer.class, (byte)105);
        CLASS_TO_ARGUMENTTYPE.put(Integer.TYPE, (byte)105);
        CLASS_TO_ARGUMENTTYPE.put(Long.class, (byte)120);
        CLASS_TO_ARGUMENTTYPE.put(Long.TYPE, (byte)120);
        CLASS_TO_ARGUMENTTYPE.put(Double.class, (byte)100);
        CLASS_TO_ARGUMENTTYPE.put(Double.TYPE, (byte)100);
        if (AbstractConnection.FLOAT_SUPPORT) {
            CLASS_TO_ARGUMENTTYPE.put(Float.class, (byte)102);
            CLASS_TO_ARGUMENTTYPE.put(Float.TYPE, (byte)102);
        } else {
            CLASS_TO_ARGUMENTTYPE.put(Float.class, (byte)100);
            CLASS_TO_ARGUMENTTYPE.put(Float.TYPE, (byte)100);
        }
        CLASS_TO_ARGUMENTTYPE.put(UInt16.class, (byte)113);
        CLASS_TO_ARGUMENTTYPE.put(UInt32.class, (byte)117);
        CLASS_TO_ARGUMENTTYPE.put(UInt64.class, (byte)116);
        CLASS_TO_ARGUMENTTYPE.put(CharSequence.class, (byte)115);
        CLASS_TO_ARGUMENTTYPE.put(Variant.class, (byte)118);
        CLASS_TO_ARGUMENTTYPE.put(DBusInterface.class, (byte)111);
        CLASS_TO_ARGUMENTTYPE.put(DBusPath.class, (byte)111);
        CLASS_TO_ARGUMENTTYPE.put(ObjectPath.class, (byte)111);
    }
}

