/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.unix.USOutputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.freedesktop.Hexdump;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageWriter
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OutputStream outputStream;
    private boolean unixSocket;

    public MessageWriter(OutputStream _out) {
        this.outputStream = _out;
        this.unixSocket = false;
        try {
            if (_out instanceof USOutputStream) {
                this.unixSocket = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.unixSocket) {
            this.outputStream = new BufferedOutputStream(_out);
        }
    }

    public void writeMessage(Message m) throws IOException {
        this.logger.debug("<= {}", (Object)m);
        if (null == m) {
            return;
        }
        if (null == m.getWireData()) {
            this.logger.warn("Message {} wire-data was null!", (Object)m);
            return;
        }
        if (this.unixSocket) {
            if (this.logger.isTraceEnabled()) {
                this.logger.debug("Writing all {} buffers simultaneously to Unix Socket", (Object)m.getWireData().length);
                for (byte[] buf : m.getWireData()) {
                    this.logger.trace("({}):{}", (Object)buf, (Object)(null == buf ? "" : Hexdump.format(buf)));
                }
            }
            ((USOutputStream)this.outputStream).write(m.getWireData());
        } else {
            for (byte[] buf : m.getWireData()) {
                this.logger.trace("({}):{}", (Object)buf, (Object)(null == buf ? "" : Hexdump.format(buf)));
                if (null == buf) break;
                this.outputStream.write(buf);
            }
        }
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.logger.info("Closing Message Writer");
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        this.outputStream = null;
    }

    public boolean isClosed() {
        return this.outputStream != null;
    }
}

