/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.helper.SampleClass;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestDisconnectStuff {
    @Test
    @Disabled(value="Fails when run in maven combined with all other tests, but runs as standalone")
    public void testStuffAfterDisconnect() throws DBusException, InterruptedException {
        DBusConnection serverConnection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        DBusConnection clientConnection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        serverConnection.setWeakReferences(true);
        clientConnection.setWeakReferences(true);
        serverConnection.requestBusName("foo.bar.why.again.disconnect.Test");
        SampleClass tclass = new SampleClass(serverConnection);
        serverConnection.exportObject("/Test2001", (DBusInterface)tclass);
        SampleRemoteInterface tri = (SampleRemoteInterface)clientConnection.getRemoteObject("foo.bar.why.again.disconnect.Test", "/Test2001", SampleRemoteInterface.class);
        try {
            clientConnection.disconnect();
            Thread.sleep(1000L);
            serverConnection.disconnect();
            Thread.sleep(1000L);
            System.out.println("getName() suceeded and returned: " + tri.getName());
            Assertions.fail((String)"Should not succeed when disconnected");
        }
        catch (NotConnected notConnected) {
            // empty catch block
        }
    }
}

