/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.signals.handler;

import java.util.concurrent.atomic.AtomicInteger;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractSignalHandler<T extends DBusSignal>
implements DBusSigHandler<T> {
    private final AtomicInteger testRuns = new AtomicInteger(0);
    private final int expectedRuns;

    public AbstractSignalHandler(int _expectedRuns) {
        this.expectedRuns = _expectedRuns;
    }

    protected abstract void handleImpl(T var1);

    public final void handle(T _s) {
        this.getTestRuns().incrementAndGet();
        Assertions.assertTrue((this.getExpectedRuns() <= this.getActualTestRuns() ? 1 : 0) != 0, (String)"Signal received to often.");
        System.out.println(this.getClass().getSimpleName() + " running");
        this.handleImpl(_s);
    }

    protected AtomicInteger getTestRuns() {
        return this.testRuns;
    }

    public int getActualTestRuns() {
        return this.testRuns.get();
    }

    public int getExpectedRuns() {
        return this.expectedRuns;
    }
}

