/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import com.github.hypfvieh.threads.NameableThreadFactory;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.InternalSignal;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.FallbackContainer;
import org.freedesktop.dbus.connections.GlobalHandler;
import org.freedesktop.dbus.connections.IncomingMessageThread;
import org.freedesktop.dbus.connections.PendingCallbackManager;
import org.freedesktop.dbus.connections.Transport;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.errors.UnknownObject;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalDBusException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Local;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;
import org.freedesktop.dbus.messages.ObjectTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Closeable {
    private static final Map<Thread, DBusCallInfo> INFOMAP = new ConcurrentHashMap<Thread, DBusCallInfo>();
    private static final int TIMEOUT = 100000;
    private static final int THREADCOUNT = 4;
    public static final boolean FLOAT_SUPPORT = null != System.getenv("DBUS_JAVA_FLOATS");
    public static final String BUSNAME_REGEX = "^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$";
    public static final String CONNID_REGEX = "^:[0-9]*\\.[0-9]*$";
    public static final String OBJECT_REGEX = "^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$";
    public static final Pattern DOLLAR_PATTERN = Pattern.compile("[$]");
    public static final int MAX_ARRAY_LENGTH = 0x4000000;
    public static final int MAX_NAME_LENGTH = 255;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectTree objectTree;
    private final Map<String, ExportedObject> exportedObjects = new HashMap<String, ExportedObject>();
    private final Map<DBusInterface, RemoteObject> importedObjects = new ConcurrentHashMap<DBusInterface, RemoteObject>();
    private final PendingCallbackManager callbackManager;
    private final FallbackContainer fallbackContainer;
    private final Queue<Error> pendingErrorQueue;
    private final Map<SignalTuple, List<DBusSigHandler<? extends DBusSignal>>> handledSignals;
    private final Map<Long, MethodCall> pendingCalls;
    private final IncomingMessageThread readerThread;
    private final BusAddress busAddress;
    private volatile boolean run;
    private boolean weakreferences = false;
    private boolean connected = false;
    private Transport transport;
    private ExecutorService workerThreadPool;
    private ExecutorService senderService;

    protected AbstractConnection(String address) throws DBusException {
        this.exportedObjects.put(null, new ExportedObject(new GlobalHandler(this), this.weakreferences));
        this.handledSignals = new ConcurrentHashMap<SignalTuple, List<DBusSigHandler<? extends DBusSignal>>>();
        this.pendingCalls = Collections.synchronizedMap(new LinkedHashMap());
        this.callbackManager = new PendingCallbackManager();
        this.pendingErrorQueue = new ConcurrentLinkedQueue<Error>();
        this.workerThreadPool = Executors.newFixedThreadPool(4, (ThreadFactory)new NameableThreadFactory("DBus Worker Thread-", false));
        this.senderService = Executors.newFixedThreadPool(1, (ThreadFactory)new NameableThreadFactory("DBus Sender Thread-", false));
        this.objectTree = new ObjectTree();
        this.fallbackContainer = new FallbackContainer();
        this.readerThread = new IncomingMessageThread(this);
        try {
            this.busAddress = new BusAddress(address);
            this.transport = new Transport(this.busAddress, 100000);
            this.connected = true;
        }
        catch (IOException | DBusException ioe) {
            this.logger.debug("Error creating transport", (Throwable)ioe);
            this.disconnect();
            throw new DBusException("Failed to connect to bus " + ioe.getMessage(), ioe);
        }
        this.run = true;
    }

    public abstract DBusInterface getExportedObject(String var1, String var2) throws DBusException;

    protected abstract <T extends DBusSignal> void removeSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    protected abstract <T extends DBusSignal> void addSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    public abstract String getMachineId();

    protected void listen() {
        this.readerThread.start();
    }

    public void changeThreadCount(byte newcount) {
        if (newcount != 4) {
            List<Runnable> remainingTasks = this.workerThreadPool.shutdownNow();
            this.workerThreadPool = Executors.newFixedThreadPool(newcount, (ThreadFactory)new NameableThreadFactory("DbusWorkerThreads", false));
            for (Runnable runnable : remainingTasks) {
                this.workerThreadPool.execute(runnable);
            }
        }
    }

    public String getExportedObject(DBusInterface _interface) throws DBusException {
        String s;
        Optional<Map.Entry> foundInterface = this.getExportedObjects().entrySet().stream().filter(e -> _interface.equals(((ExportedObject)e.getValue()).getObject().get())).findFirst();
        if (foundInterface.isPresent()) {
            return (String)foundInterface.get().getKey();
        }
        RemoteObject rObj = this.getImportedObjects().get(_interface);
        if (rObj != null && (s = rObj.getObjectPath()) != null) {
            return s;
        }
        throw new DBusException("Not an object exported or imported by this connection");
    }

    public void setWeakReferences(boolean _weakreferences) {
        this.weakreferences = _weakreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(String objectpath, DBusInterface object) throws DBusException {
        if (null == objectpath || "".equals(objectpath)) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            if (null != this.getExportedObjects().get(objectpath)) {
                throw new DBusException("Object already exported");
            }
            ExportedObject eo = new ExportedObject(object, this.weakreferences);
            this.getExportedObjects().put(objectpath, eo);
            ObjectTree objectTree = this.getObjectTree();
            synchronized (objectTree) {
                this.getObjectTree().add(objectpath, eo, eo.getIntrospectiondata());
            }
        }
    }

    public void addFallback(String objectprefix, DBusInterface object) throws DBusException {
        if (null == objectprefix || "".equals(objectprefix)) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (!objectprefix.matches(OBJECT_REGEX) || objectprefix.length() > 255) {
            throw new DBusException("Invalid object path: " + objectprefix);
        }
        ExportedObject eo = new ExportedObject(object, this.weakreferences);
        this.fallbackContainer.add(objectprefix, eo);
    }

    public void removeFallback(String objectprefix) {
        this.fallbackContainer.remove(objectprefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unExportObject(String objectpath) {
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            this.getExportedObjects().remove(objectpath);
            this.getObjectTree().remove(objectpath);
        }
    }

    public void sendMessage(final Message _message) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractConnection.this.sendMessageInternally(_message);
            }
        };
        this.senderService.execute(runnable);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.removeSigHandler(new DBusMatchRule(type), handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        String objectpath = this.getImportedObjects().get(object).getObjectPath();
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(type, null, objectpath), handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.addSigHandler(new DBusMatchRule(type), handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        RemoteObject rObj = this.getImportedObjects().get(object);
        if (rObj == null) {
            throw new DBusException("Not an object exported or imported by this connection");
        }
        String objectpath = rObj.getObjectPath();
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(type, null, objectpath), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DBusSignal> void addSigHandlerWithoutMatch(Class<? extends DBusSignal> signal, DBusSigHandler<T> handler) throws DBusException {
        DBusMatchRule rule = new DBusMatchRule(signal);
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map<SignalTuple, List<DBusSigHandler<? extends DBusSignal>>> map = this.getHandledSignals();
        synchronized (map) {
            List<DBusSigHandler<? extends DBusSignal>> v = this.getHandledSignals().get(key);
            if (null == v) {
                v = new ArrayList<DBusSigHandler<? extends DBusSignal>>();
                v.add(handler);
                this.getHandledSignals().put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    public synchronized void disconnect() {
        if (!this.connected) {
            return;
        }
        this.logger.debug("Sending disconnected signal");
        try {
            this.handleMessage(new Local.Disconnected("/"), false);
        }
        catch (Exception ex) {
            this.logger.debug("Exception while disconnecting", (Throwable)ex);
        }
        this.logger.debug("Disconnecting Abstract Connection");
        try {
            this.workerThreadPool.shutdown();
            this.workerThreadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException _ex) {
            this.logger.error("Interrupted while waiting for worker threads to be terminated.", (Throwable)_ex);
        }
        for (Runnable runnable : this.senderService.shutdownNow()) {
            runnable.run();
        }
        this.run = false;
        this.connected = false;
        this.readerThread.setTerminate(true);
        try {
            if (this.transport != null) {
                this.transport.disconnect();
                this.transport = null;
            }
        }
        catch (IOException exIo) {
            this.logger.debug("Exception while disconnecting transport.", (Throwable)exIo);
        }
        if (!this.workerThreadPool.isTerminated()) {
            this.workerThreadPool.shutdownNow();
        }
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    public <A> void callWithCallback(DBusInterface object, String m, CallbackHandler<A> callback, Object ... parameters) {
        this.logger.trace("callWithCallback({}, {}, {})", new Object[]{object, m, callback});
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        RemoteObject ro = this.getImportedObjects().get(object);
        try {
            Method me = null == ro.getInterface() ? object.getClass().getMethod(m, types) : ro.getInterface().getMethod(m, types);
            RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 2, callback, parameters);
        }
        catch (DBusExecutionException exEe) {
            this.logger.debug("", (Throwable)exEe);
            throw exEe;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusExecutionException(e.getMessage());
        }
    }

    public DBusAsyncReply<?> callMethodAsync(DBusInterface object, String m, Object ... parameters) {
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        RemoteObject ro = this.getImportedObjects().get(object);
        try {
            Method me = null == ro.getInterface() ? object.getClass().getMethod(m, types) : ro.getInterface().getMethod(m, types);
            return (DBusAsyncReply)RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 1, null, parameters);
        }
        catch (DBusExecutionException exDee) {
            this.logger.debug("", (Throwable)exDee);
            throw exDee;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusExecutionException(e.getMessage());
        }
    }

    protected void handleException(AbstractConnection dbusConnection, Message methodOrSignal, DBusExecutionException exception) {
        if (dbusConnection == null) {
            throw new NullPointerException("DBusConnection cannot be null");
        }
        try {
            dbusConnection.sendMessage(new Error(methodOrSignal, exception));
        }
        catch (DBusException ex) {
            this.logger.warn("Exception caught while processing previous error.", (Throwable)ex);
        }
    }

    void handleMessage(Message _message) throws DBusException {
        if (_message instanceof DBusSignal) {
            this.handleMessage((DBusSignal)_message, true);
        } else if (_message instanceof MethodCall) {
            this.handleMessage((MethodCall)_message);
        } else if (_message instanceof MethodReturn) {
            this.handleMessage((MethodReturn)_message);
        } else if (_message instanceof Error) {
            this.handleMessage((Error)_message);
        }
    }

    private void handleMessage(final MethodCall m) throws DBusException {
        this.logger.debug("Handling incoming method call: {}", (Object)m);
        ExportedObject eo = null;
        Method meth = null;
        DBusInterface o = null;
        if (null == m.getInterface() || m.getInterface().equals("org.freedesktop.DBus.Peer") || m.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            eo = this.getExportedObjects().get(null);
            if (null != eo && null == eo.getObject().get()) {
                this.unExportObject(null);
                eo = null;
            }
            if (null != eo) {
                meth = eo.getMethods().get(new MethodTuple(m.getName(), m.getSig()));
            }
            if (null != meth) {
                o = new GlobalHandler(this, m.getPath());
            } else {
                eo = null;
            }
        }
        if (null == o) {
            eo = this.getExportedObjects().get(m.getPath());
            if (null != eo && null == eo.getObject().get()) {
                this.logger.info("Unexporting {} implicitly", (Object)m.getPath());
                this.unExportObject(m.getPath());
                eo = null;
            }
            if (null == eo) {
                eo = this.fallbackContainer.get(m.getPath());
            }
            if (null == eo) {
                this.sendMessage(new Error(m, new UnknownObject(m.getPath() + " is not an object provided by this process.")));
                return;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Searching for method {}  with signature {}", (Object)m.getName(), (Object)m.getSig());
                this.logger.trace("List of methods on {}: ", (Object)eo);
                for (MethodTuple mt : eo.getMethods().keySet()) {
                    this.logger.trace("   {} => {}", (Object)mt, (Object)eo.getMethods().get(mt));
                }
            }
            if (null == (meth = eo.getMethods().get(new MethodTuple(m.getName(), m.getSig())))) {
                this.sendMessage(new Error(m, new UnknownMethod(String.format("The method `%s.%s' does not exist on this object.", m.getInterface(), m.getName()))));
                return;
            }
            o = eo.getObject().get();
        }
        final Method me = meth;
        final GlobalHandler ob = o;
        final boolean noreply = 1 == (m.getFlags() & 1);
        final DBusCallInfo info = new DBusCallInfo(m);
        final AbstractConnection conn = this;
        this.logger.trace("Adding Runnable for method {}", (Object)meth);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AbstractConnection.this.logger.debug("Running method {} for remote call", (Object)me);
                if (me == null) {
                    AbstractConnection.this.logger.debug("Cannot run method - method variable was null");
                    return;
                }
                try {
                    Object[] ts = me.getGenericParameterTypes();
                    m.setArgs(Marshalling.deSerializeParameters(m.getParameters(), (Type[])ts, conn));
                    AbstractConnection.this.logger.trace("Deserialised {} to types {}", (Object)Arrays.deepToString(m.getParameters()), (Object)Arrays.deepToString(ts));
                }
                catch (Exception e) {
                    AbstractConnection.this.logger.debug("", (Throwable)e);
                    AbstractConnection.this.handleException(conn, m, new UnknownMethod("Failure in de-serializing message: " + e));
                    return;
                }
                try {
                    Object result;
                    INFOMAP.put(Thread.currentThread(), info);
                    try {
                        AbstractConnection.this.logger.trace("Invoking Method: {} on {} with parameters {}", new Object[]{me, ob, Arrays.deepToString(m.getParameters())});
                        result = me.invoke(ob, m.getParameters());
                    }
                    catch (InvocationTargetException ite) {
                        AbstractConnection.this.logger.debug(ite.getMessage(), (Throwable)ite);
                        throw ite.getCause();
                    }
                    INFOMAP.remove(Thread.currentThread());
                    if (!noreply) {
                        MethodReturn reply;
                        if (Void.TYPE.equals(me.getReturnType())) {
                            reply = new MethodReturn(m, null, new Object[0]);
                        } else {
                            StringBuffer sb = new StringBuffer();
                            for (String s : Marshalling.getDBusType(me.getGenericReturnType())) {
                                sb.append(s);
                            }
                            Object[] nr = Marshalling.convertParameters(new Object[]{result}, new Type[]{me.getGenericReturnType()}, conn);
                            reply = new MethodReturn(m, sb.toString(), nr);
                        }
                        conn.sendMessage(reply);
                    }
                }
                catch (DBusExecutionException exDee) {
                    AbstractConnection.this.logger.debug("", (Throwable)exDee);
                    AbstractConnection.this.handleException(conn, m, exDee);
                }
                catch (Throwable e) {
                    AbstractConnection.this.logger.debug("", e);
                    AbstractConnection.this.handleException(conn, m, new DBusExecutionException(String.format("Error Executing Method %s.%s: %s", m.getInterface(), m.getName(), e.getMessage())));
                }
            }
        };
        this.workerThreadPool.execute(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final DBusSignal _signal, boolean _useThreadPool) {
        this.logger.debug("Handling incoming signal: ", (Object)_signal);
        ArrayList<DBusSigHandler<? extends DBusSignal>> v = new ArrayList<DBusSigHandler<? extends DBusSignal>>();
        Map<SignalTuple, List<DBusSigHandler<? extends DBusSignal>>> map = this.getHandledSignals();
        synchronized (map) {
            List<DBusSigHandler<? extends DBusSignal>> t = this.getHandledSignals().get(new SignalTuple(_signal.getInterface(), _signal.getName(), null, null));
            if (null != t) {
                v.addAll(t);
            }
            if (null != (t = this.getHandledSignals().get(new SignalTuple(_signal.getInterface(), _signal.getName(), _signal.getPath(), null)))) {
                v.addAll(t);
            }
            if (null != (t = this.getHandledSignals().get(new SignalTuple(_signal.getInterface(), _signal.getName(), null, _signal.getSource())))) {
                v.addAll(t);
            }
            if (null != (t = this.getHandledSignals().get(new SignalTuple(_signal.getInterface(), _signal.getName(), _signal.getPath(), _signal.getSource())))) {
                v.addAll(t);
            }
        }
        if (0 == v.size()) {
            return;
        }
        final AbstractConnection conn = this;
        for (final DBusSigHandler dBusSigHandler : v) {
            this.logger.trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)dBusSigHandler);
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    try {
                        DBusSignal rs = _signal instanceof InternalSignal || _signal.getClass().equals(DBusSignal.class) ? _signal.createReal(conn) : _signal;
                        dBusSigHandler.handle(rs);
                    }
                    catch (DBusException _ex) {
                        AbstractConnection.this.logger.warn("Exception while running signal handler '{}' for signal '{}': {}", new Object[]{dBusSigHandler, _signal, _ex});
                        AbstractConnection.this.handleException(conn, _signal, new DBusExecutionException("Error handling signal " + _signal.getInterface() + "." + _signal.getName() + ": " + _ex.getMessage()));
                    }
                }
            };
            if (_useThreadPool) {
                this.workerThreadPool.execute(command);
                continue;
            }
            command.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final Error err) {
        this.logger.debug("Handling incoming error: {}", (Object)err);
        MethodCall m = null;
        if (this.getPendingCalls() == null) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(err.getReplySerial())) {
                m = this.getPendingCalls().remove(err.getReplySerial());
            }
        }
        if (m != null) {
            m.setReply(err);
            CallbackHandler<? extends Object> cbh = null;
            cbh = this.callbackManager.removeCallback(m);
            this.logger.trace("{} = pendingCallbacks.remove({})", cbh, (Object)m);
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                this.logger.trace("Adding Error Runnable with callback handler {}", fcbh);
                Runnable command = new Runnable(){

                    @Override
                    public synchronized void run() {
                        try {
                            AbstractConnection.this.logger.trace("Running Error Callback for {}", (Object)err);
                            DBusCallInfo info = new DBusCallInfo(err);
                            INFOMAP.put(Thread.currentThread(), info);
                            fcbh.handleError(err.getException());
                            INFOMAP.remove(Thread.currentThread());
                        }
                        catch (Exception e) {
                            AbstractConnection.this.logger.debug("Exception while running error callback.", (Throwable)e);
                        }
                    }
                };
                this.workerThreadPool.execute(command);
            }
        } else {
            this.getPendingErrorQueue().add(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodReturn mr) {
        this.logger.debug("Handling incoming method return: {}", (Object)mr);
        MethodCall m = null;
        if (null == this.getPendingCalls()) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(mr.getReplySerial())) {
                m = this.getPendingCalls().remove(mr.getReplySerial());
            }
        }
        if (null != m) {
            m.setReply(mr);
            mr.setCall(m);
            CallbackHandler<? extends Object> cbh = this.callbackManager.getCallback(m);
            DBusAsyncReply<?> asr = this.callbackManager.getCallbackReply(m);
            this.callbackManager.removeCallback(m);
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                final DBusAsyncReply<?> fasr = asr;
                if (fasr == null) {
                    this.logger.debug("Cannot add runnable for method, given method callback was null");
                    return;
                }
                this.logger.trace("Adding Runnable for method {} with callback handler {}", fcbh, (Object)(fasr != null ? fasr.getMethod() : null));
                Runnable r = new Runnable(){

                    @Override
                    public synchronized void run() {
                        try {
                            AbstractConnection.this.logger.trace("Running Callback for {}", (Object)mr);
                            DBusCallInfo info = new DBusCallInfo(mr);
                            INFOMAP.put(Thread.currentThread(), info);
                            Object convertRV = RemoteInvocationHandler.convertRV(mr.getSig(), mr.getParameters(), fasr.getMethod(), fasr.getConnection());
                            fcbh.handle(convertRV);
                            INFOMAP.remove(Thread.currentThread());
                        }
                        catch (Exception e) {
                            AbstractConnection.this.logger.debug("Exception while running callback.", (Throwable)e);
                        }
                    }
                };
                this.workerThreadPool.execute(r);
            }
        } else {
            try {
                this.sendMessage(new Error(mr, new DBusExecutionException("Spurious reply. No message with the given serial id was awaiting a reply.")));
            }
            catch (DBusException dBusException) {
                // empty catch block
            }
        }
    }

    public void queueCallback(MethodCall _call, Method _method, CallbackHandler<?> _callback) {
        this.callbackManager.queueCallback(_call, _method, _callback, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageInternally(Message m) {
        block26: {
            try {
                if (!this.connected) {
                    throw new NotConnected("Disconnected");
                }
                if (m instanceof DBusSignal) {
                    ((DBusSignal)m).appendbody(this);
                }
                if (m instanceof MethodCall && 0 == (m.getFlags() & 1)) {
                    if (null == this.getPendingCalls()) {
                        ((MethodCall)m).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected"));
                    } else {
                        Map<Long, MethodCall> map = this.getPendingCalls();
                        synchronized (map) {
                            this.getPendingCalls().put(m.getSerial(), (MethodCall)m);
                        }
                    }
                }
                this.transport.writeMessage(m);
            }
            catch (Exception e) {
                this.logger.debug("Exception while sending message.", (Throwable)e);
                if (m instanceof MethodCall && e instanceof NotConnected) {
                    try {
                        ((MethodCall)m).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected"));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                }
                if (m instanceof MethodCall && e instanceof DBusExecutionException) {
                    try {
                        ((MethodCall)m).setReply(new Error(m, e));
                    }
                    catch (DBusException dBusException) {}
                } else if (m instanceof MethodCall) {
                    try {
                        this.logger.info("Setting reply to {} as an error", (Object)m);
                        ((MethodCall)m).setReply(new Error(m, new DBusExecutionException("Message Failed to Send: " + e.getMessage())));
                    }
                    catch (DBusException dBusException) {}
                } else if (m instanceof MethodReturn) {
                    try {
                        this.transport.writeMessage(new Error(m, e));
                    }
                    catch (IOException exIo) {
                        this.logger.debug("", (Throwable)exIo);
                    }
                    catch (DBusException exDe) {
                        this.logger.debug("", (Throwable)exDe);
                    }
                }
                if (!(e instanceof IOException)) break block26;
                this.disconnect();
            }
        }
    }

    Message readIncoming() throws DBusException {
        Message m;
        block4: {
            if (!this.connected) {
                return null;
            }
            m = null;
            try {
                m = this.transport.readMessage();
            }
            catch (IOException exIo) {
                if (!this.run && exIo instanceof EOFException) {
                    return null;
                }
                if (!this.run) break block4;
                throw new FatalDBusException(exIo.getMessage());
            }
        }
        return m;
    }

    protected Map<String, ExportedObject> getExportedObjects() {
        return this.exportedObjects;
    }

    FallbackContainer getFallbackContainer() {
        return this.fallbackContainer;
    }

    public static DBusCallInfo getCallInfo() {
        return INFOMAP.get(Thread.currentThread());
    }

    public DBusExecutionException getError() {
        Error poll = this.getPendingErrorQueue().poll();
        if (poll != null) {
            return poll.getException();
        }
        return null;
    }

    public BusAddress getAddress() {
        return this.busAddress;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected Queue<Error> getPendingErrorQueue() {
        return this.pendingErrorQueue;
    }

    protected Map<SignalTuple, List<DBusSigHandler<? extends DBusSignal>>> getHandledSignals() {
        return this.handledSignals;
    }

    protected Map<Long, MethodCall> getPendingCalls() {
        return this.pendingCalls;
    }

    protected Map<DBusInterface, RemoteObject> getImportedObjects() {
        return this.importedObjects;
    }

    protected ObjectTree getObjectTree() {
        return this.objectTree;
    }
}

