/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import com.github.hypfvieh.util.FileIoUtil;
import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Local;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.types.UInt32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBusConnection
extends AbstractConnection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_SYSTEM_BUS_ADDRESS = "unix:path=/var/run/dbus/system_bus_socket";
    private List<String> busnames;
    private static final ConcurrentMap<String, DBusConnection> CONNECTIONS = new ConcurrentHashMap<String, DBusConnection>();
    private DBus dbus;
    private final String machineId;
    private final AtomicInteger concurrentConnections = new AtomicInteger(1);
    private final boolean shared;

    public static DBusConnection getConnection(String _address) throws DBusException {
        return DBusConnection.getConnection(_address, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusConnection getConnection(String _address, boolean _registerSelf, boolean _shared) throws DBusException {
        if (_shared) {
            ConcurrentMap<String, DBusConnection> concurrentMap = CONNECTIONS;
            synchronized (concurrentMap) {
                DBusConnection c = (DBusConnection)CONNECTIONS.get(_address);
                if (c != null) {
                    c.concurrentConnections.incrementAndGet();
                    return c;
                }
                c = new DBusConnection(_address, _shared, _registerSelf, DBusConnection.getDbusMachineId());
                CONNECTIONS.put(_address, c);
                return c;
            }
        }
        return new DBusConnection(_address, _shared, _registerSelf, DBusConnection.getDbusMachineId());
    }

    private static DBusConnection getConnection(Supplier<String> _addressGenerator, boolean _registerSelf, boolean _shared) throws DBusException {
        if (_addressGenerator == null) {
            throw new DBusException("Invalid address generator");
        }
        String address = _addressGenerator.get();
        if (address == null) {
            throw new DBusException("null is not a valid DBUS address");
        }
        return DBusConnection.getConnection(address, _registerSelf, _shared);
    }

    public static DBusConnection getConnection(DBusBusType _bustype) throws DBusException {
        return DBusConnection.getConnection(_bustype, true);
    }

    public static DBusConnection newConnection(DBusBusType _bustype) throws DBusException {
        return DBusConnection.getConnection(_bustype, false);
    }

    public static DBusConnection getConnection(DBusBusType _bustype, boolean _shared) throws DBusException {
        switch (_bustype) {
            case SYSTEM: {
                DBusConnection systemConnection = DBusConnection.getConnection(() -> {
                    String bus = System.getenv("DBUS_SYSTEM_BUS_ADDRESS");
                    if (bus == null) {
                        bus = DEFAULT_SYSTEM_BUS_ADDRESS;
                    }
                    return bus;
                }, true, _shared);
                return systemConnection;
            }
            case SESSION: {
                DBusConnection sessionConnection = DBusConnection.getConnection(() -> {
                    String s = null;
                    s = SystemUtil.isMacOs() ? "unix:path=" + System.getenv("DBUS_LAUNCHD_SESSION_BUS_SOCKET") : System.getenv("DBUS_SESSION_BUS_ADDRESS");
                    if (s == null) {
                        String display = System.getenv("DISPLAY");
                        if (null == display) {
                            throw new RuntimeException("Cannot Resolve Session Bus Address");
                        }
                        if (!display.startsWith(":") && display.contains(":")) {
                            display = display.substring(display.indexOf(58));
                        }
                        try {
                            String uuid = DBusConnection.getDbusMachineId();
                            String homedir = System.getProperty("user.home");
                            File addressfile = new File(homedir + "/.dbus/session-bus", uuid + "-" + display.replaceAll(":([0-9]*)\\..*", "$1"));
                            if (!addressfile.exists()) {
                                throw new RuntimeException("Cannot Resolve Session Bus Address");
                            }
                            Properties readProperties = FileIoUtil.readProperties((File)addressfile);
                            String sessionAddress = readProperties.getProperty("DBUS_SESSION_BUS_ADDRESS");
                            if (StringUtil.isEmpty((String)sessionAddress)) {
                                throw new RuntimeException("Cannot Resolve Session Bus Address");
                            }
                            return sessionAddress;
                        }
                        catch (DBusException _ex) {
                            throw new RuntimeException("Cannot Resolve Session Bus Address", _ex);
                        }
                    }
                    return s;
                }, true, _shared);
                return sessionConnection;
            }
        }
        throw new DBusException("Invalid Bus Type: " + (Object)((Object)_bustype));
    }

    private AtomicInteger getConcurrentConnections() {
        return this.concurrentConnections;
    }

    public static String getDbusMachineId() throws DBusException {
        File uuidfile = new File("/var/lib/dbus/machine-id");
        if (!uuidfile.exists()) {
            uuidfile = new File("/usr/local/var/lib/dbus/machine-id");
        }
        if (!uuidfile.exists()) {
            uuidfile = new File("/etc/machine-id");
        }
        if (!uuidfile.exists()) {
            throw new DBusException("Cannot Resolve Session Bus Address");
        }
        String uuid = FileIoUtil.readFileToString((File)uuidfile);
        if (StringUtil.isEmpty((String)uuid)) {
            throw new DBusException("Cannot Resolve Session Bus Address: MachineId file is empty.");
        }
        return uuid;
    }

    private DBusConnection(String _address, boolean _shared, boolean _registerSelf, String _machineId) throws DBusException {
        super(_address);
        this.busnames = new ArrayList<String>();
        this.machineId = _machineId;
        this.shared = _shared;
        this.listen();
        SigHandler h = new SigHandler();
        this.addSigHandlerWithoutMatch(Local.Disconnected.class, h);
        this.addSigHandlerWithoutMatch(DBus.NameAcquired.class, h);
        if (_registerSelf) {
            this.dbus = this.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
            try {
                this.busnames.add(this.dbus.Hello());
            }
            catch (DBusExecutionException dbee) {
                this.logger.debug("", (Throwable)dbee);
                throw new DBusException(dbee.getMessage());
            }
        }
    }

    protected DBusInterface dynamicProxy(String _source, String _path) throws DBusException {
        this.logger.debug("Introspecting {} on {} for dynamic proxy creation", (Object)_path, (Object)_source);
        try {
            Introspectable intro = this.getRemoteObject(_source, _path, Introspectable.class);
            String data = intro.Introspect();
            this.logger.trace("Got introspection data: {}", (Object)data);
            String[] tags = data.split("[<>]");
            ArrayList<String> ifaces = new ArrayList<String>();
            for (String tag : tags) {
                if (!tag.startsWith("interface")) continue;
                ifaces.add(tag.replaceAll("^interface *name *= *['\"]([^'\"]*)['\"].*$", "$1"));
            }
            ArrayList ifcs = new ArrayList();
            block5: for (String iface : ifaces) {
                if (iface.startsWith("org.freedesktop.DBus.")) {
                    iface = iface.replaceAll("^.*\\.([^\\.]+)$", DBusInterface.class.getPackage().getName() + ".$1");
                }
                this.logger.debug("Trying interface {}", (Object)iface);
                int j = 0;
                while (j >= 0) {
                    try {
                        Class<?> ifclass = Class.forName(iface);
                        if (ifcs.contains(ifclass)) continue block5;
                        ifcs.add(ifclass);
                        continue block5;
                    }
                    catch (Exception ifclass) {
                        j = iface.lastIndexOf(".");
                        char[] cs = iface.toCharArray();
                        if (j < 0) continue;
                        cs[j] = 36;
                        iface = String.valueOf(cs);
                    }
                }
            }
            if (ifcs.isEmpty()) {
                ifcs.add(DBusInterface.class);
            }
            RemoteObject ro = new RemoteObject(_source, _path, null, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(((Class)ifcs.get(0)).getClassLoader(), ifcs.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.getImportedObjects().put(newi, ro);
            return newi;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusException(String.format("Failed to create proxy object for %s exported by %s. Reason: %s", _path, _source, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBusInterface getExportedObject(String _source, String _path) throws DBusException {
        ExportedObject o = null;
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            o = this.getExportedObjects().get(_path);
        }
        if (null != o && null == o.getObject().get()) {
            this.unExportObject(_path);
            o = null;
        }
        if (null != o) {
            return o.getObject().get();
        }
        if (null == _source) {
            throw new DBusException("Not an object exported by this connection and no remote specified");
        }
        return this.dynamicProxy(_source, _path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBusName(String _busname) throws DBusException {
        if (!_busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || _busname.length() > 255) {
            throw new DBusException("Invalid bus name");
        }
        List<String> list = this.busnames;
        synchronized (list) {
            try {
                this.dbus.ReleaseName(_busname);
            }
            catch (DBusExecutionException dbee) {
                this.logger.debug("", (Throwable)dbee);
                throw new DBusException(dbee.getMessage());
            }
            this.busnames.remove(_busname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBusName(String _busname) throws DBusException {
        if (!_busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || _busname.length() > 255) {
            throw new DBusException("Invalid bus name");
        }
        List<String> list = this.busnames;
        synchronized (list) {
            UInt32 rv;
            try {
                rv = this.dbus.RequestName(_busname, new UInt32(6L));
            }
            catch (DBusExecutionException dbee) {
                this.logger.debug("", (Throwable)dbee);
                throw new DBusException(dbee.getMessage());
            }
            switch (rv.intValue()) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new DBusException("Failed to register bus name");
                }
                case 3: {
                    throw new DBusException("Failed to register bus name");
                }
                case 4: {
                    break;
                }
            }
            this.busnames.add(_busname);
        }
    }

    public String getUniqueName() {
        return this.busnames.get(0);
    }

    public String[] getNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(this.busnames);
        return names.toArray(new String[0]);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String _busname, String _objectpath, Class<I> _type) throws DBusException {
        return this.getPeerRemoteObject(_busname, _objectpath, _type, true);
    }

    public DBusInterface getPeerRemoteObject(String _busname, String _objectpath) throws DBusException {
        if (null == _busname) {
            throw new DBusException("Invalid bus name: null");
        }
        if (!_busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !_busname.matches("^:[0-9]*\\.[0-9]*$") || _busname.length() > 255) {
            throw new DBusException("Invalid bus name: " + _busname);
        }
        String unique = this.dbus.GetNameOwner(_busname);
        return this.dynamicProxy(unique, _objectpath);
    }

    public DBusInterface getRemoteObject(String _busname, String _objectpath) throws DBusException {
        if (null == _busname) {
            throw new DBusException("Invalid bus name: null");
        }
        if (null == _objectpath) {
            throw new DBusException("Invalid object path: null");
        }
        if (!_busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !_busname.matches("^:[0-9]*\\.[0-9]*$") || _busname.length() > 255) {
            throw new DBusException("Invalid bus name: " + _busname);
        }
        if (!_objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || _objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + _objectpath);
        }
        return this.dynamicProxy(_busname, _objectpath);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String _busname, String _objectpath, Class<I> _type, boolean _autostart) throws DBusException {
        if (null == _busname) {
            throw new DBusException("Invalid bus name: null");
        }
        if (!_busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !_busname.matches("^:[0-9]*\\.[0-9]*$") || _busname.length() > 255) {
            throw new DBusException("Invalid bus name: " + _busname);
        }
        String unique = this.dbus.GetNameOwner(_busname);
        return this.getRemoteObject(unique, _objectpath, _type, _autostart);
    }

    public <I extends DBusInterface> I getRemoteObject(String _busname, String _objectpath, Class<I> _type) throws DBusException {
        return this.getRemoteObject(_busname, _objectpath, _type, true);
    }

    public <I extends DBusInterface> I getRemoteObject(String _busname, String _objectpath, Class<I> _type, boolean _autostart) throws DBusException {
        if (null == _busname) {
            throw new DBusException("Invalid bus name: null");
        }
        if (null == _objectpath) {
            throw new DBusException("Invalid object path: null");
        }
        if (null == _type) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (!_busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !_busname.matches("^:[0-9]*\\.[0-9]*$") || _busname.length() > 255) {
            throw new DBusException("Invalid bus name: " + _busname);
        }
        if (!_objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || _objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + _objectpath);
        }
        if (!DBusInterface.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (_type.getName().equals(_type.getSimpleName())) {
            throw new DBusException("DBusInterfaces cannot be declared outside a package");
        }
        RemoteObject ro = new RemoteObject(_busname, _objectpath, _type, _autostart);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(_type.getClassLoader(), new Class[]{_type}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.getImportedObjects().put(i, ro);
        return (I)i;
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> _type, String _source, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (_source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (!_source.matches("^:[0-9]*\\.[0-9]*$") || _source.length() > 255) {
            throw new DBusException("Invalid bus name: " + _source);
        }
        this.removeSigHandler(new DBusMatchRule(_type, _source, null), _handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> _type, String _source, DBusInterface _object, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (_source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (!_source.matches("^:[0-9]*\\.[0-9]*$") || _source.length() > 255) {
            throw new DBusException("Invalid bus name: " + _source);
        }
        String objectpath = this.getImportedObjects().get(_object).getObjectPath();
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(_type, _source, objectpath), _handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule _rule, DBusSigHandler<T> _handler) throws DBusException {
        SignalTuple key = new SignalTuple(_rule.getInterface(), _rule.getMember(), _rule.getObject(), _rule.getSource());
        Map<SignalTuple, List<DBusSigHandler<? extends DBusSignal>>> map = this.getHandledSignals();
        synchronized (map) {
            List<DBusSigHandler<? extends DBusSignal>> v = this.getHandledSignals().get(key);
            if (null != v) {
                v.remove(_handler);
                if (0 == v.size()) {
                    this.getHandledSignals().remove(key);
                    try {
                        this.dbus.RemoveMatch(_rule.toString());
                    }
                    catch (NotConnected exNc) {
                        this.logger.debug("No connection.", (Throwable)exNc);
                    }
                    catch (DBusExecutionException dbee) {
                        this.logger.debug("", (Throwable)dbee);
                        throw new DBusException(dbee);
                    }
                }
            }
        }
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> _type, String _source, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (_source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (!_source.matches("^:[0-9]*\\.[0-9]*$") || _source.length() > 255) {
            throw new DBusException("Invalid bus name: " + _source);
        }
        this.addSigHandler(new DBusMatchRule(_type, _source, null), _handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> _type, String _source, DBusInterface _object, DBusSigHandler<T> _handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (_source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (!_source.matches("^:[0-9]*\\.[0-9]*$") || _source.length() > 255) {
            throw new DBusException("Invalid bus name: " + _source);
        }
        String objectpath = this.getImportedObjects().get(_object).getObjectPath();
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(_type, _source, objectpath), _handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DBusSignal> void addSigHandler(DBusMatchRule _rule, DBusSigHandler<T> _handler) throws DBusException {
        try {
            this.dbus.AddMatch(_rule.toString());
        }
        catch (DBusExecutionException dbee) {
            this.logger.debug("", (Throwable)dbee);
            throw new DBusException(dbee.getMessage());
        }
        SignalTuple key = new SignalTuple(_rule.getInterface(), _rule.getMember(), _rule.getObject(), _rule.getSource());
        Map<SignalTuple, List<DBusSigHandler<? extends DBusSignal>>> map = this.getHandledSignals();
        synchronized (map) {
            List<DBusSigHandler<? extends DBusSignal>> v = this.getHandledSignals().get(key);
            if (null == v) {
                v = new ArrayList<DBusSigHandler<? extends DBusSignal>>();
                v.add(_handler);
                this.getHandledSignals().put(key, v);
            } else {
                v.add(_handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        if (this.shared) {
            ConcurrentMap<String, DBusConnection> concurrentMap = CONNECTIONS;
            synchronized (concurrentMap) {
                DBusConnection connection = (DBusConnection)CONNECTIONS.get(this.getAddress().getRawAddress());
                if (connection != null) {
                    if (connection.getConcurrentConnections().get() <= 1) {
                        this.logger.debug("Disconnecting last remaining DBusConnection");
                        try {
                            Error err = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected");
                            this.cleanupPendingCalls(err, true);
                            Queue<Error> queue = this.getPendingErrorQueue();
                            synchronized (queue) {
                                this.getPendingErrorQueue().add(err);
                            }
                        }
                        catch (DBusException dBusException) {
                            // empty catch block
                        }
                        CONNECTIONS.remove(this.getAddress().getRawAddress());
                        super.disconnect();
                    } else {
                        this.logger.debug("Still {} connections left, decreasing connection counter", (Object)(connection.getConcurrentConnections().get() - 1));
                        connection.getConcurrentConnections().addAndGet(-1);
                    }
                }
            }
        }
        super.disconnect();
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupPendingCalls(Error _err, boolean _clearPendingCalls) throws DBusException {
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            Iterator<Map.Entry<Long, MethodCall>> iter = this.getPendingCalls().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, MethodCall> entry = iter.next();
                if (entry.getKey() == -1L) continue;
                MethodCall m = entry.getValue();
                iter.remove();
                if (m == null) continue;
                m.setReply(_err);
            }
            if (_clearPendingCalls) {
                this.getPendingCalls().clear();
            }
        }
    }

    @Override
    public String getMachineId() {
        return this.machineId;
    }

    public static enum DBusBusType {
        SYSTEM,
        SESSION;

    }

    private class SigHandler
    implements DBusSigHandler<DBusSignal> {
        private SigHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(DBusSignal _signal) {
            if (_signal instanceof Local.Disconnected) {
                DBusConnection.this.logger.debug("Handling Disconnected signal from bus");
                try {
                    Error err = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected");
                    DBusConnection.this.cleanupPendingCalls(err, false);
                    Queue queue = DBusConnection.this.getPendingErrorQueue();
                    synchronized (queue) {
                        DBusConnection.this.getPendingErrorQueue().add(err);
                    }
                }
                catch (DBusException dBusException) {}
            } else if (_signal instanceof DBus.NameAcquired) {
                DBusConnection.this.busnames.add(((DBus.NameAcquired)_signal).name);
            }
        }
    }
}

