/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils.generator;

import com.github.hypfvieh.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.freedesktop.dbus.utils.generator.TypeConverter;

public class ClassBuilderInfo {
    private final Set<String> imports = new LinkedHashSet<String>();
    private final List<ClassMember> members = new ArrayList<ClassMember>();
    private final Set<String> implementedInterfaces = new LinkedHashSet<String>();
    private final List<ClassMethod> methods = new ArrayList<ClassMethod>();
    private final List<ClassBuilderInfo> innerClasses = new ArrayList<ClassBuilderInfo>();
    private final List<ClassConstructor> constructors = new ArrayList<ClassConstructor>();
    private String className;
    private String packageName;
    private ClassType classType;
    private String extendClass;

    public Set<String> getImports() {
        return this.imports;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String _packageName) {
        this.packageName = _packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String _className) {
        this.className = _className;
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public void setClassType(ClassType _classType) {
        this.classType = _classType;
    }

    public Set<String> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public String getExtendClass() {
        return this.extendClass;
    }

    public void setExtendClass(String _extendClass) {
        this.extendClass = _extendClass;
    }

    public List<ClassMethod> getMethods() {
        return this.methods;
    }

    public List<ClassMember> getMembers() {
        return this.members;
    }

    public List<ClassBuilderInfo> getInnerClasses() {
        return this.innerClasses;
    }

    public List<ClassConstructor> getConstructors() {
        return this.constructors;
    }

    public String createClassFileContent() {
        List<String> result = this.createClassFileContent(false, null);
        return String.join((CharSequence)System.lineSeparator(), result);
    }

    private List<String> createClassFileContent(boolean _staticClass, Set<String> _otherImports) {
        String memberType;
        String memberIndent;
        ArrayList<String> content = new ArrayList<String>();
        String classIndent = _staticClass ? "    " : "";
        String string = memberIndent = _staticClass ? "        " : "    ";
        if (!_staticClass) {
            content.add("package " + this.getPackageName() + ";");
            content.add("");
            content.add("/**");
            content.add(" * Auto-generated class.");
            content.add(" */");
        } else {
            content.add("");
            if (_otherImports != null) {
                _otherImports.addAll(this.getImports());
            }
        }
        String bgn = classIndent + "public " + (_staticClass ? "static " : "") + (this.getClassType() == ClassType.INTERFACE ? "interface" : "class");
        bgn = bgn + " " + this.getClassName();
        if (this.getExtendClass() != null) {
            if (!this.getExtendClass().startsWith("java.lang.")) {
                this.getImports().add(this.getExtendClass());
            }
            bgn = bgn + " extends " + ClassBuilderInfo.getClassName(this.getExtendClass());
        }
        if (!this.getImplementedInterfaces().isEmpty()) {
            bgn = bgn + " implements " + this.getImplementedInterfaces().stream().map(e -> ClassBuilderInfo.getClassName(e)).collect(Collectors.joining(", "));
            this.getImports().addAll(this.getImplementedInterfaces().stream().filter(s -> !s.startsWith("java.lang.")).collect(Collectors.toList()));
        }
        bgn = bgn + " {";
        content.add(bgn);
        if (_staticClass) {
            content.add("");
        }
        for (ClassMember member : this.members) {
            if (!member.getAnnotations().isEmpty()) {
                content.addAll(member.getAnnotations().stream().map(l -> memberIndent + l).collect(Collectors.toList()));
            }
            memberType = TypeConverter.getProperJavaClass(member.getType(), _otherImports);
            if (!member.getGenerics().isEmpty()) {
                memberType = memberType + "<" + member.getGenerics().stream().map(c -> TypeConverter.getProperJavaClass(c, _otherImports)).collect(Collectors.joining(" ,")) + ">";
            }
            content.add(memberIndent + "private " + (member.isFinalMember() ? "final " : "") + memberType + " " + member.getName() + ";");
        }
        if (!this.getConstructors().isEmpty()) {
            for (ClassConstructor constructor : this.getConstructors()) {
                String cstr = "    " + this.getClassName() + "(";
                if (!constructor.getArguments().isEmpty()) {
                    cstr = cstr + constructor.getArguments().entrySet().stream().map(e -> (String)e.getValue() + " " + (String)e.getKey()).collect(Collectors.joining(", "));
                }
                cstr = cstr + ") {";
                content.add(cstr);
                if (!constructor.getSuperArguments().isEmpty()) {
                    content.add("super(" + String.join((CharSequence)", ", constructor.getSuperArguments()) + ");");
                }
                if (!constructor.getArguments().isEmpty()) {
                    for (Map.Entry<String, String> e2 : constructor.getArguments().entrySet()) {
                        content.add("this." + e2.getKey() + " = " + e2.getKey() + ";");
                    }
                }
                content.add("}");
            }
        }
        content.add("");
        for (ClassMember member : this.members) {
            memberType = TypeConverter.getProperJavaClass(member.getType(), _otherImports);
            if (!member.getGenerics().isEmpty()) {
                memberType = memberType + "<" + member.getGenerics().stream().map(c -> TypeConverter.getProperJavaClass(c, _otherImports)).collect(Collectors.joining(" ,")) + ">";
            }
            if (!member.isFinalMember()) {
                content.add(memberIndent + "public void set" + StringUtil.upperCaseFirstChar((String)member.getName()) + "(" + memberType + " arg) {");
                content.add(memberIndent + "    " + member.getName() + " = arg;");
                content.add(memberIndent + "}");
            }
            content.add("");
            content.add(memberIndent + "public " + memberType + " get" + StringUtil.upperCaseFirstChar((String)member.getName()) + "() {");
            content.add(memberIndent + "    return " + member.getName() + ";");
            content.add(memberIndent + "}");
        }
        content.add("");
        for (ClassMethod mth : this.getMethods()) {
            if (!mth.getAnnotations().isEmpty()) {
                content.addAll(mth.getAnnotations().stream().map(a -> memberIndent + a).collect(Collectors.toList()));
            }
            String clzMth = memberIndent + "public " + (mth.getReturnType() == null ? "void " : TypeConverter.getProperJavaClass(mth.getReturnType(), _otherImports) + " ");
            clzMth = clzMth + mth.getName() + "(";
            if (!mth.getArguments().isEmpty()) {
                clzMth = clzMth + mth.getArguments().entrySet().stream().map(e -> (String)e.getValue() + " " + (String)e.getKey()).collect(Collectors.joining(", "));
            }
            clzMth = clzMth + ");";
            content.add(clzMth);
        }
        content.add("");
        for (ClassBuilderInfo inner : this.getInnerClasses()) {
            content.addAll(inner.createClassFileContent(true, this.getImports()));
        }
        content.add(classIndent + "}");
        if (!_staticClass) {
            content.add(2, "");
            content.addAll(2, this.getImports().stream().filter(l -> !l.startsWith("java.lang.")).map(l -> "import " + l + ";").collect(Collectors.toList()));
        }
        return content;
    }

    public String getFileName() {
        if (this.getClassName() == null) {
            return null;
        }
        if (this.getPackageName() == null) {
            return this.getClassName() + ".java";
        }
        return this.getPackageName().replace(".", File.separator) + File.separator + this.getClassName() + ".java";
    }

    public String getFqcn() {
        return StringUtil.isBlank((String)this.getPackageName()) ? this.getClassName() : this.getPackageName() + "." + this.getClassName();
    }

    static String getClassName(String _fqcn) {
        if (_fqcn == null) {
            return null;
        }
        String clzzName = _fqcn;
        if (clzzName.contains(".")) {
            clzzName = clzzName.substring(clzzName.lastIndexOf(".") + 1);
        }
        return clzzName;
    }

    public static enum ClassType {
        INTERFACE,
        CLASS;

    }

    public static class ClassConstructor {
        private final Map<String, String> arguments = new LinkedHashMap<String, String>();
        private final List<String> superArguments = new ArrayList<String>();

        public Map<String, String> getArguments() {
            return this.arguments;
        }

        public List<String> getSuperArguments() {
            return this.superArguments;
        }
    }

    public static class ClassMember {
        private final String name;
        private final String type;
        private final boolean finalMember;
        private final List<String> generics = new ArrayList<String>();
        private final List<String> annotations = new ArrayList<String>();

        public ClassMember(String _name, String _type, boolean _finalMember) {
            this.name = _name;
            this.type = _type;
            this.finalMember = _finalMember;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isFinalMember() {
            return this.finalMember;
        }

        public List<String> getGenerics() {
            return this.generics;
        }
    }

    public static class ClassMethod {
        private final String name;
        private final String returnType;
        private final boolean finalMethod;
        private final Map<String, String> arguments = new LinkedHashMap<String, String>();
        private final List<String> annotations = new ArrayList<String>();

        public ClassMethod(String _name, String _returnType, boolean _finalMethod) {
            this.name = _name;
            this.returnType = _returnType;
            this.finalMethod = _finalMethod;
        }

        public String getName() {
            return this.name;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public boolean isFinalMethod() {
            return this.finalMethod;
        }

        public Map<String, String> getArguments() {
            return this.arguments;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }
    }
}

