/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import com.github.hypfvieh.util.FileIoUtil;
import com.github.hypfvieh.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.Transport;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowLevelTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Test
    public void testLowLevel() throws ParseException, IOException, DBusException {
        String addr = LowLevelTest.getAddress();
        this.logger.debug(addr);
        BusAddress address = new BusAddress(addr);
        this.logger.debug(address + "");
        try (Transport conn = new Transport(address);){
            MethodCall m = new MethodCall("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "Hello", 0, null, new Object[0]);
            conn.writeMessage((Message)m);
            m = conn.readMessage();
            this.logger.debug(m.getClass() + "");
            this.logger.debug(m + "");
            m = conn.readMessage();
            this.logger.debug(m.getClass() + "");
            this.logger.debug(m + "");
            m = new MethodCall("org.freedesktop.DBus", "/", null, "Hello", 0, null, new Object[0]);
            conn.writeMessage((Message)m);
            m = conn.readMessage();
            this.logger.debug(m + "");
            m = new MethodCall("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "RequestName", 0, "su", new Object[]{"org.testname", 0});
            conn.writeMessage((Message)m);
            m = conn.readMessage();
            this.logger.debug(m + "");
            m = new DBusSignal(null, "/foo", "org.foo", "Foo", null, new Object[0]);
            conn.writeMessage((Message)m);
            m = conn.readMessage();
            this.logger.debug(m + "");
        }
    }

    static String getAddress() throws DBusException {
        String s = System.getenv("DBUS_SESSION_BUS_ADDRESS");
        if (s == null) {
            String display = System.getenv("DISPLAY");
            if (null == display) {
                throw new RuntimeException("Cannot Resolve Session Bus Address");
            }
            if (!display.startsWith(":") && display.contains(":")) {
                display = display.substring(display.indexOf(58));
            }
            String uuid = DBusConnection.getDbusMachineId();
            String homedir = System.getProperty("user.home");
            File addressfile = new File(homedir + "/.dbus/session-bus", uuid + "-" + display.replaceAll(":([0-9]*)\\..*", "$1"));
            if (!addressfile.exists()) {
                throw new RuntimeException("Cannot Resolve Session Bus Address");
            }
            Properties readProperties = FileIoUtil.readProperties((File)addressfile);
            String sessionAddress = readProperties.getProperty("DBUS_SESSION_BUS_ADDRESS");
            if (StringUtil.isEmpty((String)sessionAddress)) {
                throw new RuntimeException("Cannot Resolve Session Bus Address");
            }
            return sessionAddress;
        }
        return s;
    }
}

