/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MarshallingFileDescriptorTest {
    private static final String TEST_OBJECT_PATH = "/TestFileDescriptor";
    private static final String TEST_BUSNAME = "foo.bar.TestFileDescriptor";
    private DBusConnection serverConn;
    private DBusConnection clientConn;
    private FileInputStream sampleFileStream;

    @BeforeEach
    public void before() throws DBusException, FileNotFoundException, IOException {
        this.serverConn = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        this.clientConn = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        this.serverConn.setWeakReferences(true);
        this.clientConn.setWeakReferences(true);
        this.serverConn.requestBusName(TEST_BUSNAME);
        this.sampleFileStream = new FileInputStream(File.createTempFile("dbustest", "testFd"));
        GetFileDescriptor fd = new GetFileDescriptor(this.sampleFileStream.getFD());
        System.out.println("Created file descriptor: " + MarshallingFileDescriptorTest.getFileDescriptorIntId(this.sampleFileStream.getFD()));
        this.serverConn.exportObject(TEST_OBJECT_PATH, (DBusInterface)fd);
    }

    @AfterEach
    public void after() throws IOException {
        DBusExecutionException dbee = this.serverConn.getError();
        if (null != dbee) {
            throw dbee;
        }
        dbee = this.clientConn.getError();
        if (null != dbee) {
            throw dbee;
        }
        this.clientConn.disconnect();
        this.serverConn.disconnect();
        this.sampleFileStream.close();
    }

    @Test
    public void testFileDescriptor() throws DBusException, IOException {
        DBusInterface remoteObject = this.clientConn.getRemoteObject(TEST_BUSNAME, TEST_OBJECT_PATH, IFileDescriptor.class);
        Assertions.assertTrue((boolean)(remoteObject instanceof IFileDescriptor), (String)"Expected instance of GetFileDescriptor");
        FileDescriptor fileDescriptor = ((IFileDescriptor)remoteObject).getFileDescriptor();
        Assertions.assertNotNull((Object)fileDescriptor, (String)"Descriptor should not be null");
        Assertions.assertTrue((boolean)fileDescriptor.valid(), (String)"Descriptor has to be valid");
        int receivedFdId = MarshallingFileDescriptorTest.getFileDescriptorIntId(fileDescriptor);
        System.out.println("Received file descriptor with ID: " + receivedFdId);
        Assertions.assertEquals((int)MarshallingFileDescriptorTest.getFileDescriptorIntId(this.sampleFileStream.getFD()), (int)receivedFdId);
    }

    static int getFileDescriptorIntId(FileDescriptor _fd) {
        try {
            Field field = _fd.getClass().getDeclaredField("fd");
            field.setAccessible(true);
            return field.getInt(_fd);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException _ex) {
            return -99;
        }
    }

    @DBusInterfaceName(value="foo.bar.TestFileDescriptor")
    public static interface IFileDescriptor
    extends DBusInterface {
        public FileDescriptor getFileDescriptor();
    }

    public static class GetFileDescriptor
    implements IFileDescriptor {
        private final FileDescriptor fileDescriptor;

        public GetFileDescriptor(FileDescriptor _descriptor) {
            this.fileDescriptor = _descriptor;
        }

        public boolean isRemote() {
            return false;
        }

        public String getObjectPath() {
            return null;
        }

        @Override
        public FileDescriptor getFileDescriptor() {
            return this.fileDescriptor;
        }
    }
}

