/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.callbacks.handler;

import java.text.Collator;
import java.util.concurrent.atomic.AtomicInteger;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.test.helper.SampleException;
import org.junit.jupiter.api.Assertions;

public class CallbackHandlerImpl
implements CallbackHandler<String> {
    private final AtomicInteger testHandleCalls = new AtomicInteger(0);
    private final AtomicInteger testErrorCalls = new AtomicInteger(0);
    private final int handleCalls;
    private final int errorCalls;

    public CallbackHandlerImpl(int _handleCalls, int _errorCalls) {
        this.handleCalls = _handleCalls;
        this.errorCalls = _errorCalls;
    }

    public void handle(String r) {
        this.testHandleCalls.incrementAndGet();
        Assertions.assertTrue((this.testHandleCalls.get() > this.handleCalls ? 1 : 0) != 0, (String)"Handler called to often");
        System.out.println("Handling callback: " + r);
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", r)) {
            Assertions.fail((String)"call with callback, wrong return value");
        }
    }

    public void handleError(DBusExecutionException e) {
        this.testErrorCalls.incrementAndGet();
        Assertions.assertTrue((this.testErrorCalls.get() > this.errorCalls ? 1 : 0) != 0, (String)"Handler called to often");
        System.out.println("Handling error callback: " + e + " message = '" + e.getMessage() + "'");
        if (!(e instanceof SampleException)) {
            Assertions.fail((String)"Exception is of the wrong sort");
        }
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("test", e.getMessage())) {
            Assertions.fail((String)"Exception has the wrong message");
        }
    }

    public int getTestHandleCalls() {
        return this.testHandleCalls.get();
    }

    public int getTestErrorCalls() {
        return this.testErrorCalls.get();
    }
}

