/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.signals.handler;

import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.UInt32;
import org.junit.jupiter.api.Assertions;

public class GenericHandlerWithDecode
implements DBusSigHandler<DBusSignal> {
    private final UInt32 expectedIntResult;
    private final String expectedStringResult;
    private Object[] parameters;

    public GenericHandlerWithDecode(UInt32 _expectedIntResult, String _expectedStringResult) {
        this.expectedIntResult = _expectedIntResult;
        this.expectedStringResult = _expectedStringResult;
    }

    public void handle(DBusSignal s) {
        try {
            this.parameters = s.getParameters();
        }
        catch (DBusException ex) {
            Assertions.fail((String)"Unexpected DBusException", (Throwable)ex);
        }
    }

    public UInt32 getExpectedIntResult() {
        return this.expectedIntResult;
    }

    public String getExpectedStringResult() {
        return this.expectedStringResult;
    }

    public void incomingSameAsExpected() {
        Assertions.assertEquals((int)this.parameters.length, (int)2);
        if (this.expectedIntResult != null) {
            Assertions.assertEquals((Object)((UInt32)this.parameters[0]), (Object)this.getExpectedIntResult(), (String)"Retrieved int does not match.");
        }
        if (this.expectedStringResult != null) {
            Assertions.assertEquals((Object)((String)this.parameters[1]), (Object)this.getExpectedStringResult(), (String)"Retrieved string does not match.");
        }
    }
}

