/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import com.github.hypfvieh.util.TimeMeasure;
import java.lang.reflect.Type;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.errors.ServiceUnknown;
import org.freedesktop.dbus.errors.UnknownObject;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Local;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.helper.SampleClass;
import org.freedesktop.dbus.test.helper.SampleException;
import org.freedesktop.dbus.test.helper.SampleNewInterfaceClass;
import org.freedesktop.dbus.test.helper.SampleSerializable;
import org.freedesktop.dbus.test.helper.callbacks.handler.CallbackHandlerImpl;
import org.freedesktop.dbus.test.helper.interfaces.SampleNewInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface2;
import org.freedesktop.dbus.test.helper.signals.SampleSignals;
import org.freedesktop.dbus.test.helper.signals.handler.ArraySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.BadArraySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.DisconnectHandler;
import org.freedesktop.dbus.test.helper.signals.handler.EmptySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.GenericHandlerWithDecode;
import org.freedesktop.dbus.test.helper.signals.handler.GenericSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.ObjectSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.PathSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.RenamedSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.SignalHandler;
import org.freedesktop.dbus.test.helper.structs.IntStruct;
import org.freedesktop.dbus.test.helper.structs.SampleStruct;
import org.freedesktop.dbus.test.helper.structs.SampleStruct2;
import org.freedesktop.dbus.test.helper.structs.SampleStruct3;
import org.freedesktop.dbus.test.helper.structs.SampleStruct4;
import org.freedesktop.dbus.test.helper.structs.SampleTuple;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAll {
    public static final String TEST_OBJECT_PATH = "/TestAll";
    private DBusConnection serverconn = null;
    private DBusConnection clientconn = null;
    private SampleClass tclass;

    @BeforeEach
    public void setUp() throws DBusException {
        this.serverconn = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        this.clientconn = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        this.serverconn.setWeakReferences(true);
        this.clientconn.setWeakReferences(true);
        this.serverconn.requestBusName("foo.bar.Test");
        this.tclass = new SampleClass(this.serverconn);
        this.serverconn.exportObject(TEST_OBJECT_PATH, (DBusInterface)this.tclass);
        this.serverconn.addFallback("/FallbackTest", (DBusInterface)this.tclass);
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.out.println("Checking for outstanding errors");
        DBusExecutionException dbee = this.serverconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        dbee = this.clientconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        System.out.println("Disconnecting");
        this.clientconn.disconnect();
        this.serverconn.releaseBusName("foo.bar.Test");
        this.serverconn.disconnect();
    }

    @Test
    public void testSignalHandlers() throws DBusException, InterruptedException {
        SignalHandler sigh = new SignalHandler(1, new UInt32(42L), "Bar");
        RenamedSignalHandler rsh = new RenamedSignalHandler(1, new UInt32(42L), "Bar");
        EmptySignalHandler esh = new EmptySignalHandler(1);
        ArraySignalHandler ash = new ArraySignalHandler(1);
        Peer peer = (Peer)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, Peer.class);
        DBus dbus = (DBus)this.clientconn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        System.out.print("Listening for signals...");
        this.clientconn.addSigHandler(SampleSignals.TestEmptySignal.class, (DBusSigHandler)esh);
        this.clientconn.addSigHandler(SampleSignals.TestSignal.class, (DBusSigHandler)sigh);
        this.clientconn.addSigHandler(SampleSignals.TestRenamedSignal.class, (DBusSigHandler)rsh);
        this.clientconn.addSigHandler(Local.Disconnected.class, (DBusSigHandler)new DisconnectHandler(this.clientconn, rsh));
        String source = dbus.GetNameOwner("foo.bar.Test");
        this.clientconn.addSigHandler(SampleSignals.TestArraySignal.class, source, (DBusInterface)peer, (DBusSigHandler)ash);
        this.clientconn.addSigHandler(SampleSignals.TestObjectSignal.class, (DBusSigHandler)new ObjectSignalHandler(1));
        this.clientconn.addSigHandler(SampleSignals.TestPathSignal.class, (DBusSigHandler)new PathSignalHandler(1));
        BadArraySignalHandler bash = new BadArraySignalHandler(1);
        this.clientconn.addSigHandler(SampleSignals.TestSignal.class, bash);
        this.clientconn.removeSigHandler(SampleSignals.TestSignal.class, bash);
        System.out.println("done");
        System.out.println("Sending Signal");
        this.serverconn.sendMessage((Message)new SampleSignals.TestSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
        this.serverconn.sendMessage((Message)new SampleSignals.TestEmptySignal("/foo/bar/Wibble"));
        this.serverconn.sendMessage((Message)new SampleSignals.TestRenamedSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
        Thread.sleep(1000L);
        Assertions.assertTrue((sigh.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"SignalHandler should have been called");
        Assertions.assertTrue((rsh.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"EmptySignalHandler should have been called");
        this.clientconn.removeSigHandler(SampleSignals.TestSignal.class, (DBusSigHandler)sigh);
        this.clientconn.removeSigHandler(SampleSignals.TestEmptySignal.class, (DBusSigHandler)esh);
        this.clientconn.removeSigHandler(SampleSignals.TestRenamedSignal.class, (DBusSigHandler)rsh);
    }

    @Test
    public void testGenericSignalHandler() throws DBusException, InterruptedException {
        GenericSignalHandler genericHandler = new GenericSignalHandler();
        DBusMatchRule signalRule = new DBusMatchRule("signal", "org.foo", "methodnoarg", "/");
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericHandler);
        DBusSignal signalToSend = new DBusSignal(null, "/", "org.foo", "methodnoarg", null, new Object[0]);
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        Assertions.assertTrue((genericHandler.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"GenericHandler should have been called");
        this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericHandler);
    }

    @Test
    public void testGenericDecodeSignalHandler() throws DBusException, InterruptedException {
        GenericHandlerWithDecode genericDecode = new GenericHandlerWithDecode(new UInt32(42L), "SampleString");
        DBusMatchRule signalRule = new DBusMatchRule("signal", "org.foo", "methodarg", "/");
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
        DBusSignal signalToSend = new DBusSignal(null, "/", "org.foo", "methodarg", "us", new Object[]{new UInt32(42L), "SampleString"});
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        genericDecode.incomingSameAsExpected();
        this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
    }

    @Test
    public void testGenericHandlerWithNoInterface() throws DBusException, InterruptedException {
        GenericHandlerWithDecode genericDecode = new GenericHandlerWithDecode(new UInt32(42L), "SampleString");
        DBusMatchRule signalRule = new DBusMatchRule("signal", null, "methodargNoIface", "/");
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
        DBusSignal signalToSend = new DBusSignal(null, "/", "org.foo", "methodargNoIface", "us", new Object[]{new UInt32(42L), "SampleString"});
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        genericDecode.incomingSameAsExpected();
        this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
    }

    @Test
    public void testPing() throws DBusException {
        System.out.println("Pinging ourselves");
        Peer peer = (Peer)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, Peer.class);
        TimeMeasure timeMeasure = new TimeMeasure();
        for (int i = 0; i < 10; ++i) {
            timeMeasure.reset();
            peer.Ping();
            System.out.println("Ping returned in " + timeMeasure.getElapsed() + "ms.");
        }
    }

    public void testDbusNames() throws DBusException {
        System.out.println("These things are on the bus:");
        System.out.println("Listening for Method Calls");
        SampleClass tclass = new SampleClass(this.serverconn);
        SampleClass tclass2 = new SampleClass(this.serverconn);
        this.serverconn.exportObject("/TestClassToFindOnBus", (DBusInterface)tclass);
        this.serverconn.exportObject("/SecondTestClassToFindOnBus", (DBusInterface)tclass2);
        DBus dbus = (DBus)this.clientconn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        String[] names = dbus.ListNames();
        Assertions.assertTrue((boolean)Arrays.asList(names).contains("/TestClassToFindOnBus"));
        Assertions.assertTrue((boolean)Arrays.asList(names).contains("/SecondTestClassToFindOnBus"));
        this.serverconn.unExportObject("/SecondTestClassToFindOnBus");
        this.serverconn.unExportObject("/TestClassToFindOnBus");
    }

    @Test
    public void testIntrospection() throws DBusException {
        System.out.println("Getting our introspection data");
        Introspectable intro = (Introspectable)this.clientconn.getRemoteObject("foo.bar.Test", "/", Introspectable.class);
        intro = (Introspectable)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, Introspectable.class);
        String data = intro.Introspect();
        Assertions.assertNotNull((Object)data);
        Assertions.assertTrue((boolean)data.startsWith("<!DOCTYPE"));
    }

    @Test
    public void testCallRemoteMethod() throws DBusException {
        System.out.println("Calling Method0/1");
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        System.out.println("Got Remote Object: " + tri);
        String rname = tri.getName();
        System.out.println("Got Remote Name: " + rname);
        ArrayList ts = new ArrayList();
        Marshalling.getJavaType((String)"ya{si}", ts, (int)-1);
        tri.sig(ts.toArray(new Type[0]));
        DBusPath path = new DBusPath("/nonexistantwooooooo");
        DBusPath p = tri.pathrv(path);
        System.out.println(path.toString() + " => " + p.toString());
        Assertions.assertEquals((Object)path, (Object)p, (String)"pathrv incorrect");
        ArrayList<DBusPath> paths = new ArrayList<DBusPath>();
        paths.add(path);
        List<DBusPath> ps = tri.pathlistrv(paths);
        System.out.println(((Object)paths).toString() + " => " + ps.toString());
        Assertions.assertEquals(paths, ps, (String)"pathlistrv incorrect");
        HashMap<DBusPath, DBusPath> pathm = new HashMap<DBusPath, DBusPath>();
        pathm.put(path, path);
        Map<DBusPath, DBusPath> pm = tri.pathmaprv(pathm);
        System.out.println(((Object)pathm).toString() + " => " + pm.toString());
        System.out.println(pm.containsKey(path) + " " + pm.get(path) + " " + path.equals((Object)pm.get(path)));
        System.out.println(pm.containsKey(p) + " " + pm.get(p) + " " + p.equals((Object)pm.get(p)));
        Assertions.assertTrue((boolean)pm.containsKey(path), (String)"pathmaprv incorrect");
        Assertions.assertTrue((boolean)path.equals((Object)pm.get(path)), (String)"pathmaprv incorrect");
    }

    @Test
    public void testCallGetUtf8String() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        String rname = tri.getName();
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", rname)) {
            Assertions.fail((String)"getName return value incorrect");
        }
    }

    @Test
    public void testFloats() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        DBusPath path = new DBusPath("/nonexistantwooooooo");
        DBusPath p = tri.pathrv(path);
        System.out.println(path.toString() + " => " + p.toString());
        Assertions.assertEquals((Object)path, (Object)p, (String)"pathrv incorrect");
        ArrayList<DBusPath> paths = new ArrayList<DBusPath>();
        paths.add(path);
        List<DBusPath> ps = tri.pathlistrv(paths);
        System.out.println(((Object)paths).toString() + " => " + ps.toString());
        HashMap<DBusPath, DBusPath> pathm = new HashMap<DBusPath, DBusPath>();
        pathm.put(path, path);
        this.serverconn.sendMessage((Message)new SampleSignals.TestPathSignal(TEST_OBJECT_PATH, path, paths, pathm));
        System.out.println("sending it to sleep");
        tri.waitawhile();
        System.out.println("testing floats");
        if (17.093f != tri.testfloat(new float[]{17.093f, -23.0f, 0.0f, 31.42f})) {
            Assertions.fail((String)"testfloat returned the wrong thing");
        }
    }

    @Test
    public void testStruct() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        ArrayList<List<Integer>> lli = new ArrayList<List<Integer>>();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(1);
        li.add(2);
        li.add(3);
        lli.add(li);
        lli.add(li);
        lli.add(li);
        SampleStruct3 ts3 = new SampleStruct3(new SampleStruct2(new ArrayList<String>(), (Variant<? extends Object>)new Variant((Object)0)), lli);
        int[][] out = tri.teststructstruct(ts3);
        if (out.length != 3) {
            Assertions.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
        for (int[] o : out) {
            if (o.length == 3 && o[0] == 1 && o[1] == 2 && o[2] == 3) continue;
            Assertions.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
    }

    @Test
    public void testListOfStruct() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        IntStruct elem1 = new IntStruct(3, 7);
        IntStruct elem2 = new IntStruct(9, 14);
        List<IntStruct> list = Arrays.asList(elem1, elem2);
        SampleStruct4 param = new SampleStruct4(list);
        int[][] out = tri.testListstruct(param);
        if (out.length != 2) {
            Assertions.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
        Assertions.assertEquals((int)elem1.getValue1(), (int)out[0][0]);
        Assertions.assertEquals((int)elem1.getValue2(), (int)out[0][1]);
        Assertions.assertEquals((int)elem2.getValue1(), (int)out[1][0]);
        Assertions.assertEquals((int)elem2.getValue2(), (int)out[1][1]);
    }

    public void testFrob() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        System.out.println("frobnicating");
        ArrayList<Long> ls = new ArrayList<Long>();
        ls.add(2L);
        ls.add(5L);
        ls.add(71L);
        HashMap<UInt16, Short> mus = new HashMap<UInt16, Short>();
        mus.put(new UInt16(4), (short)5);
        mus.put(new UInt16(5), (short)6);
        mus.put(new UInt16(6), (short)7);
        HashMap<String, Map<UInt16, Short>> msmus = new HashMap<String, Map<UInt16, Short>>();
        msmus.put("stuff", mus);
        int rint = tri.frobnicate(ls, msmus, 13);
        if (-5 != rint) {
            Assertions.fail((String)"frobnicate return value incorrect");
        }
    }

    @Test
    public void testCallWithCallback() throws DBusException, InterruptedException {
        CallbackHandlerImpl cbWhichThrows;
        CallbackHandlerImpl cbWhichWorks;
        block2: {
            SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
            System.out.println("Doing stuff asynchronously with callback");
            cbWhichWorks = new CallbackHandlerImpl(1, 0);
            this.clientconn.callWithCallback((DBusInterface)tri, "getName", (CallbackHandler)cbWhichWorks, new Object[0]);
            System.out.println("Doing stuff asynchronously with callback, which throws an error");
            cbWhichThrows = new CallbackHandlerImpl(1, 0);
            this.clientconn.callWithCallback((DBusInterface)tri, "getNameAndThrow", (CallbackHandler)cbWhichThrows, new Object[0]);
            try {
                System.out.println("Throwing stuff");
                tri.throwme();
                Assertions.fail((String)"Method Execution should have failed");
            }
            catch (SampleException ex) {
                System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
                if (ex.getMessage().equals("test")) break block2;
                Assertions.fail((String)"Error message was not correct");
            }
        }
        Thread.sleep(500L);
        Assertions.assertEquals((int)1, (int)cbWhichWorks.getTestHandleCalls());
        Assertions.assertEquals((int)0, (int)cbWhichThrows.getTestHandleCalls());
        Assertions.assertEquals((int)0, (int)cbWhichWorks.getTestErrorCalls());
        Assertions.assertEquals((int)1, (int)cbWhichThrows.getTestErrorCalls());
    }

    @Test
    public void testException() throws DBusException {
        block2: {
            SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
            try {
                System.out.println("Throwing stuff");
                tri.throwme();
                Assertions.fail((String)"Method Execution should have failed");
            }
            catch (SampleException ex) {
                System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
                if (ex.getMessage().equals("test")) break block2;
                Assertions.fail((String)"Error message was not correct");
            }
        }
    }

    @Test
    public void testFails() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        try {
            System.out.println("Calling Method2");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.NotATest", "/Moofle", SampleRemoteInterface.class);
            System.out.println("Got Remote Name: " + tri.getName());
            Assertions.fail((String)"Method Execution should have failed");
        }
        catch (ServiceUnknown ex) {
            System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
        }
        try {
            System.out.println("Calling Method3");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", "/Moofle", SampleRemoteInterface.class);
            System.out.println("Got Remote Name: " + tri.getName());
            Assertions.fail((String)"Method Execution should have failed");
        }
        catch (UnknownObject ex) {
            System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
        }
        try {
            System.out.println("Calling Method4");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", "/BadTest", SampleRemoteInterface.class);
            System.out.println("Got Remote Name: " + tri.getName());
            Assertions.fail((String)"Method Execution should have failed");
        }
        catch (UnknownObject ex) {
            System.out.println("Remote Method Failed with: " + ((Object)((Object)ex)).getClass().getName() + " " + ex.getMessage());
        }
    }

    @Test
    public void testFallback() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", "/FallbackTest/0/1", SampleRemoteInterface.class);
        Introspectable intro = (Introspectable)this.clientconn.getRemoteObject("foo.bar.Test", "/FallbackTest/0/4", Introspectable.class);
        Assertions.assertEquals((Object)"This Is A UTF-8 Name: \u0633 !!", (Object)tri.getName());
        Assertions.assertTrue((boolean)intro.Introspect().startsWith("<!DOCTYPE"));
    }

    @Test
    public void testGetProperties() throws DBusException {
        Properties prop = (Properties)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, Properties.class);
        DBusPath prv = (DBusPath)prop.Get("foo.bar", "foo");
        System.out.println("Got path " + prv);
        Assertions.assertEquals((Object)prv.getPath(), (Object)"/nonexistant/path");
    }

    @Test
    public void testExportPath() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        System.out.print("Calling the other introspect method: ");
        String intro2 = tri2.Introspect();
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("Not XML", intro2)) {
            Assertions.fail((String)"Introspect return value incorrect");
        }
    }

    @Test
    public void testResponse() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        System.out.println(tri2.Introspect());
        SampleTuple<String, List<Integer>, Boolean> rv = tri2.show(234);
        System.out.println("Show returned: " + rv);
        if (!this.serverconn.getUniqueName().equals(rv.getFirstValue()) || 1 != rv.getSecondValue().size() || 1953 != rv.getSecondValue().get(0) || !rv.getThirdValue().booleanValue()) {
            Assertions.fail((String)("show return value incorrect (" + rv.getFirstValue() + "," + rv.getSecondValue() + "," + rv.getThirdValue() + ")"));
        }
        System.out.println("Doing stuff asynchronously");
        DBusAsyncReply stuffreply = this.clientconn.callMethodAsync((DBusInterface)tri2, "dostuff", new Object[]{new SampleStruct("bar", new UInt32(52L), new Variant((Object)Boolean.TRUE))});
        Thread.sleep(500L);
        Assertions.assertFalse((boolean)tri2.check(), (String)"bools are broken");
        Assertions.assertTrue((boolean)((Boolean)stuffreply.getReply()), (String)"dostuff return value incorrect");
    }

    @Test
    public void testArrays() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList<String> l = new ArrayList<String>();
        l.add("hi");
        l.add("hello");
        l.add("hej");
        l.add("hey");
        l.add("aloha");
        System.out.println("Sampling Arrays:");
        List<Integer> is = tri2.sampleArray(l, new Integer[]{1, 5, 7, 9}, new long[]{2L, 6L, 8L, 12L});
        System.out.println("sampleArray returned an array:");
        for (Integer i : is) {
            System.out.println("--" + i);
        }
        Assertions.assertEquals((int)5, (int)is.size());
        Assertions.assertEquals((int)-1, (int)is.get(0));
        Assertions.assertEquals((int)-5, (int)is.get(1));
        Assertions.assertEquals((int)-7, (int)is.get(2));
        Assertions.assertEquals((int)-12, (int)is.get(3));
        Assertions.assertEquals((int)-18, (int)is.get(4));
        Assertions.assertEquals((Object)this.tclass, (Object)tri2.getThis(tri2), (String)"Didn't get the correct this");
        System.out.print("Sending Array Signal...");
        ArrayList<SampleStruct2> tsl = new ArrayList<SampleStruct2>();
        tsl.add(new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(567L))));
        HashMap<UInt32, SampleStruct2> tsm = new HashMap<UInt32, SampleStruct2>();
        tsm.put(new UInt32(1L), new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(678L))));
        tsm.put(new UInt32(42L), new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(789L))));
        this.serverconn.sendMessage((Message)new SampleSignals.TestArraySignal(TEST_OBJECT_PATH, tsl, tsm));
    }

    public void testSerialization() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList<Integer> v = new ArrayList<Integer>();
        v.add(1);
        v.add(2);
        v.add(3);
        SampleSerializable<String> s = new SampleSerializable<String>(1, "woo", v);
        s = tri2.testSerializable((byte)12, s, 13);
        System.out.print("returned: " + s);
        if (s.getInt() != 1 || !s.getString().equals("woo") || s.getList().size() != 3 || s.getList().get(0) != 1 || s.getList().get(1) != 2 || s.getList().get(2) != 3) {
            Assertions.fail((String)"Didn't get back the same TestSerializable");
        }
    }

    @Test
    public void testComplex() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("cow", "moo");
        tri2.complexv((Variant<? extends Object>)new Variant(m, "a{ss}"));
        System.out.println("done");
        System.out.print("testing recursion...");
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", tri2.recursionTest())) {
            Assertions.fail((String)"recursion test failed");
        }
        System.out.println("done");
        System.out.print("testing method overloading...");
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface.class);
        if (1 != tri2.overload("foo")) {
            Assertions.fail((String)"wrong overloaded method called");
        }
        if (2 != tri2.overload((byte)0)) {
            Assertions.fail((String)"wrong overloaded method called");
        }
        if (3 != tri2.overload()) {
            Assertions.fail((String)"wrong overloaded method called");
        }
        if (4 != tri.overload()) {
            Assertions.fail((String)"wrong overloaded method called");
        }
    }

    @Test
    public void testOverload() throws DBusException {
        System.out.print("testing method overloading...");
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface.class);
        Assertions.assertEquals((int)1, (int)tri2.overload("foo"));
        Assertions.assertEquals((int)2, (int)tri2.overload((byte)0));
        Assertions.assertEquals((int)3, (int)tri2.overload());
        Assertions.assertEquals((int)4, (int)tri.overload());
    }

    @Test
    public void testRegression13291() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface.class);
        System.out.print("reg13291...");
        byte[] as = new byte[10];
        for (int i = 0; i < 10; ++i) {
            as[i] = (byte)(100 - i);
        }
        tri.reg13291(as, as);
        System.out.println("done");
    }

    @Test
    public void testNestedLists() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList<List<Integer>> lli = new ArrayList<List<Integer>>();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(1);
        lli.add(li);
        List<List<Integer>> reti = tri2.checklist(lli);
        if (reti.size() != 1 || reti.get(0).size() != 1 || reti.get(0).get(0) != 1) {
            Assertions.fail((String)"Failed to check nested lists");
        }
    }

    @Test
    public void testDynamicObjectCreation() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        SampleNewInterface tni = tri2.getNew();
        Assertions.assertEquals((Object)tni.getName(), (Object)SampleNewInterfaceClass.class.getSimpleName());
    }

    @Test
    public void testNestedListsAsync() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList lli = new ArrayList();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(57);
        lli.add(li);
        DBusAsyncReply checklistReply = this.clientconn.callMethodAsync((DBusInterface)tri2, "checklist", new Object[]{lli});
        Thread.sleep(500L);
        Assertions.assertIterableEquals(lli, (Iterable)((Iterable)checklistReply.getReply()), (String)"did not get back the same as sent in async");
        Assertions.assertIterableEquals(li, (Iterable)((Iterable)((List)checklistReply.getReply()).get(0)));
    }

    @Test
    public void testNestedListsCallback() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList lli = new ArrayList();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(25);
        lli.add(li);
        NestedListCallbackHandler cbHandle = new NestedListCallbackHandler();
        this.clientconn.callWithCallback((DBusInterface)tri2, "checklist", (CallbackHandler)cbHandle, new Object[]{lli});
        Thread.sleep(500L);
        Assertions.assertIterableEquals(lli, cbHandle.getRetval(), (String)"did not get back the same as sent in async");
        Assertions.assertIterableEquals(li, (Iterable)cbHandle.getRetval().get(0));
    }

    @Test
    public void testStructAsync() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        SampleStruct struct = new SampleStruct("fizbuzz", new UInt32(5248L), new Variant((Object)2234));
        DBusAsyncReply structReply = this.clientconn.callMethodAsync((DBusInterface)tri2, "returnSamplestruct", new Object[]{struct});
        Thread.sleep(500L);
        Assertions.assertEquals((Object)((Object)struct), (Object)structReply.getReply(), (String)"struct did not match");
    }

    private class NestedListCallbackHandler
    implements CallbackHandler<List<List<Integer>>> {
        private List<List<Integer>> retval;

        private NestedListCallbackHandler() {
        }

        public void handle(List<List<Integer>> r) {
            this.retval = r;
        }

        public void handleError(DBusExecutionException e) {
        }

        List<List<Integer>> getRetval() {
            return this.retval;
        }
    }
}

