/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.helper.interfaces.TwoPartInterface;
import org.freedesktop.dbus.test.helper.interfaces.TwoPartObject;
import org.freedesktop.dbus.test.helper.twopart.TwoPartTestClient;
import org.freedesktop.dbus.test.helper.twopart.TwoPartTestServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTwoPart {
    private volatile boolean testDone = false;
    private volatile boolean serverReady = false;

    @Test
    public void testTwoPart() throws InterruptedException {
        TwoPartServer twoPartServer = new TwoPartServer();
        twoPartServer.start();
        while (!this.serverReady) {
            Thread.sleep(1500L);
        }
        try {
            System.out.println("get conn");
            DBusConnection conn = DBusConnection.newConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
            System.out.println("get remote");
            TwoPartInterface remote = (TwoPartInterface)conn.getRemoteObject("org.freedesktop.dbus.test.two_part_server", "/", TwoPartInterface.class);
            Assertions.assertNotNull((Object)remote);
            System.out.println("get object");
            TwoPartObject o = remote.getNew();
            Assertions.assertNotNull((Object)o);
            System.out.println("get name");
            Assertions.assertEquals((Object)"give name", (Object)o.getName());
            TwoPartTestClient.TwoPartTestObject tpto = new TwoPartTestClient.TwoPartTestObject();
            conn.exportObject("/TestObject", (DBusInterface)tpto);
            conn.sendMessage((Message)new TwoPartInterface.TwoPartSignal("/FromObject", tpto));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            conn.disconnect();
        }
        catch (DBusException _ex) {
            _ex.printStackTrace();
            Assertions.fail((String)"Exception in client");
        }
    }

    private class TwoPartServer
    extends Thread {
        private TwoPartServer() {
        }

        @Override
        public void run() {
            try {
                DBusConnection conn = DBusConnection.newConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
                conn.requestBusName("org.freedesktop.dbus.test.two_part_server");
                TwoPartTestServer server = new TwoPartTestServer(conn);
                conn.exportObject("/", (DBusInterface)server);
                conn.addSigHandler(TwoPartInterface.TwoPartSignal.class, (DBusSigHandler)server);
                TestTwoPart.this.serverReady = true;
                while (!TestTwoPart.this.testDone) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (DBusException _ex) {
                _ex.printStackTrace();
                Assertions.fail((String)"Exception in server");
            }
        }
    }
}

