/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.transports.AbstractTransport;

public class TcpTransport
extends AbstractTransport {
    private Socket socket;
    private final int timeout;

    TcpTransport(BusAddress _address, int _timeout) {
        super(_address);
        this.timeout = _timeout;
        this.setSaslAuthMode(2);
    }

    @Override
    void connect() throws IOException {
        if (this.getAddress().isListeningSocket()) {
            try (ServerSocket ss = new ServerSocket();){
                ss.bind(new InetSocketAddress(this.getAddress().getHost(), this.getAddress().getPort()));
                this.socket = ss.accept();
            }
        } else {
            this.socket = new Socket();
            this.getLogger().trace("Setting timeout to {} on Socket", (Object)this.timeout);
            this.socket.connect(new InetSocketAddress(this.getAddress().getHost(), this.getAddress().getPort()), this.timeout);
        }
        this.setInputReader(this.socket.getInputStream());
        this.setOutputWriter(this.socket.getOutputStream());
        this.authenticate(this.socket.getOutputStream(), this.socket.getInputStream(), this.socket);
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        super.close();
    }
}

