/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.collections.empty;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.collections.empty.ISampleCollectionInterface;
import org.freedesktop.dbus.test.collections.empty.SampleCollectionImpl;
import org.freedesktop.dbus.test.collections.empty.structs.ArrayStructIntStruct;
import org.freedesktop.dbus.test.collections.empty.structs.ArrayStructPrimitive;
import org.freedesktop.dbus.test.collections.empty.structs.DeepArrayStruct;
import org.freedesktop.dbus.test.collections.empty.structs.DeepListStruct;
import org.freedesktop.dbus.test.collections.empty.structs.DeepMapStruct;
import org.freedesktop.dbus.test.collections.empty.structs.IEmptyCollectionStruct;
import org.freedesktop.dbus.test.collections.empty.structs.ListMapStruct;
import org.freedesktop.dbus.test.collections.empty.structs.ListStructPrimitive;
import org.freedesktop.dbus.test.collections.empty.structs.ListStructStruct;
import org.freedesktop.dbus.test.collections.empty.structs.MapArrayStruct;
import org.freedesktop.dbus.test.collections.empty.structs.MapStructIntStruct;
import org.freedesktop.dbus.test.collections.empty.structs.MapStructPrimitive;
import org.freedesktop.dbus.test.helper.structs.IntStruct;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.LoggerFactory;

class TestEmptyCollections {
    private DBusConnection serverconn;
    private DBusConnection clientconn;
    private ISampleCollectionInterface clientObj;

    TestEmptyCollections() {
    }

    @BeforeEach
    public void setUp() {
        try {
            this.serverconn = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
            this.clientconn = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
            this.serverconn.setWeakReferences(true);
            this.clientconn.setWeakReferences(true);
            SampleCollectionImpl serverImpl = new SampleCollectionImpl();
            this.serverconn.exportObject(serverImpl.getObjectPath(), (DBusInterface)serverImpl);
            this.clientObj = (ISampleCollectionInterface)this.clientconn.getRemoteObject(this.serverconn.getUniqueName(), serverImpl.getObjectPath(), ISampleCollectionInterface.class);
        }
        catch (DBusException _ex) {
            LoggerFactory.getLogger(TestEmptyCollections.class).error("Failed to initiate dbus.", (Throwable)_ex);
        }
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        DBusExecutionException dbee = this.serverconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        dbee = this.clientconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        this.clientconn.disconnect();
        this.serverconn.disconnect();
        Thread.sleep(500L);
    }

    @DisplayName(value="testCollectionsEmpty")
    @ParameterizedTest(name="{1}")
    @MethodSource(value={"scenarios"})
    <T extends IEmptyCollectionStruct<?>> void testEmpty(ArgumentObj<T> arguments, String name) {
        IEmptyCollectionStruct object = (IEmptyCollectionStruct)((ArgumentObj)arguments).factoryEmpty.apply(name);
        String result = (String)((ArgumentObj)arguments).function.apply(this.clientObj, object);
        Assertions.assertEquals((Object)object.getValidationValue(), (Object)result);
    }

    @DisplayName(value="testCollectionsNotEmpty")
    @ParameterizedTest(name="{1}")
    @MethodSource(value={"scenarios"})
    <T extends IEmptyCollectionStruct<?>> void testNonEmpty(ArgumentObj<T> arguments, String name, String validationValue) {
        IEmptyCollectionStruct object = (IEmptyCollectionStruct)((ArgumentObj)arguments).factoryNonEmpty.apply(name);
        String result = (String)((ArgumentObj)arguments).function.apply(this.clientObj, object);
        Assertions.assertEquals((Object)validationValue, (Object)result);
    }

    static Stream<Arguments> scenarios() {
        return Stream.of(Arguments.of((Object[])new Object[]{new ArgumentObj<ListStructPrimitive>(ISampleCollectionInterface::testListPrimitive, s -> new ListStructPrimitive(Collections.emptyList(), (String)s), s -> new ListStructPrimitive(Arrays.asList(1, 2), (String)s)), "ListPrimative", "1,2"}), Arguments.of((Object[])new Object[]{new ArgumentObj<ListStructStruct>(ISampleCollectionInterface::testListIntStruct, s -> new ListStructStruct(Collections.emptyList(), (String)s), s -> new ListStructStruct(Arrays.asList(new IntStruct(5, 6)), (String)s)), "ListStruct", "(5,6)"}), Arguments.of((Object[])new Object[]{new ArgumentObj<ArrayStructPrimitive>(ISampleCollectionInterface::testArrayPrimitive, s -> new ArrayStructPrimitive(new int[0], (String)s), s -> new ArrayStructPrimitive(new int[]{4, 5}, (String)s)), "ArrayPrimative", "4,5"}), Arguments.of((Object[])new Object[]{new ArgumentObj<ArrayStructIntStruct>(ISampleCollectionInterface::testArrayIntStruct, s -> new ArrayStructIntStruct(new IntStruct[0], (String)s), s -> new ArrayStructIntStruct(new IntStruct[]{new IntStruct(9, 12)}, (String)s)), "ArrayIntStruct", "(9,12)"}), Arguments.of((Object[])new Object[]{new ArgumentObj<MapStructPrimitive>(ISampleCollectionInterface::testMapPrimitive, s -> new MapStructPrimitive(Collections.emptyMap(), (String)s), s -> new MapStructPrimitive(TestEmptyCollections.getIntHashMap(), (String)s)), "MapPrimative", "{test:8}"}), Arguments.of((Object[])new Object[]{new ArgumentObj<MapStructIntStruct>(ISampleCollectionInterface::testMapIntStruct, s -> new MapStructIntStruct(Collections.emptyMap(), (String)s), s -> new MapStructIntStruct(TestEmptyCollections.getIntStructHashMap(), (String)s)), "MapIntStruct", "{other:(12,17)}"}), Arguments.of((Object[])new Object[]{new ArgumentObj<DeepListStruct>(ISampleCollectionInterface::testDeepList, s -> new DeepListStruct(Collections.emptyList(), (String)s), s -> new DeepListStruct(TestEmptyCollections.getDeepList(), (String)s)), "DeepListStruct", "[[[(111,44)]]]"}), Arguments.of((Object[])new Object[]{new ArgumentObj<DeepArrayStruct>(ISampleCollectionInterface::testDeepArray, s -> new DeepArrayStruct(new IntStruct[0][][], (String)s), s -> new DeepArrayStruct(TestEmptyCollections.getDeepArrayStruct(), (String)s)), "DeepArrayStruct", "[[[(131,145)]]]"}), Arguments.of((Object[])new Object[]{new ArgumentObj<DeepMapStruct>(ISampleCollectionInterface::testDeepMap, s -> new DeepMapStruct(Collections.emptyMap(), (String)s), s -> new DeepMapStruct(TestEmptyCollections.getDeepMapStruct(), (String)s)), "DeepMapStruct", "{complete:{inbetween:{test:(42,19)}}}"}), Arguments.of((Object[])new Object[]{new ArgumentObj<ListMapStruct>(ISampleCollectionInterface::testMixedListMap, s -> new ListMapStruct(Collections.emptyList(), (String)s), s -> new ListMapStruct(Arrays.asList(TestEmptyCollections.getIntStructHashMap()), (String)s)), "mixedListMapStruct", "[{other=(12,17)}]"}), Arguments.of((Object[])new Object[]{new ArgumentObj<MapArrayStruct>(ISampleCollectionInterface::testMixedMapArray, s -> new MapArrayStruct(Collections.emptyMap(), (String)s), s -> new MapArrayStruct(TestEmptyCollections.getMapArray(), (String)s)), "mixedMapArrayStruct", "{other=[(99,33)]}"}));
    }

    private static Map<String, IntStruct[]> getMapArray() {
        HashMap<String, IntStruct[]> map = new HashMap<String, IntStruct[]>();
        map.put("other", new IntStruct[]{new IntStruct(99, 33)});
        return map;
    }

    private static Map<String, Map<String, Map<String, IntStruct>>> getDeepMapStruct() {
        HashMap<String, Map<String, Map<String, IntStruct>>> outerMap = new HashMap<String, Map<String, Map<String, IntStruct>>>();
        HashMap midlleMap = new HashMap();
        HashMap<String, IntStruct> innerMap = new HashMap<String, IntStruct>();
        innerMap.put("test", new IntStruct(42, 19));
        midlleMap.put("inbetween", innerMap);
        outerMap.put("complete", midlleMap);
        return outerMap;
    }

    private static IntStruct[][][] getDeepArrayStruct() {
        IntStruct[][][] array = new IntStruct[1][1][1];
        array[0][0][0] = new IntStruct(131, 145);
        return array;
    }

    private static List<List<List<IntStruct>>> getDeepList() {
        return Arrays.asList(Arrays.asList(Arrays.asList(new IntStruct(111, 44))));
    }

    private static Map<String, IntStruct> getIntStructHashMap() {
        HashMap<String, IntStruct> map = new HashMap<String, IntStruct>();
        map.put("other", new IntStruct(12, 17));
        return map;
    }

    private static Map<String, Integer> getIntHashMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("test", 8);
        return map;
    }

    private static final class ArgumentObj<T> {
        private final BiFunction<ISampleCollectionInterface, T, String> function;
        private final Function<String, T> factoryEmpty;
        private Function<String, T> factoryNonEmpty;

        public ArgumentObj(BiFunction<ISampleCollectionInterface, T, String> function, Function<String, T> factoryEmpty, Function<String, T> factoryNonEmpty) {
            this.function = function;
            this.factoryEmpty = factoryEmpty;
            this.factoryNonEmpty = factoryNonEmpty;
        }
    }
}

