/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.InternalSignal;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBusSignal
extends Message {
    private static final Map<String, Class<? extends DBusSignal>> CLASS_CACHE = new ConcurrentHashMap<String, Class<? extends DBusSignal>>();
    private static final Map<Class<? extends DBusSignal>, Type[]> TYPE_CACHE = new ConcurrentHashMap<Class<? extends DBusSignal>, Type[]>();
    private static final Map<Class<? extends DBusSignal>, Constructor<? extends DBusSignal>> CONSTRUCTOR_CACHE = new ConcurrentHashMap<Class<? extends DBusSignal>, Constructor<? extends DBusSignal>>();
    private static final Map<String, String> SIGNAL_NAMES = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> INT_NAMES = new ConcurrentHashMap<String, String>();
    private static final Map<Class<? extends DBusSignal>, List<CachedConstructor>> CACHED_CONSTRUCTORS = new ConcurrentHashMap<Class<? extends DBusSignal>, List<CachedConstructor>>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<? extends DBusSignal> clazz;
    private boolean bodydone = false;
    private byte[] blen;

    DBusSignal() {
    }

    public DBusSignal(String source, String path, String iface, String member, String sig, Object ... args) throws DBusException {
        super(DBusConnection.getEndianness(), (byte)4, (byte)0);
        if (null == path || null == member || null == iface) {
            throw new MessageFormatException("Must specify object path, interface and signal name to Signals.");
        }
        this.getHeaders().put((byte)1, path);
        this.getHeaders().put((byte)3, member);
        this.getHeaders().put((byte)2, iface);
        ArrayList<Object[]> hargs = new ArrayList<Object[]>();
        hargs.add(new Object[]{(byte)1, new Object[]{"o", path}});
        hargs.add(new Object[]{(byte)2, new Object[]{"s", iface}});
        hargs.add(new Object[]{(byte)3, new Object[]{"s", member}});
        if (null != source) {
            this.getHeaders().put((byte)7, source);
            hargs.add(new Object[]{(byte)7, new Object[]{"s", source}});
        }
        if (null != sig) {
            hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
            this.getHeaders().put((byte)8, sig);
            this.setArgs(args);
        }
        this.blen = new byte[4];
        this.appendBytes(this.blen);
        long newSerial = this.getSerial() + 1L;
        this.setSerial(newSerial);
        this.append("ua(yv)", newSerial, hargs.toArray());
        this.pad((byte)8);
        long counter = this.getByteCounter();
        if (null != sig) {
            this.append(sig, args);
        }
        this.marshallint(this.getByteCounter() - counter, this.blen, 0, 4);
        this.bodydone = true;
    }

    static void addInterfaceMap(String java, String dbus) {
        INT_NAMES.put(dbus, java);
    }

    static void addSignalMap(String java, String dbus) {
        SIGNAL_NAMES.put(dbus, java);
    }

    static DBusSignal createSignal(Class<? extends DBusSignal> c, String source, String objectpath, String sig, long serial, Object ... parameters) throws DBusException {
        String type = "";
        if (null != c.getEnclosingClass()) {
            type = null != c.getEnclosingClass().getAnnotation(DBusInterfaceName.class) ? c.getEnclosingClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getEnclosingClass().getName()).replaceAll(".");
        } else {
            throw new DBusException("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package.");
        }
        InternalSignal s = new InternalSignal(source, objectpath, type, c.getSimpleName(), sig, serial, parameters);
        s.clazz = c;
        return s;
    }

    private static Class<? extends DBusSignal> createSignalClass(String intname, String signame) throws DBusException {
        String name = intname + '$' + signame;
        Class<DBusSignal> c = CLASS_CACHE.get(name);
        if (null == c) {
            c = DBusMatchRule.getCachedSignalType(name);
        }
        if (null != c) {
            return c;
        }
        do {
            try {
                c = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            name = name.replaceAll("\\.([^\\.]*)$", "\\$$1");
        } while (null == c && name.matches(".*\\..*"));
        if (null == c) {
            throw new DBusException("Could not create class from signal " + intname + '.' + signame);
        }
        CLASS_CACHE.put(name, c);
        return c;
    }

    public DBusSignal createReal(AbstractConnection conn) throws DBusException {
        String intname = INT_NAMES.get(this.getInterface());
        String signame = SIGNAL_NAMES.get(this.getName());
        if (null == intname) {
            intname = this.getInterface();
        }
        if (null == signame) {
            signame = this.getName();
        }
        if (null == this.clazz) {
            this.clazz = DBusSignal.createSignalClass(intname, signame);
        }
        this.logger.debug("Converting signal to type: {}", this.clazz);
        if (!CACHED_CONSTRUCTORS.containsKey(this.clazz)) {
            this.cacheConstructors(this.clazz);
        }
        List<CachedConstructor> list = CACHED_CONSTRUCTORS.get(this.clazz);
        Constructor con = null;
        Type[] types = null;
        Object[] parameters = this.getParameters();
        List wantedArgs = Arrays.stream(parameters).map(p -> p.getClass()).collect(Collectors.toList());
        for (CachedConstructor type : list) {
            if (!type.parameterTypes.equals(wantedArgs)) continue;
            con = type.constructor;
            types = type.types;
            break;
        }
        if (con == null) {
            this.logger.warn("Could not find suitable constructor for class {} with argument-types: {}", (Object)this.clazz.getName(), wantedArgs);
            return null;
        }
        try {
            DBusSignal s;
            Object[] args = Marshalling.deSerializeParameters(parameters, types, conn);
            if (null == args) {
                s = (DBusSignal)con.newInstance(this.getPath());
            } else {
                Object[] params = new Object[args.length + 1];
                params[0] = this.getPath();
                System.arraycopy(args, 0, params, 1, args.length);
                s = (DBusSignal)con.newInstance(params);
            }
            s.getHeaders().putAll(this.getHeaders());
            s.setWiredata(this.getWireData());
            s.setByteCounter(this.getWireData().length);
            return s;
        }
        catch (Exception _ex) {
            throw new DBusException(_ex);
        }
    }

    private void cacheConstructors(Class<? extends DBusSignal> _clazz) {
        ArrayList<CachedConstructor> list = new ArrayList<CachedConstructor>();
        Constructor<?>[] constructorArray = _clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<?> constructor;
            Constructor<?> x = constructor = constructorArray[i];
            list.add(new CachedConstructor(x));
        }
        CACHED_CONSTRUCTORS.put(_clazz, list);
    }

    protected DBusSignal(String objectpath, Object ... args) throws DBusException {
        super(DBusConnection.getEndianness(), (byte)4, (byte)0);
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$")) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        Class<?> tc = this.getClass();
        String member = tc.isAnnotationPresent(DBusMemberName.class) ? tc.getAnnotation(DBusMemberName.class).value() : tc.getSimpleName();
        String iface = null;
        Class<?> enc = tc.getEnclosingClass();
        if (null == enc || !DBusInterface.class.isAssignableFrom(enc) || enc.getName().equals(enc.getSimpleName())) {
            throw new DBusException("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package.");
        }
        iface = null != enc.getAnnotation(DBusInterfaceName.class) ? enc.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(enc.getName()).replaceAll(".");
        this.getHeaders().put((byte)1, objectpath);
        this.getHeaders().put((byte)3, member);
        this.getHeaders().put((byte)2, iface);
        ArrayList<Object[]> hargs = new ArrayList<Object[]>();
        hargs.add(new Object[]{(byte)1, new Object[]{"o", objectpath}});
        hargs.add(new Object[]{(byte)2, new Object[]{"s", iface}});
        hargs.add(new Object[]{(byte)3, new Object[]{"s", member}});
        String sig = null;
        if (0 < args.length) {
            try {
                Type[] types = TYPE_CACHE.get(tc);
                if (null == types) {
                    Constructor<?> con = tc.getDeclaredConstructors()[0];
                    CONSTRUCTOR_CACHE.put(tc, con);
                    Type[] ts = con.getGenericParameterTypes();
                    types = new Type[ts.length - 1];
                    for (int i = 1; i <= types.length; ++i) {
                        types[i - 1] = ts[i] instanceof TypeVariable ? ((TypeVariable)ts[i]).getBounds()[0] : ts[i];
                    }
                    TYPE_CACHE.put(tc, types);
                }
                sig = Marshalling.getDBusType(types);
                hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
                this.getHeaders().put((byte)8, sig);
                this.setArgs(args);
            }
            catch (Exception e) {
                this.logger.debug("", (Throwable)e);
                throw new DBusException("Failed to add signal parameters: " + e.getMessage());
            }
        }
        this.blen = new byte[4];
        this.appendBytes(this.blen);
        long newSerial = this.getSerial() + 1L;
        this.setSerial(newSerial);
        this.append("ua(yv)", newSerial, hargs.toArray());
        this.pad((byte)8);
    }

    public void appendbody(AbstractConnection conn) throws DBusException {
        if (this.bodydone) {
            return;
        }
        Type[] types = TYPE_CACHE.get(this.getClass());
        Object[] args = Marshalling.convertParameters(this.getParameters(), types, conn);
        this.setArgs(args);
        String sig = this.getSig();
        long counter = this.getByteCounter();
        if (null != args && 0 < args.length) {
            this.append(sig, args);
        }
        this.marshallint(this.getByteCounter() - counter, this.blen, 0, 4);
        this.bodydone = true;
    }

    @Override
    public String toString() {
        return "DBusSignal [clazz=" + this.clazz + "]";
    }

    private static class CachedConstructor {
        private Constructor<? extends DBusSignal> constructor;
        private List<Class<?>> parameterTypes;
        private Type[] types;

        CachedConstructor(Constructor<? extends DBusSignal> _constructor) {
            this.constructor = _constructor;
            this.parameterTypes = Arrays.stream(this.constructor.getParameterTypes()).skip(1L).map(c -> {
                if (c.isPrimitive()) {
                    return CachedConstructor.wrap(c);
                }
                return c;
            }).collect(Collectors.toList());
            this.types = CachedConstructor.createTypes(this.constructor);
        }

        private static Type[] createTypes(Constructor<? extends DBusSignal> constructor) {
            Type[] ts = constructor.getGenericParameterTypes();
            Type[] types = new Type[ts.length - 1];
            for (int i = 1; i <= types.length; ++i) {
                types[i - 1] = ts[i] instanceof TypeVariable ? ((TypeVariable)ts[i]).getBounds()[0] : ts[i];
            }
            return types;
        }

        private static <T> Class<T> wrap(Class<T> c) {
            return MethodType.methodType(c).wrap().returnType();
        }
    }
}

