/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.cross;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.freedesktop.dbus.annotations.IntrospectionDescription;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.helper.cross.CrossTestClient;
import org.freedesktop.dbus.test.helper.interfaces.Binding;
import org.freedesktop.dbus.test.helper.interfaces.SamplesInterface;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;

public class CrossTestServer
implements SamplesInterface,
Binding.SingleSample,
DBusSigHandler<Binding.SampleClient.Trigger> {
    private DBusConnection conn;
    private volatile boolean run = true;
    private Set<String> done = new TreeSet<String>();
    private Set<String> notdone = new TreeSet<String>();

    public CrossTestServer(DBusConnection _conn) {
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Identity");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityString");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Sum");
        this.notdone.add("org.freedesktop.DBus.Binding.SingleTests.Sum");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.DeStruct");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Primitize");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Invert");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Trigger");
        this.notdone.add("org.freedesktop.DBus.Binding.Tests.Exit");
        this.notdone.add("org.freedesktop.DBus.Binding.TestClient.Trigger");
        this.conn = _conn;
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return null;
    }

    public boolean isRun() {
        return this.run;
    }

    public void setRun(boolean _run) {
        this.run = _run;
    }

    public Set<String> getDone() {
        return this.done;
    }

    public void setDone(Set<String> _done) {
        this.done = _done;
    }

    public Set<String> getNotdone() {
        return this.notdone;
    }

    public void setNotdone(Set<String> _notdone) {
        this.notdone = _notdone;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public <T> Variant<T> Identity(Variant<T> input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Identity");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Identity");
        return new Variant(input.getValue());
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public byte IdentityByte(byte input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityByte");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public boolean IdentityBool(boolean input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityBool");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public short IdentityInt16(short input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt16");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt16 IdentityUInt16(UInt16 input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt16");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public int IdentityInt32(int input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt32");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt32 IdentityUInt32(UInt32 input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt32");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public long IdentityInt64(long input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt64");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt64 IdentityUInt64(UInt64 input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt64");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public double IdentityDouble(double input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityDouble");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public String IdentityString(String input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityString");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityString");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public <T> Variant<T>[] IdentityArray(Variant<T>[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityArray");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public byte[] IdentityByteArray(byte[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityByteArray");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public boolean[] IdentityBoolArray(boolean[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityBoolArray");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public short[] IdentityInt16Array(short[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt16Array");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt16[] IdentityUInt16Array(UInt16[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt16Array");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public int[] IdentityInt32Array(int[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt32Array");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt32[] IdentityUInt32Array(UInt32[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt32Array");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public long[] IdentityInt64Array(long[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityInt64Array");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public UInt64[] IdentityUInt64Array(UInt64[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityUInt64Array");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public double[] IdentityDoubleArray(double[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityDoubleArray");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns whatever it is passed")
    public String[] IdentityStringArray(String[] input) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.IdentityStringArray");
        return input;
    }

    @Override
    @IntrospectionDescription(value="Returns the sum of the values in the input list")
    public long Sum(int[] a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Sum");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Sum");
        long sum = 0L;
        for (int b : a) {
            sum += (long)b;
        }
        return sum;
    }

    @Override
    @IntrospectionDescription(value="Returns the sum of the values in the input list")
    public UInt32 Sum(byte[] a) {
        this.done.add("org.freedesktop.DBus.Binding.SingleTests.Sum");
        this.notdone.remove("org.freedesktop.DBus.Binding.SingleTests.Sum");
        int sum = 0;
        for (int n : a) {
            sum += n < 0 ? n + 256 : n;
        }
        return new UInt32((long)sum % 0x100000000L);
    }

    @Override
    @IntrospectionDescription(value="Given a map of A => B, should return a map of B => a list of all the As which mapped to B")
    public Map<String, List<String>> InvertMapping(Map<String, String> a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.InvertMapping");
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        for (String s : a.keySet()) {
            String b = a.get(s);
            ArrayList<String> l = (ArrayList<String>)m.get(b);
            if (null == l) {
                l = new ArrayList<String>();
                m.put(b, l);
            }
            l.add(s);
        }
        return m;
    }

    @Override
    @IntrospectionDescription(value="This method returns the contents of a struct as separate values")
    public Binding.Triplet<String, UInt32, Short> DeStruct(Binding.CrossSampleStruct a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.DeStruct");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.DeStruct");
        return new Binding.Triplet<String, UInt32, Short>(a.getSampleString(), a.getSampleUint32(), a.getSampleShort());
    }

    @Override
    @IntrospectionDescription(value="Given any compound type as a variant, return all the primitive types recursively contained within as an array of variants")
    public List<Variant<Object>> Primitize(Variant<Object> a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Primitize");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Primitize");
        return CrossTestClient.primitizeRecurse(a.getValue(), a.getType());
    }

    @Override
    @IntrospectionDescription(value="inverts it's input")
    public boolean Invert(boolean a) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Invert");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Invert");
        return !a;
    }

    @Override
    @IntrospectionDescription(value="triggers sending of a signal from the supplied object with the given parameter")
    public void Trigger(String a, UInt64 b) {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Trigger");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Trigger");
        try {
            this.conn.sendMessage((Message)new Binding.SampleSignals.Triggered(a, b));
        }
        catch (DBusException exD) {
            throw new DBusExecutionException(exD.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Exit() {
        this.done.add("org.freedesktop.DBus.Binding.Tests.Exit");
        this.notdone.remove("org.freedesktop.DBus.Binding.Tests.Exit");
        this.run = false;
        CrossTestServer crossTestServer = this;
        synchronized (crossTestServer) {
            this.notifyAll();
        }
    }

    public void handle(Binding.SampleClient.Trigger t) {
        this.done.add("org.freedesktop.DBus.Binding.TestClient.Trigger");
        this.notdone.remove("org.freedesktop.DBus.Binding.TestClient.Trigger");
        try {
            Binding.SampleClient cb = (Binding.SampleClient)this.conn.getRemoteObject(t.getSource(), "/TestClient", Binding.SampleClient.class);
            cb.Response(t.getSampleUint16(), t.getSampleDouble());
        }
        catch (DBusException exD) {
            throw new DBusExecutionException(exD.getMessage());
        }
    }
}

