/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DBusConnectionTest {
    @Test
    public void test_busnames_should_be_auto_released_on_close_of_non_shared_connection() throws Exception {
        String busName = "org.freedesktop.dbus.test.TestBus";
        DBusConnection connection1 = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION, (boolean)false, (int)100000);
        DBusConnection connection2 = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION, (boolean)false, (int)100000);
        Assertions.assertNotEquals((Object)connection1.getUniqueName(), (Object)connection2.getUniqueName());
        connection1.requestBusName(busName);
        Assertions.assertThrows(DBusException.class, () -> connection2.requestBusName(busName));
        connection1.close();
        connection2.requestBusName(busName);
        connection2.close();
    }
}

